/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.dataview;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.dataview.DataView;
import org.primefaces.component.dataview.DataViewGridItem;
import org.primefaces.component.dataview.DataViewListItem;
import org.primefaces.component.dataview.DataViewState;
import org.primefaces.renderkit.DataRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.GridLayoutUtils;
import org.primefaces.util.LangUtils;
import org.primefaces.util.WidgetBuilder;

public class DataViewRenderer
extends DataRenderer {
    private static final Logger LOGGER = Logger.getLogger(DataViewRenderer.class.getName());

    public void decode(FacesContext context, UIComponent component) {
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        DataView dataview = (DataView)component;
        String clientId = dataview.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterMap();
        dataview.findViewItems();
        if (dataview.isPaginationRequest(context)) {
            dataview.updatePaginationData(context);
            if (dataview.isLazy()) {
                dataview.loadLazyData();
            }
            this.encodeLayout(context, dataview);
            if (dataview.isMultiViewState()) {
                this.saveMultiViewState(dataview);
            }
        } else if (dataview.isLayoutRequest(context)) {
            String layout = (String)params.get(clientId + "_layout");
            dataview.setLayout(layout);
            this.encodeLayout(context, dataview);
            if (dataview.isMultiViewState()) {
                this.saveMultiViewState(dataview);
            }
        } else {
            if (dataview.isMultiViewState()) {
                dataview.restoreMultiViewState();
            }
            this.encodeMarkup(context, dataview);
            this.encodeScript(context, dataview);
            if (dataview.isPaginator() && dataview.getRows() == 0) {
                LOGGER.log(Level.WARNING, "DataView with paginator=true should also set the rows attribute. ClientId: " + dataview.getClientId());
            }
        }
    }

    protected void encodeMarkup(FacesContext context, DataView dataview) throws IOException {
        if (dataview.isLazy()) {
            dataview.loadLazyData();
        }
        ResponseWriter writer = context.getResponseWriter();
        String clientId = dataview.getClientId(context);
        String layout = dataview.getLayout();
        boolean hasPaginator = dataview.isPaginator();
        String paginatorPosition = dataview.getPaginatorPosition();
        String style = dataview.getStyle();
        String styleClass = this.getStyleClassBuilder(context).add("ui-dataview ui-widget", dataview.getStyleClass()).add(layout.contains("grid"), "ui-dataview-grid", "ui-dataview-list").build();
        if (hasPaginator) {
            dataview.calculateFirst();
        }
        writer.startElement("div", (UIComponent)dataview);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        this.encodeHeader(context, dataview);
        if (hasPaginator && !"bottom".equalsIgnoreCase(paginatorPosition)) {
            this.encodePaginatorMarkup(context, dataview, "top");
        }
        this.encodeContent(context, dataview);
        if (hasPaginator && !"top".equalsIgnoreCase(paginatorPosition)) {
            this.encodePaginatorMarkup(context, dataview, "bottom");
        }
        this.encodeFacet(context, dataview, "footer", "ui-dataview-footer ui-widget-header ui-corner-bottom");
        writer.endElement("div");
    }

    protected void encodeHeader(FacesContext context, DataView dataview) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        UIComponent fHeader = dataview.getFacet("header");
        writer.startElement("div", (UIComponent)dataview);
        writer.writeAttribute("class", (Object)"ui-dataview-header ui-widget-header ui-helper-clearfix ui-corner-top", null);
        if (ComponentUtils.shouldRenderFacet(fHeader)) {
            fHeader.encodeAll(context);
        }
        this.encodeLayoutOptions(context, dataview);
        writer.endElement("div");
    }

    protected void encodeContent(FacesContext context, DataView dataview) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = dataview.getClientId(context);
        writer.startElement("div", (UIComponent)dataview);
        writer.writeAttribute("id", (Object)(clientId + "_content"), null);
        writer.writeAttribute("class", (Object)"ui-dataview-content ui-widget-content", null);
        this.encodeLayout(context, dataview);
        writer.endElement("div");
    }

    protected void encodeLayoutOptions(FacesContext context, DataView dataview) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        boolean hasGridItem = dataview.getGridItem() != null;
        boolean hasListItem = dataview.getListItem() != null;
        String layout = dataview.getLayout();
        boolean isGridLayout = layout.contains("grid");
        String containerClass = "ui-dataview-layout-options ui-selectonebutton ui-buttonset";
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)containerClass, null);
        if (hasListItem) {
            String listIcon = dataview.getListIcon() != null ? dataview.getListIcon() : "ui-icon-grip-dotted-horizontal";
            this.encodeButton(context, dataview, "list", listIcon, !isGridLayout);
        }
        if (hasGridItem) {
            String gridIcon = dataview.getGridIcon() != null ? dataview.getGridIcon() : "ui-icon-grip-dotted-vertical";
            this.encodeButton(context, dataview, "grid", gridIcon, isGridLayout);
        }
        writer.endElement("div");
    }

    protected void encodeButton(FacesContext context, DataView dataview, String layout, String icon, boolean isActive) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = dataview.getClientId(context);
        String buttonClass = isActive ? "ui-button ui-button-icon-only ui-state-default ui-state-active" : "ui-button ui-button-icon-only ui-state-default";
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)buttonClass, null);
        writer.writeAttribute("tabindex", (Object)0, null);
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)(clientId + "_" + layout), null);
        writer.writeAttribute("name", (Object)clientId, null);
        writer.writeAttribute("type", (Object)"radio", null);
        writer.writeAttribute("value", (Object)layout, null);
        writer.writeAttribute("class", (Object)"ui-helper-hidden-accessible", null);
        writer.writeAttribute("tabindex", (Object)"-1", null);
        if (isActive) {
            writer.writeAttribute("checked", (Object)"checked", null);
        }
        writer.endElement("input");
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)("ui-button-icon-left ui-icon ui-c " + icon), null);
        writer.endElement("span");
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-button-text ui-c", null);
        writer.write("ui-button");
        writer.endElement("span");
        writer.endElement("div");
    }

    protected void encodeLayout(FacesContext context, DataView dataview) throws IOException {
        String layout = dataview.getLayout();
        if (dataview.getRowCount() == 0) {
            ResponseWriter writer = context.getResponseWriter();
            UIComponent emptyFacet = dataview.getFacet("emptyMessage");
            if (ComponentUtils.shouldRenderFacet(emptyFacet)) {
                emptyFacet.encodeAll(context);
            } else {
                writer.writeText((Object)dataview.getEmptyMessage(), "emptyMessage");
            }
        } else if (layout.contains("grid")) {
            this.encodeGridLayout(context, dataview);
        } else {
            this.encodeListLayout(context, dataview);
        }
    }

    protected void encodeGridLayout(FacesContext context, DataView dataview) throws IOException {
        DataViewGridItem grid = dataview.getGridItem();
        if (grid != null) {
            ResponseWriter writer = context.getResponseWriter();
            int columns = grid.getColumns();
            int rowIndex = dataview.getFirst();
            int rows = dataview.getRows();
            int itemsToRender = rows != 0 ? rows : dataview.getRowCount();
            int numberOfRowsToRender = (itemsToRender + columns - 1) / columns;
            boolean flex = ComponentUtils.isFlex(context, dataview);
            String columnClass = this.getStyleClassBuilder(context).add("ui-dataview-column").add(flex, GridLayoutUtils.getFlexColumnClass(columns), GridLayoutUtils.getColumnClass(columns)).add(dataview.getGridRowStyleClass()).build();
            String columnInlineStyle = dataview.getGridRowStyle();
            writer.startElement("div", null);
            if (flex) {
                writer.writeAttribute("class", (Object)"ui-dataview-row grid", null);
            } else {
                writer.writeAttribute("class", (Object)"ui-dataview-row ui-g", null);
            }
            for (int i = 0; i < numberOfRowsToRender; ++i) {
                dataview.setRowIndex(rowIndex);
                if (!dataview.isRowAvailable()) break;
                for (int j = 0; j < columns; ++j) {
                    writer.startElement("div", null);
                    writer.writeAttribute("class", (Object)columnClass, null);
                    if (!LangUtils.isEmpty(columnInlineStyle)) {
                        writer.writeAttribute("style", (Object)columnInlineStyle, null);
                    }
                    dataview.setRowIndex(rowIndex);
                    if (dataview.isRowAvailable()) {
                        this.renderChildren(context, (UIComponent)grid);
                    }
                    ++rowIndex;
                    writer.endElement("div");
                }
            }
            writer.endElement("div");
            dataview.setRowIndex(-1);
        }
    }

    protected void encodeListLayout(FacesContext context, DataView dataview) throws IOException {
        DataViewListItem list = dataview.getListItem();
        if (list != null) {
            ResponseWriter writer = context.getResponseWriter();
            int first = dataview.getFirst();
            int rows = dataview.getRows() == 0 ? dataview.getRowCount() : dataview.getRows();
            int pageSize = first + rows;
            writer.startElement("ul", null);
            writer.writeAttribute("class", (Object)"ui-dataview-list-container", null);
            for (int i = first; i < pageSize; ++i) {
                dataview.setRowIndex(i);
                if (!dataview.isRowAvailable()) break;
                writer.startElement("li", null);
                writer.writeAttribute("class", (Object)"ui-dataview-row", null);
                dataview.setRowIndex(i);
                if (dataview.isRowAvailable()) {
                    this.renderChildren(context, (UIComponent)list);
                }
                writer.endElement("li");
            }
            writer.endElement("ul");
            dataview.setRowIndex(-1);
        }
    }

    protected void encodeScript(FacesContext context, DataView dataview) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("DataView", dataview);
        if (dataview.isPaginator()) {
            this.encodePaginatorConfig(context, dataview, wb);
        }
        this.encodeClientBehaviors(context, dataview);
        wb.finish();
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    private void saveMultiViewState(DataView dataview) {
        if (dataview.isMultiViewState()) {
            DataViewState viewState = dataview.getMultiViewState(true);
            viewState.setFirst(dataview.getFirst());
            viewState.setRows(dataview.getRows());
            viewState.setLayout(dataview.getLayout());
        }
    }
}

