/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.imagecropper;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.logging.Logger;
import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import javax.imageio.ImageIO;
import org.primefaces.component.imagecropper.ImageCropper;
import org.primefaces.component.imagecropper.ImageCropperBase;
import org.primefaces.model.CroppedImage;
import org.primefaces.model.StreamedContent;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.shaded.commons.io.input.BoundedInputStream;
import org.primefaces.util.DynamicContentSrcBuilder;
import org.primefaces.util.FileUploadUtils;
import org.primefaces.util.LangUtils;
import org.primefaces.util.Lazy;
import org.primefaces.util.WidgetBuilder;

public class ImageCropperRenderer
extends CoreRenderer {
    private static final Logger LOGGER = Logger.getLogger(ImageCropperRenderer.class.getName());

    public void decode(FacesContext context, UIComponent component) {
        String coordsParam;
        ImageCropper cropper = (ImageCropper)component;
        Map params = context.getExternalContext().getRequestParameterMap();
        if (params.containsKey(coordsParam = cropper.getClientId(context) + "_coords")) {
            cropper.setSubmittedValue(params.get(coordsParam));
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ImageCropper cropper = (ImageCropper)component;
        this.encodeMarkup(context, cropper);
        this.encodeScript(context, cropper);
    }

    protected void encodeScript(FacesContext context, ImageCropper cropper) throws IOException {
        Object value;
        String widgetVar = cropper.resolveWidgetVar(context);
        String clientId = cropper.getClientId(context);
        String image = clientId + "_image";
        String select = null;
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.initWithComponentLoad("ImageCropper", widgetVar, clientId, clientId + "_image").attr("image", image).attr("viewMode", cropper.getViewMode(), 0).attr("aspectRatio", cropper.getAspectRatio(), Double.MIN_VALUE).attr("responsive", cropper.isResponsive(), true).attr("zoomOnTouch", cropper.isZoomOnTouch(), true).attr("zoomOnWheel", cropper.isZoomOnWheel(), true).attr("guides", cropper.isGuides(), true);
        if (cropper.getMinSize() != null) {
            wb.append(",minSize:[").append(cropper.getMinSize()).append("]");
        }
        if (cropper.getMaxSize() != null) {
            wb.append(",maxSize:[").append(cropper.getMaxSize()).append("]");
        }
        if ((value = cropper.getValue()) != null) {
            CroppedImage croppedImage = (CroppedImage)value;
            int x = croppedImage.getLeft();
            int y = croppedImage.getTop();
            int x2 = x + croppedImage.getWidth();
            int y2 = y + croppedImage.getHeight();
            select = "[" + x + "," + y + "," + x2 + "," + y2 + "]";
        } else if (LangUtils.isNotBlank(cropper.getInitialCoords())) {
            select = "[" + cropper.getInitialCoords() + "]";
        }
        if (select != null) {
            wb.append(",initialCoords:").append(select);
        }
        wb.finish();
    }

    protected void encodeMarkup(FacesContext context, ImageCropper cropper) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = cropper.getClientId(context);
        String coordsHolderId = clientId + "_coords";
        writer.startElement("div", (UIComponent)cropper);
        writer.writeAttribute("id", (Object)clientId, null);
        String style = "";
        if (cropper.getBoxHeight() > 0) {
            style = style + " max-height:" + cropper.getBoxHeight() + "px; ";
        }
        if (cropper.getBoxWidth() > 0) {
            style = style + " max-width:" + cropper.getBoxWidth() + "px; ";
        }
        if (LangUtils.isNotBlank(style)) {
            writer.writeAttribute("style", (Object)style, null);
        }
        this.renderImage(context, cropper, clientId);
        this.renderHiddenInput(context, coordsHolderId, null, false);
        writer.endElement("div");
    }

    private void renderImage(FacesContext context, ImageCropper cropper, String clientId) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String alt = cropper.getAlt() == null ? "" : cropper.getAlt();
        writer.startElement("img", null);
        writer.writeAttribute("id", (Object)(clientId + "_image"), null);
        writer.writeAttribute("alt", (Object)alt, null);
        String src = DynamicContentSrcBuilder.build(context, (UIComponent)cropper, cropper.getValueExpression(ImageCropperBase.PropertyKeys.image.name()), new Lazy<Object>(() -> cropper.getImage()), cropper.isCache(), true);
        writer.writeAttribute("src", (Object)src, null);
        writer.writeAttribute("height", (Object)"auto", null);
        writer.writeAttribute("width", (Object)"100%", null);
        writer.writeAttribute("style", (Object)"max-width: 100%;", null);
        writer.endElement("img");
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        String coords = (String)submittedValue;
        if (this.isValueBlank(coords)) {
            return null;
        }
        String[] cropCoords = coords.split("_");
        int x = (int)Double.parseDouble(cropCoords[0]);
        int y = (int)Double.parseDouble(cropCoords[1]);
        int w = (int)Double.parseDouble(cropCoords[2]);
        int h = (int)Double.parseDouble(cropCoords[3]);
        if (w <= 0 || h <= 0) {
            return null;
        }
        ImageCropper cropper = (ImageCropper)component;
        Resource resource = this.getImageResource(context, cropper);
        InputStream inputStream = null;
        Object imageObject = cropper.getImage();
        String imagePath = null;
        StreamedContent stream = null;
        if (imageObject instanceof String) {
            imagePath = imageObject.toString();
        } else if (imageObject instanceof StreamedContent) {
            stream = (StreamedContent)imageObject;
        } else {
            throw new IllegalArgumentException("'image' must be either an String relative path or a StreamedObject.");
        }
        String contentType = null;
        try {
            BufferedImage outputImage;
            if (resource != null && !"RES_NOT_FOUND".equals(resource.toString())) {
                inputStream = resource.getInputStream();
                contentType = resource.getContentType();
            } else if (imagePath != null) {
                boolean isExternal = imagePath.startsWith("http");
                if (isExternal) {
                    URL url = new URL(imagePath);
                    URLConnection urlConnection = url.openConnection();
                    inputStream = urlConnection.getInputStream();
                    contentType = urlConnection.getContentType();
                } else {
                    ExternalContext externalContext = context.getExternalContext();
                    imagePath = FileUploadUtils.checkPathTraversal(imagePath);
                    String webRoot = externalContext.getRealPath("");
                    String fileSeparator = "";
                    if (!(webRoot.endsWith("\\") || webRoot.endsWith("/") || imagePath.startsWith("\\") || imagePath.startsWith("/"))) {
                        fileSeparator = "/";
                    }
                    File file = new File(webRoot + fileSeparator + imagePath);
                    inputStream = new FileInputStream(file);
                }
            } else if (stream != null) {
                inputStream = stream.getStream().get();
                contentType = stream.getContentType();
            }
            if (cropper.getSizeLimit() != null) {
                inputStream = new BoundedInputStream(inputStream, cropper.getSizeLimit());
            }
            if (x + w > (outputImage = ImageIO.read(inputStream)).getWidth()) {
                w = outputImage.getWidth() - x;
            }
            if (y + h > outputImage.getHeight()) {
                h = outputImage.getHeight() - y;
            }
            BufferedImage cropped = outputImage.getSubimage(x, y, w, h);
            ByteArrayOutputStream croppedOutImage = new ByteArrayOutputStream();
            String format = this.guessImageFormat(contentType, imagePath);
            ImageIO.write((RenderedImage)cropped, format, croppedOutImage);
            CroppedImage croppedImage = new CroppedImage(cropper.getImage().toString(), croppedOutImage.toByteArray(), x, y, w, h);
            return croppedImage;
        }
        catch (IOException e) {
            LOGGER.severe(e.getMessage());
            throw new ConverterException((Throwable)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOGGER.severe(e.getMessage());
                }
            }
        }
    }

    private Resource getImageResource(FacesContext facesContext, ImageCropper imageCropper) {
        String imageValueExpressionString;
        Resource resource = null;
        ValueExpression imageValueExpression = imageCropper.getValueExpression(ImageCropperBase.PropertyKeys.image.toString());
        if (imageValueExpression != null && (imageValueExpressionString = imageValueExpression.getExpressionString()).matches("^[#][{]resource\\['[^']+'\\][}]$")) {
            String resourceName;
            imageValueExpressionString = imageValueExpressionString.replaceFirst("^[#][{]resource\\['", "");
            imageValueExpressionString = imageValueExpressionString.replaceFirst("'\\][}]$", "");
            String resourceLibrary = null;
            String[] resourceInfo = imageValueExpressionString.split(":");
            if (resourceInfo.length == 2) {
                resourceLibrary = resourceInfo[0];
                resourceName = resourceInfo[1];
            } else {
                resourceName = resourceInfo[0];
            }
            if (resourceName != null) {
                Application application = facesContext.getApplication();
                ResourceHandler resourceHandler = application.getResourceHandler();
                resource = resourceLibrary != null ? resourceHandler.createResource(resourceName, resourceLibrary) : resourceHandler.createResource(resourceName);
            }
        }
        return resource;
    }

    private String guessImageFormat(String contentType, String imagePath) throws IOException {
        String format = "png";
        if (contentType == null) {
            contentType = URLConnection.guessContentTypeFromName(imagePath);
        }
        if (contentType != null) {
            format = contentType.replaceFirst("^image/([^;]+)[;]?.*$", "$1");
        } else {
            String[] pathTokens;
            int queryStringIndex = imagePath.indexOf(63);
            if (queryStringIndex != -1) {
                imagePath = imagePath.substring(0, queryStringIndex);
            }
            if ((pathTokens = imagePath.split("\\.")).length > 1) {
                format = pathTokens[pathTokens.length - 1];
            }
        }
        return format;
    }
}

