/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.media;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.media.Media;
import org.primefaces.component.media.MediaBase;
import org.primefaces.component.media.player.MediaPlayer;
import org.primefaces.component.media.player.MediaPlayerFactory;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.AgentUtils;
import org.primefaces.util.DynamicContentSrcBuilder;
import org.primefaces.util.Lazy;

public class MediaRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        String src;
        Media media = (Media)component;
        MediaPlayer player = this.resolvePlayer(context, media);
        ResponseWriter writer = context.getResponseWriter();
        try {
            src = DynamicContentSrcBuilder.build(context, (UIComponent)media, media.getValueExpression(MediaBase.PropertyKeys.value.name()), new Lazy<Object>(() -> media.getValue()), media.isCache(), true);
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        String sourceParam = player.getSourceParam();
        String type = player.getType();
        if (type != null && "application/pdf".equals(type)) {
            String view = media.getView();
            String zoom = media.getZoom();
            if (view != null) {
                src = src + "#view=" + view;
            }
            if (zoom != null) {
                src = src + (view != null ? "&zoom=" + zoom : "#zoom=" + zoom);
            }
        }
        writer.startElement("object", (UIComponent)media);
        writer.writeAttribute("type", (Object)player.getType(), null);
        writer.writeAttribute("data", (Object)src, null);
        if (AgentUtils.isIE(context)) {
            this.encodeIEConfig(writer, player);
        }
        if (media.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)media.getStyleClass(), null);
        }
        this.renderPassThruAttributes(context, (UIComponent)media, Media.MEDIA_ATTRS);
        if (sourceParam != null) {
            this.encodeParam(writer, player.getSourceParam(), src, false);
        }
        if (media.getChildCount() > 0) {
            for (UIComponent child : media.getChildren()) {
                if (!(child instanceof UIParameter)) continue;
                UIParameter param = (UIParameter)child;
                this.encodeParam(writer, param.getName(), param.getValue(), false);
            }
        }
        this.renderChildren(context, (UIComponent)media);
        writer.endElement("object");
    }

    protected void encodeIEConfig(ResponseWriter writer, MediaPlayer player) throws IOException {
        writer.writeAttribute("classid", (Object)player.getClassId(), null);
        if (player.getCodebase() != null) {
            writer.writeAttribute("codebase", (Object)player.getCodebase(), null);
        }
    }

    protected void encodeParam(ResponseWriter writer, String name, Object value, boolean asAttribute) throws IOException {
        if (value == null) {
            return;
        }
        if (asAttribute) {
            writer.writeAttribute(name, value, null);
        } else {
            writer.startElement("param", null);
            writer.writeAttribute("name", (Object)name, null);
            writer.writeAttribute("value", (Object)value.toString(), null);
            writer.endElement("param");
        }
    }

    protected MediaPlayer resolvePlayer(FacesContext context, Media media) {
        if (media.getPlayer() != null) {
            return MediaPlayerFactory.getPlayer(media.getPlayer());
        }
        if (media.getValue() instanceof String) {
            Map<String, MediaPlayer> players = MediaPlayerFactory.getPlayers();
            String[] tokens = ((String)media.getValue()).split("\\.");
            String type = tokens[tokens.length - 1];
            for (MediaPlayer mp : players.values()) {
                for (String supportedType : mp.getSupportedTypes()) {
                    if (!supportedType.equalsIgnoreCase(type)) continue;
                    return mp;
                }
            }
        }
        throw new IllegalArgumentException("Cannot resolve mediaplayer for media component '" + media.getClientId(context) + "', cannot play source:" + media.getValue());
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

