/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.orderlist;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.primefaces.component.column.Column;
import org.primefaces.component.orderlist.OrderList;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.WidgetBuilder;

public class OrderListRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        OrderList pickList = (OrderList)component;
        Map params = context.getExternalContext().getRequestParameterValuesMap();
        String[] values = (String[])params.get(pickList.getClientId(context) + "_values");
        pickList.setSubmittedValue(values);
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        OrderList ol = (OrderList)component;
        this.encodeMarkup(context, ol);
        this.encodeScript(context, ol);
    }

    protected void encodeMarkup(FacesContext context, OrderList ol) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = ol.getClientId(context);
        String controlsLocation = ol.getControlsLocation();
        String style = ol.getStyle();
        String containerClass = this.getStyleClassBuilder(context).add("ui-orderlist ui-grid ui-widget").add(ol.getStyleClass()).add(ol.isDisabled(), "ui-state-disabled").add(ol.isResponsive(), "ui-grid-responsive").add("right".equals(ol.getControlsLocation()), "ui-orderlist-controls-right").build();
        writer.startElement("div", (UIComponent)ol);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)containerClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-g", null);
        if ("left".equals(controlsLocation)) {
            this.encodeControls(context, ol);
        }
        this.encodeList(context, ol);
        if ("right".equals(controlsLocation)) {
            this.encodeControls(context, ol);
        }
        writer.endElement("div");
        writer.endElement("div");
    }

    protected void encodeList(FacesContext context, OrderList ol) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = ol.getClientId(context);
        UIComponent caption = ol.getFacet("caption");
        String listStyleClass = "ui-widget-content ui-orderlist-list";
        String columnGridClass = ol.getControlsLocation().equals("none") ? "ui-g-12 ui-md-12" : "ui-g-12 ui-md-10";
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)columnGridClass, null);
        if (ComponentUtils.shouldRenderFacet(caption)) {
            this.encodeCaption(context, caption);
            listStyleClass = listStyleClass + " ui-corner-bottom";
        } else {
            listStyleClass = listStyleClass + " ui-corner-all";
        }
        writer.startElement("ul", null);
        writer.writeAttribute("class", (Object)listStyleClass, null);
        this.encodeOptions(context, ol, (List)ol.getValue());
        writer.endElement("ul");
        this.encodeInput(context, clientId + "_values");
        writer.endElement("div");
    }

    protected void encodeInput(FacesContext context, String clientId) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("select", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        writer.writeAttribute("multiple", (Object)"true", null);
        writer.writeAttribute("class", (Object)"ui-helper-hidden", null);
        writer.endElement("select");
    }

    protected void encodeControls(FacesContext context, OrderList ol) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-orderlist-controls ui-g-12 ui-md-2", null);
        this.encodeButton(context, ol.getMoveUpLabel(), "ui-orderlist-button-move-up", "ui-icon ui-icon-arrow-1-n");
        this.encodeButton(context, ol.getMoveTopLabel(), "ui-orderlist-button-move-top", "ui-icon ui-icon-arrowstop-1-n");
        this.encodeButton(context, ol.getMoveDownLabel(), "ui-orderlist-button-move-down", "ui-icon ui-icon-arrow-1-s");
        this.encodeButton(context, ol.getMoveBottomLabel(), "ui-orderlist-button-move-bottom", "ui-icon ui-icon-arrowstop-1-s");
        writer.endElement("div");
    }

    protected void encodeOptions(FacesContext context, OrderList old, List model) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String var = old.getVar();
        Converter converter = old.getConverter();
        for (Object item : model) {
            context.getExternalContext().getRequestMap().put(var, item);
            String value = converter != null ? converter.getAsString(context, (UIComponent)old, old.getItemValue()) : old.getItemValue().toString();
            writer.startElement("li", null);
            writer.writeAttribute("class", (Object)"ui-orderlist-item ui-corner-all", null);
            writer.writeAttribute("data-item-value", (Object)value, null);
            if (old.getChildCount() > 0) {
                writer.startElement("table", null);
                writer.startElement("tbody", null);
                writer.startElement("tr", null);
                for (UIComponent kid : old.getChildren()) {
                    if (!(kid instanceof Column) || !kid.isRendered()) continue;
                    Column column = (Column)kid;
                    writer.startElement("td", null);
                    if (column.getStyle() != null) {
                        writer.writeAttribute("style", (Object)column.getStyle(), null);
                    }
                    if (column.getStyleClass() != null) {
                        writer.writeAttribute("class", (Object)column.getStyleClass(), null);
                    }
                    this.renderChildren(context, (UIComponent)column);
                    writer.endElement("td");
                }
                writer.endElement("tr");
                writer.endElement("tbody");
                writer.endElement("table");
            } else {
                writer.writeText((Object)old.getItemLabel(), null);
            }
            writer.endElement("li");
        }
        context.getExternalContext().getRequestMap().remove(var);
    }

    protected void encodeButton(FacesContext context, String title, String styleClass, String icon) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("button", null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("class", (Object)("ui-button ui-widget ui-state-default ui-corner-all ui-button-icon-only " + styleClass), null);
        writer.writeAttribute("title", (Object)title, null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)("ui-button-icon-left ui-icon ui-c " + icon), null);
        writer.endElement("span");
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-button-text ui-c", null);
        writer.write("ui-button");
        writer.endElement("span");
        writer.endElement("button");
    }

    protected void encodeScript(FacesContext context, OrderList ol) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("OrderList", ol).attr("effect", ol.getEffect(), null);
        this.encodeClientBehaviors(context, ol);
        wb.finish();
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        try {
            String[] values;
            OrderList ol = (OrderList)component;
            ArrayList<String> orderedList = new ArrayList<String>();
            Converter converter = ol.getConverter();
            for (String item : values = (String[])submittedValue) {
                String convertedValue;
                if (this.isValueBlank(item)) continue;
                String string = convertedValue = converter != null ? converter.getAsObject(context, (UIComponent)ol, item) : item;
                if (convertedValue == null) continue;
                orderedList.add(convertedValue);
            }
            return orderedList;
        }
        catch (Exception exception) {
            throw new ConverterException((Throwable)exception);
        }
    }

    protected void encodeCaption(FacesContext context, UIComponent caption) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-orderlist-caption ui-widget-header ui-corner-top", null);
        caption.encodeAll(context);
        writer.endElement("div");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

