/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.selectcheckboxmenu;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UISelectMany;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import org.primefaces.component.selectcheckboxmenu.SelectCheckboxMenu;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.expression.SearchExpressionUtils;
import org.primefaces.renderkit.SelectManyRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.WidgetBuilder;

public class SelectCheckboxMenuRenderer
extends SelectManyRenderer {
    @Override
    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        Object renderer = ComponentUtils.getUnwrappedRenderer(context, "javax.faces.SelectMany", "javax.faces.Checkbox");
        return renderer.getConvertedValue(context, component, submittedValue);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        SelectCheckboxMenu menu = (SelectCheckboxMenu)component;
        this.encodeMarkup(context, menu);
        this.encodeScript(context, menu);
    }

    protected void encodeMarkup(FacesContext context, SelectCheckboxMenu menu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = menu.getClientId(context);
        List<SelectItem> selectItems = this.getSelectItems(context, (UIInput)menu);
        boolean valid = menu.isValid();
        String title = menu.getTitle();
        String style = menu.getStyle();
        String styleclass = this.createStyleClass((UIInput)menu, "ui-selectcheckboxmenu ui-widget ui-state-default ui-corner-all");
        styleclass = menu.isMultiple() ? "ui-selectcheckboxmenu-multiple " + styleclass : styleclass;
        writer.startElement("div", (UIComponent)menu);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleclass, "styleclass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        if (title != null) {
            writer.writeAttribute("title", (Object)title, "title");
        }
        this.renderARIACombobox(context, (UIInput)menu);
        this.encodeKeyboardTarget(context, menu);
        this.encodeInputs(context, menu, selectItems);
        if (menu.isMultiple()) {
            this.encodeMultipleLabel(context, menu, selectItems);
        } else {
            this.encodeLabel(context, menu, selectItems, valid);
        }
        this.encodeMenuIcon(context, menu, valid);
        writer.endElement("div");
    }

    protected void encodeInputs(FacesContext context, SelectCheckboxMenu menu, List<SelectItem> selectItems) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Converter converter = menu.getConverter();
        Object values = this.getValues((UIComponent)menu);
        Object submittedValues = this.getSubmittedValues((UIComponent)menu);
        writer.startElement("div", (UIComponent)menu);
        writer.writeAttribute("class", (Object)"ui-helper-hidden", null);
        int idx = -1;
        for (int i = 0; i < selectItems.size(); ++i) {
            SelectItem selectItem = selectItems.get(i);
            if (selectItem instanceof SelectItemGroup) {
                SelectItemGroup selectItemGroup = (SelectItemGroup)selectItem;
                String selectItemGroupLabel = selectItemGroup.getLabel() == null ? "" : selectItemGroup.getLabel();
                for (SelectItem childSelectItem : selectItemGroup.getSelectItems()) {
                    this.encodeOption(context, menu, values, submittedValues, converter, childSelectItem, ++idx, selectItemGroupLabel);
                }
                continue;
            }
            this.encodeOption(context, menu, values, submittedValues, converter, selectItem, ++idx);
        }
        writer.endElement("div");
    }

    protected void encodeOption(FacesContext context, SelectCheckboxMenu menu, Object values, Object submittedValues, Converter converter, SelectItem option, int idx) throws IOException {
        this.encodeOption(context, menu, values, submittedValues, converter, option, idx, null);
    }

    protected void encodeOption(FacesContext context, SelectCheckboxMenu menu, Object values, Object submittedValues, Converter converter, SelectItem option, int idx, String selectItemGroupLabel) throws IOException {
        Object itemValue;
        Object valuesArray;
        ResponseWriter writer = context.getResponseWriter();
        String itemValueAsString = this.getOptionAsString(context, (UIComponent)menu, converter, option.getValue());
        String name = menu.getClientId(context);
        String id = name + UINamingContainer.getSeparatorChar((FacesContext)context) + idx;
        boolean disabled = option.isDisabled() || menu.isDisabled();
        boolean escaped = option.isEscape();
        String itemLabel = option.getLabel();
        String string = itemLabel = this.isValueBlank(itemLabel) ? "&nbsp;" : itemLabel;
        if (submittedValues != null) {
            valuesArray = submittedValues;
            itemValue = itemValueAsString;
        } else {
            valuesArray = values;
            itemValue = option.getValue();
        }
        boolean checked = this.isSelected(context, (UIComponent)menu, itemValue, valuesArray, converter);
        if (option.isNoSelectionOption() && values != null && !checked) {
            return;
        }
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)name, null);
        writer.writeAttribute("type", (Object)"checkbox", null);
        writer.writeAttribute("value", (Object)itemValueAsString, null);
        writer.writeAttribute("data-escaped", (Object)String.valueOf(escaped), null);
        if (selectItemGroupLabel != null) {
            writer.writeAttribute("data-group-label", (Object)selectItemGroupLabel, null);
        }
        writer.writeAttribute("aria-checked", (Object)checked, null);
        if (checked) {
            writer.writeAttribute("checked", (Object)"checked", null);
        }
        if (option.getDescription() != null) {
            writer.writeAttribute("title", (Object)option.getDescription(), null);
        }
        if (menu.getOnchange() != null) {
            writer.writeAttribute("onchange", (Object)menu.getOnchange(), null);
        }
        this.renderAccessibilityAttributes(context, (UIInput)menu, option.isDisabled(), false);
        writer.endElement("input");
        writer.startElement("label", null);
        writer.writeAttribute("for", (Object)id, null);
        if (disabled) {
            writer.writeAttribute("class", (Object)"ui-state-disabled", null);
        }
        if ("&nbsp;".equals(itemLabel)) {
            writer.write(itemLabel);
        } else if (escaped) {
            writer.writeText((Object)itemLabel, "value");
        } else {
            writer.write(itemLabel);
        }
        writer.endElement("label");
    }

    protected void encodeLabel(FacesContext context, SelectCheckboxMenu menu, List<SelectItem> selectItems, boolean valid) throws IOException {
        String labelClass;
        ResponseWriter writer = context.getResponseWriter();
        String label = menu.getLabel();
        String string = labelClass = !valid ? "ui-selectcheckboxmenu-label ui-corner-all ui-state-error" : "ui-selectcheckboxmenu-label ui-corner-all";
        if (label == null) {
            label = "";
        }
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-selectcheckboxmenu-label-container", null);
        writer.startElement("label", null);
        writer.writeAttribute("class", (Object)labelClass, null);
        writer.writeText((Object)label, null);
        writer.endElement("label");
        writer.endElement("span");
    }

    protected void encodeMultipleLabel(FacesContext context, SelectCheckboxMenu menu, List<SelectItem> selectItems) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Converter converter = menu.getConverter();
        Object values = this.getValues((UIComponent)menu);
        Object submittedValues = this.getSubmittedValues((UIComponent)menu);
        Object valuesArray = submittedValues != null ? submittedValues : values;
        String listClass = this.createStyleClass((UIInput)menu, null, "ui-selectcheckboxmenu-multiple-container ui-widget ui-inputfield ui-state-default ui-corner-all");
        String label = menu.getEmptyLabel() == null ? menu.getLabel() : menu.getEmptyLabel();
        writer.startElement("ul", null);
        writer.writeAttribute("data-label", (Object)label, null);
        writer.writeAttribute("class", (Object)listClass, null);
        if (valuesArray != null) {
            int length = Array.getLength(valuesArray);
            for (int i = 0; i < length; ++i) {
                Object value = Array.get(valuesArray, i);
                SelectItem selectedItem = null;
                block1: for (SelectItem item : selectItems) {
                    if (item instanceof SelectItemGroup) {
                        SelectItemGroup group = (SelectItemGroup)item;
                        for (SelectItem groupItem : group.getSelectItems()) {
                            if (!this.isSelectValueEqual(context, (UIComponent)menu, value, groupItem.getValue(), converter)) continue;
                            selectedItem = groupItem;
                            continue block1;
                        }
                        continue;
                    }
                    if (!this.isSelectValueEqual(context, (UIComponent)menu, value, item.getValue(), converter)) continue;
                    selectedItem = item;
                    break;
                }
                if (selectedItem == null) continue;
                String itemValueAsString = value == null || value instanceof String ? (String)value : this.getOptionAsString(context, (UIComponent)menu, converter, value);
                writer.startElement("li", null);
                writer.writeAttribute("class", (Object)"ui-selectcheckboxmenu-token ui-state-active ui-corner-all", null);
                writer.writeAttribute("data-item-value", (Object)itemValueAsString, null);
                writer.startElement("span", null);
                writer.writeAttribute("class", (Object)"ui-selectcheckboxmenu-token-label", null);
                if (selectedItem.getLabel() != null) {
                    if (selectedItem.isEscape()) {
                        writer.writeText((Object)selectedItem.getLabel(), null);
                    } else {
                        writer.write(selectedItem.getLabel());
                    }
                } else {
                    writer.writeText(value, null);
                }
                writer.endElement("span");
                writer.startElement("span", null);
                writer.writeAttribute("class", (Object)"ui-selectcheckboxmenu-token-icon ui-icon ui-icon-close", null);
                writer.endElement("span");
                writer.endElement("li");
            }
        }
        writer.endElement("ul");
    }

    protected void encodeMenuIcon(FacesContext context, SelectCheckboxMenu menu, boolean valid) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String iconClass = valid ? "ui-selectcheckboxmenu-trigger ui-state-default ui-corner-right" : "ui-selectcheckboxmenu-trigger ui-state-default ui-corner-right ui-state-error";
        writer.startElement("div", (UIComponent)menu);
        writer.writeAttribute("class", (Object)iconClass, null);
        writer.startElement("span", (UIComponent)menu);
        writer.writeAttribute("class", (Object)"ui-icon ui-icon-triangle-1-s", null);
        writer.endElement("span");
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, SelectCheckboxMenu menu) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("SelectCheckboxMenu", menu).callback("onShow", "function()", menu.getOnShow()).callback("onHide", "function()", menu.getOnHide()).callback("onChange", "function()", menu.getOnchange()).attr("scrollHeight", menu.getScrollHeight(), Integer.MAX_VALUE).attr("showHeader", menu.isShowHeader(), true).attr("updateLabel", menu.isUpdateLabel(), false).attr("labelSeparator", menu.getLabelSeparator(), ", ").attr("emptyLabel", menu.getEmptyLabel()).attr("multiple", menu.isMultiple(), false).attr("dynamic", menu.isDynamic(), false).attr("appendTo", SearchExpressionFacade.resolveClientId(context, (UIComponent)menu, menu.getAppendTo(), SearchExpressionUtils.SET_RESOLVE_CLIENT_SIDE), null);
        if (menu.isFilter()) {
            wb.attr("filter", true).attr("filterMatchMode", menu.getFilterMatchMode(), null).nativeAttr("filterFunction", menu.getFilterFunction(), null).attr("caseSensitive", menu.isCaseSensitive(), false).attr("filterPlaceholder", menu.getFilterPlaceholder(), null);
        }
        wb.attr("panelStyle", menu.getPanelStyle(), null).attr("panelStyleClass", menu.getPanelStyleClass(), null);
        this.encodeClientBehaviors(context, (ClientBehaviorHolder)menu);
        wb.finish();
    }

    @Override
    protected String getSubmitParam(FacesContext context, UISelectMany selectMany) {
        return selectMany.getClientId(context);
    }

    protected void encodeKeyboardTarget(FacesContext context, SelectCheckboxMenu menu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String inputId = menu.getClientId(context) + "_focus";
        String tabindex = menu.getTabindex();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-helper-hidden-accessible", null);
        writer.startElement("input", (UIComponent)menu);
        writer.writeAttribute("id", (Object)inputId, null);
        writer.writeAttribute("name", (Object)inputId, null);
        writer.writeAttribute("type", (Object)"text", null);
        writer.writeAttribute("readonly", (Object)"readonly", null);
        writer.writeAttribute("role", (Object)"combobox", null);
        writer.writeAttribute("aria-hidden", (Object)"true", null);
        if (tabindex != null) {
            writer.writeAttribute("tabindex", (Object)tabindex, null);
        }
        writer.endElement("input");
        writer.endElement("div");
    }
}

