/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.csp;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialResponseWriter;
import javax.faces.context.ResponseWriter;
import org.primefaces.context.PartialResponseWriterWrapper;
import org.primefaces.context.PrimeRequestContext;
import org.primefaces.csp.CspResponseWriter;
import org.primefaces.csp.CspState;
import org.primefaces.util.EscapeUtils;

public class CspPartialResponseWriter
extends PartialResponseWriterWrapper {
    private CspResponseWriter cspResponseWriter;
    private PrimeRequestContext requestContext;
    private CspState cspState;
    private StringBuilder sb;

    public CspPartialResponseWriter(PartialResponseWriter wrapped, FacesContext context, CspState cspState) {
        super(wrapped);
        this.cspResponseWriter = new CspResponseWriter((ResponseWriter)wrapped, cspState);
        this.requestContext = PrimeRequestContext.getCurrentInstance(context);
        this.cspState = cspState;
    }

    @Override
    public void startInsertAfter(String targetId) throws IOException {
        this.cspResponseWriter.reset();
        super.startInsertAfter(targetId);
    }

    @Override
    public void startInsertBefore(String targetId) throws IOException {
        this.cspResponseWriter.reset();
        super.startInsertBefore(targetId);
    }

    @Override
    public void endInsert() throws IOException {
        super.endInsert();
        this.writeJavascriptHandlers();
    }

    @Override
    public void startUpdate(String targetId) throws IOException {
        this.cspResponseWriter.reset();
        super.startUpdate(targetId);
    }

    @Override
    public void endUpdate() throws IOException {
        super.endUpdate();
        this.writeJavascriptHandlers();
    }

    @Override
    public void startEval() throws IOException {
        this.cspResponseWriter.reset();
        super.startEval();
    }

    @Override
    public void endEval() throws IOException {
        this.cspResponseWriter.reset();
        super.endEval();
    }

    @Override
    public void startExtension(Map<String, String> attributes) throws IOException {
        this.cspResponseWriter.reset();
        super.startExtension(attributes);
    }

    @Override
    public void endExtension() throws IOException {
        this.cspResponseWriter.reset();
        super.endExtension();
    }

    @Override
    public void startError(String errorName) throws IOException {
        this.cspResponseWriter.reset();
        super.startError(errorName);
    }

    @Override
    public void endError() throws IOException {
        this.cspResponseWriter.reset();
        super.endError();
    }

    public void startElement(String name, UIComponent component) throws IOException {
        this.cspResponseWriter.startElement(name, component);
    }

    public void writeAttribute(String name, Object value, String property) throws IOException {
        this.cspResponseWriter.writeAttribute(name, value, property);
    }

    public void writeURIAttribute(String name, Object value, String property) throws IOException {
        this.cspResponseWriter.writeURIAttribute(name, value, property);
    }

    public void endElement(String name) throws IOException {
        this.cspResponseWriter.endElement(name);
    }

    public void flush() throws IOException {
        this.cspResponseWriter.flush();
    }

    public void writeComment(Object comment) throws IOException {
        this.cspResponseWriter.writeComment(comment);
    }

    public void writeText(Object text, String property) throws IOException {
        this.cspResponseWriter.writeText(text, property);
    }

    public void writeText(Object text, UIComponent component, String property) throws IOException {
        this.cspResponseWriter.writeText(text, component, property);
    }

    public void writeText(char[] text, int off, int len) throws IOException {
        this.cspResponseWriter.writeText(text, off, len);
    }

    public void close() throws IOException {
        this.cspResponseWriter.close();
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.cspResponseWriter.write(cbuf, off, len);
    }

    void writeJavascriptHandlers() throws IOException {
        if (this.cspState.getEventHandlers() == null || this.cspState.getEventHandlers().isEmpty()) {
            return;
        }
        if (this.sb == null) {
            this.sb = new StringBuilder(this.cspState.getEventHandlers().size() * 25);
        } else {
            this.sb.setLength(0);
        }
        for (Map.Entry<String, Map<String, String>> elements : this.cspState.getEventHandlers().entrySet()) {
            String id = elements.getKey();
            for (Map.Entry<String, String> events : elements.getValue().entrySet()) {
                String event = events.getKey();
                String javascript = events.getValue();
                this.sb.append("PrimeFaces.csp.register('");
                this.sb.append(EscapeUtils.forJavaScript(id));
                this.sb.append("','");
                this.sb.append(event);
                this.sb.append("',function(event){");
                this.sb.append(javascript);
                this.sb.append("});");
            }
        }
        this.requestContext.getScriptsToExecute().add(this.sb.toString());
        this.cspState.getEventHandlers().clear();
    }
}

