/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model.file;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.faces.FacesException;
import javax.servlet.http.Part;
import org.primefaces.model.file.UploadedFile;
import org.primefaces.shaded.commons.io.input.BoundedInputStream;
import org.primefaces.shaded.owasp.SafeFile;
import org.primefaces.util.FileUploadUtils;

public class NativeUploadedFile
implements UploadedFile,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final String CONTENT_DISPOSITION_FILENAME_ATTR = "filename";
    private transient Part part;
    private String filename;
    private byte[] cachedContent;
    private Long sizeLimit;

    public NativeUploadedFile() {
    }

    public NativeUploadedFile(Part part, Long sizeLimit) {
        this.part = part;
        this.sizeLimit = sizeLimit;
        this.filename = this.resolveFilename(part);
    }

    @Override
    public String getFileName() {
        return this.filename;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.sizeLimit == null ? this.part.getInputStream() : new BoundedInputStream(this.part.getInputStream(), this.sizeLimit);
    }

    @Override
    public long getSize() {
        return this.part.getSize();
    }

    @Override
    public byte[] getContent() {
        if (this.cachedContent != null) {
            return this.cachedContent;
        }
        try (InputStream input = this.getInputStream();){
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            int n = 0;
            while (-1 != (n = input.read(buffer))) {
                output.write(buffer, 0, n);
            }
            this.cachedContent = output.toByteArray();
        }
        catch (IOException ex) {
            this.cachedContent = null;
            throw new FacesException((Throwable)ex);
        }
        return this.cachedContent;
    }

    @Override
    public String getContentType() {
        return this.part.getContentType();
    }

    @Override
    public void write(String filePath) throws Exception {
        SafeFile file = new SafeFile(filePath);
        String validFilePath = FileUploadUtils.getValidFilePath(file.getCanonicalPath());
        this.part.write(new SafeFile(validFilePath, this.filename).getCanonicalPath());
    }

    @Override
    public void delete() throws IOException {
        this.part.delete();
    }

    public Part getPart() {
        return this.part;
    }

    private String resolveFilename(Part part) {
        if (part == null) {
            return null;
        }
        String contentDisposition = part.getHeader("content-disposition");
        if (contentDisposition == null) {
            return null;
        }
        return FileUploadUtils.getValidFilename(this.getContentDispositionFileName(contentDisposition));
    }

    protected String getContentDispositionFileName(String line) {
        int i = line.indexOf(CONTENT_DISPOSITION_FILENAME_ATTR);
        if (i == -1) {
            return null;
        }
        i += CONTENT_DISPOSITION_FILENAME_ATTR.length();
        int lineLength = line.length();
        while (i < lineLength && Character.isWhitespace(line.charAt(i))) {
            ++i;
        }
        if (i == lineLength || line.charAt(i++) != '=') {
            throw new FacesException("Content-Disposition filename property did not have '='.");
        }
        while (i < lineLength && Character.isWhitespace(line.charAt(i))) {
            ++i;
        }
        if (i == lineLength || line.charAt(i++) != '\"') {
            throw new FacesException("Content-Disposition filename property was not quoted.");
        }
        StringBuilder b = new StringBuilder();
        while (i < lineLength) {
            char c = line.charAt(i);
            if (c == '\"') {
                return this.decode(b.toString());
            }
            if (c == '\\' && i + 2 != lineLength) {
                char next;
                if ((next = line.charAt(++i)) == '\"') {
                    b.append('\"');
                } else {
                    b.append(c);
                    b.append(next);
                }
            } else {
                b.append(c);
            }
            ++i;
        }
        return this.decode(b.toString());
    }

    private String decode(String encoded) {
        try {
            encoded = encoded.replaceAll("%(?![0-9a-fA-F]{2})", "%25");
            encoded = encoded.replaceAll("\\+", "%2B");
            return URLDecoder.decode(encoded, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new FacesException((Throwable)ex);
        }
    }
}

