/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model.filter;

import java.util.Locale;
import java.util.function.BiPredicate;
import javax.faces.context.FacesContext;
import org.primefaces.model.filter.FilterConstraint;

public abstract class ComparableFilterConstraint
implements FilterConstraint {
    @Override
    public boolean isMatching(FacesContext ctxt, Object value, Object filter, Locale locale) {
        if (value == null || filter == null) {
            return false;
        }
        ComparableFilterConstraint.assertComparable(value);
        ComparableFilterConstraint.assertAssignable(filter, value);
        return this.getPredicate().test((Comparable)value, (Comparable)filter);
    }

    protected abstract BiPredicate<Comparable, Comparable> getPredicate();

    static void assertComparable(Object value) {
        if (!(value instanceof Comparable)) {
            throw new IllegalArgumentException("Value should be a java.lang.Comparable");
        }
    }

    static void assertAssignable(Object filter, Object value) {
        if (!filter.getClass().isAssignableFrom(value.getClass())) {
            throw new IllegalArgumentException("Filter cannot be casted to value type. Forgot to add a converter?");
        }
    }
}

