/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.util;

import java.awt.Color;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellUtil;
import org.apache.poi.xssf.usermodel.DefaultIndexedColorMap;
import org.apache.poi.xssf.usermodel.IndexedColorMap;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.export.ExcelOptions;
import org.primefaces.util.BigDecimalValidator;
import org.primefaces.util.CurrencyValidator;
import org.primefaces.util.LangUtils;

public class ExcelStylesManager {
    protected static final String DEFAULT_FONT = "Arial";
    private final Workbook wb;
    private final Locale locale;
    private final ExcelOptions options;
    private final boolean hssf;
    private final boolean stronglyTypedCells;
    private final DecimalFormat numberFormat;
    private final DecimalFormat currencyFormat;
    private CellStyle facetStyle;
    private CellStyle defaultCellStyle;
    private CellStyle generalNumberStyle;
    private CellStyle formattedDecimalStyle;
    private CellStyle formattedIntegerStyle;
    private CellStyle currencyStyle;

    public ExcelStylesManager(Workbook wb, Locale locale, ExcelOptions options) {
        this.wb = wb;
        this.locale = locale;
        this.options = options;
        this.hssf = wb instanceof HSSFWorkbook;
        this.stronglyTypedCells = options == null || options.isStronglyTypedCells();
        this.numberFormat = this.getNumberFormat();
        this.currencyFormat = this.getCurrencyFormat();
    }

    public void updateCell(UIColumn column, Cell cell, String value) {
        this.updateCell(cell, value);
        this.applyColumnAlignments(column, cell);
    }

    private void updateCell(Cell cell, String value) {
        boolean printed = false;
        if (this.stronglyTypedCells && !(printed = this.setNumberValueIfAppropiate(cell, value))) {
            printed = this.setCurrencyValueIfAppropiate(cell, value);
        }
        if (!printed) {
            cell.setCellStyle(this.getDefaultCellStyle());
            cell.setCellValue(this.createRichTextString(value));
        }
    }

    private boolean setNumberValueIfAppropiate(Cell cell, String value) {
        if (LangUtils.isNumeric(value)) {
            double number = Double.parseDouble(value);
            cell.setCellValue(number);
            cell.setCellStyle(this.getGeneralNumberStyle());
            return true;
        }
        BigDecimal number = BigDecimalValidator.getInstance().validate(value, this.numberFormat);
        if (number != null) {
            boolean hasDecimals;
            cell.setCellValue(number.doubleValue());
            boolean bl = hasDecimals = number.stripTrailingZeros().scale() > 0;
            if (hasDecimals) {
                cell.setCellStyle(this.getFormattedDecimalStyle());
            } else {
                cell.setCellStyle(this.getFormattedIntegerStyle());
            }
            return true;
        }
        return false;
    }

    private boolean setCurrencyValueIfAppropiate(Cell cell, String value) {
        BigDecimal currency = CurrencyValidator.getInstance().validate(value, this.currencyFormat);
        if (currency == null) {
            return false;
        }
        cell.setCellValue(((Number)currency).doubleValue());
        cell.setCellStyle(this.getCurrencyStyle());
        return true;
    }

    private void applyColumnAlignments(UIColumn column, Cell cell) {
        String[] styles = new String[]{column.getStyle(), column.getStyleClass()};
        if (LangUtils.containsIgnoreCase(styles, "right")) {
            CellUtil.setAlignment((Cell)cell, (HorizontalAlignment)HorizontalAlignment.RIGHT);
        } else if (LangUtils.containsIgnoreCase(styles, "center")) {
            CellUtil.setAlignment((Cell)cell, (HorizontalAlignment)HorizontalAlignment.CENTER);
        } else if (LangUtils.containsIgnoreCase(styles, "left")) {
            CellUtil.setAlignment((Cell)cell, (HorizontalAlignment)HorizontalAlignment.LEFT);
        }
    }

    public CellStyle getFacetStyle() {
        if (this.facetStyle == null) {
            this.facetStyle = this.createFacetStyle();
        }
        return this.facetStyle;
    }

    private CellStyle getDefaultCellStyle() {
        if (this.defaultCellStyle == null) {
            this.defaultCellStyle = this.createDefaultCellStyle();
        }
        return this.defaultCellStyle;
    }

    private CellStyle getGeneralNumberStyle() {
        if (this.generalNumberStyle == null) {
            this.generalNumberStyle = this.createGeneralNumberStyle();
        }
        return this.generalNumberStyle;
    }

    private CellStyle getFormattedIntegerStyle() {
        if (this.formattedIntegerStyle == null) {
            this.formattedIntegerStyle = this.createFormattedIntegerStyle();
        }
        return this.formattedIntegerStyle;
    }

    private CellStyle getFormattedDecimalStyle() {
        if (this.formattedDecimalStyle == null) {
            this.formattedDecimalStyle = this.createFormattedDecimalStyle();
        }
        return this.formattedDecimalStyle;
    }

    private CellStyle getCurrencyStyle() {
        if (this.currencyStyle == null) {
            this.currencyStyle = this.createCurrencyStyle();
        }
        return this.currencyStyle;
    }

    private CellStyle createFacetStyle() {
        CellStyle style = this.wb.createCellStyle();
        style.setFont(this.createFont());
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setWrapText(true);
        this.applyFacetOptions(style);
        return style;
    }

    private CellStyle createDefaultCellStyle() {
        CellStyle style = this.wb.createCellStyle();
        style.setFont(this.createFont());
        this.applyCellOptions(style);
        return style;
    }

    private CellStyle createGeneralNumberStyle() {
        CellStyle style = this.createDefaultCellStyle();
        style.setAlignment(HorizontalAlignment.RIGHT);
        return style;
    }

    private CellStyle createFormattedIntegerStyle() {
        CellStyle style = this.createGeneralNumberStyle();
        String format = this.getFormattedIntegerExcelFormat();
        short dataFormat = this.wb.getCreationHelper().createDataFormat().getFormat(format);
        style.setDataFormat(dataFormat);
        return style;
    }

    private CellStyle createFormattedDecimalStyle() {
        CellStyle style = this.createGeneralNumberStyle();
        String format = this.getFormattedDecimalExcelFormat();
        short dataFormat = this.wb.getCreationHelper().createDataFormat().getFormat(format);
        style.setDataFormat(dataFormat);
        return style;
    }

    private CellStyle createCurrencyStyle() {
        CellStyle style = this.createDefaultCellStyle();
        String format = this.getCurrencyExcelFormat();
        short dataFormat = this.wb.getCreationHelper().createDataFormat().getFormat(format);
        style.setDataFormat(dataFormat);
        style.setAlignment(HorizontalAlignment.RIGHT);
        return style;
    }

    private void applyFacetOptions(CellStyle style) {
        if (this.options != null) {
            if (this.hssf) {
                this.applyHssfFacetOptions(style);
            } else {
                this.applyXssfFacetOptions(style);
            }
        }
    }

    private void applyCellOptions(CellStyle style) {
        if (this.options != null) {
            if (this.hssf) {
                this.applyHssfCellOptions(style);
            } else {
                this.applyXssfCellOptions(style);
            }
        }
    }

    private void applyHssfFacetOptions(CellStyle style) {
        String facetFontSize;
        String facetFontColor;
        Color color;
        Font facetFont = this.wb.getFontAt(style.getFontIndex());
        String facetFontStyle = this.options.getFacetFontStyle();
        if (facetFontStyle != null) {
            if ("BOLD".equalsIgnoreCase(facetFontStyle)) {
                facetFont.setBold(true);
            }
            if ("ITALIC".equalsIgnoreCase(facetFontStyle)) {
                facetFont.setItalic(true);
            }
        }
        HSSFPalette palette = ((HSSFWorkbook)this.wb).getCustomPalette();
        String facetBackground = this.options.getFacetBgColor();
        if (facetBackground != null) {
            color = Color.decode(facetBackground);
            HSSFColor backgroundColor = palette.findSimilarColor(color.getRed(), color.getGreen(), color.getBlue());
            style.setFillForegroundColor(backgroundColor.getIndex());
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        }
        if ((facetFontColor = this.options.getFacetFontColor()) != null) {
            color = Color.decode(facetFontColor);
            HSSFColor facetColor = palette.findSimilarColor(color.getRed(), color.getGreen(), color.getBlue());
            facetFont.setColor(facetColor.getIndex());
        }
        if ((facetFontSize = this.options.getFacetFontSize()) != null) {
            facetFont.setFontHeightInPoints(Short.parseShort(facetFontSize));
        }
    }

    private void applyXssfFacetOptions(CellStyle style) {
        String facetFontSize;
        String facetFontColor;
        String facetBackground;
        Font facetFont = this.wb.getFontAt(style.getFontIndex());
        String facetFontStyle = this.options.getFacetFontStyle();
        if (facetFontStyle != null) {
            if ("BOLD".equalsIgnoreCase(facetFontStyle)) {
                facetFont.setBold(true);
            }
            if ("ITALIC".equalsIgnoreCase(facetFontStyle)) {
                facetFont.setItalic(true);
            }
        }
        if ((facetBackground = this.options.getFacetBgColor()) != null) {
            XSSFColor backgroundColor = new XSSFColor(Color.decode(facetBackground), (IndexedColorMap)new DefaultIndexedColorMap());
            ((XSSFCellStyle)style).setFillForegroundColor(backgroundColor);
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        }
        if ((facetFontColor = this.options.getFacetFontColor()) != null) {
            XSSFColor facetColor = new XSSFColor(Color.decode(facetFontColor), (IndexedColorMap)new DefaultIndexedColorMap());
            ((XSSFFont)facetFont).setColor(facetColor);
        }
        if ((facetFontSize = this.options.getFacetFontSize()) != null) {
            facetFont.setFontHeightInPoints(Short.parseShort(facetFontSize));
        }
    }

    private void applyHssfCellOptions(CellStyle style) {
        String cellFontStyle;
        String cellFontSize;
        Font cellFont = this.wb.getFontAt(style.getFontIndex());
        String cellFontColor = this.options.getCellFontColor();
        if (cellFontColor != null) {
            HSSFPalette palette = ((HSSFWorkbook)this.wb).getCustomPalette();
            Color color = Color.decode(cellFontColor);
            HSSFColor cellColor = palette.findSimilarColor(color.getRed(), color.getGreen(), color.getBlue());
            cellFont.setColor(cellColor.getIndex());
        }
        if ((cellFontSize = this.options.getCellFontSize()) != null) {
            cellFont.setFontHeightInPoints(Short.parseShort(cellFontSize));
        }
        if ((cellFontStyle = this.options.getCellFontStyle()) != null) {
            if ("BOLD".equalsIgnoreCase(cellFontStyle)) {
                cellFont.setBold(true);
            }
            if ("ITALIC".equalsIgnoreCase(cellFontStyle)) {
                cellFont.setItalic(true);
            }
        }
    }

    private void applyXssfCellOptions(CellStyle style) {
        String cellFontStyle;
        String cellFontSize;
        Font cellFont = this.wb.getFontAt(style.getFontIndex());
        String cellFontColor = this.options.getCellFontColor();
        if (cellFontColor != null) {
            XSSFColor cellColor = new XSSFColor(Color.decode(cellFontColor), (IndexedColorMap)new DefaultIndexedColorMap());
            ((XSSFFont)cellFont).setColor(cellColor);
        }
        if ((cellFontSize = this.options.getCellFontSize()) != null) {
            cellFont.setFontHeightInPoints(Short.parseShort(cellFontSize));
        }
        if ((cellFontStyle = this.options.getCellFontStyle()) != null) {
            if ("BOLD".equalsIgnoreCase(cellFontStyle)) {
                cellFont.setBold(true);
            }
            if ("ITALIC".equalsIgnoreCase(cellFontStyle)) {
                cellFont.setItalic(true);
            }
        }
    }

    private Font createFont() {
        Font font = this.wb.createFont();
        if (this.options != null) {
            String fontName = LangUtils.isBlank(this.options.getFontName()) ? DEFAULT_FONT : this.options.getFontName();
            font.setFontName(fontName);
        } else {
            font.setFontName(DEFAULT_FONT);
        }
        return font;
    }

    public RichTextString createRichTextString(String value) {
        if (this.hssf) {
            return new HSSFRichTextString(value);
        }
        return new XSSFRichTextString(value);
    }

    protected String getCurrencyExcelFormat() {
        String pattern = this.currencyFormat.toLocalizedPattern();
        String[] patterns = pattern.split(";");
        return this.toExcelPattern(patterns[0], this.currencyFormat.getDecimalFormatSymbols());
    }

    protected String getFormattedIntegerExcelFormat() {
        if (this.options == null || this.options.getNumberFormat() == null) {
            return BuiltinFormats.getBuiltinFormat((int)3);
        }
        return this.toExcelPattern(this.numberFormat.toLocalizedPattern(), this.numberFormat.getDecimalFormatSymbols());
    }

    protected String getFormattedDecimalExcelFormat() {
        if (this.options == null || this.options.getNumberFormat() == null) {
            return "#,##0.###";
        }
        return this.toExcelPattern(this.numberFormat.toLocalizedPattern(), this.numberFormat.getDecimalFormatSymbols());
    }

    private String toExcelPattern(String pattern, DecimalFormatSymbols symbols) {
        StringBuilder buffer = new StringBuilder(pattern.length());
        for (int i = 0; i < pattern.length(); ++i) {
            char character = pattern.charAt(i);
            if (character == symbols.getDecimalSeparator()) {
                buffer.append(".");
                continue;
            }
            if (character == symbols.getGroupingSeparator()) {
                buffer.append(",");
                continue;
            }
            if (character == symbols.getPatternSeparator()) {
                buffer.append(";");
                continue;
            }
            if (character == '\u00a4') {
                buffer.append("\"").append(symbols.getCurrencySymbol()).append("\"");
                continue;
            }
            buffer.append(character);
        }
        return buffer.toString();
    }

    private DecimalFormat getNumberFormat() {
        if (this.options != null && this.options.getNumberFormat() != null) {
            return this.options.getNumberFormat();
        }
        return (DecimalFormat)DecimalFormat.getInstance(this.locale);
    }

    private DecimalFormat getCurrencyFormat() {
        if (this.options != null && this.options.getCurrencyFormat() != null) {
            return this.options.getCurrencyFormat();
        }
        return (DecimalFormat)DecimalFormat.getCurrencyInstance(this.locale);
    }
}

