/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import org.primefaces.component.api.DynamicColumn;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.column.Column;
import org.primefaces.component.columngroup.ColumnGroup;
import org.primefaces.component.columns.Columns;
import org.primefaces.model.ColumnMeta;
import org.primefaces.util.ComponentUtils;

public interface ColumnAware {
    default public void forEachColumn(Predicate<UIColumn> callback) {
        this.forEachColumn(true, true, false, callback);
    }

    default public void forEachColumn(boolean unwrapDynamicColumns, boolean skipUnrendered, boolean skipColumnGroups, Predicate<UIColumn> callback) {
        this.forEachColumn(FacesContext.getCurrentInstance(), (UIComponent)this, unwrapDynamicColumns, skipUnrendered, skipColumnGroups, callback);
    }

    default public boolean forEachColumn(FacesContext context, UIComponent root, boolean unwrapDynamicColumns, boolean skipUnrendered, boolean skipColumnGroups, Predicate<UIColumn> callback) {
        for (int i = 0; i < root.getChildCount(); ++i) {
            int j;
            UIComponent child = (UIComponent)root.getChildren().get(i);
            if (!(child instanceof Columns) && skipUnrendered && !child.isRendered()) continue;
            if (child instanceof Columns) {
                Columns columns = (Columns)child;
                if (unwrapDynamicColumns) {
                    for (j = 0; j < columns.getRowCount(); ++j) {
                        DynamicColumn dynaColumn = new DynamicColumn(j, columns, context);
                        dynaColumn.applyStatelessModel();
                        if (skipUnrendered && !dynaColumn.isRendered() || callback.test(dynaColumn)) continue;
                        return false;
                    }
                    continue;
                }
                if (callback.test(columns)) continue;
                return false;
            }
            if (child instanceof Column) {
                Column column = (Column)child;
                if (callback.test(column)) continue;
                return false;
            }
            if (child instanceof ColumnGroup && !skipColumnGroups) {
                for (int j2 = 0; j2 < child.getChildCount(); ++j2) {
                    UIComponent row = (UIComponent)child.getChildren().get(j2);
                    if (skipUnrendered && !row.isRendered() || this.forEachColumn(context, row, unwrapDynamicColumns, skipUnrendered, skipColumnGroups, callback)) continue;
                    return false;
                }
                continue;
            }
            if (child instanceof ColumnAware) {
                ColumnAware columnAware = (ColumnAware)child;
                for (j = 0; j < ((UIComponent)columnAware).getChildCount(); ++j) {
                    UIComponent columnAwareChild = (UIComponent)((UIComponent)columnAware).getChildren().get(j);
                    if (skipUnrendered && !columnAwareChild.isRendered() || this.forEachColumn(context, columnAwareChild, unwrapDynamicColumns, skipUnrendered, skipColumnGroups, callback)) continue;
                    return false;
                }
                continue;
            }
            if (!child.getClass().getName().endsWith("UIRepeat")) continue;
            VisitContext visitContext = VisitContext.createVisitContext((FacesContext)context, null, ComponentUtils.VISIT_HINTS_SKIP_UNRENDERED);
            child.visitTree(visitContext, (ctx, target) -> {
                Column column;
                if (target.getClass().getName().endsWith("UIRepeat")) {
                    return VisitResult.ACCEPT;
                }
                if (target instanceof Column && !callback.test(column = (Column)target)) {
                    return VisitResult.COMPLETE;
                }
                return VisitResult.REJECT;
            });
        }
        return true;
    }

    default public void invokeOnColumn(String columnKey, Consumer<UIColumn> callback) {
        this.forEachColumn(column -> {
            if (column.getColumnKey().equals(columnKey)) {
                callback.accept((UIColumn)column);
                return false;
            }
            return true;
        });
    }

    default public void invokeOnColumn(String columnKey, int rowIndex, Consumer<UIColumn> callback) {
        this.forEachColumn(column -> {
            if (column.getColumnKey((UIComponent)this, rowIndex).equals(columnKey)) {
                callback.accept((UIColumn)column);
                return false;
            }
            return true;
        });
    }

    default public UIColumn findColumn(String columnKey) {
        if ("globalFilter".equals(columnKey)) {
            return null;
        }
        List<UIColumn> columns = this.getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            UIColumn column = columns.get(i);
            if (!Objects.equals(column.getColumnKey(), columnKey)) continue;
            return column;
        }
        if (this.getFrozenColumnsCount() > 0) {
            UIColumn column = this.findColumnInGroup(columnKey, this.getColumnGroup("frozenHeader"));
            if (column == null) {
                column = this.findColumnInGroup(columnKey, this.getColumnGroup("scrollableHeader"));
            }
            if (column != null) {
                return column;
            }
        } else {
            return this.findColumnInGroup(columnKey, this.getColumnGroup("header"));
        }
        throw new FacesException("Cannot find column with key: " + columnKey);
    }

    default public int getFrozenColumnsCount() {
        return 0;
    }

    default public UIColumn findColumnInGroup(String columnKey, ColumnGroup group) {
        if (group == null) {
            return null;
        }
        for (int i = 0; i < group.getChildCount(); ++i) {
            UIComponent row = (UIComponent)group.getChildren().get(i);
            for (int j = 0; j < row.getChildCount(); ++j) {
                UIComponent rowChild = (UIComponent)row.getChildren().get(j);
                if (rowChild instanceof Column) {
                    Column column = (Column)rowChild;
                    if (!Objects.equals(column.getColumnKey(), columnKey)) continue;
                    return column;
                }
                if (!(rowChild instanceof Columns)) continue;
                Columns columns = (Columns)rowChild;
                List<DynamicColumn> dynamicColumns = columns.getDynamicColumns();
                for (UIColumn uIColumn : dynamicColumns) {
                    if (!Objects.equals(uIColumn.getColumnKey(), columnKey)) continue;
                    return uIColumn;
                }
            }
        }
        return null;
    }

    default public ColumnGroup getColumnGroup(String type) {
        for (int i = 0; i < ((UIComponent)this).getChildCount(); ++i) {
            ColumnGroup colGroup;
            UIComponent child = (UIComponent)((UIComponent)this).getChildren().get(i);
            if (!(child instanceof ColumnGroup) || !Objects.equals(type, (colGroup = (ColumnGroup)child).getType())) continue;
            return colGroup;
        }
        return null;
    }

    public List<UIColumn> getColumns();

    public void setColumns(List<UIColumn> var1);

    default public List<UIColumn> collectColumns() {
        ArrayList<UIColumn> columns = new ArrayList<UIColumn>();
        FacesContext context = FacesContext.getCurrentInstance();
        for (int i = 0; i < ((UIComponent)this).getChildCount(); ++i) {
            UIComponent child = (UIComponent)((UIComponent)this).getChildren().get(i);
            if (child instanceof Column) {
                columns.add((Column)child);
                continue;
            }
            if (!(child instanceof Columns)) continue;
            Columns uiColumns = (Columns)child;
            for (int j = 0; j < uiColumns.getRowCount(); ++j) {
                DynamicColumn dynaColumn = new DynamicColumn(j, uiColumns, context);
                columns.add(dynaColumn);
            }
        }
        Map<String, ColumnMeta> columnMeta = this.getColumnMeta();
        columns.sort((c1, c2) -> {
            if (c1 instanceof DynamicColumn) {
                ((DynamicColumn)c1).applyStatelessModel();
            }
            Integer dp1 = c1.getDisplayPriority();
            ColumnMeta cm1 = (ColumnMeta)columnMeta.get(c1.getColumnKey());
            if (cm1 != null && cm1.getDisplayPriority() != null) {
                dp1 = cm1.getDisplayPriority();
            }
            if (c2 instanceof DynamicColumn) {
                ((DynamicColumn)c2).applyStatelessModel();
            }
            Integer dp2 = c2.getDisplayPriority();
            ColumnMeta cm2 = (ColumnMeta)columnMeta.get(c2.getColumnKey());
            if (cm2 != null && cm2.getDisplayPriority() != null) {
                dp2 = cm2.getDisplayPriority();
            }
            return dp1.compareTo(dp2);
        });
        return columns;
    }

    default public int getColumnsCount() {
        return this.getColumnsCount(true);
    }

    default public int getColumnsCount(boolean visibleOnly) {
        LongAdder columnsCount = new LongAdder();
        this.forEachColumn(true, true, true, column -> {
            if (!visibleOnly || column.isVisible()) {
                columnsCount.increment();
            }
            return true;
        });
        return columnsCount.intValue();
    }

    default public int getColumnsCountWithSpan() {
        return this.getColumnsCountWithSpan(true);
    }

    default public int getColumnsCountWithSpan(boolean visibleOnly) {
        LongAdder columnsCountWithSpan = new LongAdder();
        this.forEachColumn(true, true, true, column -> {
            if (!visibleOnly || column.isVisible()) {
                columnsCountWithSpan.add(column.getColspan());
            }
            return true;
        });
        return columnsCountWithSpan.intValue();
    }

    default public void resetDynamicColumns() {
        this.forEachColumn(false, false, false, column -> {
            if (column instanceof Columns) {
                ((Columns)column).setRowIndex(-1);
                this.setColumns(null);
            }
            return true;
        });
    }

    public Map<String, ColumnMeta> getColumnMeta();

    public void setColumnMeta(Map<String, ColumnMeta> var1);

    default public String getOrderedColumnKeys() {
        return this.getColumns().stream().map(e -> e.getColumnKey()).collect(Collectors.joining(","));
    }
}

