/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.api;

import java.util.Map;
import java.util.function.Consumer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.FacesEvent;
import org.primefaces.event.SelectEvent;

public interface DialogReturnAware {
    public static final String EVENT_DIALOG_RETURN = "dialogReturn";
    public static final String ATTRIBUTE_DIALOG_RETURN_SCRIPT = "data-dialogreturn";

    default public boolean isDialogReturnEvent(FacesEvent event, FacesContext context) {
        if (event instanceof AjaxBehaviorEvent) {
            Map params = context.getExternalContext().getRequestParameterMap();
            String eventName = (String)params.get("javax.faces.behavior.event");
            return eventName.equals(EVENT_DIALOG_RETURN);
        }
        return false;
    }

    default public void queueDialogReturnEvent(FacesEvent event, FacesContext context, UIComponent source, Consumer<FacesEvent> queueEvent) {
        Map params = context.getExternalContext().getRequestParameterMap();
        AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
        Map session = context.getExternalContext().getSessionMap();
        String dcid = (String)params.get(source.getClientId(context) + "_pfdlgcid");
        Object selectedValue = session.get(dcid);
        session.remove(dcid);
        queueEvent.accept((FacesEvent)new SelectEvent(source, behaviorEvent.getBehavior(), selectedValue));
    }
}

