/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datatable;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.model.SelectItem;
import org.primefaces.component.api.DynamicColumn;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.celleditor.CellEditor;
import org.primefaces.component.column.Column;
import org.primefaces.component.column.ColumnBase;
import org.primefaces.component.columngroup.ColumnGroup;
import org.primefaces.component.columns.Columns;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.datatable.feature.DataTableFeature;
import org.primefaces.component.datatable.feature.FilterFeature;
import org.primefaces.component.datatable.feature.RowExpandFeature;
import org.primefaces.component.datatable.feature.SelectionFeature;
import org.primefaces.component.datatable.feature.SortFeature;
import org.primefaces.component.headerrow.HeaderRow;
import org.primefaces.component.row.Row;
import org.primefaces.component.subtable.SubTable;
import org.primefaces.component.summaryrow.SummaryRow;
import org.primefaces.event.data.PostRenderEvent;
import org.primefaces.model.ColumnMeta;
import org.primefaces.model.SortMeta;
import org.primefaces.model.SortOrder;
import org.primefaces.renderkit.DataRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.LangUtils;
import org.primefaces.util.MessageFactory;
import org.primefaces.util.WidgetBuilder;

public class DataTableRenderer
extends DataRenderer {
    private static final Logger LOGGER = Logger.getLogger(DataTableRenderer.class.getName());

    public void decode(FacesContext context, UIComponent component) {
        DataTable table = (DataTable)component;
        for (DataTableFeature feature : DataTable.FEATURES) {
            if (!feature.shouldDecode(context, table)) continue;
            feature.decode(context, table);
        }
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        DataTable table = (DataTable)component;
        if (table.shouldEncodeFeature(context)) {
            for (DataTableFeature feature : DataTable.FEATURES) {
                if (!feature.shouldEncode(context, table)) continue;
                feature.encode(context, this, table);
            }
            if (table.isFullUpdateRequest(context)) {
                this.render(context, table);
            }
        } else {
            this.render(context, table);
        }
        context.getApplication().publishEvent(context, PostRenderEvent.class, (Object)table);
    }

    protected void render(FacesContext context, DataTable table) throws IOException {
        this.preRender(context, table);
        this.encodeMarkup(context, table);
        this.encodeScript(context, table);
        if (table.isPaginator() && table.getRows() == 0) {
            LOGGER.log(Level.WARNING, "DataTable with paginator=true should also set the rows attribute. ClientId: " + table.getClientId());
        }
    }

    protected void preRender(FacesContext context, DataTable table) {
        table.getSortByAsMap();
        table.getFilterByAsMap();
        if (table.isMultiViewState()) {
            table.restoreMultiViewState();
        }
        if (table.isLiveScroll()) {
            table.setScrollOffset(0);
        }
        if (table.isLazy()) {
            if (table.isLiveScroll()) {
                table.loadLazyScrollData(0, table.getScrollRows());
            } else if (table.isVirtualScroll()) {
                int rows = table.getRows();
                int scrollRows = table.getScrollRows();
                int virtualScrollRows = scrollRows * 2;
                scrollRows = rows == 0 ? virtualScrollRows : Math.min(virtualScrollRows, rows);
                table.loadLazyScrollData(0, scrollRows);
            } else {
                table.loadLazyData();
            }
        } else {
            if (table.isFilteringCurrentlyActive()) {
                FilterFeature.getInstance().filter(context, table);
            }
            if (table.isSortingCurrentlyActive()) {
                SortFeature.getInstance().sort(context, table);
                table.setRowIndex(-1);
            }
        }
        if (table.isSelectionEnabled()) {
            SelectionFeature.getInstance().decodeSelectionRowKeys(context, table);
        }
        if (table.isPaginator()) {
            table.calculateRows();
            table.calculateFirst();
        }
        table.resetDynamicColumns();
    }

    protected void encodeScript(FacesContext context, DataTable table) throws IOException {
        String selectionMode = table.resolveSelectionMode();
        String widgetClass = table.getFrozenColumns() == 0 ? "DataTable" : "FrozenDataTable";
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init(widgetClass, table);
        if (table.isPaginator()) {
            this.encodePaginatorConfig(context, table, wb);
        }
        wb.attr("selectionMode", selectionMode, null).attr("selectionPageOnly", table.isSelectionPageOnly(), true).attr("rowSelectMode", table.getRowSelectMode(), "new").attr("nativeElements", table.isNativeElements(), false).attr("rowSelector", table.getRowSelector(), null).attr("disabledTextSelection", table.isDisabledTextSelection(), true);
        if (table.isFilteringEnabled()) {
            wb.attr("filter", true).attr("filterEvent", table.getFilterEvent(), null).attr("filterDelay", table.getFilterDelay(), Integer.MAX_VALUE);
        }
        if (table.getRowExpansion() != null) {
            wb.attr("expansion", true).attr("rowExpandMode", table.getRowExpandMode());
        }
        if (table.isScrollable()) {
            wb.attr("scrollable", true).attr("liveScroll", table.isLiveScroll()).attr("scrollStep", table.getScrollRows()).attr("scrollLimit", table.getRowCount()).attr("scrollWidth", table.getScrollWidth(), null).attr("scrollHeight", table.getScrollHeight(), null).attr("frozenColumns", table.getFrozenColumns(), 0).attr("liveScrollBuffer", table.getLiveScrollBuffer()).attr("virtualScroll", table.isVirtualScroll()).attr("touchable", false, true);
        } else {
            wb.attr("touchable", ComponentUtils.isTouchable(context, table), true);
        }
        wb.attr("resizableColumns", table.isResizableColumns(), false).attr("liveResize", table.isLiveResize(), false).attr("draggableColumns", table.isDraggableColumns(), false).attr("resizeMode", table.getResizeMode(), "fit");
        wb.attr("draggableRows", table.isDraggableRows(), false).attr("rowDragSelector", table.getRowDragSelector(), null);
        if (table.isEditable()) {
            wb.attr("editable", true).attr("editMode", table.getEditMode()).attr("cellSeparator", table.getCellSeparator(), null).attr("saveOnCellBlur", table.isSaveOnCellBlur(), true).attr("cellEditMode", table.getCellEditMode(), "eager").attr("editInitEvent", table.getEditInitEvent()).attr("rowEditMode", table.getRowEditMode(), "eager");
        }
        if (table.isSortingEnabled()) {
            wb.attr("sorting", true);
            if (table.isMultiSort()) {
                wb.attr("multiSort", true).nativeAttr("sortMetaOrder", table.getSortMetaAsString(), null);
            }
            if (table.isAllowUnsorting()) {
                wb.attr("allowUnsorting", true);
            }
        }
        if (table.isStickyHeader()) {
            wb.attr("stickyHeader", true).attr("stickyTopAt", table.getStickyTopAt(), null);
        }
        wb.attr("tabindex", table.getTabindex(), "0").attr("reflow", table.isReflow(), false).attr("rowHover", table.isRowHover(), false).attr("clientCache", table.isClientCache(), false).attr("multiViewState", table.isMultiViewState(), false).attr("partialUpdate", table.isPartialUpdate(), true).nativeAttr("groupColumnIndexes", table.getGroupedColumnIndexes(), null).callback("onRowClick", "function(row)", table.getOnRowClick());
        wb.attr("disableContextMenuIfEmpty", table.isDisableContextMenuIfEmpty());
        this.encodeClientBehaviors(context, table);
        wb.finish();
    }

    protected void encodeMarkup(FacesContext context, DataTable table) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = table.getClientId(context);
        boolean scrollable = table.isScrollable();
        boolean hasPaginator = table.isPaginator();
        boolean resizable = table.isResizableColumns();
        String style = Objects.toString(table.getStyle(), "");
        String paginatorPosition = table.getPaginatorPosition();
        int frozenColumns = table.getFrozenColumns();
        boolean hasFrozenColumns = frozenColumns != 0;
        String summary = table.getSummary();
        if (table.isReflow()) {
            style = style + ";visibility:hidden;";
        }
        String containerClass = this.getStyleClassBuilder(context).add("ui-datatable ui-widget").add(scrollable, "ui-datatable-scrollable").add(table.getStyleClass()).add(resizable, "ui-datatable-resizable").add(table.isStickyHeader(), "ui-datatable-sticky").add(ComponentUtils.isRTL(context, table), "ui-datatable-rtl").add(table.isReflow(), "ui-datatable-reflow").add(hasFrozenColumns, "ui-datatable-frozencolumn").add(table.isStripedRows(), "ui-datatable-striped").add(table.isShowGridlines(), "ui-datatable-gridlines").add("small".equals(table.getSize()), "ui-datatable-sm").add("large".equals(table.getSize()), "ui-datatable-lg").build();
        if (summary != null) {
            writer.startElement("span", null);
            writer.writeAttribute("id", (Object)(clientId + "_summary"), null);
            writer.writeAttribute("class", (Object)"ui-datatable-summary", null);
            writer.writeText((Object)summary, null);
            writer.endElement("span");
        }
        writer.startElement("div", (UIComponent)table);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)containerClass, "styleClass");
        if (LangUtils.isNotBlank(style)) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        if (table.isReflow()) {
            this.encodeSortableHeaderOnReflow(context, table);
        }
        this.encodeFacet(context, table, table.getHeader(), "ui-datatable-header ui-widget-header ui-corner-top");
        if (hasPaginator && !"bottom".equalsIgnoreCase(paginatorPosition)) {
            this.encodePaginatorMarkup(context, table, "top");
        }
        if (scrollable) {
            this.encodeScrollableTable(context, table);
        } else {
            this.encodeRegularTable(context, table);
        }
        if (hasPaginator && !"top".equalsIgnoreCase(paginatorPosition)) {
            this.encodePaginatorMarkup(context, table, "bottom");
        }
        this.encodeFacet(context, table, table.getFooter(), "ui-datatable-footer ui-widget-header ui-corner-bottom");
        if (table.isSelectionEnabled()) {
            this.encodeStateHolder(context, table, table.getClientId(context) + "_selection", table.getSelectedRowKeysAsString());
        }
        if (table.isDraggableColumns()) {
            this.encodeStateHolder(context, table, table.getClientId(context) + "_columnOrder", table.getOrderedColumnKeys());
        }
        if (scrollable) {
            this.encodeStateHolder(context, table, table.getClientId(context) + "_scrollState", table.getScrollState());
        }
        if (resizable) {
            this.encodeStateHolder(context, table, table.getClientId(context) + "_resizableColumnState", table.getColumnsWidthForClientSide());
        }
        if (table.getRowExpansion() != null) {
            this.encodeStateHolder(context, table, table.getClientId(context) + "_rowExpansionState", null);
        }
        writer.endElement("div");
    }

    protected void encodeRegularTable(FacesContext context, DataTable table) throws IOException {
        String width;
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-datatable-tablewrapper", null);
        String tableStyle = table.getTableStyle();
        if (table.isResizableColumns() && (width = table.getWidth()) != null) {
            tableStyle = tableStyle != null ? tableStyle + ";width:" + width + "px" : "width:" + width + "px";
        }
        writer.startElement("table", null);
        writer.writeAttribute("role", (Object)"grid", null);
        if (tableStyle != null) {
            writer.writeAttribute("style", (Object)tableStyle, null);
        }
        if (table.getTableStyleClass() != null) {
            writer.writeAttribute("class", (Object)table.getTableStyleClass(), null);
        }
        String summary = table.getSummary();
        String clientId = table.getClientId(context);
        if (summary != null) {
            writer.writeAttribute("summary", (Object)summary, null);
            writer.writeAttribute("aria-describedby", (Object)(clientId + "_summary"), null);
        }
        this.encodeThead(context, table);
        this.encodeTbody(context, table, false);
        this.encodeTFoot(context, table);
        writer.endElement("table");
        writer.endElement("div");
    }

    protected void encodeScrollableTable(FacesContext context, DataTable table) throws IOException {
        String tableStyle = table.getTableStyle();
        String tableStyleClass = table.getTableStyleClass();
        int frozenColumns = table.getFrozenColumns();
        boolean hasFrozenColumns = frozenColumns != 0;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = table.getClientId(context);
        int columnsCount = table.getColumns().size();
        boolean isVirtualScroll = table.isVirtualScroll();
        if (hasFrozenColumns) {
            writer.startElement("table", null);
            writer.writeAttribute("class", (Object)"ui-datatable-fs", null);
            writer.startElement("tbody", null);
            writer.startElement("tr", null);
            writer.startElement("td", null);
            writer.writeAttribute("class", (Object)"ui-datatable-frozenlayout-left", null);
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)"ui-datatable-frozen-container", null);
            this.encodeScrollAreaStart(context, table, "ui-widget-header ui-datatable-scrollable-header", "ui-datatable-scrollable-header-box", tableStyle, tableStyleClass);
            this.encodeThead(context, table, 0, frozenColumns, clientId + "_frozenThead", "frozenHeader");
            this.encodeFrozenRows(context, table, 0, frozenColumns);
            this.encodeScrollAreaEnd(context);
            if (isVirtualScroll) {
                this.encodeVirtualScrollBody(context, table, tableStyle, tableStyleClass, 0, frozenColumns, clientId + "_frozenTbody");
            } else {
                this.encodeScrollBody(context, table, tableStyle, tableStyleClass, 0, frozenColumns, clientId + "_frozenTbody");
            }
            this.encodeScrollAreaStart(context, table, "ui-widget-header ui-datatable-scrollable-footer", "ui-datatable-scrollable-footer-box", tableStyle, tableStyleClass);
            this.encodeTFoot(context, table, 0, frozenColumns, clientId + "_frozenTfoot", "frozenFooter");
            this.encodeScrollAreaEnd(context);
            writer.endElement("div");
            writer.endElement("td");
            writer.startElement("td", null);
            writer.writeAttribute("class", (Object)"ui-datatable-frozenlayout-right", null);
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)"ui-datatable-scrollable-container", null);
            this.encodeScrollAreaStart(context, table, "ui-widget-header ui-datatable-scrollable-header", "ui-datatable-scrollable-header-box", tableStyle, tableStyleClass);
            this.encodeThead(context, table, frozenColumns, columnsCount, clientId + "_scrollableThead", "scrollableHeader");
            this.encodeFrozenRows(context, table, frozenColumns, columnsCount);
            this.encodeScrollAreaEnd(context);
            if (isVirtualScroll) {
                this.encodeVirtualScrollBody(context, table, tableStyle, tableStyleClass, frozenColumns, columnsCount, clientId + "_scrollableTbody");
            } else {
                this.encodeScrollBody(context, table, tableStyle, tableStyleClass, frozenColumns, columnsCount, clientId + "_scrollableTbody");
            }
            this.encodeScrollAreaStart(context, table, "ui-widget-header ui-datatable-scrollable-footer", "ui-datatable-scrollable-footer-box", tableStyle, tableStyleClass);
            this.encodeTFoot(context, table, frozenColumns, columnsCount, clientId + "_scrollableTfoot", "scrollableFooter");
            this.encodeScrollAreaEnd(context);
            writer.endElement("div");
            writer.endElement("td");
            writer.endElement("tr");
            writer.endElement("tbody");
            writer.endElement("table");
        } else {
            this.encodeScrollAreaStart(context, table, "ui-widget-header ui-datatable-scrollable-header", "ui-datatable-scrollable-header-box", tableStyle, tableStyleClass);
            this.encodeThead(context, table);
            this.encodeFrozenRows(context, table, 0, columnsCount);
            this.encodeScrollAreaEnd(context);
            if (isVirtualScroll) {
                this.encodeVirtualScrollBody(context, table, tableStyle, tableStyleClass, 0, columnsCount, null);
            } else {
                this.encodeScrollBody(context, table, tableStyle, tableStyleClass, 0, columnsCount, null);
            }
            this.encodeScrollAreaStart(context, table, "ui-widget-header ui-datatable-scrollable-footer", "ui-datatable-scrollable-footer-box", tableStyle, tableStyleClass);
            this.encodeTFoot(context, table);
            this.encodeScrollAreaEnd(context);
        }
    }

    protected void encodeFrozenScrollableTable(FacesContext context, DataTable table, int frozenColumns) throws IOException {
    }

    protected void encodeScrollAreaStart(FacesContext context, DataTable table, String containerClass, String containerBoxClass, String tableStyle, String tableStyleClass) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)containerClass, null);
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)containerBoxClass, null);
        writer.startElement("table", null);
        writer.writeAttribute("role", (Object)"grid", null);
        if (tableStyle != null) {
            writer.writeAttribute("style", (Object)tableStyle, null);
        }
        if (tableStyleClass != null) {
            writer.writeAttribute("class", (Object)tableStyleClass, null);
        }
    }

    protected void encodeScrollAreaEnd(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("table");
        writer.endElement("div");
        writer.endElement("div");
    }

    protected void encodeScrollBody(FacesContext context, DataTable table, String tableStyle, String tableStyleClass, int columnStart, int columnEnd, String tbodyId) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String scrollHeight = table.getScrollHeight();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-datatable-scrollable-body", null);
        writer.writeAttribute("tabindex", (Object)"-1", null);
        if (LangUtils.isNotBlank(scrollHeight)) {
            if (!this.endsWithLenghtUnit(scrollHeight)) {
                scrollHeight = scrollHeight + "px";
            }
            if (scrollHeight.indexOf(37) == -1) {
                writer.writeAttribute("style", (Object)("max-height:" + scrollHeight), null);
            }
        }
        writer.startElement("table", null);
        writer.writeAttribute("role", (Object)"grid", null);
        if (tableStyle != null) {
            writer.writeAttribute("style", (Object)tableStyle, null);
        }
        if (table.getTableStyleClass() != null) {
            writer.writeAttribute("class", (Object)tableStyleClass, null);
        }
        this.encodeTbody(context, table, false, columnStart, columnEnd, tbodyId);
        writer.endElement("table");
        writer.endElement("div");
    }

    protected void encodeVirtualScrollBody(FacesContext context, DataTable table, String tableStyle, String tableStyleClass, int columnStart, int columnEnd, String tbodyId) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String scrollHeight = table.getScrollHeight();
        tableStyleClass = tableStyleClass == null ? "ui-datatable-virtualscroll-table" : tableStyleClass + " " + "ui-datatable-virtualscroll-table";
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-datatable-scrollable-body", null);
        writer.writeAttribute("tabindex", (Object)"-1", null);
        if (scrollHeight != null && scrollHeight.indexOf(37) == -1) {
            writer.writeAttribute("style", (Object)("max-height:" + scrollHeight + "px"), null);
        }
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-datatable-virtualscroll-wrapper", null);
        writer.startElement("table", null);
        writer.writeAttribute("role", (Object)"grid", null);
        writer.writeAttribute("class", (Object)tableStyleClass, null);
        if (tableStyle != null) {
            writer.writeAttribute("style", (Object)tableStyle, null);
        }
        this.encodeTbody(context, table, false, columnStart, columnEnd, tbodyId);
        writer.endElement("table");
        writer.endElement("div");
        writer.endElement("div");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void encodeColumnHeader(FacesContext context, DataTable table, UIColumn column) throws IOException {
        if (!column.isRendered()) {
            return;
        }
        ColumnMeta columnMeta = table.getColumnMeta().get(column.getColumnKey());
        ResponseWriter writer = context.getResponseWriter();
        String clientId = column.getContainerClientId(context);
        boolean sortable = table.isColumnSortable(context, column);
        boolean filterable = table.isColumnFilterable(context, column);
        boolean isGroupedColumn = column.isGroupRow();
        String selectionMode = column.getSelectionMode();
        SortMeta sortMeta = null;
        boolean resizable = table.isResizableColumns() && column.isResizable();
        boolean draggable = table.isDraggableColumns() && column.isDraggable();
        int responsivePriority = column.getResponsivePriority();
        boolean columnVisible = column.isVisible();
        if (columnMeta != null && columnMeta.getVisible() != null) {
            columnVisible = columnMeta.getVisible();
        }
        String columnClass = this.getStyleClassBuilder(context).add("ui-state-default").add(sortable, "ui-sortable-column").add(filterable, "ui-filter-column").add(selectionMode != null, "ui-selection-column").add(isGroupedColumn, "ui-grouped-column").add(resizable, "ui-resizable-column").add(draggable, "ui-draggable-column").add(!column.isToggleable(), "ui-static-column").add(!columnVisible, "ui-helper-hidden").add(column.getStyleClass()).add(responsivePriority > 0, "ui-column-p-" + responsivePriority).build();
        if (sortable && (sortMeta = table.getSortByAsMap().get(column.getColumnKey())).isActive()) {
            columnClass = columnClass + " ui-state-active";
        }
        String style = column.getStyle();
        String width = column.getWidth();
        if (columnMeta != null && columnMeta.getWidth() != null) {
            width = columnMeta.getWidth();
        }
        if (width != null) {
            String unit = this.endsWithLenghtUnit(width) ? "" : "px";
            style = style != null ? style + ";width:" + width + unit : "width:" + width + unit;
        }
        String ariaHeaderLabel = this.getHeaderLabel(context, column);
        UIComponent component = column instanceof UIComponent ? (UIComponent)column : null;
        writer.startElement("th", component);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)columnClass, null);
        writer.writeAttribute("role", (Object)"columnheader", null);
        writer.writeAttribute("aria-label", (Object)ariaHeaderLabel, null);
        writer.writeAttribute("scope", (Object)"col", null);
        if (component != null) {
            this.renderDynamicPassThruAttributes(context, component);
        }
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if (column.getRowspan() != 1) {
            writer.writeAttribute("rowspan", (Object)column.getRowspan(), null);
        }
        if (column.getColspan() != 1) {
            writer.writeAttribute("colspan", (Object)column.getColspan(), null);
        }
        if (filterable) {
            String filterPosition = column.getFilterPosition();
            if ("bottom".equals(filterPosition)) {
                this.encodeColumnHeaderContent(context, table, column, sortMeta);
                this.encodeFilter(context, table, column);
            } else {
                if (!"top".equals(filterPosition)) throw new FacesException(filterPosition + " is an invalid option for filterPosition, valid values are 'bottom' or 'top'.");
                this.encodeFilter(context, table, column);
                this.encodeColumnHeaderContent(context, table, column, sortMeta);
            }
        } else {
            this.encodeColumnHeaderContent(context, table, column, sortMeta);
        }
        if (selectionMode != null && "multiple".equalsIgnoreCase(selectionMode)) {
            this.encodeCheckbox(context, table, table.isSelectAll(), false, "ui-chkbox ui-chkbox-all ui-widget", true);
        }
        writer.endElement("th");
    }

    protected String resolveDefaultSortIcon(SortMeta sortMeta) {
        SortOrder sortOrder = sortMeta.getOrder();
        String sortIcon = "ui-sortable-column-icon ui-icon ui-icon-carat-2-n-s";
        if (sortOrder.isAscending()) {
            sortIcon = "ui-sortable-column-icon ui-icon ui-icon ui-icon-carat-2-n-s ui-icon-triangle-1-n";
        } else if (sortOrder.isDescending()) {
            sortIcon = "ui-sortable-column-icon ui-icon ui-icon ui-icon-carat-2-n-s ui-icon-triangle-1-s";
        }
        return sortIcon;
    }

    protected void encodeColumnHeaderContent(FacesContext context, DataTable table, UIColumn column, SortMeta sortMeta) throws IOException {
        String sortIcon;
        ResponseWriter writer = context.getResponseWriter();
        UIComponent header = column.getFacet("header");
        String headerText = column.getHeaderText();
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-column-title", null);
        if (ComponentUtils.shouldRenderFacet(header, table.isRenderEmptyFacets())) {
            header.encodeAll(context);
        } else if (headerText != null) {
            if (table.isEscapeText()) {
                writer.writeText((Object)headerText, "headerText");
            } else {
                writer.write(headerText);
            }
        }
        writer.endElement("span");
        if (sortMeta != null && (sortIcon = this.resolveDefaultSortIcon(sortMeta)) != null) {
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)sortIcon, null);
            writer.endElement("span");
            if (table.isMultiSort()) {
                writer.startElement("span", null);
                writer.writeAttribute("class", (Object)"ui-sortable-column-badge ui-helper-hidden", null);
                writer.endElement("span");
            }
        }
    }

    protected void encodeFilter(FacesContext context, DataTable table, UIColumn column) throws IOException {
        if (table.isGlobalFilterOnly()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        UIComponent filterFacet = table.getFilterComponent(column);
        if (!ComponentUtils.shouldRenderFacet(filterFacet, table.isRenderEmptyFacets())) {
            this.encodeDefaultFilter(context, table, column, writer);
        } else {
            Object filterValue = table.getFilterValue(column);
            if (filterValue != null) {
                ((ValueHolder)filterFacet).setValue(filterValue);
            }
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)"ui-column-customfilter", null);
            filterFacet.encodeAll(context);
            writer.endElement("div");
        }
    }

    protected void encodeDefaultFilter(FacesContext context, DataTable table, UIColumn column, ResponseWriter writer) throws IOException {
        String separator = String.valueOf(UINamingContainer.getSeparatorChar((FacesContext)context));
        boolean disableTabbing = table.getScrollWidth() != null;
        String filterId = column.getContainerClientId(context) + separator + "filter";
        Object filterValue = this.findFilterValueForColumn(context, table, column, filterId);
        String filterStyleClass = column.getFilterStyleClass();
        String ariaLabelId = filterId + "_label";
        String ariaHeaderLabel = this.getHeaderLabel(context, column);
        String ariaMessage = MessageFactory.getMessage("primefaces.datatable.aria.FILTER_BY", ariaHeaderLabel);
        writer.startElement("label", null);
        writer.writeAttribute("id", (Object)ariaLabelId, null);
        writer.writeAttribute("for", (Object)filterId, null);
        writer.writeAttribute("class", (Object)"ui-helper-hidden", null);
        writer.writeText((Object)ariaMessage, null);
        writer.endElement("label");
        this.encodeFilterInput(column, writer, disableTabbing, filterId, filterStyleClass, filterValue, ariaLabelId);
    }

    protected void encodeFilterInput(UIColumn column, ResponseWriter writer, boolean disableTabbing, String filterId, String filterStyleClass, Object filterValue, String ariaLabelId) throws IOException {
        if (this.hasFilterOptions(column)) {
            this.encodeFilterInputSelect(column, writer, disableTabbing, filterId, filterStyleClass, filterValue, ariaLabelId);
        } else {
            this.encodeFilterInputText(column, writer, disableTabbing, filterId, filterStyleClass, filterValue, ariaLabelId);
        }
    }

    private boolean hasFilterOptions(UIColumn column) {
        boolean hasFilterOptionsVE;
        boolean bl = hasFilterOptionsVE = column.getValueExpression(ColumnBase.PropertyKeys.filterOptions.toString()) != null;
        if (!hasFilterOptionsVE) {
            return false;
        }
        SelectItem[] filterOptions = this.getFilterOptions(column);
        return filterOptions != null && filterOptions.length != 0;
    }

    protected void encodeFilterInputSelect(UIColumn column, ResponseWriter writer, boolean disableTabbing, String filterId, String filterStyleClass, Object filterValue, String ariaLabelId) throws IOException {
        SelectItem[] itemsArray;
        filterStyleClass = filterStyleClass == null ? "ui-column-filter ui-widget ui-state-default ui-corner-left" : "ui-column-filter ui-widget ui-state-default ui-corner-left " + filterStyleClass;
        writer.startElement("select", null);
        writer.writeAttribute("id", (Object)filterId, null);
        writer.writeAttribute("name", (Object)filterId, null);
        writer.writeAttribute("class", (Object)filterStyleClass, null);
        writer.writeAttribute("aria-labelledby", (Object)ariaLabelId, null);
        if (disableTabbing) {
            writer.writeAttribute("tabindex", (Object)"-1", null);
        }
        for (SelectItem item : itemsArray = this.getFilterOptions(column)) {
            Object itemValue = item.getValue();
            writer.startElement("option", null);
            writer.writeAttribute("value", item.getValue(), null);
            if (itemValue != null && String.valueOf(itemValue).equals(filterValue)) {
                writer.writeAttribute("selected", (Object)"selected", null);
            }
            if (item.isEscape()) {
                writer.writeText((Object)item.getLabel(), "value");
            } else {
                writer.write(item.getLabel());
            }
            writer.endElement("option");
        }
        writer.endElement("select");
    }

    protected void encodeFilterInputText(UIColumn column, ResponseWriter writer, boolean disableTabbing, String filterId, String filterStyleClass, Object filterValue, String ariaLabelId) throws IOException {
        filterStyleClass = filterStyleClass == null ? "ui-column-filter ui-inputfield ui-inputtext ui-widget ui-state-default ui-corner-all" : "ui-column-filter ui-inputfield ui-inputtext ui-widget ui-state-default ui-corner-all " + filterStyleClass;
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)filterId, null);
        writer.writeAttribute("name", (Object)filterId, null);
        writer.writeAttribute("class", (Object)filterStyleClass, null);
        writer.writeAttribute("value", filterValue, null);
        writer.writeAttribute("autocomplete", (Object)"off", null);
        writer.writeAttribute("aria-labelledby", (Object)ariaLabelId, null);
        if (disableTabbing) {
            writer.writeAttribute("tabindex", (Object)"-1", null);
        }
        if (column.getFilterStyle() != null) {
            writer.writeAttribute("style", (Object)column.getFilterStyle(), null);
        }
        if (column.getFilterMaxLength() != Integer.MAX_VALUE) {
            writer.writeAttribute("maxlength", (Object)column.getFilterMaxLength(), null);
        }
        writer.endElement("input");
    }

    protected Object findFilterValueForColumn(FacesContext context, DataTable table, UIColumn column, String filterId) {
        Object filterValue;
        if (table.isReset()) {
            filterValue = "";
        } else {
            filterValue = table.getFilterValue(column);
            if (filterValue == null) {
                Object columnFilterValue;
                Map params = context.getExternalContext().getRequestParameterMap();
                filterValue = params.containsKey(filterId) ? params.get(filterId) : ((columnFilterValue = column.getFilterValue()) == null ? "" : columnFilterValue.toString());
            }
        }
        return filterValue;
    }

    protected SelectItem[] getFilterOptions(UIColumn column) {
        Object options = column.getFilterOptions();
        if (options instanceof SelectItem[]) {
            return (SelectItem[])options;
        }
        if (options instanceof Collection) {
            return ((Collection)column.getFilterOptions()).toArray(new SelectItem[0]);
        }
        throw new FacesException("Filter options for column " + column.getClientId() + " should be a SelectItem array or collection");
    }

    public void encodeColumnFooter(FacesContext context, DataTable table, UIColumn column) throws IOException {
        if (!column.isRendered()) {
            return;
        }
        ColumnMeta columnMeta = table.getColumnMeta().get(column.getColumnKey());
        ResponseWriter writer = context.getResponseWriter();
        int responsivePriority = column.getResponsivePriority();
        String style = column.getStyle();
        String styleClass = column.getStyleClass();
        styleClass = styleClass == null ? "ui-state-default" : "ui-state-default " + styleClass;
        boolean columnVisible = column.isVisible();
        if (columnMeta != null && columnMeta.getVisible() != null) {
            columnVisible = columnMeta.getVisible();
        }
        if (!columnVisible) {
            styleClass = styleClass + " " + "ui-helper-hidden";
        }
        if (responsivePriority > 0) {
            styleClass = styleClass + " ui-column-p-" + responsivePriority;
        }
        writer.startElement("td", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if (column.getRowspan() != 1) {
            writer.writeAttribute("rowspan", (Object)column.getRowspan(), null);
        }
        if (column.getColspan() != 1) {
            writer.writeAttribute("colspan", (Object)column.getColspan(), null);
        }
        UIComponent facet = column.getFacet("footer");
        String text = column.getFooterText();
        if (ComponentUtils.shouldRenderFacet(facet, table.isRenderEmptyFacets())) {
            facet.encodeAll(context);
        } else if (text != null) {
            if (table.isEscapeText()) {
                writer.writeText((Object)text, "footerText");
            } else {
                writer.write(text);
            }
        }
        writer.endElement("td");
    }

    protected void encodeThead(FacesContext context, DataTable table) throws IOException {
        this.encodeThead(context, table, 0, table.getColumns().size(), null, null);
    }

    protected void encodeThead(FacesContext context, DataTable table, int columnStart, int columnEnd, String theadId, String columnGroupType) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        List<UIColumn> columns = table.getColumns();
        String theadClientId = theadId == null ? table.getClientId(context) + "_head" : theadId;
        String colGroupType = columnGroupType == null ? "header" : columnGroupType;
        ColumnGroup group = table.getColumnGroup(colGroupType);
        writer.startElement("thead", null);
        writer.writeAttribute("id", (Object)theadClientId, null);
        if (group != null && group.isRendered()) {
            context.getAttributes().put("org.primefaces.HELPER_RENDERER", "columnGroup");
            for (UIComponent child : group.getChildren()) {
                if (!child.isRendered()) continue;
                if (child instanceof Row) {
                    Row headerRow = (Row)child;
                    String rowClass = headerRow.getStyleClass();
                    String rowStyle = headerRow.getStyle();
                    writer.startElement("tr", null);
                    writer.writeAttribute("role", (Object)"row", null);
                    if (rowClass != null) {
                        writer.writeAttribute("class", (Object)rowClass, null);
                    }
                    if (rowStyle != null) {
                        writer.writeAttribute("style", (Object)rowStyle, null);
                    }
                    for (UIComponent headerRowChild : headerRow.getChildren()) {
                        if (!headerRowChild.isRendered()) continue;
                        if (headerRowChild instanceof Column) {
                            this.encodeColumnHeader(context, table, (Column)headerRowChild);
                            continue;
                        }
                        if (headerRowChild instanceof Columns) {
                            List<DynamicColumn> dynamicColumns = ((Columns)headerRowChild).getDynamicColumns();
                            for (DynamicColumn dynaColumn : dynamicColumns) {
                                dynaColumn.applyModel();
                                this.encodeColumnHeader(context, table, dynaColumn);
                            }
                            continue;
                        }
                        headerRowChild.encodeAll(context);
                    }
                    writer.endElement("tr");
                    continue;
                }
                child.encodeAll(context);
            }
            context.getAttributes().remove("org.primefaces.HELPER_RENDERER");
        } else {
            writer.startElement("tr", null);
            writer.writeAttribute("role", (Object)"row", null);
            for (int i = columnStart; i < columnEnd; ++i) {
                UIColumn column = columns.get(i);
                if (column instanceof DynamicColumn) {
                    ((DynamicColumn)column).applyModel();
                }
                this.encodeColumnHeader(context, table, column);
            }
            writer.endElement("tr");
        }
        writer.endElement("thead");
    }

    public void encodeTbody(FacesContext context, DataTable table, boolean dataOnly) throws IOException {
        this.encodeTbody(context, table, dataOnly, 0, table.getColumns().size(), null);
    }

    public void encodeTbody(FacesContext context, DataTable table, boolean dataOnly, int columnStart, int columnEnd, String tbodyId) throws IOException {
        boolean hasData;
        int rowCountToRender;
        ResponseWriter writer = context.getResponseWriter();
        String rowIndexVar = table.getRowIndexVar();
        String clientId = table.getClientId(context);
        String emptyMessage = table.getEmptyMessage();
        UIComponent emptyFacet = table.getFacet("emptyMessage");
        SubTable subTable = table.getSubTable();
        String tbodyClientId = tbodyId == null ? clientId + "_data" : tbodyId;
        Map params = context.getExternalContext().getRequestParameterMap();
        int rows = table.getRows();
        int first = table.isClientCacheRequest(context) ? Integer.valueOf((String)params.get(clientId + "_first")) + rows : table.getFirst();
        int rowCount = table.getRowCount();
        int n = rows == 0 ? (table.isLiveScroll() ? table.getScrollRows() + table.getScrollOffset() : rowCount) : (rowCountToRender = rows);
        if (table.isVirtualScroll()) {
            int virtualScrollRowCount = table.getScrollRows() * 2;
            rowCountToRender = virtualScrollRowCount > rowCount ? rowCount : virtualScrollRowCount;
        }
        int frozenRows = table.getFrozenRows();
        boolean bl = hasData = rowCount > 0;
        if (first == 0 && frozenRows > 0) {
            first += frozenRows;
        }
        if (!dataOnly) {
            writer.startElement("tbody", null);
            writer.writeAttribute("id", (Object)tbodyClientId, null);
            writer.writeAttribute("class", (Object)"ui-datatable-data ui-widget-content", null);
            if (table.isRowSelectionEnabled()) {
                writer.writeAttribute("tabindex", (Object)table.getTabindex(), null);
            }
        }
        if (hasData) {
            if (subTable != null) {
                this.encodeSubTable(context, table, subTable, first, first + rowCountToRender);
            } else {
                this.encodeRows(context, table, first, first + rowCountToRender, columnStart, columnEnd);
            }
        } else {
            writer.startElement("tr", null);
            writer.writeAttribute("class", (Object)"ui-widget-content ui-datatable-empty-message", null);
            writer.startElement("td", null);
            writer.writeAttribute("colspan", (Object)table.getColumnsCountWithSpan(), null);
            if (ComponentUtils.shouldRenderFacet(emptyFacet, table.isRenderEmptyFacets())) {
                emptyFacet.encodeAll(context);
            } else {
                writer.writeText((Object)emptyMessage, "emptyMessage");
            }
            writer.endElement("td");
            writer.endElement("tr");
        }
        if (!dataOnly) {
            writer.endElement("tbody");
        }
        table.setRowIndex(-1);
        if (rowIndexVar != null) {
            context.getExternalContext().getRequestMap().remove(rowIndexVar);
        }
    }

    protected void encodeRows(FacesContext context, DataTable table, int first, int last, int columnStart, int columnEnd) throws IOException {
        String clientId = table.getClientId(context);
        SummaryRow summaryRow = table.getSummaryRow();
        HeaderRow headerRow = table.getHeaderRow();
        ELContext eLContext = context.getELContext();
        SortMeta sort = table.getHighestPriorityActiveSortMeta();
        boolean encodeHeaderRow = headerRow != null && headerRow.isEnabled() && sort != null;
        boolean encodeSummaryRow = summaryRow != null && sort != null;
        for (int i = first; i < last; ++i) {
            table.resetDynamicColumns();
            table.setRowIndex(i);
            if (!table.isRowAvailable()) break;
            table.setRowIndex(i);
            if (encodeHeaderRow && (i == first || !this.isInSameGroup(context, table, i, -1, sort.getSortBy(), eLContext))) {
                table.setRowIndex(i);
                this.encodeHeaderRow(context, table, headerRow);
            }
            table.setRowIndex(i);
            this.encodeRow(context, table, clientId, i, columnStart, columnEnd);
            if (!encodeSummaryRow || this.isInSameGroup(context, table, i, 1, sort.getSortBy(), eLContext)) continue;
            table.setRowIndex(i);
            this.encodeSummaryRow(context, summaryRow, sort);
        }
    }

    protected void encodeFrozenRows(FacesContext context, DataTable table, int columnStart, int columnEnd) throws IOException {
        int frozenRows = table.getFrozenRows();
        if (frozenRows == 0) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        String clientId = table.getClientId(context);
        writer.startElement("tbody", null);
        writer.writeAttribute("class", (Object)"ui-datatable-data ui-widget-content", null);
        for (int i = 0; i < frozenRows; ++i) {
            table.setRowIndex(i);
            this.encodeRow(context, table, clientId, i, columnStart, columnEnd);
        }
        writer.endElement("tbody");
    }

    protected void encodeSummaryRow(FacesContext context, SummaryRow summaryRow, SortMeta sort) throws IOException {
        MethodExpression me = summaryRow.getListener();
        if (me != null) {
            me.invoke(context.getELContext(), new Object[]{sort.getSortBy()});
        }
        summaryRow.encodeAll(context);
    }

    protected void encodeHeaderRow(FacesContext context, DataTable table, HeaderRow headerRow) throws IOException {
        headerRow.encodeAll(context);
    }

    public boolean encodeRow(FacesContext context, DataTable table, String clientId, int rowIndex) throws IOException {
        return this.encodeRow(context, table, clientId, rowIndex, 0, table.getColumns().size());
    }

    public boolean encodeRow(FacesContext context, DataTable table, String clientId, int rowIndex, int columnStart, int columnEnd) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        boolean selectionEnabled = table.isSelectionEnabled();
        boolean rowExpansionAvailable = table.getRowExpansion() != null;
        String rowKey = null;
        List<UIColumn> columns = table.getColumns();
        HeaderRow headerRow = table.getHeaderRow();
        if (selectionEnabled || rowExpansionAvailable) {
            rowKey = table.getRowKey(table.getRowData());
        }
        boolean selected = selectionEnabled && table.getSelectedRowKeys().contains(rowKey);
        boolean disabled = table.isDisabledSelection();
        boolean expanded = table.isExpandedRow() || rowExpansionAvailable && table.getExpandedRowKeys().contains(rowKey);
        String rowStyleClass = this.getStyleClassBuilder(context).add("ui-widget-content").add(rowIndex % 2 == 0, "ui-datatable-even", "ui-datatable-odd").add(selectionEnabled && !disabled, "ui-datatable-selectable").add(selected, "ui-state-highlight").add(table.isEditingRow(), "ui-row-editing").add(table.getRowStyleClass()).add(expanded, "ui-expanded-row").build();
        writer.startElement("tr", null);
        writer.writeAttribute("data-ri", (Object)rowIndex, null);
        if (rowKey != null) {
            writer.writeAttribute("data-rk", (Object)rowKey, null);
        }
        writer.writeAttribute("class", (Object)rowStyleClass, null);
        writer.writeAttribute("role", (Object)"row", null);
        if (selectionEnabled) {
            writer.writeAttribute("aria-selected", (Object)String.valueOf(selected), null);
        }
        if (headerRow != null && !headerRow.isExpanded()) {
            writer.writeAttribute("style", (Object)"display: none;", null);
        }
        for (int i = columnStart; i < columnEnd; ++i) {
            UIColumn column = columns.get(i);
            if (column instanceof Column) {
                this.encodeCell(context, table, column, selected, selectionEnabled, rowIndex);
                continue;
            }
            if (!(column instanceof DynamicColumn)) continue;
            DynamicColumn dynamicColumn = (DynamicColumn)column;
            dynamicColumn.applyModel();
            this.encodeCell(context, table, dynamicColumn, false, selectionEnabled, rowIndex);
        }
        writer.endElement("tr");
        if (expanded) {
            RowExpandFeature.getInstance().encodeExpansion(context, this, table, rowIndex);
        }
        return true;
    }

    protected void encodeCell(FacesContext context, DataTable table, UIColumn column, boolean selected, boolean rowSelectionEnabled, int rowIndex) throws IOException {
        UIComponent component;
        if (!column.isRendered()) {
            return;
        }
        ColumnMeta columnMeta = table.getColumnMeta().get(column.getColumnKey((UIComponent)table, rowIndex));
        boolean columnVisible = column.isVisible();
        if (columnMeta != null && columnMeta.getVisible() != null) {
            columnVisible = columnMeta.getVisible();
        }
        ResponseWriter writer = context.getResponseWriter();
        boolean columnSelectionEnabled = column.getSelectionMode() != null;
        boolean isGroupedColumn = column.isGroupRow();
        CellEditor editor = column.getCellEditor();
        boolean editorEnabled = editor != null && editor.isRendered();
        int responsivePriority = column.getResponsivePriority();
        String style = column.getStyle();
        String styleClass = this.getStyleClassBuilder(context).add(columnSelectionEnabled, "ui-selection-column").add(isGroupedColumn, "ui-grouped-column").add(editorEnabled && editor.isDisabled(), "ui-cell-editor-disabled").add(editorEnabled && !editor.isDisabled(), "ui-editable-column").add(!column.isSelectRow(), "ui-column-unselectable").add(!columnVisible, "ui-helper-hidden").add(column.getStyleClass()).add(responsivePriority > 0, "ui-column-p-" + responsivePriority).build();
        int colspan = column.getColspan();
        int rowspan = column.getRowspan();
        writer.startElement("td", null);
        writer.writeAttribute("role", (Object)"gridcell", null);
        if (colspan != 1) {
            writer.writeAttribute("colspan", (Object)colspan, null);
        }
        if (rowspan != 1) {
            writer.writeAttribute("rowspan", (Object)rowspan, null);
        }
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, null);
        }
        UIComponent uIComponent = component = column instanceof UIComponent ? (UIComponent)column : null;
        if (component != null) {
            this.renderDynamicPassThruAttributes(context, component);
        }
        if (columnSelectionEnabled) {
            this.encodeColumnSelection(context, table, column, selected, rowSelectionEnabled);
        }
        if (this.hasColumnDefaultRendering(table, column)) {
            this.encodeDefaultFieldCell(context, table, column, writer);
        } else if (column instanceof DynamicColumn) {
            this.encodeDynamicCell(context, table, column);
        } else {
            column.renderChildren(context);
        }
        writer.endElement("td");
    }

    protected void encodeDynamicCell(FacesContext context, DataTable table, UIColumn column) throws IOException {
        column.encodeAll(context);
    }

    protected void encodeDefaultFieldCell(FacesContext context, DataTable table, UIColumn column, ResponseWriter writer) throws IOException {
        String value = table.getConvertedFieldValue(context, column);
        if (value != null) {
            writer.writeText((Object)value, null);
        }
    }

    protected void encodeTFoot(FacesContext context, DataTable table) throws IOException {
        this.encodeTFoot(context, table, 0, table.getColumns().size(), null, null);
    }

    protected void encodeTFoot(FacesContext context, DataTable table, int columnStart, int columnEnd, String tfootId, String columnGroupType) throws IOException {
        boolean shouldRenderFooter;
        ResponseWriter writer = context.getResponseWriter();
        List<UIColumn> columns = table.getColumns();
        String tfootClientId = tfootId == null ? table.getClientId(context) + "_foot" : tfootId;
        String colGroupType = columnGroupType == null ? "footer" : columnGroupType;
        ColumnGroup group = table.getColumnGroup(colGroupType);
        boolean hasFooterColumn = table.hasFooterColumn();
        boolean bl = shouldRenderFooter = hasFooterColumn || group != null;
        if (!shouldRenderFooter) {
            return;
        }
        writer.startElement("tfoot", null);
        writer.writeAttribute("id", (Object)tfootClientId, null);
        if (group != null && group.isRendered()) {
            context.getAttributes().put("org.primefaces.HELPER_RENDERER", "columnGroup");
            for (UIComponent child : group.getChildren()) {
                if (!child.isRendered()) continue;
                if (child instanceof Row) {
                    Row footerRow = (Row)child;
                    String rowClass = footerRow.getStyleClass();
                    String rowStyle = footerRow.getStyle();
                    writer.startElement("tr", null);
                    if (rowClass != null) {
                        writer.writeAttribute("class", (Object)rowClass, null);
                    }
                    if (rowStyle != null) {
                        writer.writeAttribute("style", (Object)rowStyle, null);
                    }
                    for (UIComponent footerRowChild : footerRow.getChildren()) {
                        if (!footerRowChild.isRendered()) continue;
                        if (footerRowChild instanceof Column) {
                            this.encodeColumnFooter(context, table, (Column)footerRowChild);
                            continue;
                        }
                        if (footerRowChild instanceof Columns) {
                            List<DynamicColumn> dynamicColumns = ((Columns)footerRowChild).getDynamicColumns();
                            for (DynamicColumn dynaColumn : dynamicColumns) {
                                dynaColumn.applyModel();
                                this.encodeColumnFooter(context, table, dynaColumn);
                            }
                            continue;
                        }
                        footerRowChild.encodeAll(context);
                    }
                    writer.endElement("tr");
                    continue;
                }
                child.encodeAll(context);
            }
            context.getAttributes().remove("org.primefaces.HELPER_RENDERER");
        } else if (table.hasFooterColumn()) {
            writer.startElement("tr", null);
            for (int i = columnStart; i < columnEnd; ++i) {
                UIColumn column = columns.get(i);
                if (column instanceof Column) {
                    this.encodeColumnFooter(context, table, column);
                    continue;
                }
                if (!(column instanceof DynamicColumn)) continue;
                DynamicColumn dynamicColumn = (DynamicColumn)column;
                dynamicColumn.applyModel();
                this.encodeColumnFooter(context, table, dynamicColumn);
            }
            writer.endElement("tr");
        }
        writer.endElement("tfoot");
    }

    protected void encodeFacet(FacesContext context, DataTable table, UIComponent facet, String styleClass) throws IOException {
        if (facet == null) {
            return;
        }
        if (!ComponentUtils.shouldRenderFacet(facet, table.isRenderEmptyFacets())) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        facet.encodeAll(context);
        writer.endElement("div");
    }

    protected void encodeStateHolder(FacesContext context, DataTable table, String id, String value) throws IOException {
        this.renderHiddenInput(context, id, value, false);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void encodeRadio(FacesContext context, DataTable table, boolean checked, boolean disabled) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (table.isNativeElements()) {
            this.encodeNativeRadio(context, table, checked, disabled);
        } else {
            String boxClass = "ui-radiobutton-box ui-widget ui-corner-all ui-state-default";
            String iconClass = checked ? "ui-radiobutton-icon ui-icon ui-icon-bullet ui-c" : "ui-radiobutton-icon ui-icon ui-icon-blank ui-c";
            boxClass = disabled ? boxClass + " ui-state-disabled" : boxClass;
            boxClass = checked ? boxClass + " ui-state-active" : boxClass;
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)"ui-radiobutton ui-widget", null);
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)"ui-helper-hidden-accessible", null);
            this.encodeNativeRadio(context, table, checked, disabled);
            writer.endElement("div");
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)boxClass, null);
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)iconClass, null);
            writer.endElement("span");
            writer.endElement("div");
            writer.endElement("div");
        }
    }

    protected void encodeColumnSelection(FacesContext context, DataTable table, UIColumn column, boolean selected, boolean rowSelectionEnabled) throws IOException {
        String selectionMode = column.getSelectionMode();
        if ("single".equalsIgnoreCase(selectionMode)) {
            this.encodeRadio(context, table, selected, !rowSelectionEnabled);
        } else if ("multiple".equalsIgnoreCase(selectionMode)) {
            this.encodeCheckbox(context, table, selected, !rowSelectionEnabled, "ui-chkbox ui-widget", false);
        } else {
            throw new FacesException("Invalid column selection mode:" + selectionMode);
        }
    }

    protected void encodeCheckbox(FacesContext context, DataTable table, boolean checked, boolean disabled, String styleClass, boolean isHeaderCheckbox) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (table.isNativeElements()) {
            this.encodeNativeCheckbox(context, table, checked, disabled, isHeaderCheckbox);
        } else {
            String iconClass;
            String ariaRowLabel = table.getAriaRowLabel();
            String rowKey = null;
            String boxClass = "ui-chkbox-box ui-widget ui-corner-all ui-state-default";
            boxClass = disabled ? boxClass + " ui-state-disabled" : boxClass;
            boxClass = checked ? boxClass + " ui-state-active" : boxClass;
            String string = iconClass = checked ? "ui-chkbox-icon ui-icon ui-icon-check ui-c" : "ui-chkbox-icon ui-icon ui-icon-blank ui-c";
            if (isHeaderCheckbox) {
                rowKey = "head";
                ariaRowLabel = MessageFactory.getMessage("primefaces.datatable.aria.HEADER_CHECKBOX_ALL", new Object[0]);
            } else {
                rowKey = table.getRowKey();
            }
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
            writer.startElement("div", null);
            writer.writeAttribute("id", (Object)(table.getClientId(context) + "_" + rowKey + "_checkbox"), null);
            writer.writeAttribute("role", (Object)"checkbox", null);
            writer.writeAttribute("tabindex", (Object)"0", null);
            writer.writeAttribute("aria-label", (Object)ariaRowLabel, null);
            writer.writeAttribute("aria-checked", (Object)String.valueOf(checked), null);
            if (disabled) {
                writer.writeAttribute("aria-disabled", (Object)"true", null);
            }
            writer.writeAttribute("class", (Object)boxClass, null);
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)iconClass, null);
            writer.endElement("span");
            writer.endElement("div");
            writer.endElement("div");
        }
    }

    protected void encodeNativeCheckbox(FacesContext context, DataTable table, boolean checked, boolean disabled, boolean isHeaderCheckbox) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String ariaRowLabel = table.getAriaRowLabel();
        if (isHeaderCheckbox) {
            ariaRowLabel = MessageFactory.getMessage("primefaces.datatable.aria.HEADER_CHECKBOX_ALL", new Object[0]);
        }
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"checkbox", null);
        writer.writeAttribute("name", (Object)(table.getClientId(context) + "_checkbox"), null);
        writer.writeAttribute("aria-label", (Object)ariaRowLabel, null);
        writer.writeAttribute("aria-checked", (Object)String.valueOf(checked), null);
        if (checked) {
            writer.writeAttribute("checked", (Object)"checked", null);
        }
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        writer.endElement("input");
    }

    protected void encodeNativeRadio(FacesContext context, DataTable table, boolean checked, boolean disabled) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String ariaRowLabel = table.getAriaRowLabel();
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"radio", null);
        writer.writeAttribute("name", (Object)(table.getClientId(context) + "_radio"), null);
        writer.writeAttribute("aria-label", (Object)ariaRowLabel, null);
        if (checked) {
            writer.writeAttribute("checked", (Object)"checked", null);
        }
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        writer.endElement("input");
    }

    protected void encodeSubTable(FacesContext context, DataTable table, SubTable subTable, int first, int last) throws IOException {
        LOGGER.info("SubTable has been deprecated, use row grouping instead");
        for (int i = first; i < last; ++i) {
            table.setRowIndex(i);
            if (!table.isRowAvailable()) break;
            subTable.encodeAll(context);
        }
    }

    protected boolean isInSameGroup(FacesContext context, DataTable table, int currentRowIndex, int step, ValueExpression groupByVE, ELContext eLContext) {
        table.setRowIndex(currentRowIndex);
        Object currentGroupByData = groupByVE.getValue(eLContext);
        table.setRowIndex(currentRowIndex + step);
        if (!table.isRowAvailable()) {
            return false;
        }
        Object nextGroupByData = groupByVE.getValue(eLContext);
        return Objects.equals(nextGroupByData, currentGroupByData);
    }

    protected void encodeSortableHeaderOnReflow(FacesContext context, DataTable table) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Map<SortMeta, String> headers = this.getSortableColumnHeaders(context, table);
        if (!headers.isEmpty()) {
            String reflowId = table.getContainerClientId(context) + "_reflowDD";
            writer.startElement("label", null);
            writer.writeAttribute("id", (Object)(reflowId + "_label"), null);
            writer.writeAttribute("for", (Object)reflowId, null);
            writer.writeAttribute("class", (Object)"ui-reflow-label", null);
            writer.writeText((Object)MessageFactory.getMessage("primefaces.datatable.SORT_LABEL", new Object[0]), null);
            writer.endElement("label");
            writer.startElement("select", null);
            writer.writeAttribute("id", (Object)reflowId, null);
            writer.writeAttribute("name", (Object)reflowId, null);
            writer.writeAttribute("class", (Object)"ui-reflow-dropdown ui-state-default", null);
            writer.writeAttribute("autocomplete", (Object)"off", null);
            for (Map.Entry<SortMeta, String> header : headers.entrySet()) {
                for (int sortOrder = 0; sortOrder < 2; ++sortOrder) {
                    String sortOrderLabel = sortOrder == 0 ? MessageFactory.getMessage("primefaces.datatable.SORT_ASC", new Object[0]) : MessageFactory.getMessage("primefaces.datatable.SORT_DESC", new Object[0]);
                    writer.startElement("option", null);
                    writer.writeAttribute("value", (Object)(header.getKey().getColumnKey() + "_" + sortOrder), null);
                    writer.writeAttribute("data-columnkey", (Object)header.getKey().getColumnKey(), null);
                    writer.writeAttribute("data-sortorder", (Object)sortOrder, null);
                    writer.writeText((Object)(header.getValue() + " " + sortOrderLabel), null);
                    writer.endElement("option");
                }
            }
            writer.endElement("select");
        }
    }

    protected Map<SortMeta, String> getSortableColumnHeaders(FacesContext context, DataTable table) {
        AtomicReference<Object> headerLabel = new AtomicReference<Object>(null);
        Map<String, SortMeta> sortByAsMap = table.getSortByAsMap();
        LinkedHashMap<SortMeta, String> headers = new LinkedHashMap<SortMeta, String>(sortByAsMap.size());
        for (SortMeta sortMeta : sortByAsMap.values()) {
            if (sortMeta.isHeaderRow()) continue;
            headerLabel.set(null);
            table.invokeOnColumn(sortMeta.getColumnKey(), column -> headerLabel.set(this.getHeaderLabel(context, (UIColumn)column)));
            headers.put(sortMeta, headerLabel.get());
        }
        return headers;
    }

    protected boolean hasColumnDefaultRendering(DataTable table, UIColumn column) {
        return column.getChildren().isEmpty() && (table.getSortByAsMap().containsKey(column.getColumnKey()) || table.getFilterByAsMap().containsKey(column.getColumnKey()) || LangUtils.isNotBlank(column.getField()));
    }
}

