/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datatable.feature;

import java.io.IOException;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.primefaces.component.api.DynamicColumn;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.datatable.DataTableRenderer;
import org.primefaces.component.datatable.feature.DataTableFeature;

public class CellEditFeature
implements DataTableFeature {
    private static final CellEditFeature INSTANCE = new CellEditFeature();

    private CellEditFeature() {
    }

    public static CellEditFeature getInstance() {
        return INSTANCE;
    }

    @Override
    public void decode(FacesContext context, DataTable table) {
        throw new FacesException("CellEditFeature should not decode.");
    }

    @Override
    public void encode(FacesContext context, DataTableRenderer renderer, DataTable table) throws IOException {
        Map params = context.getExternalContext().getRequestParameterMap();
        String clientId = table.getClientId(context);
        String[] cellInfo = ((String)params.get(clientId + "_cellInfo")).split(",");
        int rowIndex = Integer.parseInt(cellInfo[0]);
        int cellIndex = Integer.parseInt(cellInfo[1]);
        int i = -1;
        UIColumn column = null;
        for (UIColumn col : table.getColumns()) {
            if (!col.isRendered() || ++i != cellIndex) continue;
            column = col;
            break;
        }
        if (column == null) {
            throw new FacesException("No column found for cellIndex: " + cellIndex);
        }
        table.setRowIndex(rowIndex);
        if (column.isDynamic()) {
            DynamicColumn dynamicColumn = (DynamicColumn)column;
            dynamicColumn.applyStatelessModel();
        }
        if (table.isCellEditCancelRequest(context) || table.isCellEditInitRequest(context)) {
            column.getCellEditor().getFacet("input").encodeAll(context);
        } else {
            column.getCellEditor().getFacet("output").encodeAll(context);
        }
        if (column.isDynamic()) {
            ((DynamicColumn)column).cleanStatelessModel();
        }
    }

    @Override
    public boolean shouldDecode(FacesContext context, DataTable table) {
        return false;
    }

    @Override
    public boolean shouldEncode(FacesContext context, DataTable table) {
        return context.getExternalContext().getRequestParameterMap().containsKey(table.getClientId(context) + "_cellInfo");
    }
}

