/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datatable.feature;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.datatable.DataTableRenderer;
import org.primefaces.component.datatable.DataTableState;
import org.primefaces.component.datatable.feature.DataTableFeature;
import org.primefaces.event.data.PostPageEvent;

public class PageFeature
implements DataTableFeature {
    private static final PageFeature INSTANCE = new PageFeature();

    private PageFeature() {
    }

    public static PageFeature getInstance() {
        return INSTANCE;
    }

    @Override
    public void decode(FacesContext context, DataTable table) {
        throw new FacesException("PageFeature should not encode.");
    }

    @Override
    public void encode(FacesContext context, DataTableRenderer renderer, DataTable table) throws IOException {
        table.updatePaginationData(context);
        boolean isPageState = table.isPageStateRequest(context);
        if (table.isLazy() && !isPageState) {
            table.loadLazyData();
        }
        if (!isPageState && !table.isFullUpdateRequest(context)) {
            renderer.encodeTbody(context, table, true);
        }
        context.getApplication().publishEvent(context, PostPageEvent.class, (Object)table);
        if (table.isMultiViewState()) {
            DataTableState ts = table.getMultiViewState(true);
            ts.setFirst(table.getFirst());
            ts.setRows(table.getRows());
        }
    }

    @Override
    public boolean shouldDecode(FacesContext context, DataTable table) {
        return false;
    }

    @Override
    public boolean shouldEncode(FacesContext context, DataTable table) {
        return table.isPaginationRequest(context);
    }
}

