/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.treetable.export;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.el.MethodExpression;
import javax.faces.FacesException;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import org.primefaces.component.export.ExportConfiguration;
import org.primefaces.component.export.TableExporter;
import org.primefaces.component.treetable.TreeTable;
import org.primefaces.model.TreeNode;

public abstract class TreeTableExporter
extends TableExporter<TreeTable> {
    private OutputStream outputStream;

    protected boolean hasColumnFooter(List<UIColumn> columns) {
        return columns.stream().anyMatch(c -> c.getFooter() != null);
    }

    protected String exportColumnByFunction(FacesContext context, org.primefaces.component.api.UIColumn column) {
        MethodExpression exportFunction = column.getExportFunction();
        if (exportFunction != null) {
            return (String)exportFunction.invoke(context.getELContext(), new Object[]{column});
        }
        return "";
    }

    protected void exportPageOnly(FacesContext context, TreeTable table, Object document) {
        int rowsToExport;
        int first = table.getFirst();
        int rows = table.getRows();
        TreeNode root = table.getValue();
        root.setExpanded(true);
        int totalRows = TreeTableExporter.getTreeRowCount(root) - 1;
        if (rows == 0) {
            rows = totalRows;
        }
        if ((rowsToExport = first + rows) > totalRows) {
            rowsToExport = totalRows;
        }
        for (int rowIndex = first; rowIndex < rowsToExport; ++rowIndex) {
            this.exportRow(context, table, document, rowIndex);
        }
    }

    protected void exportAll(FacesContext context, TreeTable table, Object document) {
        int first = table.getFirst();
        TreeNode root = table.getValue();
        root.setExpanded(true);
        int rowCount = TreeTableExporter.getTreeRowCount(root) - 1;
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            this.exportRow(context, table, document, rowIndex);
        }
        table.setFirst(first);
    }

    protected void exportRow(FacesContext context, TreeTable table, Object document, int rowIndex) {
        Map requestMap = context.getExternalContext().getRequestMap();
        Object origVar = requestMap.get(table.getVar());
        Object data = TreeTableExporter.traverseTree(table.getValue(), rowIndex + 1);
        requestMap.put(table.getVar(), data);
        this.preRowExport(table, document);
        this.exportCells(table, document);
        this.postRowExport(table, document);
        if (origVar != null) {
            requestMap.put(table.getVar(), origVar);
        } else {
            requestMap.remove(table.getVar());
        }
    }

    protected void exportRow(TreeTable table, Object document) {
        this.preRowExport(table, document);
        this.exportCells(table, document);
        this.postRowExport(table, document);
    }

    protected void exportSelectionOnly(FacesContext context, TreeTable table, Object document) {
        Object selection = table.getSelection();
        String var = table.getVar();
        if (selection != null) {
            Map requestMap = context.getExternalContext().getRequestMap();
            if (selection.getClass().isArray()) {
                int size = Array.getLength(selection);
                for (int i = 0; i < size; ++i) {
                    requestMap.put(var, Array.get(selection, i));
                    this.exportRow(table, document);
                }
            } else if (Collection.class.isAssignableFrom(selection.getClass())) {
                for (Object obj : (Collection)selection) {
                    requestMap.put(var, obj);
                    this.exportRow(table, document);
                }
            } else {
                requestMap.put(var, selection);
                this.exportCells(table, document);
            }
        }
    }

    protected void preExport(FacesContext context, ExportConfiguration exportConfiguration) throws IOException {
    }

    protected void postExport(FacesContext context, ExportConfiguration exportConfiguration) throws IOException {
    }

    protected void preRowExport(TreeTable table, Object document) {
    }

    protected void postRowExport(TreeTable table, Object document) {
    }

    protected abstract void exportCells(TreeTable var1, Object var2);

    @Override
    public void export(FacesContext context, List<TreeTable> tables, OutputStream outputStream, ExportConfiguration exportConfiguration) throws IOException {
        this.outputStream = outputStream;
        this.preExport(context, exportConfiguration);
        ExportVisitCallback exportCallback = new ExportVisitCallback(tables, exportConfiguration);
        exportCallback.export(context);
        this.postExport(context, exportConfiguration);
        this.outputStream = null;
    }

    protected abstract void doExport(FacesContext var1, TreeTable var2, ExportConfiguration var3, int var4) throws IOException;

    protected OutputStream getOutputStream() {
        return this.outputStream;
    }

    protected static int getTreeRowCount(TreeNode<?> node) {
        int count = 1;
        if (node.getChildren() != null) {
            for (TreeNode<?> childNode : node.getChildren()) {
                count += TreeTableExporter.getTreeRowCount(childNode);
            }
            return count;
        }
        return count;
    }

    protected static Object traverseTree(TreeNode node, int rowIndex) {
        return TreeTableExporter.traverseTree(node, new MutableInt(rowIndex));
    }

    protected static Object traverseTree(TreeNode<?> node, MutableInt rowIndex) {
        int index = rowIndex.getValue();
        rowIndex.decrement();
        if (index <= 0) {
            return node.getData();
        }
        if (node.getChildren() != null) {
            TreeNode<?> childNode;
            Object data = null;
            Iterator<TreeNode<?>> iterator = node.getChildren().iterator();
            while (iterator.hasNext() && (data = TreeTableExporter.traverseTree(childNode = iterator.next(), rowIndex)) == null) {
            }
            return data;
        }
        return null;
    }

    private static class MutableInt {
        private int value;

        public MutableInt(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public void decrement() {
            --this.value;
        }
    }

    private class ExportVisitCallback
    implements VisitCallback {
        private ExportConfiguration config;
        private List<TreeTable> tables;
        private int index;

        public ExportVisitCallback(List<TreeTable> tables, ExportConfiguration config) {
            this.tables = tables;
            this.config = config;
            this.index = 0;
        }

        public VisitResult visit(VisitContext context, UIComponent component) {
            try {
                TreeTableExporter.this.doExport(context.getFacesContext(), (TreeTable)component, this.config, this.index);
                ++this.index;
            }
            catch (IOException e) {
                throw new FacesException((Throwable)e);
            }
            return VisitResult.ACCEPT;
        }

        public void export(FacesContext context) {
            List tableIds = this.tables.stream().map(dt -> dt.getClientId(context)).collect(Collectors.toList());
            VisitContext visitContext = VisitContext.createVisitContext((FacesContext)context, tableIds, null);
            context.getViewRoot().visitTree(visitContext, (VisitCallback)this);
        }
    }

    protected static enum ColumnType {
        HEADER("header"),
        FOOTER("footer");

        private final String facet;

        private ColumnType(String facet) {
            this.facet = facet;
        }

        public String facet() {
            return this.facet;
        }

        public String toString() {
            return this.facet;
        }
    }
}

