/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.convert;

import java.util.PrimitiveIterator;

public class PatternReader {
    private static final int INVALID_CODEPOINT = -1;
    private PrimitiveIterator.OfInt iterator;
    private int peeked = -1;
    private StringBuilder literals = new StringBuilder();
    private final TokenVisitor visitor;

    private PatternReader(CharSequence sequence, TokenVisitor visitor) {
        this.iterator = sequence.codePoints().iterator();
        this.visitor = visitor;
    }

    private void addLiteral(int literal) {
        if (literal != -1) {
            this.literals.appendCodePoint(literal);
        }
    }

    private int consumeChar() {
        int peek = this.peeked;
        if (peek == -1) {
            return this.iterator.hasNext() ? this.iterator.nextInt() : -1;
        }
        this.peeked = -1;
        return peek;
    }

    private void consumeEscapeOrQuoteLiteral() {
        this.consumeChar();
        if (this.peek() == 39) {
            this.consumeChar();
            this.addLiteral(39);
        } else {
            this.consumeQuotedLiteral();
        }
    }

    private void consumePattern() {
        while (!this.isEoi()) {
            int ch = this.peek();
            if (ch == 39) {
                this.consumeEscapeOrQuoteLiteral();
                continue;
            }
            if (ch >= 97 && ch <= 122 || ch >= 65 && ch <= 90) {
                this.consumePatternLetters();
                continue;
            }
            this.consumeChar();
            this.addLiteral(ch);
        }
        this.finishLiterals();
    }

    private void consumePatternLetters() {
        int letter = this.consumeChar();
        int repetitions = 1;
        while (this.peek() == letter) {
            this.consumeChar();
            ++repetitions;
        }
        this.processPatternLetter(letter, repetitions);
    }

    private void consumeQuotedLiteral() {
        while (!this.isEoi()) {
            int ch = this.consumeChar();
            if (ch != 39) {
                this.addLiteral(ch);
                continue;
            }
            if (this.peek() != 39) break;
            this.consumeChar();
            this.addLiteral(39);
        }
    }

    private void finishLiterals() {
        if (this.literals.length() > 0) {
            this.visitor.visitLiteral(this.literals.toString());
            this.literals.setLength(0);
        }
    }

    private boolean isEoi() {
        return this.peeked == -1 && !this.iterator.hasNext();
    }

    private int peek() {
        if (this.peeked == -1 && this.iterator.hasNext()) {
            this.peeked = this.iterator.nextInt();
        }
        return this.peeked;
    }

    private void processPatternLetter(int letter, int repetitions) {
        this.finishLiterals();
        this.visitor.visitTokenLetter(letter, repetitions);
    }

    public static void parsePattern(CharSequence sequence, TokenVisitor visitor) {
        PatternReader reader = new PatternReader(sequence, visitor);
        reader.consumePattern();
    }

    public static interface TokenVisitor {
        public void visitLiteral(String var1);

        public void visitTokenLetter(int var1, int var2);
    }
}

