/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.faces.FacesException;
import org.primefaces.model.StreamedContent;
import org.primefaces.util.SerializableConsumer;
import org.primefaces.util.SerializableSupplier;

public class DefaultStreamedContent
implements StreamedContent,
Serializable {
    private SerializableSupplier<InputStream> stream;
    private String contentType;
    private String name;
    private String contentEncoding;
    private Integer contentLength;
    private SerializableConsumer<OutputStream> writer;

    @Override
    public Supplier<InputStream> getStream() {
        return this.stream;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getContentEncoding() {
        return this.contentEncoding;
    }

    @Override
    public Integer getContentLength() {
        return this.contentLength;
    }

    @Override
    public Consumer<OutputStream> getWriter() {
        return this.writer;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final DefaultStreamedContent streamedContent = new DefaultStreamedContent();

        private Builder() {
        }

        public Builder stream(SerializableSupplier<InputStream> is) {
            this.streamedContent.stream = is;
            return this;
        }

        public Builder contentType(String contentType) {
            this.streamedContent.contentType = contentType;
            return this;
        }

        public Builder name(String name) {
            this.streamedContent.name = name;
            return this;
        }

        public Builder contentEncoding(String contentEncoding) {
            this.streamedContent.contentEncoding = contentEncoding;
            return this;
        }

        public Builder contentLength(Integer contentLength) {
            this.streamedContent.contentLength = contentLength;
            return this;
        }

        public Builder writer(SerializableConsumer<OutputStream> writer) {
            this.streamedContent.writer = writer;
            return this;
        }

        public DefaultStreamedContent build() {
            if (this.streamedContent.writer == null && this.streamedContent.stream == null) {
                throw new FacesException("Either provide a 'stream' or 'writer'!");
            }
            return this.streamedContent;
        }
    }
}

