/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.util;

import java.io.IOException;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.primefaces.component.api.UICalendar;
import org.primefaces.component.datepicker.DatePicker;
import org.primefaces.convert.DateTimePatternConverter;
import org.primefaces.convert.PatternConverter;
import org.primefaces.util.ELUtils;
import org.primefaces.util.EscapeUtils;
import org.primefaces.util.LangUtils;

public class CalendarUtils {
    private static final String[] TIME_CHARS = new String[]{"H", "K", "h", "k", "m", "s"};
    private static final PatternConverter PATTERN_CONVERTER = new DateTimePatternConverter();

    private CalendarUtils() {
    }

    public static final String getValueAsString(FacesContext context, UICalendar calendar) {
        Object submittedValue = calendar.getSubmittedValue();
        if (submittedValue != null) {
            return submittedValue.toString();
        }
        return CalendarUtils.getValueAsString(context, calendar, calendar.getValue());
    }

    public static LocalDate getObjectAsLocalDate(FacesContext context, UICalendar calendar, Object value) {
        Object obj;
        Converter converter;
        Locale locale;
        if (value == null) {
            return null;
        }
        if (value instanceof LocalDate) {
            return (LocalDate)value;
        }
        if (value instanceof LocalDateTime) {
            return ((LocalDateTime)value).toLocalDate();
        }
        if (value instanceof java.util.Date) {
            return CalendarUtils.convertDate2LocalDate((java.util.Date)value);
        }
        String pattern = calendar.calculatePattern();
        if (pattern != null && (locale = calendar.calculateLocale(context)) != null) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern, locale);
            try {
                return LocalDate.parse(value.toString(), formatter);
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        }
        if (calendar.getConverter() != null) {
            try {
                Object obj2 = calendar.getConverter().getAsObject(context, (UIComponent)calendar, value.toString());
                if (obj2 instanceof LocalDate) {
                    return (LocalDate)obj2;
                }
            }
            catch (ConverterException obj2) {
                // empty catch block
            }
        }
        if ((converter = context.getApplication().createConverter(value.getClass())) != null && (obj = converter.getAsObject(context, (UIComponent)calendar, value.toString())) instanceof LocalDate) {
            return (LocalDate)obj;
        }
        return null;
    }

    public static LocalTime getObjectAsLocalTime(FacesContext context, UICalendar calendar, Object value) {
        Object obj;
        Converter converter;
        Locale locale;
        if (value == null || value instanceof LocalDate) {
            return null;
        }
        if (value instanceof LocalTime) {
            return (LocalTime)value;
        }
        if (value instanceof LocalDateTime) {
            return ((LocalDateTime)value).toLocalTime();
        }
        if (value instanceof java.util.Date) {
            return CalendarUtils.convertDate2LocalTime((java.util.Date)value);
        }
        String pattern = calendar.calculatePattern();
        if (pattern != null && (locale = calendar.calculateLocale(context)) != null) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern, locale);
            try {
                return LocalTime.parse(value.toString(), formatter);
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        }
        if (calendar.getConverter() != null) {
            try {
                Object obj2 = calendar.getConverter().getAsObject(context, (UIComponent)calendar, value.toString());
                if (obj2 instanceof LocalTime) {
                    return (LocalTime)obj2;
                }
            }
            catch (ConverterException obj2) {
                // empty catch block
            }
        }
        if ((converter = context.getApplication().createConverter(value.getClass())) != null && (obj = converter.getAsObject(context, (UIComponent)calendar, value.toString())) instanceof LocalTime) {
            return (LocalTime)obj;
        }
        return null;
    }

    public static Instant getObjectAsInstant(FacesContext context, UICalendar calendar, Object value, String attributeName) {
        if (value == null) {
            return null;
        }
        if (value instanceof LocalDateTime) {
            return ((LocalDateTime)value).toInstant(ZoneOffset.UTC);
        }
        if (value instanceof LocalDate) {
            return ((LocalDate)value).atStartOfDay().toInstant(ZoneOffset.UTC);
        }
        if (value instanceof LocalTime) {
            LocalDate now = LocalDate.now();
            return now.atTime((LocalTime)value).toInstant(ZoneOffset.UTC);
        }
        if (value instanceof java.util.Date) {
            if (value instanceof Date) {
                return new java.util.Date(((Date)value).getTime()).toInstant();
            }
            return ((java.util.Date)value).toInstant();
        }
        if (value instanceof String) {
            LocalTime timePart;
            boolean hasTime = calendar.isTimeOnly() || calendar.hasTime() || calendar instanceof DatePicker && ((DatePicker)calendar).isShowTime();
            LocalDate datePart = calendar.isTimeOnly() ? null : CalendarUtils.getObjectAsLocalDate(context, calendar, value);
            LocalTime localTime = timePart = hasTime ? CalendarUtils.getObjectAsLocalTime(context, calendar, value) : null;
            if (datePart == null) {
                datePart = LocalDate.now();
            }
            if (timePart == null) {
                return datePart.atStartOfDay().toInstant(ZoneOffset.UTC);
            }
            return datePart.atTime(timePart).toInstant(ZoneOffset.UTC);
        }
        String id = calendar.getClientId(context);
        String component = calendar.getClass().getSimpleName();
        String type = value.getClass().getName();
        throw new FacesException(component + " : \"" + id + "\"@\"" + attributeName + "\" has unsupported type " + type);
    }

    public static final String getValueAsString(FacesContext context, UICalendar calendar, Object value) {
        if (value == null) {
            return null;
        }
        return CalendarUtils.getValueAsString(context, calendar, value, calendar.calculatePattern());
    }

    public static final String getTimeOnlyValueAsString(FacesContext context, UICalendar calendar) {
        Object value = calendar.getValue();
        if (value == null) {
            return null;
        }
        return CalendarUtils.getValueAsString(context, calendar, value, calendar.calculateTimeOnlyPattern());
    }

    public static final String getValueAsString(FacesContext context, UICalendar calendar, Object value, String pattern) {
        if (value == null) {
            return null;
        }
        if (value instanceof List) {
            StringBuilder valuesAsString = new StringBuilder();
            String separator = "multiple".equals(calendar.getSelectionMode()) ? "," : " " + calendar.getRangeSeparator() + " ";
            List values = (List)value;
            for (int i = 0; i < values.size(); ++i) {
                if (i != 0) {
                    valuesAsString.append(separator);
                }
                valuesAsString.append(CalendarUtils.getValue(context, calendar, values.get(i), pattern));
            }
            return valuesAsString.toString();
        }
        return CalendarUtils.getValue(context, calendar, value, pattern);
    }

    public static final String getValue(FacesContext context, UICalendar calendar, Object value, String pattern) {
        Converter converter = calendar.getConverter();
        if (converter != null) {
            return converter.getAsString(context, (UIComponent)calendar, value);
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof java.util.Date) {
            SimpleDateFormat format = new SimpleDateFormat(pattern, calendar.calculateLocale(context));
            format.setTimeZone(CalendarUtils.calculateTimeZone(calendar.getTimeZone()));
            return format.format((java.util.Date)value);
        }
        if (value instanceof LocalDate || value instanceof LocalDateTime || value instanceof LocalTime || value instanceof YearMonth) {
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(pattern, calendar.calculateLocale(context));
            if (value instanceof LocalDate) {
                return ((LocalDate)value).format(dateTimeFormatter);
            }
            if (value instanceof LocalDateTime) {
                return ((LocalDateTime)value).format(dateTimeFormatter);
            }
            if (value instanceof LocalTime) {
                if (calendar instanceof UICalendar) {
                    return LocalDateTime.of(LocalDate.now(), (LocalTime)value).format(dateTimeFormatter);
                }
                return ((LocalTime)value).format(dateTimeFormatter);
            }
            return ((YearMonth)value).format(dateTimeFormatter);
        }
        Class<?> type = ELUtils.getType(context, calendar.getValueExpression("value"));
        if (type != null && type != Object.class && type != java.util.Date.class && type != LocalDate.class && type != LocalDateTime.class && type != LocalTime.class && type != YearMonth.class && (converter = context.getApplication().createConverter(type)) != null) {
            return converter.getAsString(context, (UIComponent)calendar, value);
        }
        throw new FacesException("Value could be either String, LocalDate, LocalDateTime, LocalTime, YearMonth or java.util.Date (deprecated)");
    }

    public static final String convertPattern(String pattern) {
        if (pattern == null) {
            return null;
        }
        return PATTERN_CONVERTER.convert(pattern);
    }

    public static void encodeListValue(FacesContext context, UICalendar uicalendar, String optionName, List<?> values, String pattern) throws IOException {
        if (values == null) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.write("," + optionName + ":[");
        for (int i = 0; i < values.size(); ++i) {
            String preText;
            Object item = values.get(i);
            String string = preText = i == 0 ? "" : ",";
            if (item instanceof java.util.Date) {
                writer.write(preText + "\"" + EscapeUtils.forJavaScript(CalendarUtils.getValueAsString(context, uicalendar, item, pattern)) + "\"");
                continue;
            }
            if (item instanceof LocalDate || item instanceof LocalDateTime || item instanceof LocalTime) {
                writer.write(preText + "\"" + EscapeUtils.forJavaScript(CalendarUtils.getValueAsString(context, uicalendar, item, pattern)) + "\"");
                continue;
            }
            writer.write(preText + "" + item);
        }
        writer.write("]");
    }

    public static ZoneId calculateZoneId(Object usertimeZone) {
        return CalendarUtils.calculateZoneId(usertimeZone, ZoneId.systemDefault());
    }

    public static ZoneId calculateZoneId(Object usertimeZone, ZoneId defaultZoneId) {
        if (usertimeZone != null) {
            if (usertimeZone instanceof String) {
                String usertimeZoneStr = (String)usertimeZone;
                if (LangUtils.isNotEmpty(usertimeZoneStr)) {
                    return ZoneId.of(usertimeZoneStr);
                }
                return defaultZoneId;
            }
            if (usertimeZone instanceof ZoneId) {
                return (ZoneId)usertimeZone;
            }
            if (usertimeZone instanceof TimeZone) {
                return ((TimeZone)usertimeZone).toZoneId();
            }
            throw new IllegalArgumentException("TimeZone could be either String or java.time.ZoneId or java.util.TimeZone");
        }
        return defaultZoneId;
    }

    public static TimeZone calculateTimeZone(Object usertimeZone) {
        return CalendarUtils.calculateTimeZone(usertimeZone, TimeZone.getDefault());
    }

    public static TimeZone calculateTimeZone(Object usertimeZone, TimeZone defaultTimeZone) {
        if (usertimeZone != null) {
            if (usertimeZone instanceof String) {
                return TimeZone.getTimeZone((String)usertimeZone);
            }
            if (usertimeZone instanceof TimeZone) {
                return (TimeZone)usertimeZone;
            }
            throw new IllegalArgumentException("TimeZone could be either String or java.util.TimeZone");
        }
        return defaultTimeZone;
    }

    public static ZoneOffset calculateZoneOffset(Object usertimeZone) {
        return CalendarUtils.calculateZoneOffset(usertimeZone, ZoneId.systemDefault());
    }

    public static ZoneOffset calculateZoneOffset(Object usertimeZone, ZoneId defaultZoneId) {
        ZoneId zoneId = CalendarUtils.calculateZoneId(usertimeZone, defaultZoneId);
        LocalDateTime now = LocalDateTime.now();
        return zoneId.getRules().getOffset(now);
    }

    private static ZonedDateTime convertDate2ZonedDateTime(java.util.Date date, ZoneId zoneId) {
        if (date == null) {
            return null;
        }
        if (date instanceof Date) {
            Date sqlDate = (Date)date;
            return sqlDate.toLocalDate().atStartOfDay(zoneId);
        }
        return date.toInstant().atZone(zoneId);
    }

    public static LocalDate convertDate2LocalDate(java.util.Date date) {
        return CalendarUtils.convertDate2LocalDate(date, ZoneId.systemDefault());
    }

    public static LocalDate convertDate2LocalDate(java.util.Date date, ZoneId zoneId) {
        if (date == null) {
            return null;
        }
        return CalendarUtils.convertDate2ZonedDateTime(date, zoneId).toLocalDate();
    }

    public static LocalDateTime convertDate2LocalDateTime(java.util.Date date) {
        return CalendarUtils.convertDate2LocalDateTime(date, ZoneId.systemDefault());
    }

    public static LocalDateTime convertDate2LocalDateTime(java.util.Date date, ZoneId zoneId) {
        if (date == null) {
            return null;
        }
        return CalendarUtils.convertDate2ZonedDateTime(date, zoneId).toLocalDateTime();
    }

    public static LocalTime convertDate2LocalTime(java.util.Date date) {
        return CalendarUtils.convertDate2LocalTime(date, ZoneId.systemDefault());
    }

    public static LocalTime convertDate2LocalTime(java.util.Date date, ZoneId zoneId) {
        if (date == null) {
            return null;
        }
        return CalendarUtils.convertDate2ZonedDateTime(date, zoneId).toLocalTime();
    }

    public static java.util.Date convertLocalDate2Date(LocalDate localDate, ZoneId zoneId) {
        if (localDate == null) {
            return null;
        }
        return java.util.Date.from(localDate.atStartOfDay(zoneId).toInstant());
    }

    public static java.util.Date convertLocalDateTime2Date(LocalDateTime localDateTime) {
        return CalendarUtils.convertLocalDateTime2Date(localDateTime, ZoneId.systemDefault());
    }

    public static java.util.Date convertLocalDateTime2Date(LocalDateTime localDateTime, ZoneId zoneId) {
        if (localDateTime == null) {
            return null;
        }
        return java.util.Date.from(localDateTime.atZone(zoneId).toInstant());
    }

    public static java.util.Date convertLocalTime2Date(LocalTime localTime, ZoneId zoneId) {
        if (localTime == null) {
            return null;
        }
        return java.util.Date.from(localTime.atDate(LocalDate.now()).atZone(zoneId).toInstant());
    }

    public static final String removeTime(String pattern) {
        for (String timeChar : TIME_CHARS) {
            if (!pattern.contains(timeChar)) continue;
            pattern = pattern.substring(0, pattern.indexOf(timeChar));
        }
        return pattern.trim();
    }

    public static final boolean hasTime(String pattern) {
        for (String timeChar : TIME_CHARS) {
            if (!pattern.contains(timeChar)) continue;
            return true;
        }
        return false;
    }

    public static LocalDateTime toLocalDateTime(ZoneId zoneId, String isoDateString) {
        if (isoDateString == null) {
            return null;
        }
        ZonedDateTime zonedDateTimeUtc = ZonedDateTime.parse(isoDateString);
        ZonedDateTime zonedDateTimeTargetZone = zonedDateTimeUtc.withZoneSameInstant(zoneId);
        LocalDateTime localDateTime = zonedDateTimeTargetZone.toLocalDateTime();
        return localDateTime;
    }

    public static Temporal now(UICalendar uicalendar) {
        boolean timeOnly = uicalendar.isTimeOnly();
        ZoneId zone = CalendarUtils.calculateZoneId(uicalendar.getTimeZone());
        if (timeOnly) {
            return LocalTime.now(zone);
        }
        boolean hasTime = uicalendar.hasTime();
        return hasTime ? LocalDateTime.now(zone) : LocalDate.now(zone);
    }

    public static Object now(UICalendar uicalendar, Class<?> dateType) {
        Temporal now = CalendarUtils.now(uicalendar);
        if (dateType.isAssignableFrom(java.util.Date.class)) {
            ZoneId zone = CalendarUtils.calculateZoneId(uicalendar.getTimeZone());
            java.util.Date date = now instanceof LocalDate ? java.util.Date.from(((LocalDate)now).atStartOfDay(zone).toInstant()) : (now instanceof LocalTime ? java.util.Date.from(((LocalTime)now).atDate(LocalDate.now(zone)).atZone(zone).toInstant()) : java.util.Date.from(((LocalDateTime)now).atZone(zone).toInstant()));
            return date;
        }
        return now;
    }

    public static List<String> splitRange(String dateRange, String pattern, String separator) {
        String token = " " + separator + " ";
        if (pattern.contains(token)) {
            throw new FacesException("Pattern '" + pattern + "' contains separator '" + token + "'");
        }
        ArrayList<String> dates = new ArrayList<String>();
        if (!dateRange.contains(token)) {
            return dates;
        }
        int index = dateRange.indexOf(token);
        dates.add(dateRange.substring(0, index));
        dates.add(dateRange.substring(index + token.length()));
        return dates;
    }
}

