/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.calendar;

import java.io.IOException;
import java.util.Locale;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.api.UICalendar;
import org.primefaces.component.calendar.BaseCalendarRenderer;
import org.primefaces.component.calendar.Calendar;
import org.primefaces.util.CalendarUtils;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.WidgetBuilder;

public class CalendarRenderer
extends BaseCalendarRenderer {
    @Override
    protected void encodeMarkup(FacesContext context, UICalendar uicalendar, String value) throws IOException {
        Calendar calendar = (Calendar)uicalendar;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = calendar.getClientId(context);
        String styleClass = calendar.getStyleClass();
        styleClass = styleClass == null ? "ui-calendar" : "ui-calendar " + styleClass;
        String inputId = clientId + "_input";
        boolean popup = calendar.isPopup();
        writer.startElement("span", (UIComponent)calendar);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (calendar.getStyle() != null) {
            writer.writeAttribute("style", (Object)calendar.getStyle(), null);
        }
        if (!popup) {
            writer.startElement("div", null);
            writer.writeAttribute("id", (Object)(clientId + "_inline"), null);
            writer.endElement("div");
        }
        this.encodeInput(context, calendar, inputId, value, popup);
        writer.endElement("span");
    }

    @Override
    protected void encodeScript(FacesContext context, UICalendar uicalendar, String value) throws IOException {
        String showOn;
        String beforeShow;
        String beforeShowDay;
        Calendar calendar = (Calendar)uicalendar;
        Locale locale = calendar.calculateLocale(context);
        String pattern = calendar.calculateWidgetPattern();
        String mask = calendar.getMask();
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("Calendar", calendar);
        wb.attr("popup", calendar.isPopup()).attr("locale", locale.toString()).attr("dateFormat", CalendarUtils.convertPattern(pattern));
        Object pagedate = calendar.getPagedate();
        String defaultDate = null;
        if (calendar.isConversionFailed()) {
            Class<?> dateType = this.resolveDateType(context, calendar);
            defaultDate = CalendarUtils.getValueAsString(context, calendar, CalendarUtils.now(uicalendar, dateType));
        } else if (!this.isValueBlank(value)) {
            defaultDate = value;
        } else if (pagedate != null) {
            defaultDate = CalendarUtils.getValueAsString(context, calendar, pagedate);
        }
        wb.attr("defaultDate", defaultDate, null).attr("numberOfMonths", calendar.getPages(), 1).attr("minDate", CalendarUtils.getValueAsString(context, calendar, calendar.getMindate(), pattern), null).attr("maxDate", CalendarUtils.getValueAsString(context, calendar, calendar.getMaxdate(), pattern), null).attr("showButtonPanel", calendar.isShowButtonPanel(), false).attr("showTodayButton", calendar.isShowTodayButton(), true).attr("showWeek", calendar.isShowWeek(), false).attr("disabledWeekends", calendar.isDisabledWeekends(), false).attr("disabled", calendar.isDisabled(), false).attr("readonly", calendar.isReadonly(), false).attr("yearRange", calendar.getYearRange(), null).attr("focusOnSelect", calendar.isFocusOnSelect(), false).attr("shortYearCutoff", calendar.getShortYearCutoff(), null).attr("touchable", ComponentUtils.isTouchable(context, calendar), true);
        if (calendar.isNavigator()) {
            wb.attr("changeMonth", true).attr("changeYear", true);
        }
        if (calendar.getEffect() != null) {
            wb.attr("showAnim", calendar.getEffect()).attr("duration", calendar.getEffectDuration());
        }
        if ((beforeShowDay = calendar.getBeforeShowDay()) != null) {
            wb.nativeAttr("preShowDay", beforeShowDay);
        }
        if ((beforeShow = calendar.getBeforeShow()) != null) {
            wb.nativeAttr("preShow", beforeShow);
        }
        if (!"focus".equalsIgnoreCase(showOn = calendar.getShowOn())) {
            wb.attr("showOn", showOn).attr("buttonTabindex", calendar.getButtonTabindex());
        }
        if (calendar.isShowOtherMonths()) {
            wb.attr("showOtherMonths", true).attr("selectOtherMonths", calendar.isSelectOtherMonths());
        }
        if (calendar.hasTime()) {
            String timeControlType = calendar.getTimeControlType();
            wb.attr("timeOnly", calendar.isTimeOnly()).attr("stepHour", calendar.getStepHour()).attr("stepMinute", calendar.getStepMinute()).attr("stepSecond", calendar.getStepSecond()).attr("hourMin", calendar.getMinHour()).attr("hourMax", calendar.getMaxHour()).attr("minuteMin", calendar.getMinMinute()).attr("minuteMax", calendar.getMaxMinute()).attr("secondMin", calendar.getMinSecond()).attr("secondMax", calendar.getMaxSecond()).attr("timeInput", calendar.isTimeInput()).attr("controlType", timeControlType, null).attr("showHour", calendar.getShowHour(), null).attr("showMinute", calendar.getShowMinute(), null).attr("showSecond", calendar.getShowSecond(), null).attr("showMillisec", calendar.getShowMillisec(), null).attr("oneLine", calendar.isOneLine()).attr("hour", calendar.getDefaultHour()).attr("minute", calendar.getDefaultMinute()).attr("second", calendar.getDefaultSecond()).attr("millisec", calendar.getDefaultMillisec());
            String timeControlObject = calendar.getTimeControlObject();
            if ("custom".equalsIgnoreCase(timeControlType)) {
                wb.nativeAttr("timeControlObject", timeControlObject);
            }
        }
        if (mask != null && !"false".equals(mask)) {
            String patternTemplate = calendar.getPattern() == null ? pattern : calendar.getPattern();
            String maskTemplate = "true".equals(mask) ? calendar.convertPattern(patternTemplate) : mask;
            wb.attr("mask", maskTemplate).attr("maskSlotChar", calendar.getMaskSlotChar(), "_").attr("maskAutoClear", calendar.isMaskAutoClear(), true);
        }
        this.encodeClientBehaviors(context, (ClientBehaviorHolder)calendar);
        wb.finish();
    }
}

