/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.checkbox;

import java.io.IOException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.checkbox.Checkbox;
import org.primefaces.component.radiobutton.RadioButtonRenderer;
import org.primefaces.component.selectmanycheckbox.SelectManyCheckbox;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.SharedStringBuilder;

public class CheckboxRenderer
extends InputRenderer {
    private static final String SB_BUILD_EVENT = RadioButtonRenderer.class.getName() + "#buildEvent";

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Checkbox checkbox = (Checkbox)component;
        SelectManyCheckbox selectManyCheckbox = (SelectManyCheckbox)SearchExpressionFacade.resolveComponent(context, (UIComponent)checkbox, checkbox.getFor());
        this.encodeMarkup(context, checkbox, selectManyCheckbox);
    }

    protected void encodeMarkup(FacesContext context, Checkbox checkbox, SelectManyCheckbox selectManyCheckbox) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String masterClientId = selectManyCheckbox.getClientId(context);
        String clientId = checkbox.getClientId(context);
        boolean disabled = checkbox.isDisabled() || selectManyCheckbox.isDisabled();
        String style = checkbox.getStyle();
        String styleClass = checkbox.getStyleClass();
        styleClass = styleClass == null ? "ui-chkbox ui-widget" : "ui-chkbox ui-widget " + styleClass;
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        this.encodeOptionInput(context, selectManyCheckbox, checkbox, clientId, masterClientId, disabled);
        this.encodeOptionOutput(context, disabled, selectManyCheckbox);
        writer.endElement("div");
    }

    protected void encodeOptionInput(FacesContext context, SelectManyCheckbox selectManyCheckbox, Checkbox checkbox, String id, String name, boolean disabled) throws IOException {
        String onclick;
        String onchange;
        ResponseWriter writer = context.getResponseWriter();
        String tabindex = checkbox.getTabindex();
        if (tabindex == null) {
            tabindex = selectManyCheckbox.getTabindex();
        }
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-helper-hidden-accessible", null);
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)name, null);
        writer.writeAttribute("type", (Object)"checkbox", null);
        writer.writeAttribute("class", (Object)"ui-chkbox-clone", null);
        writer.writeAttribute("data-itemindex", (Object)checkbox.getItemIndex(), null);
        if (tabindex != null) {
            writer.writeAttribute("tabindex", (Object)tabindex, null);
        }
        if (!this.isValueBlank(onchange = this.buildEvent(context, selectManyCheckbox, checkbox, "onchange", "change", "valueChange"))) {
            writer.writeAttribute("onchange", (Object)onchange, null);
        }
        if (!this.isValueBlank(onclick = this.buildEvent(context, selectManyCheckbox, checkbox, "onclick", "click", "click"))) {
            writer.writeAttribute("onclick", (Object)onclick, null);
        }
        this.renderAccessibilityAttributes(context, (UIInput)selectManyCheckbox, disabled, selectManyCheckbox.isReadonly());
        this.renderValidationMetadata(context, (EditableValueHolder)selectManyCheckbox);
        writer.endElement("input");
        writer.endElement("div");
    }

    protected String buildEvent(FacesContext context, SelectManyCheckbox selectManyCheckbox, Checkbox checkbox, String domEvent, String behaviorEvent, String behaviorEventAlias) {
        String manyCheckboxEvent = this.buildDomEvent(context, (UIComponent)selectManyCheckbox, domEvent, behaviorEvent, behaviorEventAlias, null);
        String checkboxEvent = this.buildDomEvent(context, (UIComponent)checkbox, domEvent, behaviorEvent, behaviorEventAlias, null);
        StringBuilder eventBuilder = SharedStringBuilder.get(context, SB_BUILD_EVENT);
        if (manyCheckboxEvent != null) {
            eventBuilder.append(manyCheckboxEvent);
        }
        if (checkboxEvent != null) {
            eventBuilder.append(checkboxEvent);
        }
        return eventBuilder.toString();
    }

    protected void encodeOptionOutput(FacesContext context, boolean disabled, SelectManyCheckbox selectManyCheckbox) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String boxClass = this.createStyleClass((UIInput)selectManyCheckbox, null, "ui-chkbox-box ui-widget ui-corner-all ui-state-default");
        boxClass = disabled ? boxClass + " ui-state-disabled" : boxClass;
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)boxClass, null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-chkbox-icon ui-icon ui-icon-blank ui-c", null);
        writer.endElement("span");
        writer.endElement("div");
    }

    @Override
    public String getHighlighter() {
        return "manychkbox";
    }

    @Override
    protected boolean isGrouped() {
        return true;
    }
}

