/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datatable;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.BehaviorEvent;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PostRestoreStateEvent;
import javax.faces.model.DataModel;
import org.primefaces.PrimeFaces;
import org.primefaces.component.api.DynamicColumn;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.column.Column;
import org.primefaces.component.column.ColumnBase;
import org.primefaces.component.columngroup.ColumnGroup;
import org.primefaces.component.columns.Columns;
import org.primefaces.component.datatable.DataTableBase;
import org.primefaces.component.datatable.DataTableState;
import org.primefaces.component.datatable.feature.AddRowFeature;
import org.primefaces.component.datatable.feature.CellEditFeature;
import org.primefaces.component.datatable.feature.DataTableFeature;
import org.primefaces.component.datatable.feature.DraggableColumnsFeature;
import org.primefaces.component.datatable.feature.DraggableRowsFeature;
import org.primefaces.component.datatable.feature.FilterFeature;
import org.primefaces.component.datatable.feature.PageFeature;
import org.primefaces.component.datatable.feature.ResizableColumnsFeature;
import org.primefaces.component.datatable.feature.RowEditFeature;
import org.primefaces.component.datatable.feature.RowExpandFeature;
import org.primefaces.component.datatable.feature.ScrollFeature;
import org.primefaces.component.datatable.feature.SelectionFeature;
import org.primefaces.component.datatable.feature.SortFeature;
import org.primefaces.component.headerrow.HeaderRow;
import org.primefaces.component.row.Row;
import org.primefaces.component.rowexpansion.RowExpansion;
import org.primefaces.component.subtable.SubTable;
import org.primefaces.component.summaryrow.SummaryRow;
import org.primefaces.event.AbstractAjaxBehaviorEvent;
import org.primefaces.event.CellEditEvent;
import org.primefaces.event.ColumnResizeEvent;
import org.primefaces.event.ReorderEvent;
import org.primefaces.event.RowEditEvent;
import org.primefaces.event.SelectEvent;
import org.primefaces.event.ToggleEvent;
import org.primefaces.event.ToggleSelectEvent;
import org.primefaces.event.UnselectEvent;
import org.primefaces.event.data.FilterEvent;
import org.primefaces.event.data.PageEvent;
import org.primefaces.event.data.SortEvent;
import org.primefaces.model.ColumnMeta;
import org.primefaces.model.FilterMeta;
import org.primefaces.model.LazyDataModel;
import org.primefaces.model.SelectableDataModel;
import org.primefaces.model.SortMeta;
import org.primefaces.model.Visibility;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.LangUtils;
import org.primefaces.util.LocaleUtils;
import org.primefaces.util.MapBuilder;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="components.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="jquery/jquery-plugins.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="touch/touchswipe.js"), @ResourceDependency(library="primefaces", name="components.js")})
public class DataTable
extends DataTableBase {
    public static final String COMPONENT_TYPE = "org.primefaces.component.DataTable";
    public static final String CONTAINER_CLASS = "ui-datatable ui-widget";
    public static final String TABLE_WRAPPER_CLASS = "ui-datatable-tablewrapper";
    public static final String REFLOW_CLASS = "ui-datatable-reflow";
    public static final String RTL_CLASS = "ui-datatable-rtl";
    public static final String COLUMN_HEADER_CLASS = "ui-state-default";
    public static final String DYNAMIC_COLUMN_HEADER_CLASS = "ui-dynamic-column";
    public static final String COLUMN_HEADER_CONTAINER_CLASS = "ui-header-column";
    public static final String COLUMN_FOOTER_CLASS = "ui-state-default";
    public static final String COLUMN_FOOTER_CONTAINER_CLASS = "ui-footer-column";
    public static final String DATA_CLASS = "ui-datatable-data ui-widget-content";
    public static final String ROW_CLASS = "ui-widget-content";
    public static final String SELECTABLE_ROW_CLASS = "ui-datatable-selectable";
    public static final String EMPTY_MESSAGE_ROW_CLASS = "ui-widget-content ui-datatable-empty-message";
    public static final String HEADER_CLASS = "ui-datatable-header ui-widget-header ui-corner-top";
    public static final String FOOTER_CLASS = "ui-datatable-footer ui-widget-header ui-corner-bottom";
    public static final String SORTABLE_COLUMN_CLASS = "ui-sortable-column";
    public static final String SORTABLE_COLUMN_ICON_CLASS = "ui-sortable-column-icon ui-icon ui-icon-carat-2-n-s";
    public static final String SORTABLE_COLUMN_ASCENDING_ICON_CLASS = "ui-sortable-column-icon ui-icon ui-icon ui-icon-carat-2-n-s ui-icon-triangle-1-n";
    public static final String SORTABLE_COLUMN_DESCENDING_ICON_CLASS = "ui-sortable-column-icon ui-icon ui-icon ui-icon-carat-2-n-s ui-icon-triangle-1-s";
    public static final String SORTABLE_PRIORITY_CLASS = "ui-sortable-column-badge ui-helper-hidden";
    public static final String STATIC_COLUMN_CLASS = "ui-static-column";
    public static final String UNSELECTABLE_COLUMN_CLASS = "ui-column-unselectable";
    public static final String HIDDEN_COLUMN_CLASS = "ui-helper-hidden";
    public static final String FILTER_COLUMN_CLASS = "ui-filter-column";
    public static final String COLUMN_TITLE_CLASS = "ui-column-title";
    public static final String COLUMN_FILTER_CLASS = "ui-column-filter ui-widget ui-state-default ui-corner-left";
    public static final String COLUMN_INPUT_FILTER_CLASS = "ui-column-filter ui-inputfield ui-inputtext ui-widget ui-state-default ui-corner-all";
    public static final String COLUMN_CUSTOM_FILTER_CLASS = "ui-column-customfilter";
    public static final String RESIZABLE_COLUMN_CLASS = "ui-resizable-column";
    public static final String DRAGGABLE_COLUMN_CLASS = "ui-draggable-column";
    public static final String EXPANDED_ROW_CLASS = "ui-expanded-row";
    public static final String EXPANDED_ROW_CONTENT_CLASS = "ui-expanded-row-content";
    public static final String ROW_TOGGLER_CLASS = "ui-row-toggler";
    public static final String EDITABLE_COLUMN_CLASS = "ui-editable-column";
    public static final String CELL_EDITOR_CLASS = "ui-cell-editor";
    public static final String CELL_EDITOR_INPUT_CLASS = "ui-cell-editor-input";
    public static final String CELL_EDITOR_OUTPUT_CLASS = "ui-cell-editor-output";
    public static final String CELL_EDITOR_DISABLED_CLASS = "ui-cell-editor-disabled";
    public static final String ROW_EDITOR_COLUMN_CLASS = "ui-row-editor-column";
    public static final String ROW_EDITOR_CLASS = "ui-row-editor ui-helper-clearfix";
    public static final String SELECTION_COLUMN_CLASS = "ui-selection-column";
    public static final String GROUPED_COLUMN_CLASS = "ui-grouped-column";
    public static final String EVEN_ROW_CLASS = "ui-datatable-even";
    public static final String ODD_ROW_CLASS = "ui-datatable-odd";
    public static final String SCROLLABLE_CONTAINER_CLASS = "ui-datatable-scrollable";
    public static final String SCROLLABLE_HEADER_CLASS = "ui-widget-header ui-datatable-scrollable-header";
    public static final String SCROLLABLE_HEADER_BOX_CLASS = "ui-datatable-scrollable-header-box";
    public static final String SCROLLABLE_BODY_CLASS = "ui-datatable-scrollable-body";
    public static final String SCROLLABLE_FOOTER_CLASS = "ui-widget-header ui-datatable-scrollable-footer";
    public static final String SCROLLABLE_FOOTER_BOX_CLASS = "ui-datatable-scrollable-footer-box";
    public static final String VIRTUALSCROLL_WRAPPER_CLASS = "ui-datatable-virtualscroll-wrapper";
    public static final String VIRTUALSCROLL_TABLE_CLASS = "ui-datatable-virtualscroll-table";
    public static final String COLUMN_RESIZER_CLASS = "ui-column-resizer";
    public static final String RESIZABLE_CONTAINER_CLASS = "ui-datatable-resizable";
    public static final String SUBTABLE_HEADER = "ui-datatable-subtable-header";
    public static final String SUBTABLE_FOOTER = "ui-datatable-subtable-footer";
    public static final String SUMMARY_ROW_CLASS = "ui-datatable-summaryrow ui-widget-header";
    public static final String HEADER_ROW_CLASS = "ui-rowgroup-header ui-datatable-headerrow ui-widget-header";
    public static final String ROW_GROUP_TOGGLER_CLASS = "ui-rowgroup-toggler";
    public static final String ROW_GROUP_TOGGLER_OPEN_ICON_CLASS = "ui-rowgroup-toggler-icon ui-icon ui-icon-circle-triangle-s";
    public static final String ROW_GROUP_TOGGLER_CLOSED_ICON_CLASS = "ui-rowgroup-toggler-icon ui-icon ui-icon-circle-triangle-e";
    public static final String EDITING_ROW_CLASS = "ui-row-editing";
    public static final String STICKY_HEADER_CLASS = "ui-datatable-sticky";
    public static final String ARIA_FILTER_BY = "primefaces.datatable.aria.FILTER_BY";
    public static final String ARIA_HEADER_CHECKBOX_ALL = "primefaces.datatable.aria.HEADER_CHECKBOX_ALL";
    public static final String SORT_LABEL = "primefaces.datatable.SORT_LABEL";
    public static final String SORT_ASC = "primefaces.datatable.SORT_ASC";
    public static final String SORT_DESC = "primefaces.datatable.SORT_DESC";
    public static final String ROW_GROUP_TOGGLER = "primefaces.rowgrouptoggler.aria.ROW_GROUP_TOGGLER";
    public static final String STRIPED_ROWS_CLASS = "ui-datatable-striped";
    public static final String GRIDLINES_CLASS = "ui-datatable-gridlines";
    public static final String SMALL_SIZE_CLASS = "ui-datatable-sm";
    public static final String LARGE_SIZE_CLASS = "ui-datatable-lg";
    public static final List<DataTableFeature> FEATURES = Collections.unmodifiableList(Arrays.asList(DraggableColumnsFeature.getInstance(), FilterFeature.getInstance(), PageFeature.getInstance(), SortFeature.getInstance(), ResizableColumnsFeature.getInstance(), SelectionFeature.getInstance(), RowEditFeature.getInstance(), CellEditFeature.getInstance(), RowExpandFeature.getInstance(), ScrollFeature.getInstance(), DraggableRowsFeature.getInstance(), AddRowFeature.getInstance()));
    private static final Map<String, Class<? extends BehaviorEvent>> BEHAVIOR_EVENT_MAPPING = MapBuilder.builder().put("page", PageEvent.class).put("sort", SortEvent.class).put("filter", FilterEvent.class).put("rowSelect", SelectEvent.class).put("rowUnselect", UnselectEvent.class).put("rowEdit", RowEditEvent.class).put("rowEditInit", RowEditEvent.class).put("rowEditCancel", RowEditEvent.class).put("colResize", ColumnResizeEvent.class).put("toggleSelect", ToggleSelectEvent.class).put("colReorder", null).put("contextMenu", SelectEvent.class).put("rowSelectRadio", SelectEvent.class).put("rowSelectCheckbox", SelectEvent.class).put("rowUnselectCheckbox", UnselectEvent.class).put("rowDblselect", SelectEvent.class).put("rowToggle", ToggleEvent.class).put("cellEditInit", CellEditEvent.class).put("cellEdit", CellEditEvent.class).put("rowReorder", ReorderEvent.class).put("tap", SelectEvent.class).put("taphold", SelectEvent.class).put("cellEditCancel", CellEditEvent.class).put("virtualScroll", PageEvent.class).put("liveScroll", PageEvent.class).build();
    private static final Collection<String> EVENT_NAMES = BEHAVIOR_EVENT_MAPPING.keySet();
    private boolean reset = false;
    private List<UIColumn> columns;
    private Map<String, AjaxBehaviorEvent> deferredEvents = new HashMap<String, AjaxBehaviorEvent>(1);

    public boolean shouldEncodeFeature(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_encodeFeature");
    }

    public boolean isFullUpdateRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_fullUpdate");
    }

    public boolean isRowEditRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_rowEditAction");
    }

    public boolean isRowEditInitRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_rowEditInit");
    }

    public boolean isCellEditCancelRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_cellEditCancel");
    }

    public boolean isCellEditInitRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_cellEditInit");
    }

    public boolean isClientCacheRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_clientCache");
    }

    public boolean isPageStateRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_pageState");
    }

    public boolean isScrollingRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_scrolling");
    }

    public boolean isRowEditCancelRequest(FacesContext context) {
        Map params = context.getExternalContext().getRequestParameterMap();
        String value = (String)params.get(this.getClientId(context) + "_rowEditAction");
        return "cancel".equals(value);
    }

    public boolean isRowSelectionEnabled() {
        return this.getSelectionMode() != null;
    }

    public boolean isColumnSelectionEnabled() {
        return this.getColumnSelectionMode() != null;
    }

    public String getColumnSelectionMode() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            String selectionMode;
            UIComponent child = (UIComponent)this.getChildren().get(i);
            if (!child.isRendered() || !(child instanceof Column) || (selectionMode = ((Column)child).getSelectionMode()) == null) continue;
            return selectionMode;
        }
        return null;
    }

    public boolean isSelectionEnabled() {
        return this.isRowSelectionEnabled() || this.isColumnSelectionEnabled();
    }

    public boolean isSingleSelectionMode() {
        String selectionMode = this.getSelectionMode();
        if (LangUtils.isNotBlank(selectionMode)) {
            return "single".equalsIgnoreCase(selectionMode);
        }
        String columnSelectionMode = this.getColumnSelectionMode();
        return "single".equalsIgnoreCase(columnSelectionMode);
    }

    public void processEvent(ComponentSystemEvent event) throws AbortProcessingException {
        super.processEvent(event);
        if (event instanceof PostRestoreStateEvent && this == event.getComponent() && this.isFilteringEnabled() && !this.isLazy()) {
            ValueExpression ve = this.getValueExpression(DataTableBase.PropertyKeys.filteredValue.name());
            if (ve != null) {
                List<?> filteredValue = this.getFilteredValue();
                if (filteredValue != null) {
                    this.setValue(filteredValue);
                }
            } else if (this.isFilteringCurrentlyActive()) {
                this.filterAndSort();
            }
        }
    }

    @Override
    public void processValidators(FacesContext context) {
        super.processValidators(context);
        FilterFeature feature = FilterFeature.getInstance();
        if (feature.shouldDecode(context, this)) {
            feature.decode(context, this);
            AjaxBehaviorEvent event = this.deferredEvents.get("filter");
            if (event != null) {
                FilterEvent wrappedEvent = new FilterEvent((UIComponent)this, event.getBehavior(), this.getFilterByAsMap());
                wrappedEvent.setPhaseId(PhaseId.PROCESS_VALIDATIONS);
                super.queueEvent((FacesEvent)wrappedEvent);
            }
        }
    }

    @Override
    public void processUpdates(FacesContext context) {
        super.processUpdates(context);
        Map<String, FilterMeta> filterBy = this.getFilterByAsMap();
        ELContext elContext = context.getELContext();
        for (FilterMeta filter : filterBy.values()) {
            ValueExpression columnFilterValueVE;
            UIColumn column = this.findColumn(filter.getColumnKey());
            if (column == null || (columnFilterValueVE = column.getValueExpression(ColumnBase.PropertyKeys.filterValue.toString())) == null) continue;
            if (column.isDynamic()) {
                DynamicColumn dynamicColumn = (DynamicColumn)column;
                dynamicColumn.applyStatelessModel();
                columnFilterValueVE.setValue(elContext, filter.getFilterValue());
                dynamicColumn.cleanStatelessModel();
                continue;
            }
            columnFilterValueVE.setValue(elContext, filter.getFilterValue());
        }
    }

    public void queueEvent(FacesEvent event) {
        FacesContext context = this.getFacesContext();
        if (ComponentUtils.isRequestSource((UIComponent)this, context) && event instanceof AjaxBehaviorEvent) {
            this.setRowIndex(-1);
            Map params = context.getExternalContext().getRequestParameterMap();
            String eventName = (String)params.get("javax.faces.behavior.event");
            String clientId = this.getClientId(context);
            AbstractAjaxBehaviorEvent wrapperEvent = null;
            RowEditEvent<Object> behaviorEvent = (RowEditEvent<Object>)event;
            if ("rowSelect".equals(eventName) || "rowSelectRadio".equals(eventName) || "contextMenu".equals(eventName) || "rowSelectCheckbox".equals(eventName) || "rowDblselect".equals(eventName)) {
                String rowKey = (String)params.get(clientId + "_instantSelectedRowKey");
                wrapperEvent = new SelectEvent<Object>((UIComponent)this, behaviorEvent.getBehavior(), this.getRowData(rowKey));
            } else if ("rowUnselect".equals(eventName) || "rowUnselectCheckbox".equals(eventName)) {
                String rowKey = (String)params.get(clientId + "_instantUnselectedRowKey");
                wrapperEvent = new UnselectEvent<Object>((UIComponent)this, behaviorEvent.getBehavior(), this.getRowData(rowKey));
            } else if ("page".equals(eventName) || "virtualScroll".equals(eventName) || "liveScroll".equals(eventName)) {
                int rows = this.getRowsToRender();
                int first = Integer.parseInt((String)params.get(clientId + "_first"));
                int page = rows > 0 ? first / rows : 0;
                wrapperEvent = new PageEvent((UIComponent)this, behaviorEvent.getBehavior(), page);
            } else if ("sort".equals(eventName)) {
                wrapperEvent = new SortEvent((UIComponent)this, behaviorEvent.getBehavior(), this.getSortByAsMap());
            } else {
                if ("filter".equals(eventName)) {
                    this.deferredEvents.put("filter", (AjaxBehaviorEvent)event);
                    return;
                }
                if ("rowEdit".equals(eventName) || "rowEditCancel".equals(eventName) || "rowEditInit".equals(eventName)) {
                    this.loadLazyDataIfRequired();
                    int rowIndex = Integer.parseInt((String)params.get(clientId + "_rowEditIndex"));
                    this.setRowIndex(rowIndex);
                    wrapperEvent = new RowEditEvent<Object>((UIComponent)this, behaviorEvent.getBehavior(), this.getRowData());
                } else if ("colResize".equals(eventName)) {
                    String columnId = (String)params.get(clientId + "_columnId");
                    int width = Double.valueOf((String)params.get(clientId + "_width")).intValue();
                    int height = Double.valueOf((String)params.get(clientId + "_height")).intValue();
                    wrapperEvent = new ColumnResizeEvent((UIComponent)this, behaviorEvent.getBehavior(), width, height, this.findColumn(columnId));
                } else if ("toggleSelect".equals(eventName)) {
                    boolean checked = Boolean.parseBoolean((String)params.get(clientId + "_checked"));
                    wrapperEvent = new ToggleSelectEvent((UIComponent)this, behaviorEvent.getBehavior(), checked);
                } else if ("colReorder".equals(eventName)) {
                    wrapperEvent = behaviorEvent;
                } else if ("rowToggle".equals(eventName)) {
                    this.loadLazyDataIfRequired();
                    boolean expansion = params.containsKey(clientId + "_rowExpansion");
                    Visibility visibility = expansion ? Visibility.VISIBLE : Visibility.HIDDEN;
                    String rowIndex = expansion ? (String)params.get(clientId + "_expandedRowIndex") : (String)params.get(clientId + "_collapsedRowIndex");
                    this.setRowIndex(Integer.parseInt(rowIndex));
                    wrapperEvent = new ToggleEvent((UIComponent)this, behaviorEvent.getBehavior(), visibility, this.getRowData());
                } else if ("cellEdit".equals(eventName) || "cellEditCancel".equals(eventName) || "cellEditInit".equals(eventName)) {
                    String[] cellInfo = ((String)params.get(clientId + "_cellInfo")).split(",");
                    int rowIndex = Integer.parseInt(cellInfo[0]);
                    int cellIndex = Integer.parseInt(cellInfo[1]);
                    String rowKey = null;
                    if (cellInfo.length == 3) {
                        rowKey = cellInfo[2];
                    }
                    int i = -1;
                    UIColumn column = null;
                    for (UIColumn col : this.getColumns()) {
                        if (!col.isRendered() || ++i != cellIndex) continue;
                        column = col;
                        break;
                    }
                    wrapperEvent = new CellEditEvent((UIComponent)this, behaviorEvent.getBehavior(), rowIndex, column, rowKey);
                } else if ("rowReorder".equals(eventName)) {
                    int fromIndex = Integer.parseInt((String)params.get(clientId + "_fromIndex"));
                    int toIndex = Integer.parseInt((String)params.get(clientId + "_toIndex"));
                    wrapperEvent = new ReorderEvent((UIComponent)this, behaviorEvent.getBehavior(), fromIndex, toIndex);
                } else if ("tap".equals(eventName) || "taphold".equals(eventName)) {
                    String rowkey = (String)params.get(clientId + "_rowkey");
                    wrapperEvent = new SelectEvent<Object>((UIComponent)this, behaviorEvent.getBehavior(), this.getRowData(rowkey));
                }
            }
            if (wrapperEvent == null) {
                throw new FacesException("Component " + this.getClass().getName() + " does not support event " + eventName + "!");
            }
            wrapperEvent.setPhaseId(event.getPhaseId());
            super.queueEvent(wrapperEvent);
        } else {
            super.queueEvent(event);
        }
    }

    public boolean hasFooterColumn() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            UIColumn column;
            UIComponent child = (UIComponent)this.getChildren().get(i);
            if (!child.isRendered() || !(child instanceof UIColumn) || (column = (UIColumn)child).getFooterText() == null && !ComponentUtils.shouldRenderFacet(column.getFacet("footer"))) continue;
            return true;
        }
        return false;
    }

    public void loadLazyDataIfRequired() {
        if (this.isLazy() && ((LazyDataModel)this.getValue()).getWrappedData() == null) {
            this.loadLazyData();
        }
    }

    public void loadLazyData() {
        DataModel model = this.getDataModel();
        if (model instanceof LazyDataModel) {
            LazyDataModel lazyModel = (LazyDataModel)model;
            Map filterBy = this.getActiveFilterMeta();
            lazyModel.setRowCount(lazyModel.count(filterBy));
            this.calculateFirst();
            FacesContext context = this.getFacesContext();
            int first = this.getFirst();
            int rows = this.getRows();
            if (this.isClientCacheRequest(context)) {
                Map params = context.getExternalContext().getRequestParameterMap();
                first = Integer.parseInt((String)params.get(this.getClientId(context) + "_first")) + rows;
            }
            List data = lazyModel.load(first, rows, this.getActiveSortMeta(), filterBy);
            lazyModel.setPageSize(rows);
            lazyModel.setWrappedData(data == null ? Collections.emptyList() : data);
            if (ComponentUtils.isRequestSource((UIComponent)this, context) && (this.isPaginator() || this.isLiveScroll() || this.isVirtualScroll())) {
                PrimeFaces.current().ajax().addCallbackParam("totalRecords", lazyModel.getRowCount());
            }
        }
    }

    public void loadLazyScrollData(int offset, int rows) {
        DataModel model = this.getDataModel();
        if (model instanceof LazyDataModel) {
            LazyDataModel lazyModel = (LazyDataModel)model;
            Map filterBy = this.getActiveFilterMeta();
            lazyModel.setRowCount(lazyModel.count(filterBy));
            List data = lazyModel.load(offset, rows, this.getActiveSortMeta(), this.getActiveFilterMeta());
            lazyModel.setPageSize(rows);
            lazyModel.setWrappedData(data);
            if (ComponentUtils.isRequestSource((UIComponent)this, this.getFacesContext()) && (this.isPaginator() || this.isLiveScroll() || this.isVirtualScroll())) {
                PrimeFaces.current().ajax().addCallbackParam("totalRecords", lazyModel.getRowCount());
            }
        }
    }

    public void clearLazyCache() {
        if (this.getDataModel() instanceof LazyDataModel) {
            LazyDataModel model = (LazyDataModel)this.getDataModel();
            model.setWrappedData(null);
        }
    }

    public int getScrollOffset() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)"scrollOffset"), (Object)0);
    }

    public void setScrollOffset(int scrollOffset) {
        this.getStateHelper().put((Serializable)((Object)"scrollOffset"), (Object)scrollOffset);
    }

    public boolean isReset() {
        return this.reset;
    }

    public void resetValue() {
        this.setValue(null);
        this.setFilteredValue(null);
    }

    public void reset() {
        this.resetValue();
        this.setFirst(0);
        this.resetRows();
        this.reset = true;
        this.setDefaultSort(false);
        this.setDefaultFilter(false);
        this.setSortByAsMap(null);
        this.setFilterByAsMap(null);
        this.setSelectedRowKeys(null);
        this.setScrollOffset(0);
    }

    public RowExpansion getRowExpansion() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            UIComponent child = (UIComponent)this.getChildren().get(i);
            if (!(child instanceof RowExpansion)) continue;
            return (RowExpansion)child;
        }
        return null;
    }

    @Override
    public Map<String, Class<? extends BehaviorEvent>> getBehaviorEventMapping() {
        return BEHAVIOR_EVENT_MAPPING;
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public boolean isBodyUpdate(FacesContext context) {
        String clientId = this.getClientId(context);
        return context.getExternalContext().getRequestParameterMap().containsKey(clientId + "_updateBody");
    }

    public SubTable getSubTable() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            UIComponent child = (UIComponent)this.getChildren().get(i);
            if (!(child instanceof SubTable)) continue;
            return (SubTable)child;
        }
        return null;
    }

    public String getRowKey(Object object) {
        boolean hasRowKeyVe;
        DataModel model = this.getDataModel();
        if (model instanceof SelectableDataModel) {
            return ((SelectableDataModel)model).getRowKey(object);
        }
        boolean bl = hasRowKeyVe = this.getValueExpression(DataTableBase.PropertyKeys.rowKey.name()) != null;
        if (!hasRowKeyVe) {
            throw new UnsupportedOperationException("DataTable#rowKey must be defined for component " + this.getClientId(this.getFacesContext()));
        }
        return ComponentUtils.executeInRequestScope(this.getFacesContext(), this.getVar(), object, () -> this.getRowKey());
    }

    public Object getRowData(String rowKey) {
        DataModel model = this.getDataModel();
        if (model instanceof SelectableDataModel) {
            return ((SelectableDataModel)model).getRowData(rowKey);
        }
        Collection data = (Collection)this.getDataModel().getWrappedData();
        for (Object o : data) {
            if (!Objects.equals(rowKey, this.getRowKey(o))) continue;
            return o;
        }
        return null;
    }

    public Set<String> getExpandedRowKeys() {
        return ComponentUtils.eval(this.getStateHelper(), (Serializable)((Object)InternalPropertyKeys.expandedRowKeys), Collections::emptySet);
    }

    public void setExpandedRowKeys(Set<String> expandedRowKeys) {
        this.getStateHelper().put((Serializable)((Object)InternalPropertyKeys.expandedRowKeys), expandedRowKeys);
    }

    public Set<String> getSelectedRowKeys() {
        return ComponentUtils.eval(this.getStateHelper(), (Serializable)((Object)InternalPropertyKeys.selectedRowKeys), Collections::emptySet);
    }

    public void setSelectedRowKeys(Set<String> selectedRowKeys) {
        this.getStateHelper().put((Serializable)((Object)InternalPropertyKeys.selectedRowKeys), selectedRowKeys);
    }

    public String getSelectedRowKeysAsString() {
        return String.join((CharSequence)",", this.getSelectedRowKeys());
    }

    public boolean isSelectAll() {
        return ComponentUtils.eval(this.getStateHelper(), (Serializable)((Object)InternalPropertyKeys.selectAll), () -> false);
    }

    public void setSelectAll(boolean selectAll) {
        this.getStateHelper().put((Serializable)((Object)InternalPropertyKeys.selectAll), (Object)selectAll);
    }

    public SummaryRow getSummaryRow() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            UIComponent kid = (UIComponent)this.getChildren().get(i);
            if (!kid.isRendered() || !(kid instanceof SummaryRow)) continue;
            return (SummaryRow)kid;
        }
        return null;
    }

    @Override
    public HeaderRow getHeaderRow() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            UIComponent child = (UIComponent)this.getChildren().get(i);
            if (!child.isRendered() || !(child instanceof HeaderRow)) continue;
            return (HeaderRow)child;
        }
        return null;
    }

    @Override
    public List<UIColumn> getColumns() {
        if (this.columns != null) {
            return this.columns;
        }
        List columns = this.collectColumns();
        if (this.getFacesContext().getCurrentPhaseId() == PhaseId.RENDER_RESPONSE) {
            this.columns = columns;
        }
        return columns;
    }

    @Override
    public void setColumns(List<UIColumn> columns) {
        this.columns = columns;
    }

    public String getScrollState() {
        String name;
        Map params = this.getFacesContext().getExternalContext().getRequestParameterMap();
        String value = (String)params.get(name = this.getClientId() + "_scrollState");
        return value == null ? (this.isRTL() ? "-1,0" : "0,0") : value;
    }

    @Override
    protected boolean shouldSkipChildren(FacesContext context) {
        Map params = context.getExternalContext().getRequestParameterMap();
        String paramValue = (String)params.get("primefaces.skipchildren");
        if (paramValue != null && !Boolean.parseBoolean(paramValue)) {
            return false;
        }
        return this.isSkipChildren() || params.containsKey(this.getClientId(context) + "_skipChildren");
    }

    public boolean isMultiSort() {
        return "multiple".equals(this.getSortMode());
    }

    public String resolveSelectionMode() {
        String tableSelectionMode = this.getSelectionMode();
        String selectionMode = null;
        if (LangUtils.isNotBlank(tableSelectionMode)) {
            selectionMode = tableSelectionMode;
        } else {
            String columnSelectionMode = this.getColumnSelectionMode();
            if (LangUtils.isNotBlank(columnSelectionMode)) {
                selectionMode = "single".equals(columnSelectionMode) ? "radio" : "checkbox";
            }
        }
        return selectionMode;
    }

    @Override
    protected boolean requiresColumns() {
        return true;
    }

    @Override
    protected void processColumnFacets(FacesContext context, PhaseId phaseId) {
        if (this.getChildCount() > 0) {
            for (UIComponent child : this.getChildren()) {
                if (!child.isRendered()) continue;
                if (child instanceof UIColumn) {
                    if (child instanceof Column) {
                        for (UIComponent facet : child.getFacets().values()) {
                            this.process(context, facet, phaseId);
                        }
                        continue;
                    }
                    if (!(child instanceof Columns)) continue;
                    Columns uicolumns = (Columns)child;
                    int f = uicolumns.getFirst();
                    int r = uicolumns.getRows();
                    int l = r == 0 ? uicolumns.getRowCount() : f + r;
                    for (int i = f; i < l; ++i) {
                        uicolumns.setRowIndex(i);
                        if (!uicolumns.isRowAvailable()) break;
                        for (UIComponent facet : child.getFacets().values()) {
                            this.process(context, facet, phaseId);
                        }
                    }
                    uicolumns.setRowIndex(-1);
                    continue;
                }
                if (!(child instanceof ColumnGroup) || child.getChildCount() <= 0) continue;
                for (UIComponent columnGroupChild : child.getChildren()) {
                    if (columnGroupChild instanceof Row && columnGroupChild.getChildCount() > 0) {
                        for (UIComponent rowChild : columnGroupChild.getChildren()) {
                            if (rowChild instanceof Column && rowChild.getFacetCount() > 0) {
                                for (UIComponent facet : rowChild.getFacets().values()) {
                                    this.process(context, facet, phaseId);
                                }
                                continue;
                            }
                            this.process(context, rowChild, phaseId);
                        }
                        continue;
                    }
                    this.process(context, columnGroupChild, phaseId);
                }
            }
        }
    }

    @Override
    protected boolean visitRows(VisitContext context, VisitCallback callback, boolean visitRows) {
        if (this.getFacesContext().isPostback() && !ComponentUtils.isSkipIteration(context, context.getFacesContext())) {
            this.loadLazyDataIfRequired();
        }
        return super.visitRows(context, callback, visitRows);
    }

    @Override
    protected void processChildren(FacesContext context, PhaseId phaseId) {
        if (this.getFacesContext().isPostback()) {
            this.loadLazyDataIfRequired();
        }
        int first = this.getFirst();
        int rows = this.getRows();
        int rowCount = this.getRowCount();
        int last = 0;
        last = rows == 0 ? (this.isLiveScroll() ? this.getScrollRows() + this.getScrollOffset() : (this.isVirtualScroll() ? first + this.getScrollRows() * 2 : rowCount)) : first + rows;
        List<UIComponent> iterableChildren = null;
        for (int rowIndex = first; rowIndex < last; ++rowIndex) {
            this.setRowIndex(rowIndex);
            if (!this.isRowAvailable()) break;
            if (iterableChildren == null) {
                iterableChildren = this.getIterableChildren();
            }
            for (int i = 0; i < iterableChildren.size(); ++i) {
                UIComponent child = iterableChildren.get(i);
                if (!child.isRendered()) continue;
                if (child instanceof Column) {
                    for (int j = 0; j < child.getChildCount(); ++j) {
                        UIComponent grandkid = (UIComponent)child.getChildren().get(j);
                        this.process(context, grandkid, phaseId);
                    }
                    continue;
                }
                if (child instanceof RowExpansion) {
                    Object rowData = this.getRowData();
                    String rowKey = this.getRowKey(rowData);
                    if (!this.getExpandedRowKeys().contains(rowKey) && !this.isExpandedRow()) continue;
                    this.process(context, child, phaseId);
                    continue;
                }
                this.process(context, child, phaseId);
            }
        }
    }

    @Override
    public boolean isDefaultSort() {
        return this.getSortByAsMap() != null && Boolean.TRUE.equals(this.getStateHelper().get((Serializable)((Object)InternalPropertyKeys.defaultSort)));
    }

    @Override
    public void setDefaultSort(boolean defaultSort) {
        this.getStateHelper().put((Serializable)((Object)InternalPropertyKeys.defaultSort), (Object)defaultSort);
    }

    @Override
    public boolean isDefaultFilter() {
        return Boolean.TRUE.equals(this.getStateHelper().get((Serializable)((Object)InternalPropertyKeys.defaultFilter)));
    }

    @Override
    public void setDefaultFilter(boolean defaultFilter) {
        this.getStateHelper().put((Serializable)((Object)InternalPropertyKeys.defaultFilter), (Object)defaultFilter);
    }

    public List<UIColumn> findOrderedColumns(String columnOrder) {
        FacesContext context = this.getFacesContext();
        ArrayList<UIColumn> orderedColumns = null;
        if (columnOrder != null) {
            orderedColumns = new ArrayList<UIColumn>();
            String[] order = columnOrder.split(",");
            String separator = String.valueOf(UINamingContainer.getSeparatorChar((FacesContext)context));
            block0: for (String columnId : order) {
                for (UIComponent child : this.getChildren()) {
                    String columnsClientId;
                    if (child instanceof Column && child.getClientId(context).equals(columnId)) {
                        orderedColumns.add((UIColumn)child);
                        continue block0;
                    }
                    if (!(child instanceof Columns) || !columnId.startsWith(columnsClientId = child.getClientId(context))) continue;
                    String[] ids = columnId.split(separator);
                    int index = Integer.parseInt(ids[ids.length - 1]);
                    orderedColumns.add(new DynamicColumn(index, (Columns)child, context));
                    continue block0;
                }
            }
        }
        return orderedColumns;
    }

    public Locale resolveDataLocale() {
        FacesContext context = this.getFacesContext();
        return LocaleUtils.resolveLocale(context, this.getDataLocale(), this.getClientId(context));
    }

    @Override
    protected List<UIComponent> getIterableChildren() {
        ArrayList<UIComponent> iterableChildren = new ArrayList<UIComponent>(this.getChildCount());
        for (int i = 0; i < this.getChildCount(); ++i) {
            UIComponent child = (UIComponent)this.getChildren().get(i);
            if (child instanceof ColumnGroup) continue;
            iterableChildren.add(child);
        }
        return iterableChildren;
    }

    public List<?> getFilteredValue() {
        ValueExpression ve = this.getValueExpression(DataTableBase.PropertyKeys.filteredValue.name());
        if (ve != null) {
            return (List)ve.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setFilteredValue(List<?> filteredValue) {
        ValueExpression ve = this.getValueExpression(DataTableBase.PropertyKeys.filteredValue.name());
        if (ve != null) {
            ve.setValue(this.getFacesContext().getELContext(), filteredValue);
        }
    }

    @Override
    public Object saveState(FacesContext context) {
        if (this.isFilteringEnabled()) {
            this.setValue(null);
        }
        this.resetDynamicColumns();
        if (this.deferredEvents != null) {
            this.deferredEvents.clear();
        }
        this.reset = false;
        this.columns = null;
        return super.saveState(context);
    }

    @Override
    protected void preDecode(FacesContext context) {
        this.resetDynamicColumns();
        super.preDecode(context);
    }

    @Override
    protected void preValidate(FacesContext context) {
        this.resetDynamicColumns();
        super.preValidate(context);
    }

    @Override
    protected void preUpdate(FacesContext context) {
        this.resetDynamicColumns();
        super.preUpdate(context);
    }

    @Override
    protected void preEncode(FacesContext context) {
        this.resetDynamicColumns();
        super.preEncode(context);
    }

    @Override
    public void restoreMultiViewState() {
        DataTableState ts = this.getMultiViewState(false);
        if (ts != null) {
            if (this.isPaginator()) {
                this.setFirst(ts.getFirst());
                int rows = ts.getRows() == 0 ? this.getRows() : ts.getRows();
                this.setRows(rows);
            }
            if (ts.getSortBy() != null) {
                this.updateSortByWithMVS(ts.getSortBy());
            }
            if (ts.getFilterBy() != null) {
                this.updateFilterByWithMVS(this.getFacesContext(), ts.getFilterBy());
            }
            if (this.isSelectionEnabled() && ts.getSelectedRowKeys() != null) {
                this.updateSelectionWithMVS(ts.getSelectedRowKeys());
            }
            if (ts.getExpandedRowKeys() != null) {
                this.updateExpansionWithMVS(ts.getExpandedRowKeys());
            }
            this.setColumnMeta(ts.getColumnMeta());
        }
    }

    public void updateSelectionWithMVS(Set<String> rowKeys) {
        if (this.getFacesContext().isPostback()) {
            return;
        }
        SelectionFeature.getInstance().decodeSelection(this.getFacesContext(), this, rowKeys);
    }

    public void updateExpansionWithMVS(Set<String> rowKeys) {
        this.setExpandedRowKeys(rowKeys);
    }

    @Override
    public DataTableState getMultiViewState(boolean create) {
        FacesContext fc = this.getFacesContext();
        String viewId = fc.getViewRoot().getViewId();
        return PrimeFaces.current().multiViewState().get(viewId, this.getClientId(fc), create, DataTableState::new);
    }

    @Override
    public void resetMultiViewState() {
        this.reset();
    }

    public String getGroupedColumnIndexes() {
        return IntStream.range(0, this.getColumns().size()).filter(i -> this.getColumns().get(i).isGroupRow()).mapToObj(Objects::toString).collect(Collectors.joining(",", "[", "]"));
    }

    @Override
    public Map<String, SortMeta> getSortByAsMap() {
        return ComponentUtils.computeIfAbsent(this.getStateHelper(), (Serializable)((Object)InternalPropertyKeys.sortByAsMap), () -> this.initSortBy(this.getFacesContext()));
    }

    @Override
    public void setSortByAsMap(Map<String, SortMeta> sortBy) {
        this.getStateHelper().put((Serializable)((Object)InternalPropertyKeys.sortByAsMap), sortBy);
    }

    @Override
    public Map<String, FilterMeta> getFilterByAsMap() {
        return ComponentUtils.eval(this.getStateHelper(), (Serializable)((Object)InternalPropertyKeys.filterByAsMap), () -> this.initFilterBy(this.getFacesContext()));
    }

    @Override
    public void setFilterByAsMap(Map<String, FilterMeta> sortBy) {
        this.getStateHelper().put((Serializable)((Object)InternalPropertyKeys.filterByAsMap), sortBy);
    }

    @Override
    public int getFrozenColumnsCount() {
        return this.getFrozenColumns();
    }

    @Override
    public boolean isFilterByAsMapDefined() {
        return this.getStateHelper().get((Serializable)((Object)InternalPropertyKeys.filterByAsMap)) != null;
    }

    @Override
    public Map<String, ColumnMeta> getColumnMeta() {
        HashMap<String, ColumnMeta> value = (HashMap<String, ColumnMeta>)this.getStateHelper().get((Serializable)((Object)InternalPropertyKeys.columnMeta));
        if (value == null) {
            value = new HashMap<String, ColumnMeta>();
            this.setColumnMeta(value);
        }
        return value;
    }

    @Override
    public void setColumnMeta(Map<String, ColumnMeta> columnMeta) {
        this.getStateHelper().put((Serializable)((Object)InternalPropertyKeys.columnMeta), columnMeta);
    }

    @Override
    public String getWidth() {
        return (String)this.getStateHelper().eval((Serializable)((Object)InternalPropertyKeys.width), null);
    }

    @Override
    public void setWidth(String width) {
        this.getStateHelper().put((Serializable)((Object)InternalPropertyKeys.width), (Object)width);
    }

    @Override
    public void filterAndSort() {
        if (this.isLazy()) {
            return;
        }
        this.setDataModel(null);
        FilterFeature.getInstance().filter(FacesContext.getCurrentInstance(), this);
        SortFeature.getInstance().sort(FacesContext.getCurrentInstance(), this);
    }

    public void selectRow(String rowKey) {
        this.getSelectedRowKeys().add(rowKey);
        if (this.isMultiViewState()) {
            DataTableState mvs = this.getMultiViewState(true);
            if (mvs.getSelectedRowKeys() == null) {
                mvs.setSelectedRowKeys(new HashSet<String>());
            }
            mvs.getSelectedRowKeys().add(rowKey);
        }
    }

    public void unselectRow(String rowKey) {
        DataTableState mvs;
        if (this.getSelectedRowKeys().contains(rowKey)) {
            this.getSelectedRowKeys().remove(rowKey);
        }
        if (this.isMultiViewState() && (mvs = this.getMultiViewState(false)) != null && mvs.getSelectedRowKeys() != null && mvs.getSelectedRowKeys().contains(rowKey)) {
            mvs.getSelectedRowKeys().remove(rowKey);
        }
    }

    public void expandRow(String rowKey) {
        this.getExpandedRowKeys().add(rowKey);
        if (this.isMultiViewState()) {
            DataTableState mvs = this.getMultiViewState(true);
            if (mvs.getExpandedRowKeys() == null) {
                mvs.setExpandedRowKeys(new HashSet<String>());
            }
            mvs.getExpandedRowKeys().add(rowKey);
        }
    }

    public void collapseRow(String rowKey) {
        DataTableState mvs;
        if (this.getExpandedRowKeys().contains(rowKey)) {
            this.getExpandedRowKeys().remove(rowKey);
        }
        if (this.isMultiViewState() && (mvs = this.getMultiViewState(false)) != null && mvs.getExpandedRowKeys() != null && mvs.getExpandedRowKeys().contains(rowKey)) {
            mvs.getExpandedRowKeys().remove(rowKey);
        }
    }

    public LazyDataModel<?> getLazyDataModel() {
        if (this.isLazy()) {
            return (LazyDataModel)this.getDataModel();
        }
        return null;
    }

    protected static enum InternalPropertyKeys {
        defaultFilter,
        filterByAsMap,
        defaultSort,
        sortByAsMap,
        visibleColumnsAsMap,
        resizableColumnsAsMap,
        selectedRowKeys,
        selectAll,
        expandedRowKeys,
        columnMeta,
        width;

    }
}

