/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.export;

import javax.el.MethodExpression;
import org.primefaces.component.export.ExporterOptions;

public class ExportConfiguration {
    private String outputFileName;
    private boolean pageOnly;
    private boolean selectionOnly;
    private boolean visibleOnly;
    private boolean exportHeader;
    private boolean exportFooter;
    private String encodingType;
    private MethodExpression preProcessor;
    private MethodExpression postProcessor;
    private ExporterOptions options;
    private MethodExpression onTableRender;

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "ExportConfiguration(outputFileName=" + this.outputFileName + ", pageOnly=" + this.pageOnly + ", selectionOnly=" + this.selectionOnly + ", visibleOnly=" + this.visibleOnly + ", exportHeader=" + this.exportHeader + ", exportFooter=" + this.exportFooter + ", encodingType=" + this.encodingType + ", preProcessor=" + this.preProcessor + ", postProcessor=" + this.postProcessor + ", options=" + this.options + ", onTableRender=" + this.onTableRender + ")";
    }

    public String getOutputFileName() {
        return this.outputFileName;
    }

    public boolean isPageOnly() {
        return this.pageOnly;
    }

    public boolean isSelectionOnly() {
        return this.selectionOnly;
    }

    public boolean isVisibleOnly() {
        return this.visibleOnly;
    }

    public boolean isExportHeader() {
        return this.exportHeader;
    }

    public boolean isExportFooter() {
        return this.exportFooter;
    }

    public String getEncodingType() {
        return this.encodingType;
    }

    public MethodExpression getPreProcessor() {
        return this.preProcessor;
    }

    public MethodExpression getPostProcessor() {
        return this.postProcessor;
    }

    public ExporterOptions getOptions() {
        return this.options;
    }

    public MethodExpression getOnTableRender() {
        return this.onTableRender;
    }

    public static class Builder {
        private String outputFileName;
        private boolean pageOnly;
        private boolean selectionOnly;
        private boolean visibleOnly;
        private boolean exportHeader;
        private boolean exportFooter;
        private String encodingType;
        private MethodExpression preProcessor;
        private MethodExpression postProcessor;
        private ExporterOptions options;
        private MethodExpression onTableRender;

        Builder() {
        }

        public Builder outputFileName(String outputFileName) {
            this.outputFileName = outputFileName;
            return this;
        }

        public Builder pageOnly(boolean pageOnly) {
            this.pageOnly = pageOnly;
            return this;
        }

        public Builder selectionOnly(boolean selectionOnly) {
            this.selectionOnly = selectionOnly;
            return this;
        }

        public Builder visibleOnly(boolean visibleOnly) {
            this.visibleOnly = visibleOnly;
            return this;
        }

        public Builder exportHeader(boolean exportHeader) {
            this.exportHeader = exportHeader;
            return this;
        }

        public Builder exportFooter(boolean exportFooter) {
            this.exportFooter = exportFooter;
            return this;
        }

        public Builder encodingType(String encodingType) {
            this.encodingType = encodingType;
            return this;
        }

        public Builder preProcessor(MethodExpression preProcessor) {
            this.preProcessor = preProcessor;
            return this;
        }

        public Builder postProcessor(MethodExpression postProcessor) {
            this.postProcessor = postProcessor;
            return this;
        }

        public Builder options(ExporterOptions options) {
            this.options = options;
            return this;
        }

        public Builder onTableRender(MethodExpression onTableRender) {
            this.onTableRender = onTableRender;
            return this;
        }

        public ExportConfiguration build() {
            ExportConfiguration config = new ExportConfiguration();
            config.outputFileName = this.outputFileName;
            config.pageOnly = this.pageOnly;
            config.selectionOnly = this.selectionOnly;
            config.visibleOnly = this.visibleOnly;
            config.exportHeader = this.exportHeader;
            config.exportFooter = this.exportFooter;
            config.encodingType = this.encodingType;
            config.preProcessor = this.preProcessor;
            config.postProcessor = this.postProcessor;
            config.options = this.options;
            config.onTableRender = this.onTableRender;
            return config;
        }

        public String toString() {
            return "ExportConfiguration.ExportConfigurationBuilder(outputFileName=" + this.outputFileName + ", pageOnly=" + this.pageOnly + ", selectionOnly=" + this.selectionOnly + ", visibleOnly=" + this.visibleOnly + ", exportHeader=" + this.exportHeader + ", exportFooter=" + this.exportFooter + ", encodingType=" + this.encodingType + ", preProcessor=" + this.preProcessor + ", postProcessor=" + this.postProcessor + ", options=" + this.options + ", onTableRender=" + this.onTableRender + ")";
        }
    }
}

