/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model;

import java.io.Serializable;
import java.util.Objects;
import javax.el.ELContext;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import org.primefaces.component.api.DynamicColumn;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.column.ColumnBase;
import org.primefaces.component.datatable.feature.FilterFeature;
import org.primefaces.model.MatchMode;
import org.primefaces.model.filter.FilterConstraint;
import org.primefaces.model.filter.FunctionFilterConstraint;
import org.primefaces.model.filter.GlobalFilterConstraint;

public class FilterMeta
implements Serializable {
    public static final String GLOBAL_FILTER_KEY = "globalFilter";
    private static final long serialVersionUID = 1L;
    private String field;
    private String columnKey;
    private ValueExpression filterBy;
    private Object filterValue;
    private MatchMode matchMode = MatchMode.CONTAINS;
    private FilterConstraint constraint;

    public FilterMeta() {
    }

    FilterMeta(String columnKey, String field, FilterConstraint constraint, ValueExpression filterBy, Object filterValue, MatchMode matchMode) {
        this.field = field;
        this.columnKey = columnKey;
        this.filterBy = filterBy;
        this.constraint = constraint;
        this.filterValue = filterValue;
        this.matchMode = matchMode;
    }

    @Deprecated
    public FilterMeta(String field, String columnKey, ValueExpression filterByVE, MatchMode filterMatchMode, Object filterValue) {
        this.field = field;
        this.columnKey = columnKey;
        this.filterBy = filterByVE;
        this.constraint = FilterFeature.FILTER_CONSTRAINTS.get((Object)filterMatchMode);
        this.filterValue = filterValue;
        this.matchMode = filterMatchMode;
    }

    public static FilterMeta of(FacesContext context, String var, UIColumn column) {
        if (column instanceof DynamicColumn) {
            ((DynamicColumn)column).applyStatelessModel();
        }
        if (!column.isFilterable()) {
            return null;
        }
        String field = column.getField();
        ValueExpression filterByVE = column.getValueExpression(ColumnBase.PropertyKeys.filterBy.name());
        if (field == null && filterByVE == null) {
            return null;
        }
        if (field == null) {
            field = column.resolveField(context, filterByVE);
        } else if (filterByVE == null) {
            filterByVE = UIColumn.createValueExpressionFromField(context, var, field);
        }
        MatchMode matchMode = MatchMode.of(column.getFilterMatchMode());
        FilterConstraint constraint = FilterFeature.FILTER_CONSTRAINTS.get((Object)matchMode);
        if (column.getFilterFunction() != null) {
            constraint = new FunctionFilterConstraint(column.getFilterFunction());
        }
        return new FilterMeta(column.getColumnKey(), field, constraint, filterByVE, column.getFilterValue(), matchMode);
    }

    public static FilterMeta of(Object globalFilterValue, MethodExpression globalFilterFunction) {
        FilterConstraint constraint = globalFilterFunction == null ? new GlobalFilterConstraint() : new FunctionFilterConstraint(globalFilterFunction);
        return new FilterMeta(GLOBAL_FILTER_KEY, GLOBAL_FILTER_KEY, constraint, null, globalFilterValue, MatchMode.GLOBAL);
    }

    public String getField() {
        return this.field;
    }

    public String getColumnKey() {
        return this.columnKey;
    }

    public ValueExpression getFilterBy() {
        return this.filterBy;
    }

    public void setFilterBy(ValueExpression filterBy) {
        this.filterBy = filterBy;
    }

    public Object getFilterValue() {
        return this.filterValue;
    }

    public void setFilterValue(Object filterValue) {
        this.filterValue = filterValue;
    }

    public FilterConstraint getConstraint() {
        return this.constraint;
    }

    public void setConstraint(FilterConstraint constraint) {
        this.constraint = constraint;
    }

    public boolean isActive() {
        return this.filterValue != null;
    }

    public MatchMode getMatchMode() {
        return this.matchMode;
    }

    public void setMatchMode(MatchMode matchMode) {
        this.matchMode = matchMode;
    }

    public boolean isGlobalFilter() {
        return GLOBAL_FILTER_KEY.equals(this.columnKey);
    }

    public Object getLocalValue(ELContext elContext, UIColumn column) {
        if (column instanceof DynamicColumn) {
            ((DynamicColumn)column).applyStatelessModel();
        }
        return this.filterBy.getValue(elContext);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "FilterMeta{field='" + this.field + '\'' + ", columnKey='" + this.columnKey + '\'' + ", filterBy=" + this.filterBy + ", filterValue=" + this.filterValue + ", matchMode=" + (Object)((Object)this.matchMode) + ", constraint=" + this.constraint + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilterMeta that = (FilterMeta)o;
        return Objects.equals(this.field, that.field) && Objects.equals(this.columnKey, that.columnKey);
    }

    public int hashCode() {
        return Objects.hash(this.field, this.columnKey);
    }

    public static final class Builder {
        private final FilterMeta filterBy = new FilterMeta();

        private Builder() {
        }

        public Builder field(String field) {
            this.filterBy.field = field;
            return this;
        }

        public Builder filterBy(ValueExpression filterBy) {
            this.filterBy.filterBy = filterBy;
            return this;
        }

        public Builder filterValue(Object filterValue) {
            this.filterBy.filterValue = filterValue;
            return this;
        }

        public Builder constraint(FilterConstraint constraint) {
            this.filterBy.constraint = constraint;
            return this;
        }

        public Builder matchMode(MatchMode matchMode) {
            this.filterBy.matchMode = matchMode;
            return this;
        }

        public FilterMeta build() {
            if (this.filterBy.matchMode != null) {
                this.filterBy.constraint = FilterFeature.FILTER_CONSTRAINTS.get((Object)this.filterBy.matchMode);
            }
            Objects.requireNonNull(this.filterBy.constraint, "Filter constraint is required");
            Objects.requireNonNull(this.filterBy.field, "Field is required");
            return this.filterBy;
        }
    }
}

