/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import org.primefaces.util.EscapeUtils;

public class ResponsiveOption
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String breakpoint;
    private int numVisible;
    private int numScroll;

    public ResponsiveOption() {
    }

    public ResponsiveOption(String breakpoint, int numVisible) {
        this.breakpoint = breakpoint;
        this.numVisible = numVisible;
    }

    public ResponsiveOption(String breakpoint, int numVisible, int numScroll) {
        this(breakpoint, numVisible);
        this.numScroll = numScroll;
    }

    public String getBreakpoint() {
        return this.breakpoint;
    }

    public void setBreakpoint(String breakpoint) {
        this.breakpoint = breakpoint;
    }

    public int getNumVisible() {
        return this.numVisible;
    }

    public void setNumVisible(int numVisible) {
        this.numVisible = numVisible;
    }

    public int getNumScroll() {
        return this.numScroll;
    }

    public void setNumScroll(int numScroll) {
        this.numScroll = numScroll;
    }

    public void encode(Writer writer) throws IOException {
        writer.write("{");
        writer.write("breakpoint:\"" + EscapeUtils.forJavaScript(this.breakpoint) + "\"");
        writer.write(",numVisible:" + this.numVisible);
        writer.write(",numScroll:" + this.numScroll);
        writer.write("}");
    }
}

