/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.renderkit;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UISelectOne;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import org.primefaces.renderkit.SelectRenderer;

public abstract class SelectOneRenderer
extends SelectRenderer {
    public void decode(FacesContext context, UIComponent component) {
        UISelectOne selectOne = (UISelectOne)component;
        if (!this.shouldDecode((UIInput)selectOne)) {
            return;
        }
        String clientId = this.getSubmitParam(context, selectOne);
        Map params = context.getExternalContext().getRequestParameterMap();
        String submittedValue = params.containsKey(clientId) ? (String)params.get(clientId) : "";
        List<String> validSubmittedValues = this.validateSubmittedValues(context, (UIInput)selectOne, (Object[])this.getValues(selectOne), submittedValue);
        selectOne.setSubmittedValue((Object)(validSubmittedValues.isEmpty() || validSubmittedValues.contains(submittedValue) ? submittedValue : validSubmittedValues.get(0)));
        this.decodeBehaviors(context, (UIComponent)selectOne);
    }

    protected Object getValues(UISelectOne selectOne) {
        Object value = selectOne.getValue();
        if (value != null) {
            return new Object[]{value};
        }
        return null;
    }

    protected Object getSubmittedValues(UIComponent component) {
        UISelectOne select = (UISelectOne)component;
        Object val = select.getSubmittedValue();
        if (val != null) {
            return new Object[]{val};
        }
        return null;
    }

    protected SelectItem findSelectItemByLabel(FacesContext fc, UIComponent component, Converter converter, List<SelectItem> selectItems, String valueOrLabel) {
        return this.findSelectItem(fc, component, converter, selectItems, valueOrLabel, false);
    }

    protected SelectItem findSelectItemByValue(FacesContext fc, UIComponent component, Converter converter, List<SelectItem> selectItems, String valueOrLabel) {
        return this.findSelectItem(fc, component, converter, selectItems, valueOrLabel, true);
    }

    private SelectItem findSelectItem(FacesContext fc, UIComponent component, Converter converter, List<SelectItem> selectItems, String valueOrLabel, boolean byValue) {
        for (int i = 0; i < selectItems.size(); ++i) {
            SelectItem item = selectItems.get(i);
            if (item instanceof SelectItemGroup) {
                SelectItem foundValue;
                SelectItemGroup selectItemGroup = (SelectItemGroup)item;
                if (selectItemGroup.getSelectItems() == null || (foundValue = this.findSelectItem(fc, component, converter, Arrays.asList(selectItemGroup.getSelectItems()), valueOrLabel, byValue)) == null) continue;
                return foundValue;
            }
            String itemString = byValue ? this.getOptionAsString(fc, component, converter, item.getValue()) : item.getLabel();
            if (!Objects.equals(valueOrLabel, itemString)) continue;
            return item;
        }
        return null;
    }

    protected abstract String getSubmitParam(FacesContext var1, UISelectOne var2);
}

