/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
import javax.servlet.http.HttpServletRequest;
import org.primefaces.component.fileupload.FileUpload;
import org.primefaces.component.fileupload.FileUploadChunkDecoder;
import org.primefaces.component.fileupload.FileUploadDecoder;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.model.file.UploadedFile;
import org.primefaces.shaded.commons.io.FilenameUtils;
import org.primefaces.shaded.owasp.SafeFile;
import org.primefaces.shaded.owasp.ValidationException;
import org.primefaces.util.EscapeUtils;
import org.primefaces.util.IOUtils;
import org.primefaces.util.LangUtils;
import org.primefaces.virusscan.VirusException;

public class FileUploadUtils {
    private static final Logger LOGGER = Logger.getLogger(FileUploadUtils.class.getName());
    private static final Pattern INVALID_FILENAME_PATTERN = Pattern.compile("([\\/:*?\"<>|])");

    private FileUploadUtils() {
    }

    public static String getValidFilename(String filename) {
        if (LangUtils.isBlank(filename)) {
            return null;
        }
        if (FileUploadUtils.isSystemWindows()) {
            if (!filename.contains("\\\\")) {
                String[] parts;
                int length = FilenameUtils.getPrefixLength(filename);
                String prefix = LangUtils.substring(filename, 0, length);
                for (String part : parts = prefix.split(Pattern.quote(File.separator))) {
                    if (!INVALID_FILENAME_PATTERN.matcher(part).find()) continue;
                    throw new FacesException("Invalid filename: " + filename);
                }
            } else {
                throw new FacesException("Invalid filename: " + filename);
            }
        }
        String name = FilenameUtils.getName(filename);
        String extension = FilenameUtils.getExtension(filename);
        if (name.isEmpty() && extension.isEmpty()) {
            throw new FacesException("Filename can not be the empty string");
        }
        return name;
    }

    public static String getValidFilePath(String filePath) throws ValidationException {
        if (LangUtils.isBlank(filePath)) {
            throw new FacesException("Path can not be the empty string or null");
        }
        try {
            SafeFile file = new SafeFile(filePath);
            File parentFile = file.getParentFile();
            if (!file.exists()) {
                throw new ValidationException("Invalid directory", "Invalid directory, \"" + file + "\" does not exist.");
            }
            if (!parentFile.exists()) {
                throw new ValidationException("Invalid directory", "Invalid directory, specified parent does not exist.");
            }
            if (!parentFile.isDirectory()) {
                throw new ValidationException("Invalid directory", "Invalid directory, specified parent is not a directory.");
            }
            if (!file.getCanonicalPath().startsWith(parentFile.getCanonicalPath())) {
                throw new ValidationException("Invalid directory", "Invalid directory, \"" + file + "\" does not inside specified parent.");
            }
            if (!file.getCanonicalPath().equals(filePath)) {
                throw new ValidationException("Invalid directory", "Invalid directory name does not match the canonical path");
            }
        }
        catch (IOException ex) {
            throw new ValidationException("Invalid directory", "Failure to validate directory path");
        }
        return filePath;
    }

    public static boolean isSystemWindows() {
        return File.separatorChar == '\\';
    }

    public static boolean isValidType(PrimeApplicationContext context, FileUpload fileUpload, UploadedFile uploadedFile) {
        boolean bl;
        block10: {
            String fileName = uploadedFile.getFileName();
            InputStream input = uploadedFile.getInputStream();
            try {
                boolean validType;
                boolean bl2 = validType = FileUploadUtils.isValidFileName(fileUpload, uploadedFile) && FileUploadUtils.isValidFileContent(context, fileUpload, fileName, input);
                if (validType && LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(String.format("The uploaded file %s meets the filename and content type specifications", fileName));
                }
                bl = validType;
                if (input == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.log(Level.WARNING, String.format("The type of the uploaded file %s could not be validated", fileName), ex);
                    }
                    return false;
                }
            }
            input.close();
        }
        return bl;
    }

    private static boolean isValidFileName(FileUpload fileUpload, UploadedFile uploadedFile) {
        boolean isValid;
        String javascriptRegex = fileUpload.getAllowTypes();
        if (LangUtils.isBlank(javascriptRegex)) {
            return true;
        }
        String javaRegex = FileUploadUtils.convertJavaScriptRegex(javascriptRegex);
        if (LangUtils.isBlank(javaRegex)) {
            return true;
        }
        String fileName = EscapeUtils.forJavaScriptAttribute(uploadedFile.getFileName());
        String contentType = EscapeUtils.forJavaScriptAttribute(uploadedFile.getContentType());
        Pattern allowTypesPattern = Pattern.compile(javaRegex, 66);
        Matcher fileNameMatcher = allowTypesPattern.matcher(fileName);
        Matcher contentTypeMatcher = allowTypesPattern.matcher(contentType);
        boolean bl = isValid = fileNameMatcher.find() || contentTypeMatcher.find();
        if (!isValid) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning(String.format("The uploaded filename %s does not match the specified regex %s", fileName, javaRegex));
            }
            return false;
        }
        return true;
    }

    protected static String convertJavaScriptRegex(String jsRegex) {
        char endChar;
        int start = 0;
        int end = jsRegex.length() - 1;
        if (jsRegex.charAt(0) == '/') {
            start = 1;
        }
        if ((endChar = jsRegex.charAt(end)) != '/' && endChar == 'i' || endChar == 'g') {
            --end;
        }
        return LangUtils.substring(jsRegex, start, end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isValidFileContent(PrimeApplicationContext context, FileUpload fileUpload, String fileName, InputStream stream) throws IOException {
        block42: {
            Path tempFile;
            block40: {
                boolean bl;
                block41: {
                    String contentType;
                    block38: {
                        boolean out2;
                        block39: {
                            if (!fileUpload.isValidateContentType()) {
                                if (LOGGER.isLoggable(Level.FINE)) {
                                    LOGGER.fine("Content type checking is disabled");
                                }
                                return true;
                            }
                            if (LangUtils.isBlank(fileUpload.getAccept())) {
                                return true;
                            }
                            String tempFilePrefix = UUID.randomUUID().toString();
                            tempFile = Files.createTempFile(tempFilePrefix, null, new FileAttribute[0]);
                            try (PushbackInputStream in = new PushbackInputStream(new BufferedInputStream(stream));
                                 FileOutputStream out2 = new FileOutputStream(tempFile.toFile());){
                                IOUtils.copyLarge(in, out2);
                            }
                            contentType = context.getFileTypeDetector().probeContentType(tempFile);
                            if (contentType != null) break block38;
                            if (LOGGER.isLoggable(Level.WARNING)) {
                                LOGGER.warning(String.format("Could not determine content type of uploaded file %s, consider plugging in an adequate FileTypeDetector implementation", fileName));
                            }
                            out2 = false;
                            try {
                                Files.delete(tempFile);
                            }
                            catch (Exception ex) {
                                if (!LOGGER.isLoggable(Level.WARNING)) break block39;
                                LOGGER.log(Level.WARNING, String.format("Could not delete temporary file %s, will try to delete on JVM exit", tempFile.toAbsolutePath()), ex);
                                try {
                                    tempFile.toFile().deleteOnExit();
                                }
                                catch (Exception ex1) {
                                    if (!LOGGER.isLoggable(Level.WARNING)) break block39;
                                    LOGGER.log(Level.WARNING, String.format("Could not register temporary file %s for deletion on JVM exit", tempFile.toAbsolutePath()), ex1);
                                }
                            }
                        }
                        return out2;
                    }
                    try {
                        String[] accepts = fileUpload.getAccept().split(",");
                        boolean accepted = false;
                        for (String accept : accepts) {
                            if ((accept = accept.trim().toLowerCase()).startsWith(".") && fileName.toLowerCase().endsWith(accept)) {
                                accepted = true;
                                if (!LOGGER.isLoggable(Level.FINE)) break;
                                LOGGER.fine(String.format("The file extension %s of the uploaded file %s is accepted", accept, fileName));
                                break;
                            }
                            if (!FilenameUtils.wildcardMatch(contentType.toLowerCase(), accept)) continue;
                            accepted = true;
                            if (!LOGGER.isLoggable(Level.FINE)) break;
                            LOGGER.fine(String.format("The content type %s of the uploaded file %s is accepted by %s", contentType, fileName, accept));
                            break;
                        }
                        if (accepted) break block40;
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine(String.format("The uploaded file %s with content type %s does not match the accept specification %s", fileName, contentType, fileUpload.getAccept()));
                        }
                        bl = false;
                    }
                    catch (Throwable throwable) {
                        block43: {
                            try {
                                Files.delete(tempFile);
                            }
                            catch (Exception ex) {
                                if (!LOGGER.isLoggable(Level.WARNING)) break block43;
                                LOGGER.log(Level.WARNING, String.format("Could not delete temporary file %s, will try to delete on JVM exit", tempFile.toAbsolutePath()), ex);
                                try {
                                    tempFile.toFile().deleteOnExit();
                                }
                                catch (Exception ex1) {
                                    if (!LOGGER.isLoggable(Level.WARNING)) break block43;
                                    LOGGER.log(Level.WARNING, String.format("Could not register temporary file %s for deletion on JVM exit", tempFile.toAbsolutePath()), ex1);
                                }
                            }
                        }
                        throw throwable;
                    }
                    try {
                        Files.delete(tempFile);
                    }
                    catch (Exception ex) {
                        if (!LOGGER.isLoggable(Level.WARNING)) break block41;
                        LOGGER.log(Level.WARNING, String.format("Could not delete temporary file %s, will try to delete on JVM exit", tempFile.toAbsolutePath()), ex);
                        try {
                            tempFile.toFile().deleteOnExit();
                        }
                        catch (Exception ex1) {
                            if (!LOGGER.isLoggable(Level.WARNING)) break block41;
                            LOGGER.log(Level.WARNING, String.format("Could not register temporary file %s for deletion on JVM exit", tempFile.toAbsolutePath()), ex1);
                        }
                    }
                }
                return bl;
            }
            try {
                Files.delete(tempFile);
            }
            catch (Exception ex) {
                if (!LOGGER.isLoggable(Level.WARNING)) break block42;
                LOGGER.log(Level.WARNING, String.format("Could not delete temporary file %s, will try to delete on JVM exit", tempFile.toAbsolutePath()), ex);
                try {
                    tempFile.toFile().deleteOnExit();
                }
                catch (Exception ex1) {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.log(Level.WARNING, String.format("Could not register temporary file %s for deletion on JVM exit", tempFile.toAbsolutePath()), ex1);
                    }
                }
            }
        }
        return true;
    }

    public static void performVirusScan(FacesContext facesContext, UploadedFile file) throws VirusException {
        PrimeApplicationContext.getCurrentInstance(facesContext).getVirusScannerService().performVirusScan(file);
    }

    public static void tryValidateFile(FacesContext context, FileUpload fileUpload, UploadedFile uploadedFile) throws ValidatorException {
        Long sizeLimit = fileUpload.getSizeLimit();
        PrimeApplicationContext appContext = PrimeApplicationContext.getCurrentInstance(context);
        if (sizeLimit != null && uploadedFile.getSize() > sizeLimit) {
            throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, fileUpload.getInvalidSizeMessage(), ""));
        }
        if (!FileUploadUtils.isValidType(appContext, fileUpload, uploadedFile)) {
            throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, fileUpload.getInvalidFileMessage(), ""));
        }
        if (fileUpload.isVirusScan()) {
            FileUploadUtils.performVirusScan(context, uploadedFile);
        }
    }

    public static void tryValidateFiles(FacesContext context, FileUpload fileUpload, List<UploadedFile> files) {
        long totalPartSize = 0L;
        Long sizeLimit = fileUpload.getSizeLimit();
        for (UploadedFile file : files) {
            totalPartSize += file.getSize();
            FileUploadUtils.tryValidateFile(context, fileUpload, file);
        }
        if (sizeLimit != null && totalPartSize > sizeLimit) {
            throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, fileUpload.getInvalidFileMessage(), ""));
        }
    }

    public static String checkPathTraversal(String relativePath) {
        File file;
        String os = System.getProperty("os.name").toLowerCase();
        if (!os.contains("win")) {
            String string = relativePath = relativePath.startsWith("/") ? relativePath.substring(1) : relativePath;
        }
        if ((file = new File(relativePath)).isAbsolute()) {
            throw new FacesException("Path traversal attempt - absolute path not allowed.");
        }
        try {
            String pathUsingCanonical = file.getCanonicalPath();
            String pathUsingAbsolute = file.getAbsolutePath();
            if (!pathUsingCanonical.equals(pathUsingAbsolute)) {
                throw new FacesException("Path traversal attempt for path " + relativePath);
            }
        }
        catch (IOException ex) {
            throw new FacesException("Path traversal - unexpected exception.", (Throwable)ex);
        }
        return relativePath;
    }

    public static List<Path> listChunks(Path path) {
        List<Path> list;
        block8: {
            Stream<Path> walk = Files.walk(path, new FileVisitOption[0]);
            try {
                list = walk.filter(p -> Files.isRegularFile(p, new LinkOption[0]) && p.getFileName().toString().matches("\\d+")).sorted(Comparator.comparing(p -> Long.parseLong(p.getFileName().toString()))).collect(Collectors.toList());
                if (walk == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (walk != null) {
                        try {
                            walk.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | SecurityException e) {
                    throw new FacesException((Throwable)e);
                }
            }
            walk.close();
        }
        return list;
    }

    public static <T extends HttpServletRequest> List<Path> listChunks(T request) {
        Path chunkDir = FileUploadUtils.getChunkDir(request);
        if (!Files.exists(chunkDir, new LinkOption[0])) {
            return Collections.emptyList();
        }
        return FileUploadUtils.listChunks(chunkDir);
    }

    public static <T extends HttpServletRequest> FileUploadChunkDecoder<T> getFileUploadChunkDecoder(T request) {
        PrimeApplicationContext pfContext = PrimeApplicationContext.getCurrentInstance(request.getServletContext());
        FileUploadDecoder decoder = pfContext.getFileUploadDecoder();
        if (!(decoder instanceof FileUploadChunkDecoder)) {
            throw new FacesException("Chunk decoder not supported");
        }
        return (FileUploadChunkDecoder)((Object)decoder);
    }

    public static <T extends HttpServletRequest> Path getChunkDir(T request) {
        FileUploadChunkDecoder<T> chunkDecoder = FileUploadUtils.getFileUploadChunkDecoder(request);
        String fileKey = chunkDecoder.generateFileInfoKey(request);
        return Paths.get(chunkDecoder.getUploadDirectory(request), fileKey);
    }
}

