/*
 © 2019 Alexandre Bonneau

 The MIT License (http://www.opensource.org/licenses/mit-license.php)

 Permission is hereby granted, free of charge, to any person
 obtaining a copy of this software and associated documentation
 files (the "Software"), to deal in the Software without
 restriction, including without limitation the rights to use,
 copy, modify, merge, publish, distribute, sub license, and/or sell
 copies of the Software, and to permit persons to whom the
 Software is furnished to do so, subject to the following
 conditions:

 The above copyright notice and this permission notice shall be
 included in all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 OTHER DEALINGS IN THE SOFTWARE.
    2009 Robert J. Knothe
 @since        2009-08-09

 @summary      autoNumeric is a standalone Javascript library
               that provides live *as-you-type* formatting for
               international numbers and currencies.

 @link         http://autonumeric.org

               Note : Some functions are borrowed from big.js
 @see          https://github.com/MikeMcl/big.js/

 Please report any bugs to https://github.com/autoNumeric/autoNumeric

 @license      Released under the MIT License
 @link         http://www.opensource.org/licenses/mit-license.php

 Permission is hereby granted, free of charge, to any person
 obtaining a copy of this software and associated documentation
 files (the "Software"), to deal in the Software without
 restriction, including without limitation the rights to use,
 copy, modify, merge, publish, distribute, sub license, and/or sell
 copies of the Software, and to permit persons to whom the
 Software is furnished to do so, subject to the following
 conditions:

 The above copyright notice and this permission notice shall be
 included in all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 OTHER DEALINGS IN THE SOFTWARE.
*/
(function(m,u){"object"===typeof exports&&"object"===typeof module?module.exports=u():"function"===typeof define&&define.amd?define([],u):"object"===typeof exports?exports.AutoNumeric=u():m.AutoNumeric=u()})(this,function(){return function(m){function u(n){if(x[n])return x[n].exports;var r=x[n]={i:n,l:!1,exports:{}};m[n].call(r.exports,r,r.exports,u);r.l=!0;return r.exports}var x={};u.m=m;u.c=x;u.d=function(n,r,C){u.o(n,r)||Object.defineProperty(n,r,{enumerable:!0,get:C})};u.r=function(n){"undefined"!==
typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(n,Symbol.toStringTag,{value:"Module"});Object.defineProperty(n,"__esModule",{value:!0})};u.t=function(n,r){r&1&&(n=u(n));if(r&8||r&4&&"object"===typeof n&&n&&n.__esModule)return n;var C=Object.create(null);u.r(C);Object.defineProperty(C,"default",{enumerable:!0,value:n});if(r&2&&"string"!=typeof n)for(var A in n)u.d(C,A,function(z){return n[z]}.bind(null,A));return C};u.n=function(n){var r=n&&n.__esModule?function(){return n["default"]}:function(){return n};
u.d(r,"a",r);return r};u.o=function(n,r){return Object.prototype.hasOwnProperty.call(n,r)};u.p="";return u(u.s="./src/main.js")}({"./src/AutoNumeric.js":function(m,u,x){function n(d){var a=Array.isArray(d)?A(d):void 0;a||(a="undefined"!==typeof Symbol&&Symbol.iterator in Object(d)?Array.from(d):void 0);if(!(d=a||C(d)))throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");return d}function r(d,a){var b=
Array.isArray(d)?d:void 0;if(!b)if("undefined"!==typeof Symbol&&Symbol.iterator in Object(d)){b=[];var e=!0,h=!1,g=void 0;try{for(var l=d[Symbol.iterator](),p;!(e=(p=l.next()).done)&&(b.push(p.value),!a||b.length!==a);e=!0);}catch(q){h=!0,g=q}finally{try{if(!e&&null!=l["return"])l["return"]()}finally{if(h)throw g;}}}else b=void 0;if(!(d=b||C(d,a)))throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
return d}function C(d,a){if(d){if("string"===typeof d)return A(d,a);var b=Object.prototype.toString.call(d).slice(8,-1);"Object"===b&&d.constructor&&(b=d.constructor.name);if("Map"===b||"Set"===b)return Array.from(b);if("Arguments"===b||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(b))return A(d,a)}}function A(d,a){if(null==a||a>d.length)a=d.length;for(var b=0,e=Array(a);b<a;b++)e[b]=d[b];return e}function z(){z=Object.assign||function(d){for(var a=1;a<arguments.length;a++){var b=arguments[a],e;
for(e in b)Object.prototype.hasOwnProperty.call(b,e)&&(d[e]=b[e])}return d};return z.apply(this,arguments)}function y(d){"@babel/helpers - typeof";y="function"===typeof Symbol&&"symbol"===typeof Symbol.iterator?function(a){return typeof a}:function(a){return a&&"function"===typeof Symbol&&a.constructor===Symbol&&a!==Symbol.prototype?"symbol":typeof a};return y(d)}function v(d,a){for(var b=0;b<a.length;b++){var e=a[b];e.enumerable=e.enumerable||!1;e.configurable=!0;"value"in e&&(e.writable=!0);Object.defineProperty(d,
e.key,e)}}function D(d,a,b){a&&v(d.prototype,a);b&&v(d,b);return d}x.r(u);x.d(u,"default",function(){return k});var c=x("./src/AutoNumericHelper.js"),w=x("./src/AutoNumericEnum.js"),E=x("./src/maths/Evaluator.js"),f=x("./src/maths/Parser.js"),k=function(){function d(){var a=this,b=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null,e=1<arguments.length&&void 0!==arguments[1]?arguments[1]:null,h=2<arguments.length&&void 0!==arguments[2]?arguments[2]:null;if(!(this instanceof d))throw new TypeError("Cannot call a class as a function");
e=d._setArgumentsValues(b,e,h);b=e.initialValue;h=e.userOptions;this.domElement=e.domElement;this.defaultRawValue="";this._setSettings(h,!1);this._checkElement();this.savedCancellableValue=null;this.historyTable=[];this.historyTableIndex=-1;this.onGoingRedo=!1;this.parentForm=this._getParentForm();if(!this.runOnce&&this.settings.formatOnPageLoad)this._formatDefaultValueOnPageLoad(b);else{if(c["default"].isNull(b))switch(this.settings.emptyInputBehavior){case d.options.emptyInputBehavior.min:e=this.settings.minimumValue;
break;case d.options.emptyInputBehavior.max:e=this.settings.maximumValue;break;case d.options.emptyInputBehavior.zero:e="0";break;case d.options.emptyInputBehavior.focus:case d.options.emptyInputBehavior.press:case d.options.emptyInputBehavior.always:case d.options.emptyInputBehavior["null"]:e="";break;default:e=this.settings.emptyInputBehavior}else e=b;this._setElementAndRawValue(e)}this.runOnce=!0;this.hasEventListeners=!1;if(this.isInputElement||this.isContentEditable)this.settings.noEventListeners||
this._createEventListeners(),this._setWritePermissions(!0);this._saveInitialValues(b);this.sessionStorageAvailable=this.constructor._storageTest();this.storageNamePrefix="AUTO_";this._setPersistentStorageName();this.validState=!0;this.isEditing=this.isDropEvent=this.isWheelEvent=this.isFocused=!1;this.rawValueOnFocus=void 0;this.internalModification=!1;this.attributeToWatch=this._getAttributeToWatch();this.getterSetter=Object.getOwnPropertyDescriptor(this.domElement.__proto__,this.attributeToWatch);
this._addWatcher();this.settings.createLocalList&&this._createLocalList();this.constructor._addToGlobalList(this);this.global={set:function(g){var l=1<arguments.length&&void 0!==arguments[1]?arguments[1]:null;a.autoNumericLocalList.forEach(function(p){p.set(g,l)})},setUnformatted:function(g){var l=1<arguments.length&&void 0!==arguments[1]?arguments[1]:null;a.autoNumericLocalList.forEach(function(p){p.setUnformatted(g,l)})},get:function(){var g=0<arguments.length&&void 0!==arguments[0]?arguments[0]:
null,l=[];a.autoNumericLocalList.forEach(function(p){l.push(p.get())});a._executeCallback(l,g);return l},getNumericString:function(){var g=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null,l=[];a.autoNumericLocalList.forEach(function(p){l.push(p.getNumericString())});a._executeCallback(l,g);return l},getFormatted:function(){var g=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null,l=[];a.autoNumericLocalList.forEach(function(p){l.push(p.getFormatted())});a._executeCallback(l,g);
return l},getNumber:function(){var g=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null,l=[];a.autoNumericLocalList.forEach(function(p){l.push(p.getNumber())});a._executeCallback(l,g);return l},getLocalized:function(){var g=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null,l=[];a.autoNumericLocalList.forEach(function(p){l.push(p.getLocalized())});a._executeCallback(l,g);return l},reformat:function(){a.autoNumericLocalList.forEach(function(g){g.reformat()})},unformat:function(){a.autoNumericLocalList.forEach(function(g){g.unformat()})},
unformatLocalized:function(){var g=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null;a.autoNumericLocalList.forEach(function(l){l.unformatLocalized(g)})},update:function(){for(var g=arguments.length,l=Array(g),p=0;p<g;p++)l[p]=arguments[p];a.autoNumericLocalList.forEach(function(q){q.update.apply(q,l)})},isPristine:function(){var g=0<arguments.length&&void 0!==arguments[0]?arguments[0]:!0,l=!0;a.autoNumericLocalList.forEach(function(p){l&&!p.isPristine(g)&&(l=!1)});return l},clear:function(){var g=
0<arguments.length&&void 0!==arguments[0]?arguments[0]:!1;a.autoNumericLocalList.forEach(function(l){l.clear(g)})},remove:function(){a.autoNumericLocalList.forEach(function(g){g.remove()})},wipe:function(){a.autoNumericLocalList.forEach(function(g){g.wipe()})},nuke:function(){a.autoNumericLocalList.forEach(function(g){g.nuke()})},has:function(g){return g instanceof d?a.autoNumericLocalList.has(g.node()):a.autoNumericLocalList.has(g)},addObject:function(g){if(g instanceof d)var l=g.node();else l=g,
g=d.getAutoNumericElement(l);a._hasLocalList()||a._createLocalList();var p=g._getLocalList();0===p.size&&(g._createLocalList(),p=g._getLocalList());if(p instanceof Map)var q=c["default"].mergeMaps(a._getLocalList(),p);else a._addToLocalList(l,g),q=a._getLocalList();q.forEach(function(t){t._setLocalList(q)})},removeObject:function(g){var l=1<arguments.length&&void 0!==arguments[1]?arguments[1]:!1;if(g instanceof d){var p=g.node();var q=g}else p=g,q=d.getAutoNumericElement(p);var t=a.autoNumericLocalList;
a.autoNumericLocalList["delete"](p);t.forEach(function(B){B._setLocalList(a.autoNumericLocalList)});l||p!==a.node()?q._createLocalList():q._setLocalList(new Map)},empty:function(){var g=0<arguments.length&&void 0!==arguments[0]?arguments[0]:!1;a.autoNumericLocalList.forEach(function(l){g?l._createLocalList():l._setLocalList(new Map)})},elements:function(){var g=[];a.autoNumericLocalList.forEach(function(l){g.push(l.node())});return g},getList:function(){return a.autoNumericLocalList},size:function(){return a.autoNumericLocalList.size}};
this.options={reset:function(){a.settings={rawValue:a.defaultRawValue};a.update(d.defaultSettings);return a},allowDecimalPadding:function(g){a.update({allowDecimalPadding:g});return a},alwaysAllowDecimalCharacter:function(g){a.update({alwaysAllowDecimalCharacter:g});return a},caretPositionOnFocus:function(g){a.settings.caretPositionOnFocus=g;return a},createLocalList:function(g){a.settings.createLocalList=g;a.settings.createLocalList?a._hasLocalList()||a._createLocalList():a._deleteLocalList();return a},
currencySymbol:function(g){a.update({currencySymbol:g});return a},currencySymbolPlacement:function(g){a.update({currencySymbolPlacement:g});return a},decimalCharacter:function(g){a.update({decimalCharacter:g});return a},decimalCharacterAlternative:function(g){a.settings.decimalCharacterAlternative=g;return a},decimalPlaces:function(g){c["default"].warning("Using `options.decimalPlaces()` instead of calling the specific `options.decimalPlacesRawValue()`, `options.decimalPlacesShownOnFocus()` and `options.decimalPlacesShownOnBlur()` methods will reset those options.\nPlease call the specific methods if you do not want to reset those.",
a.settings.showWarnings);a.update({decimalPlaces:g});return a},decimalPlacesRawValue:function(g){a.update({decimalPlacesRawValue:g});return a},decimalPlacesShownOnBlur:function(g){a.update({decimalPlacesShownOnBlur:g});return a},decimalPlacesShownOnFocus:function(g){a.update({decimalPlacesShownOnFocus:g});return a},defaultValueOverride:function(g){a.update({defaultValueOverride:g});return a},digitalGroupSpacing:function(g){a.update({digitalGroupSpacing:g});return a},digitGroupSeparator:function(g){a.update({digitGroupSeparator:g});
return a},divisorWhenUnfocused:function(g){a.update({divisorWhenUnfocused:g});return a},emptyInputBehavior:function(g){null===a.rawValue&&g!==d.options.emptyInputBehavior["null"]&&(c["default"].warning("You are trying to modify the `emptyInputBehavior` option to something different than `'null'` (".concat(g,"), but the element raw value is currently set to `null`. This would result in an invalid `rawValue`. In order to fix that, the element value has been changed to the empty string `''`."),a.settings.showWarnings),
a.rawValue="");a.update({emptyInputBehavior:g});return a},eventBubbles:function(g){a.settings.eventBubbles=g;return a},eventIsCancelable:function(g){a.settings.eventIsCancelable=g;return a},failOnUnknownOption:function(g){a.settings.failOnUnknownOption=g;return a},formatOnPageLoad:function(g){a.settings.formatOnPageLoad=g;return a},formulaMode:function(g){a.settings.formulaMode=g;return a},historySize:function(g){a.settings.historySize=g;return a},invalidClass:function(g){a.settings.invalidClass=
g;return a},isCancellable:function(g){a.settings.isCancellable=g;return a},leadingZero:function(g){a.update({leadingZero:g});return a},maximumValue:function(g){a.update({maximumValue:g});return a},minimumValue:function(g){a.update({minimumValue:g});return a},modifyValueOnWheel:function(g){a.settings.modifyValueOnWheel=g;return a},negativeBracketsTypeOnBlur:function(g){a.update({negativeBracketsTypeOnBlur:g});return a},negativePositiveSignPlacement:function(g){a.update({negativePositiveSignPlacement:g});
return a},negativeSignCharacter:function(g){a.update({negativeSignCharacter:g});return a},noEventListeners:function(g){g===d.options.noEventListeners.noEvents&&a.settings.noEventListeners===d.options.noEventListeners.addEvents&&a._removeEventListeners();a.update({noEventListeners:g});return a},onInvalidPaste:function(g){a.settings.onInvalidPaste=g;return a},outputFormat:function(g){a.settings.outputFormat=g;return a},overrideMinMaxLimits:function(g){a.update({overrideMinMaxLimits:g});return a},positiveSignCharacter:function(g){a.update({positiveSignCharacter:g});
return a},rawValueDivisor:function(g){a.update({rawValueDivisor:g});return a},readOnly:function(g){a.settings.readOnly=g;a._setWritePermissions();return a},roundingMethod:function(g){a.update({roundingMethod:g});return a},saveValueToSessionStorage:function(g){a.update({saveValueToSessionStorage:g});return a},symbolWhenUnfocused:function(g){a.update({symbolWhenUnfocused:g});return a},selectNumberOnly:function(g){a.settings.selectNumberOnly=g;return a},selectOnFocus:function(g){a.settings.selectOnFocus=
g;return a},serializeSpaces:function(g){a.settings.serializeSpaces=g;return a},showOnlyNumbersOnFocus:function(g){a.update({showOnlyNumbersOnFocus:g});return a},showPositiveSign:function(g){a.update({showPositiveSign:g});return a},showWarnings:function(g){a.settings.showWarnings=g;return a},styleRules:function(g){a.update({styleRules:g});return a},suffixText:function(g){a.update({suffixText:g});return a},unformatOnHover:function(g){a.settings.unformatOnHover=g;return a},unformatOnSubmit:function(g){a.settings.unformatOnSubmit=
g;return a},valuesToStrings:function(g){a.update({valuesToStrings:g});return a},watchExternalChanges:function(g){a.update({watchExternalChanges:g});return a},wheelOn:function(g){a.settings.wheelOn=g;return a},wheelStep:function(g){a.settings.wheelStep=g;return a}};this._triggerEvent(d.events.initialized,this.domElement,{newValue:c["default"].getElementValue(this.domElement),newRawValue:this.rawValue,error:null,aNElement:this})}D(d,[{key:"_saveInitialValues",value:function(a){this.initialValueHtmlAttribute=
c["default"].scientificToDecimal(this.domElement.getAttribute("value"));c["default"].isNull(this.initialValueHtmlAttribute)&&(this.initialValueHtmlAttribute="");this.initialValue=a;c["default"].isNull(this.initialValue)&&(this.initialValue="")}},{key:"_createEventListeners",value:function(){var a=this;this.formulaMode=!1;this._onFocusInFunc=function(b){a._onFocusIn(b)};this._onFocusInAndMouseEnterFunc=function(b){a._onFocusInAndMouseEnter(b)};this._onFocusFunc=function(){a._onFocus()};this._onKeydownFunc=
function(b){a._onKeydown(b)};this._onKeypressFunc=function(b){a._onKeypress(b)};this._onKeyupFunc=function(b){a._onKeyup(b)};this._onFocusOutAndMouseLeaveFunc=function(b){a._onFocusOutAndMouseLeave(b)};this._onPasteFunc=function(b){a._onPaste(b)};this._onWheelFunc=function(b){a._onWheel(b)};this._onDropFunc=function(b){a._onDrop(b)};this._onKeydownGlobalFunc=function(b){a._onKeydownGlobal(b)};this._onKeyupGlobalFunc=function(b){a._onKeyupGlobal(b)};this.domElement.addEventListener("focusin",this._onFocusInFunc,
!1);this.domElement.addEventListener("focus",this._onFocusInAndMouseEnterFunc,!1);this.domElement.addEventListener("focus",this._onFocusFunc,!1);this.domElement.addEventListener("mouseenter",this._onFocusInAndMouseEnterFunc,!1);this.domElement.addEventListener("keydown",this._onKeydownFunc,!1);this.domElement.addEventListener("keypress",this._onKeypressFunc,!1);this.domElement.addEventListener("keyup",this._onKeyupFunc,!1);this.domElement.addEventListener("blur",this._onFocusOutAndMouseLeaveFunc,
!1);this.domElement.addEventListener("mouseleave",this._onFocusOutAndMouseLeaveFunc,!1);this.domElement.addEventListener("paste",this._onPasteFunc,!1);this.domElement.addEventListener("wheel",this._onWheelFunc,!1);this.domElement.addEventListener("drop",this._onDropFunc,!1);this._setupFormListener();this.hasEventListeners=!0;d._doesGlobalListExists()||(document.addEventListener("keydown",this._onKeydownGlobalFunc,!1),document.addEventListener("keyup",this._onKeyupGlobalFunc,!1))}},{key:"_removeEventListeners",
value:function(){this.domElement.removeEventListener("focusin",this._onFocusInFunc,!1);this.domElement.removeEventListener("focus",this._onFocusInAndMouseEnterFunc,!1);this.domElement.removeEventListener("focus",this._onFocusFunc,!1);this.domElement.removeEventListener("mouseenter",this._onFocusInAndMouseEnterFunc,!1);this.domElement.removeEventListener("blur",this._onFocusOutAndMouseLeaveFunc,!1);this.domElement.removeEventListener("mouseleave",this._onFocusOutAndMouseLeaveFunc,!1);this.domElement.removeEventListener("keydown",
this._onKeydownFunc,!1);this.domElement.removeEventListener("keypress",this._onKeypressFunc,!1);this.domElement.removeEventListener("keyup",this._onKeyupFunc,!1);this.domElement.removeEventListener("paste",this._onPasteFunc,!1);this.domElement.removeEventListener("wheel",this._onWheelFunc,!1);this.domElement.removeEventListener("drop",this._onDropFunc,!1);this._removeFormListener();this.hasEventListeners=!1;document.removeEventListener("keydown",this._onKeydownGlobalFunc,!1);document.removeEventListener("keyup",
this._onKeyupGlobalFunc,!1)}},{key:"_updateEventListeners",value:function(){this.settings.noEventListeners||this.hasEventListeners||this._createEventListeners();this.settings.noEventListeners&&this.hasEventListeners&&this._removeEventListeners()}},{key:"_setupFormListener",value:function(){var a=this;c["default"].isNull(this.parentForm)||(this._onFormSubmitFunc=function(){a._onFormSubmit()},this._onFormResetFunc=function(){a._onFormReset()},this._hasParentFormCounter()?this._incrementParentFormCounter():
(this._initializeFormCounterToOne(),this.parentForm.addEventListener("submit",this._onFormSubmitFunc,!1),this.parentForm.addEventListener("reset",this._onFormResetFunc,!1),this._storeFormHandlerFunction()))}},{key:"_removeFormListener",value:function(){if(!c["default"].isNull(this.parentForm)){var a=this._getParentFormCounter();1===a?(this.parentForm.removeEventListener("submit",this._getFormHandlerFunction().submitFn,!1),this.parentForm.removeEventListener("reset",this._getFormHandlerFunction().resetFn,
!1),this._removeFormDataSetInfo()):1<a?this._decrementParentFormCounter():c["default"].throwError("The AutoNumeric object count on the form is incoherent.")}}},{key:"_hasParentFormCounter",value:function(){return"anCount"in this.parentForm.dataset}},{key:"_getParentFormCounter",value:function(){return Number(this.parentForm.dataset.anCount)}},{key:"_initializeFormCounterToOne",value:function(){this._getFormElement(0<arguments.length&&void 0!==arguments[0]?arguments[0]:null).dataset.anCount=1}},{key:"_incrementParentFormCounter",
value:function(){this._getFormElement(0<arguments.length&&void 0!==arguments[0]?arguments[0]:null).dataset.anCount++}},{key:"_decrementParentFormCounter",value:function(){this.parentForm.dataset.anCount--}},{key:"_hasFormHandlerFunction",value:function(){return"anFormHandler"in this._getFormElement(0<arguments.length&&void 0!==arguments[0]?arguments[0]:null).dataset}},{key:"_getFormElement",value:function(){var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null;return c["default"].isNull(a)?
this.parentForm:a}},{key:"_storeFormHandlerFunction",value:function(){var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null;this.constructor._doesFormHandlerListExists()||this.constructor._createFormHandlerList();var b=c["default"].randomString();this._getFormElement(a).dataset.anFormHandler=b;window.aNFormHandlerMap.set(b,{submitFn:this._onFormSubmitFunc,resetFn:this._onFormResetFunc})}},{key:"_getFormHandlerKey",value:function(){this._hasFormHandlerFunction()||c["default"].throwError("Unable to retrieve the form handler name");
var a=this.parentForm.dataset.anFormHandler;""===a&&c["default"].throwError("The form handler name is invalid");return a}},{key:"_getFormHandlerFunction",value:function(){var a=this._getFormHandlerKey();return window.aNFormHandlerMap.get(a)}},{key:"_removeFormDataSetInfo",value:function(){this._decrementParentFormCounter();window.aNFormHandlerMap["delete"](this._getFormHandlerKey());this.parentForm.removeAttribute("data-an-count");this.parentForm.removeAttribute("data-an-form-handler")}},{key:"_setWritePermissions",
value:function(){0<arguments.length&&void 0!==arguments[0]&&arguments[0]&&this.domElement.readOnly||this.settings.readOnly?this._setReadOnly():this._setReadWrite()}},{key:"_setReadOnly",value:function(){this.isInputElement?this.domElement.readOnly=!0:this.domElement.setAttribute("contenteditable",!1)}},{key:"_setReadWrite",value:function(){this.isInputElement?this.domElement.readOnly=!1:this.domElement.setAttribute("contenteditable",!0)}},{key:"_addWatcher",value:function(){var a=this;if(!c["default"].isUndefined(this.getterSetter)){var b=
this.getterSetter,e=b.set,h=b.get;Object.defineProperty(this.domElement,this.attributeToWatch,{configurable:!0,get:function(){return h.call(a.domElement)},set:function(g){e.call(a.domElement,g);a.settings.watchExternalChanges&&!a.internalModification&&a.set(g)}})}}},{key:"_removeWatcher",value:function(){var a=this;if(!c["default"].isUndefined(this.getterSetter)){var b=this.getterSetter,e=b.set,h=b.get;Object.defineProperty(this.domElement,this.attributeToWatch,{configurable:!0,get:function(){return h.call(a.domElement)},
set:function(g){e.call(a.domElement,g)}})}}},{key:"_getAttributeToWatch",value:function(){if(this.isInputElement)var a="value";else{var b=this.domElement.nodeType;b===Node.ELEMENT_NODE||b===Node.DOCUMENT_NODE||b===Node.DOCUMENT_FRAGMENT_NODE?a="textContent":b===Node.TEXT_NODE&&(a="nodeValue")}return a}},{key:"_historyTableAdd",value:function(){var a=0===this.historyTable.length;if(a||this.rawValue!==this._historyTableCurrentValueUsed()){var b=!0;a||(a=this.historyTableIndex+1,a<this.historyTable.length&&
this.rawValue===this.historyTable[a].value?b=!1:c["default"].arrayTrim(this.historyTable,this.historyTableIndex+1));this.historyTableIndex++;b&&(b=c["default"].getElementSelection(this.domElement),this.selectionStart=b.start,this.selectionEnd=b.end,this.historyTable.push({value:this.rawValue,start:this.selectionStart+1,end:this.selectionEnd+1}),1<this.historyTable.length&&(this.historyTable[this.historyTableIndex-1].start=this.selectionStart,this.historyTable[this.historyTableIndex-1].end=this.selectionEnd));
this.historyTable.length>this.settings.historySize&&this._historyTableForget()}}},{key:"_historyTableUndoOrRedo",value:function(){var a;(0<arguments.length&&void 0!==arguments[0]?arguments[0]:1)?(a=0<this.historyTableIndex)&&this.historyTableIndex--:(a=this.historyTableIndex+1<this.historyTable.length)&&this.historyTableIndex++;a&&(a=this.historyTable[this.historyTableIndex],this.set(a.value,null,!1),c["default"].setElementSelection(this.domElement,a.start,a.end))}},{key:"_historyTableUndo",value:function(){this._historyTableUndoOrRedo(!0)}},
{key:"_historyTableRedo",value:function(){this._historyTableUndoOrRedo(!1)}},{key:"_historyTableForget",value:function(){for(var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:1,b=[],e=0;e<a;e++)b.push(this.historyTable.shift()),this.historyTableIndex--,0>this.historyTableIndex&&(this.historyTableIndex=0);return 1===b.length?b[0]:b}},{key:"_historyTableCurrentValueUsed",value:function(){var a=this.historyTableIndex;0>a&&(a=0);return c["default"].isUndefinedOrNullOrEmpty(this.historyTable[a])?
"":this.historyTable[a].value}},{key:"_parseStyleRules",value:function(){var a=this;c["default"].isUndefinedOrNullOrEmpty(this.settings.styleRules)||""===this.rawValue||(c["default"].isUndefinedOrNullOrEmpty(this.settings.styleRules.positive)||(0<=this.rawValue?this._addCSSClass(this.settings.styleRules.positive):this._removeCSSClass(this.settings.styleRules.positive)),c["default"].isUndefinedOrNullOrEmpty(this.settings.styleRules.negative)||(0>this.rawValue?this._addCSSClass(this.settings.styleRules.negative):
this._removeCSSClass(this.settings.styleRules.negative)),c["default"].isUndefinedOrNullOrEmpty(this.settings.styleRules.ranges)||0===this.settings.styleRules.ranges.length||this.settings.styleRules.ranges.forEach(function(b){a.rawValue>=b.min&&a.rawValue<b.max?a._addCSSClass(b["class"]):a._removeCSSClass(b["class"])}),c["default"].isUndefinedOrNullOrEmpty(this.settings.styleRules.userDefined)||0===this.settings.styleRules.userDefined.length||this.settings.styleRules.userDefined.forEach(function(b){if(c["default"].isFunction(b.callback))if(c["default"].isString(b.classes))b.callback(a.rawValue)?
a._addCSSClass(b.classes):a._removeCSSClass(b.classes);else if(c["default"].isArray(b.classes))if(2===b.classes.length)b.callback(a.rawValue)?(a._addCSSClass(b.classes[0]),a._removeCSSClass(b.classes[1])):(a._removeCSSClass(b.classes[0]),a._addCSSClass(b.classes[1]));else if(2<b.classes.length){var e=b.callback(a.rawValue);c["default"].isArray(e)?b.classes.forEach(function(h,g){c["default"].isInArray(g,e)?a._addCSSClass(h):a._removeCSSClass(h)}):c["default"].isInt(e)?b.classes.forEach(function(h,
g){g===e?a._addCSSClass(h):a._removeCSSClass(h)}):c["default"].isNull(e)?b.classes.forEach(function(h){a._removeCSSClass(h)}):c["default"].throwError("The callback result is not an array nor a valid array index, ".concat(y(e)," given."))}else c["default"].throwError("The classes attribute is not valid for the `styleRules` option.");else c["default"].isUndefinedOrNullOrEmpty(b.classes)?b.callback(a):c["default"].throwError("The callback/classes structure is not valid for the `styleRules` option.");
else c["default"].warning("The given `styleRules` callback is not a function, ".concat("undefined"===typeof callback?"undefined":y(callback)," given."),a.settings.showWarnings)}))}},{key:"_addCSSClass",value:function(a){this.domElement.classList.add(a)}},{key:"_removeCSSClass",value:function(a){this.domElement.classList.remove(a)}},{key:"update",value:function(){for(var a=this,b=arguments.length,e=Array(b),h=0;h<b;h++)e[h]=arguments[h];Array.isArray(e)&&Array.isArray(e[0])&&(e=e[0]);b=c["default"].cloneObject(this.settings);
h=this.rawValue;var g={};c["default"].isUndefinedOrNullOrEmpty(e)||0===e.length?g=null:1<=e.length&&e.forEach(function(l){a.constructor._isPreDefinedOptionValid(l)&&(l=a.constructor._getOptionObject(l));z(g,l)});try{this._setSettings(g,!0),this._setWritePermissions(),this._updateEventListeners(),this.set(h)}catch(l){this._setSettings(b,!0),c["default"].throwError("Unable to update the settings, those are invalid: [".concat(l,"]"))}return this}},{key:"getSettings",value:function(){return this.settings}},
{key:"set",value:function(a){var b=1<arguments.length&&void 0!==arguments[1]?arguments[1]:null,e=2<arguments.length&&void 0!==arguments[2]?arguments[2]:!0;if(c["default"].isUndefined(a))return c["default"].warning("You are trying to set an 'undefined' value ; an error could have occurred.",this.settings.showWarnings),this;c["default"].isNull(b)||this._setSettings(b,!0);if(null===a&&this.settings.emptyInputBehavior!==d.options.emptyInputBehavior["null"])return c["default"].warning("You are trying to set the `null` value while the `emptyInputBehavior` option is set to ".concat(this.settings.emptyInputBehavior,
". If you want to be able to set the `null` value, you need to change the 'emptyInputBehavior' option to `'null'`."),this.settings.showWarnings),this;if(null===a)return this._setElementAndRawValue(null,null,e),this._saveValueToPersistentStorage(),this;b=this.constructor._toNumericValue(a,this.settings);if(isNaN(Number(b)))return c["default"].warning("The value you are trying to set results in `NaN`. The element value is set to the empty string instead.",this.settings.showWarnings),this.setValue("",
e),this;if(""===b)switch(this.settings.emptyInputBehavior){case d.options.emptyInputBehavior.zero:b=0;break;case d.options.emptyInputBehavior.min:b=this.settings.minimumValue;break;case d.options.emptyInputBehavior.max:b=this.settings.maximumValue;break;default:c["default"].isNumber(this.settings.emptyInputBehavior)&&(b=Number(this.settings.emptyInputBehavior))}if(""!==b){var h=this.constructor._checkIfInRangeWithOverrideOption(b,this.settings),g=r(h,2);h=g[0];g=g[1];if(h&&g&&this.settings.valuesToStrings&&
this._checkValuesToStrings(b))return this._setElementAndRawValue(this.settings.valuesToStrings[b],b,e),this._saveValueToPersistentStorage(),this;c["default"].isZeroOrHasNoValue(b)&&(b="0");h&&g?(h=this.constructor._roundRawValue(b,this.settings),h=this._trimLeadingAndTrailingZeros(h.replace(this.settings.decimalCharacter,".")),b=this._getRawValueToFormat(b),this.isFocused?b=this.constructor._roundFormattedValueShownOnFocus(b,this.settings):(this.settings.divisorWhenUnfocused&&(b/=this.settings.divisorWhenUnfocused,
b=b.toString()),b=this.constructor._roundFormattedValueShownOnBlur(b,this.settings)),b=this.constructor._modifyNegativeSignAndDecimalCharacterForFormattedValue(b,this.settings),b=this.constructor._addGroupSeparators(b,this.settings,this.isFocused,this.rawValue,h),!this.isFocused&&this.settings.symbolWhenUnfocused&&(b="".concat(b).concat(this.settings.symbolWhenUnfocused)),(this.settings.decimalPlacesShownOnFocus||this.settings.divisorWhenUnfocused)&&this._saveValueToPersistentStorage(),this._setElementAndRawValue(b,
h,e),this._setValidOrInvalidState(h)):(this._triggerRangeEvents(h,g),c["default"].throwError("The value [".concat(b,"] being set falls outside of the minimumValue [").concat(this.settings.minimumValue,"] and maximumValue [").concat(this.settings.maximumValue,"] range set for this element")),this._removeValueFromPersistentStorage(),this.setValue("",e))}else this._setElementAndRawValue(this.settings.emptyInputBehavior===d.options.emptyInputBehavior.always?this.settings.currencySymbol:"","",e);return this}},
{key:"setUnformatted",value:function(a){var b=1<arguments.length&&void 0!==arguments[1]?arguments[1]:null;if(null===a||c["default"].isUndefined(a))return this;c["default"].isNull(b)||this._setSettings(b,!0);b=this.constructor._removeBrackets(a,this.settings);b=this.constructor._stripAllNonNumberCharacters(b,this.settings,!0,this.isFocused);c["default"].isNumber(b)||c["default"].throwError("The value is not a valid one, it's not a numeric string nor a recognized currency.");this.constructor._isWithinRangeWithOverrideOption(b,
this.settings)?this.setValue(a):c["default"].throwError("The value is out of the range limits [".concat(this.settings.minimumValue,", ").concat(this.settings.maximumValue,"]."));return this}},{key:"setValue",value:function(a){this._setElementAndRawValue(a,1<arguments.length&&void 0!==arguments[1]?arguments[1]:!0);return this}},{key:"_setRawValue",value:function(a){var b=1<arguments.length&&void 0!==arguments[1]?arguments[1]:!0;if(this.rawValue!==a){var e=this.rawValue;this.rawValue=a;!c["default"].isNull(this.settings.rawValueDivisor)&&
0!==this.settings.rawValueDivisor&&""!==a&&null!==a&&this._isUserManuallyEditingTheValue()&&(this.rawValue/=this.settings.rawValueDivisor);this._triggerEvent(d.events.rawValueModified,this.domElement,{oldRawValue:e,newRawValue:this.rawValue,isPristine:this.isPristine(!0),error:null,aNElement:this});this._parseStyleRules();b&&this._historyTableAdd()}}},{key:"_setElementValue",value:function(a){var b=1<arguments.length&&void 0!==arguments[1]?arguments[1]:!0,e=c["default"].getElementValue(this.domElement);
a!==e&&(this.internalModification=!0,c["default"].setElementValue(this.domElement,a),this.internalModification=!1,b&&this._triggerEvent(d.events.formatted,this.domElement,{oldValue:e,newValue:a,oldRawValue:this.rawValue,newRawValue:this.rawValue,isPristine:this.isPristine(!1),error:null,aNElement:this}));return this}},{key:"_setElementAndRawValue",value:function(a){var b=1<arguments.length&&void 0!==arguments[1]?arguments[1]:null,e=2<arguments.length&&void 0!==arguments[2]?arguments[2]:!0;c["default"].isNull(b)?
b=a:c["default"].isBoolean(b)&&(e=b,b=a);this._setElementValue(a);this._setRawValue(b,e);return this}},{key:"_getRawValueToFormat",value:function(a){return c["default"].isNull(this.settings.rawValueDivisor)||0===this.settings.rawValueDivisor||""===a||null===a?a:a*this.settings.rawValueDivisor}},{key:"_checkValuesToStrings",value:function(a){return this.constructor._checkValuesToStringsArray(a,this.valuesToStringsKeys)}},{key:"_isUserManuallyEditingTheValue",value:function(){return this.isFocused&&
this.isEditing||this.isDropEvent}},{key:"_executeCallback",value:function(a,b){!c["default"].isNull(b)&&c["default"].isFunction(b)&&b(a,this)}},{key:"_triggerEvent",value:function(a){c["default"].triggerEvent(a,1<arguments.length&&void 0!==arguments[1]?arguments[1]:document,2<arguments.length&&void 0!==arguments[2]?arguments[2]:null,this.settings.eventBubbles,this.settings.eventIsCancelable)}},{key:"get",value:function(){return this.getNumericString(0<arguments.length&&void 0!==arguments[0]?arguments[0]:
null)}},{key:"getNumericString",value:function(){var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null;var b=c["default"].isNull(this.rawValue)?null:c["default"].trimPaddedZerosFromDecimalPlaces(this.rawValue);this._executeCallback(b,a);return b}},{key:"getFormatted",value:function(){var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null;"value"in this.domElement||"textContent"in this.domElement||c["default"].throwError("Unable to get the formatted string from the element.");
var b=c["default"].getElementValue(this.domElement);this._executeCallback(b,a);return b}},{key:"getNumber",value:function(){var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null;var b=null===this.rawValue?null:this.constructor._toLocale(this.getNumericString(),"number",this.settings);this._executeCallback(b,a);return b}},{key:"getLocalized",value:function(){var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null,b=1<arguments.length&&void 0!==arguments[1]?arguments[1]:null;c["default"].isFunction(a)&&
c["default"].isNull(b)&&(b=a,a=null);var e=c["default"].isEmptyString(this.rawValue)?"":""+Number(this.rawValue);""!==e&&0===Number(e)&&this.settings.leadingZero!==d.options.leadingZero.keep&&(e="0");a=c["default"].isNull(a)?this.settings.outputFormat:a;e=this.constructor._toLocale(e,a,this.settings);this._executeCallback(e,b);return e}},{key:"reformat",value:function(){this.set(this.rawValue);return this}},{key:"unformat",value:function(){this._setElementValue(this.getNumericString());return this}},
{key:"unformatLocalized",value:function(){this._setElementValue(this.getLocalized(0<arguments.length&&void 0!==arguments[0]?arguments[0]:null));return this}},{key:"isPristine",value:function(){return(0<arguments.length&&void 0!==arguments[0]?arguments[0]:1)?this.initialValue===this.getNumericString():this.initialValueHtmlAttribute===this.getFormatted()}},{key:"select",value:function(){this.settings.selectNumberOnly?this.selectNumber():this._defaultSelectAll();return this}},{key:"_defaultSelectAll",
value:function(){c["default"].setElementSelection(this.domElement,0,c["default"].getElementValue(this.domElement).length)}},{key:"selectNumber",value:function(){var a=c["default"].getElementValue(this.domElement),b=a.length,e=this.settings.currencySymbol.length,h=this.settings.currencySymbolPlacement,g=c["default"].isNegative(a,this.settings.negativeSignCharacter)?1:0,l=this.settings.suffixText.length;a=h===d.options.currencySymbolPlacement.suffix?0:this.settings.negativePositiveSignPlacement===d.options.negativePositiveSignPlacement.left&&
1===g&&0<e?e+1:e;if(h===d.options.currencySymbolPlacement.prefix)b-=l;else switch(this.settings.negativePositiveSignPlacement){case d.options.negativePositiveSignPlacement.left:b-=l+e;break;case d.options.negativePositiveSignPlacement.right:b=0<e?b-(e+g+l):b-(e+l);break;default:b-=e+l}c["default"].setElementSelection(this.domElement,a,b);return this}},{key:"selectInteger",value:function(){var a=0,b=0<=this.rawValue;if(this.settings.currencySymbolPlacement===d.options.currencySymbolPlacement.prefix||
this.settings.currencySymbolPlacement===d.options.currencySymbolPlacement.suffix&&(this.settings.negativePositiveSignPlacement===d.options.negativePositiveSignPlacement.prefix||this.settings.negativePositiveSignPlacement===d.options.negativePositiveSignPlacement.none))if(this.settings.showPositiveSign&&b||!b&&this.settings.currencySymbolPlacement===d.options.currencySymbolPlacement.prefix&&this.settings.negativePositiveSignPlacement===d.options.negativePositiveSignPlacement.left)a+=1;this.settings.currencySymbolPlacement===
d.options.currencySymbolPlacement.prefix&&(a+=this.settings.currencySymbol.length);var e=c["default"].getElementValue(this.domElement),h=e.indexOf(this.settings.decimalCharacter);-1===h&&(h=this.settings.currencySymbolPlacement===d.options.currencySymbolPlacement.suffix?e.length-this.settings.currencySymbol.length:e.length,b||this.settings.negativePositiveSignPlacement!==d.options.negativePositiveSignPlacement.suffix&&this.settings.currencySymbolPlacement!==d.options.currencySymbolPlacement.suffix||
--h,h-=this.settings.suffixText.length);c["default"].setElementSelection(this.domElement,a,h);return this}},{key:"selectDecimal",value:function(){var a=c["default"].getElementValue(this.domElement).indexOf(this.settings.decimalCharacter);if(-1===a)var b=a=0;else a+=1,b=a+Number(this.isFocused?this.settings.decimalPlacesShownOnFocus:this.settings.decimalPlacesShownOnBlur);c["default"].setElementSelection(this.domElement,a,b);return this}},{key:"node",value:function(){return this.domElement}},{key:"parent",
value:function(){return this.domElement.parentNode}},{key:"detach",value:function(){var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null;a=c["default"].isNull(a)?this.domElement:a.node();this._removeFromLocalList(a);return this}},{key:"attach",value:function(a){var b=1<arguments.length&&void 0!==arguments[1]?arguments[1]:!0;this._addToLocalList(a.node());b&&a.update(this.settings);return this}},{key:"formatOther",value:function(a){return this._formatOrUnformatOther(!0,a,1<arguments.length&&
void 0!==arguments[1]?arguments[1]:null)}},{key:"unformatOther",value:function(a){return this._formatOrUnformatOther(!1,a,1<arguments.length&&void 0!==arguments[1]?arguments[1]:null)}},{key:"_formatOrUnformatOther",value:function(a,b){var e=2<arguments.length&&void 0!==arguments[2]?arguments[2]:null;e=c["default"].isNull(e)?this.settings:this._cloneAndMergeSettings(e);if(c["default"].isElement(b)){var h=c["default"].getElementValue(b);e=a?d.format(h,e):d.unformat(h,e);c["default"].setElementValue(b,
e);return null}return e=a?d.format(b,e):d.unformat(b,e)}},{key:"init",value:function(a){var b=this,e=1<arguments.length&&void 0!==arguments[1]?arguments[1]:!0,h=!1,g=[];c["default"].isString(a)?g=n(document.querySelectorAll(a)):c["default"].isElement(a)?(g.push(a),h=!0):c["default"].isArray(a)?g=a:c["default"].throwError("The given parameters to the 'init' function are invalid.");if(0===g.length)return c["default"].warning("No valid DOM elements were given hence no AutoNumeric object were instantiated.",
!0),[];var l=this._getLocalList(),p=[];g.forEach(function(q){var t=b.settings.createLocalList;e&&(b.settings.createLocalList=!1);var B=new d(q,c["default"].getElementValue(q),b.settings);e&&(B._setLocalList(l),b._addToLocalList(q,B),b.settings.createLocalList=t);p.push(B)});return h?p[0]:p}},{key:"clear",value:function(){0<arguments.length&&void 0!==arguments[0]&&arguments[0]?this.set("",{emptyInputBehavior:d.options.emptyInputBehavior.focus}):this.set("");return this}},{key:"remove",value:function(){this._removeValueFromPersistentStorage();
this._removeEventListeners();this._removeWatcher();this._removeFromLocalList(this.domElement);this.constructor._removeFromGlobalList(this)}},{key:"wipe",value:function(){this._setElementValue("",!1);this.remove()}},{key:"nuke",value:function(){this.remove();this.domElement.parentNode.removeChild(this.domElement)}},{key:"form",value:function(){if(0<arguments.length&&void 0!==arguments[0]&&arguments[0]||c["default"].isUndefinedOrNullOrEmpty(this.parentForm)){var a=this._getParentForm();if(!c["default"].isNull(a)&&
a!==this.parentForm){var b=this._getFormAutoNumericChildren(this.parentForm);this.parentForm.dataset.anCount=b.length;this._hasFormHandlerFunction(a)?this._incrementParentFormCounter(a):(this._storeFormHandlerFunction(a),this._initializeFormCounterToOne(a))}this.parentForm=a}return this.parentForm}},{key:"_getFormAutoNumericChildren",value:function(a){var b=this;return n(a.querySelectorAll("input")).filter(function(e){return b.constructor.isManagedByAutoNumeric(e)})}},{key:"_getParentForm",value:function(){if("body"===
this.domElement.tagName.toLowerCase())return null;var a=this.domElement;do{a=a.parentNode;if(c["default"].isNull(a))return null;var b=a.tagName?a.tagName.toLowerCase():"";if("body"===b)break}while("form"!==b);return"form"===b?a:null}},{key:"formNumericString",value:function(){return this.constructor._serializeNumericString(this.form(),this.settings.serializeSpaces)}},{key:"formFormatted",value:function(){return this.constructor._serializeFormatted(this.form(),this.settings.serializeSpaces)}},{key:"formLocalized",
value:function(){var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null;a=c["default"].isNull(a)?this.settings.outputFormat:a;return this.constructor._serializeLocalized(this.form(),this.settings.serializeSpaces,a)}},{key:"formArrayNumericString",value:function(){return this.constructor._serializeNumericStringArray(this.form(),this.settings.serializeSpaces)}},{key:"formArrayFormatted",value:function(){return this.constructor._serializeFormattedArray(this.form(),this.settings.serializeSpaces)}},
{key:"formArrayLocalized",value:function(){var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null;a=c["default"].isNull(a)?this.settings.outputFormat:a;return this.constructor._serializeLocalizedArray(this.form(),this.settings.serializeSpaces,a)}},{key:"formJsonNumericString",value:function(){return JSON.stringify(this.formArrayNumericString())}},{key:"formJsonFormatted",value:function(){return JSON.stringify(this.formArrayFormatted())}},{key:"formJsonLocalized",value:function(){return JSON.stringify(this.formArrayLocalized(0<
arguments.length&&void 0!==arguments[0]?arguments[0]:null))}},{key:"formUnformat",value:function(){this.constructor._getChildANInputElement(this.form()).forEach(function(a){d.getAutoNumericElement(a).unformat()});return this}},{key:"formUnformatLocalized",value:function(){this.constructor._getChildANInputElement(this.form()).forEach(function(a){d.getAutoNumericElement(a).unformatLocalized()});return this}},{key:"formReformat",value:function(){this.constructor._getChildANInputElement(this.form()).forEach(function(a){d.getAutoNumericElement(a).reformat()});
return this}},{key:"formSubmitNumericString",value:function(){var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null;c["default"].isNull(a)?(this.formUnformat(),this.form().submit(),this.formReformat()):c["default"].isFunction(a)?a(this.formNumericString()):c["default"].throwError("The given callback is not a function.");return this}},{key:"formSubmitFormatted",value:function(){var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null;c["default"].isNull(a)?this.form().submit():
c["default"].isFunction(a)?a(this.formFormatted()):c["default"].throwError("The given callback is not a function.");return this}},{key:"formSubmitLocalized",value:function(){var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null,b=1<arguments.length&&void 0!==arguments[1]?arguments[1]:null;c["default"].isNull(b)?(this.formUnformatLocalized(),this.form().submit(),this.formReformat()):c["default"].isFunction(b)?b(this.formLocalized(a)):c["default"].throwError("The given callback is not a function.");
return this}},{key:"formSubmitArrayNumericString",value:function(a){c["default"].isFunction(a)?a(this.formArrayNumericString()):c["default"].throwError("The given callback is not a function.");return this}},{key:"formSubmitArrayFormatted",value:function(a){c["default"].isFunction(a)?a(this.formArrayFormatted()):c["default"].throwError("The given callback is not a function.");return this}},{key:"formSubmitArrayLocalized",value:function(a){var b=1<arguments.length&&void 0!==arguments[1]?arguments[1]:
null;c["default"].isFunction(a)?a(this.formArrayLocalized(b)):c["default"].throwError("The given callback is not a function.");return this}},{key:"formSubmitJsonNumericString",value:function(a){c["default"].isFunction(a)?a(this.formJsonNumericString()):c["default"].throwError("The given callback is not a function.");return this}},{key:"formSubmitJsonFormatted",value:function(a){c["default"].isFunction(a)?a(this.formJsonFormatted()):c["default"].throwError("The given callback is not a function.");
return this}},{key:"formSubmitJsonLocalized",value:function(a){var b=1<arguments.length&&void 0!==arguments[1]?arguments[1]:null;c["default"].isFunction(a)?a(this.formJsonLocalized(b)):c["default"].throwError("The given callback is not a function.");return this}},{key:"_createLocalList",value:function(){this.autoNumericLocalList=new Map;this._addToLocalList(this.domElement)}},{key:"_deleteLocalList",value:function(){delete this.autoNumericLocalList}},{key:"_setLocalList",value:function(a){this.autoNumericLocalList=
a}},{key:"_getLocalList",value:function(){return this.autoNumericLocalList}},{key:"_hasLocalList",value:function(){return this.autoNumericLocalList instanceof Map&&0!==this.autoNumericLocalList.size}},{key:"_addToLocalList",value:function(a){var b=1<arguments.length&&void 0!==arguments[1]?arguments[1]:null;c["default"].isNull(b)&&(b=this);c["default"].isUndefined(this.autoNumericLocalList)?c["default"].throwError("The local list provided does not exists when trying to add an element. [".concat(this.autoNumericLocalList,
"] given.")):this.autoNumericLocalList.set(a,b)}},{key:"_removeFromLocalList",value:function(a){if(c["default"].isUndefined(this.autoNumericLocalList))this.settings.createLocalList&&c["default"].throwError("The local list provided does not exists when trying to remove an element. [".concat(this.autoNumericLocalList,"] given."));else this.autoNumericLocalList["delete"](a)}},{key:"_mergeSettings",value:function(){for(var a=arguments.length,b=Array(a),e=0;e<a;e++)b[e]=arguments[e];z.apply(void 0,[this.settings].concat(b))}},
{key:"_cloneAndMergeSettings",value:function(){for(var a={},b=arguments.length,e=Array(b),h=0;h<b;h++)e[h]=arguments[h];z.apply(void 0,[a,this.settings].concat(e));return a}},{key:"_updatePredefinedOptions",value:function(a){var b=1<arguments.length&&void 0!==arguments[1]?arguments[1]:null;c["default"].isNull(b)?this.update(a):(this._mergeSettings(a,b),this.update(this.settings));return this}},{key:"french",value:function(){var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null;this._updatePredefinedOptions(d.getPredefinedOptions().French,
a);return this}},{key:"northAmerican",value:function(){var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null;this._updatePredefinedOptions(d.getPredefinedOptions().NorthAmerican,a);return this}},{key:"british",value:function(){var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null;this._updatePredefinedOptions(d.getPredefinedOptions().British,a);return this}},{key:"swiss",value:function(){var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null;this._updatePredefinedOptions(d.getPredefinedOptions().Swiss,
a);return this}},{key:"japanese",value:function(){var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null;this._updatePredefinedOptions(d.getPredefinedOptions().Japanese,a);return this}},{key:"spanish",value:function(){var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null;this._updatePredefinedOptions(d.getPredefinedOptions().Spanish,a);return this}},{key:"chinese",value:function(){var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null;this._updatePredefinedOptions(d.getPredefinedOptions().Chinese,
a);return this}},{key:"brazilian",value:function(){var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null;this._updatePredefinedOptions(d.getPredefinedOptions().Brazilian,a);return this}},{key:"_runCallbacksFoundInTheSettingsObject",value:function(){for(var a in this.settings)if(Object.prototype.hasOwnProperty.call(this.settings,a)){var b=this.settings[a];"function"===typeof b?this.settings[a]=b(this,a):(b=this.domElement.getAttribute(a),b=c["default"].camelize(b),"function"===typeof this.settings[b]&&
(this.settings[a]=b(this,a)))}}},{key:"_setTrailingNegativeSignInfo",value:function(){this.isTrailingNegative=this.settings.currencySymbolPlacement===d.options.currencySymbolPlacement.prefix&&this.settings.negativePositiveSignPlacement===d.options.negativePositiveSignPlacement.suffix||this.settings.currencySymbolPlacement===d.options.currencySymbolPlacement.suffix&&(this.settings.negativePositiveSignPlacement===d.options.negativePositiveSignPlacement.left||this.settings.negativePositiveSignPlacement===
d.options.negativePositiveSignPlacement.right)}},{key:"_modifyNegativeSignAndDecimalCharacterForRawValue",value:function(a){"."!==this.settings.decimalCharacter&&(a=a.replace(this.settings.decimalCharacter,"."));"-"!==this.settings.negativeSignCharacter&&this.settings.isNegativeSignAllowed&&(a=a.replace(this.settings.negativeSignCharacter,"-"));a.match(/\d/)||(a+="0");return a}},{key:"_initialCaretPosition",value:function(a){c["default"].isNull(this.settings.caretPositionOnFocus)&&this.settings.selectOnFocus===
d.options.selectOnFocus.doNotSelect&&c["default"].throwError("`_initialCaretPosition()` should never be called when the `caretPositionOnFocus` option is `null`.");var b=0>this.rawValue,e=c["default"].isZeroOrHasNoValue(a),h=a.length,g=0,l=0,p=0;if(this.settings.caretPositionOnFocus!==d.options.caretPositionOnFocus.start){a=a.replace(this.settings.negativeSignCharacter,"");a=a.replace(this.settings.positiveSignCharacter,"");a=a.replace(this.settings.currencySymbol,"");g=a.length;var q=c["default"].contains(a,
this.settings.decimalCharacter);if(this.settings.caretPositionOnFocus===d.options.caretPositionOnFocus.decimalLeft||this.settings.caretPositionOnFocus===d.options.caretPositionOnFocus.decimalRight)q?(l=a.indexOf(this.settings.decimalCharacter),p=this.settings.decimalCharacter.length):(l=g,p=0)}a="";b?a=this.settings.negativeSignCharacter:this.settings.showPositiveSign&&!e&&(a=this.settings.positiveSignCharacter);a=a.length;q=this.settings.currencySymbol.length;if(this.settings.currencySymbolPlacement===
d.options.currencySymbolPlacement.prefix)if(this.settings.caretPositionOnFocus===d.options.caretPositionOnFocus.start)if(this.settings.negativePositiveSignPlacement!==d.options.negativePositiveSignPlacement.none&&(b||!b&&this.settings.showPositiveSign&&!e))switch(this.settings.negativePositiveSignPlacement){case d.options.negativePositiveSignPlacement.prefix:case d.options.negativePositiveSignPlacement.left:case d.options.negativePositiveSignPlacement.right:var t=a+q;break;case d.options.negativePositiveSignPlacement.suffix:t=
q}else t=q;else if(this.settings.caretPositionOnFocus===d.options.caretPositionOnFocus.end)if(this.settings.negativePositiveSignPlacement!==d.options.negativePositiveSignPlacement.none&&(b||!b&&this.settings.showPositiveSign&&!e))switch(this.settings.negativePositiveSignPlacement){case d.options.negativePositiveSignPlacement.prefix:case d.options.negativePositiveSignPlacement.left:case d.options.negativePositiveSignPlacement.right:t=h;break;case d.options.negativePositiveSignPlacement.suffix:t=q+
g}else t=h;else if(this.settings.caretPositionOnFocus===d.options.caretPositionOnFocus.decimalLeft)if(this.settings.negativePositiveSignPlacement!==d.options.negativePositiveSignPlacement.none&&(b||!b&&this.settings.showPositiveSign&&!e))switch(this.settings.negativePositiveSignPlacement){case d.options.negativePositiveSignPlacement.prefix:case d.options.negativePositiveSignPlacement.left:case d.options.negativePositiveSignPlacement.right:t=a+q+l;break;case d.options.negativePositiveSignPlacement.suffix:t=
q+l}else t=q+l;else{if(this.settings.caretPositionOnFocus===d.options.caretPositionOnFocus.decimalRight)if(this.settings.negativePositiveSignPlacement!==d.options.negativePositiveSignPlacement.none&&(b||!b&&this.settings.showPositiveSign&&!e))switch(this.settings.negativePositiveSignPlacement){case d.options.negativePositiveSignPlacement.prefix:case d.options.negativePositiveSignPlacement.left:case d.options.negativePositiveSignPlacement.right:t=a+q+l+p;break;case d.options.negativePositiveSignPlacement.suffix:t=
q+l+p}else t=q+l+p}else if(this.settings.currencySymbolPlacement===d.options.currencySymbolPlacement.suffix)if(this.settings.caretPositionOnFocus===d.options.caretPositionOnFocus.start)if(this.settings.negativePositiveSignPlacement!==d.options.negativePositiveSignPlacement.none&&(b||!b&&this.settings.showPositiveSign&&!e))switch(this.settings.negativePositiveSignPlacement){case d.options.negativePositiveSignPlacement.suffix:case d.options.negativePositiveSignPlacement.right:case d.options.negativePositiveSignPlacement.left:t=
0;break;case d.options.negativePositiveSignPlacement.prefix:t=a}else t=0;else if(this.settings.caretPositionOnFocus===d.options.caretPositionOnFocus.end)if(this.settings.negativePositiveSignPlacement!==d.options.negativePositiveSignPlacement.none&&(b||!b&&this.settings.showPositiveSign&&!e))switch(this.settings.negativePositiveSignPlacement){case d.options.negativePositiveSignPlacement.suffix:case d.options.negativePositiveSignPlacement.right:case d.options.negativePositiveSignPlacement.left:t=g;
break;case d.options.negativePositiveSignPlacement.prefix:t=a+g}else t=g;else if(this.settings.caretPositionOnFocus===d.options.caretPositionOnFocus.decimalLeft)if(this.settings.negativePositiveSignPlacement!==d.options.negativePositiveSignPlacement.none&&(b||!b&&this.settings.showPositiveSign&&!e))switch(this.settings.negativePositiveSignPlacement){case d.options.negativePositiveSignPlacement.suffix:case d.options.negativePositiveSignPlacement.right:case d.options.negativePositiveSignPlacement.left:t=
l;break;case d.options.negativePositiveSignPlacement.prefix:t=a+l}else t=l;else if(this.settings.caretPositionOnFocus===d.options.caretPositionOnFocus.decimalRight)if(this.settings.negativePositiveSignPlacement!==d.options.negativePositiveSignPlacement.none&&(b||!b&&this.settings.showPositiveSign&&!e))switch(this.settings.negativePositiveSignPlacement){case d.options.negativePositiveSignPlacement.suffix:case d.options.negativePositiveSignPlacement.right:case d.options.negativePositiveSignPlacement.left:t=
l+p;break;case d.options.negativePositiveSignPlacement.prefix:t=a+l+p}else t=l+p;return t}},{key:"_triggerRangeEvents",value:function(a,b){a||this._triggerEvent(d.events.minRangeExceeded,this.domElement);b||this._triggerEvent(d.events.maxRangeExceeded,this.domElement)}},{key:"_setInvalidState",value:function(){this.isInputElement?c["default"].setInvalidState(this.domElement):this._addCSSClass(this.settings.invalidClass);this._triggerEvent(d.events.invalidValue,this.domElement);this.validState=!1}},
{key:"_setValidState",value:function(){this.isInputElement?c["default"].setValidState(this.domElement):this._removeCSSClass(this.settings.invalidClass);this.validState||this._triggerEvent(d.events.correctedValue,this.domElement);this.validState=!0}},{key:"_setValidOrInvalidState",value:function(a){if(this.settings.overrideMinMaxLimits===d.options.overrideMinMaxLimits.invalid){var b=this.constructor._isMinimumRangeRespected(a,this.settings);a=this.constructor._isMaximumRangeRespected(a,this.settings);
b&&a?this._setValidState():this._setInvalidState();this._triggerRangeEvents(b,a)}}},{key:"_keepAnOriginalSettingsCopy",value:function(){this.originalDigitGroupSeparator=this.settings.digitGroupSeparator;this.originalCurrencySymbol=this.settings.currencySymbol;this.originalSuffixText=this.settings.suffixText}},{key:"_trimLeadingAndTrailingZeros",value:function(a){if(""===a||null===a)return a;if(this.settings.leadingZero!==d.options.leadingZero.keep){if(0===Number(a))return"0";a=a.replace(/^(-)?0+(?=\d)/g,
"$1")}c["default"].contains(a,".")&&(a=a.replace(/(\.[0-9]*?)0+$/,"$1"));return a=a.replace(/\.$/,"")}},{key:"_setPersistentStorageName",value:function(){this.settings.saveValueToSessionStorage&&(""===this.domElement.name||c["default"].isUndefined(this.domElement.name)?this.rawValueStorageName="".concat(this.storageNamePrefix).concat(this.domElement.id):this.rawValueStorageName="".concat(this.storageNamePrefix).concat(decodeURIComponent(this.domElement.name)))}},{key:"_saveValueToPersistentStorage",
value:function(){this.settings.saveValueToSessionStorage&&(this.sessionStorageAvailable?sessionStorage.setItem(this.rawValueStorageName,this.rawValue):document.cookie="".concat(this.rawValueStorageName,"\x3d").concat(this.rawValue,"; expires\x3d ; path\x3d/"))}},{key:"_getValueFromPersistentStorage",value:function(){if(this.settings.saveValueToSessionStorage)return this.sessionStorageAvailable?sessionStorage.getItem(this.rawValueStorageName):this.constructor._readCookie(this.rawValueStorageName);
c["default"].warning("`_getValueFromPersistentStorage()` is called but `settings.saveValueToSessionStorage` is false. There must be an error that needs fixing.",this.settings.showWarnings);return null}},{key:"_removeValueFromPersistentStorage",value:function(){if(this.settings.saveValueToSessionStorage)if(this.sessionStorageAvailable)sessionStorage.removeItem(this.rawValueStorageName);else{var a=new Date;a.setTime(a.getTime()-864E5);a="; expires\x3d".concat(a.toUTCString());document.cookie="".concat(this.rawValueStorageName,
"\x3d'' ;").concat(a,"; path\x3d/")}}},{key:"_getDefaultValue",value:function(a){a=a.getAttribute("value");return c["default"].isNull(a)?"":a}},{key:"_onFocusInAndMouseEnter",value:function(a){this.isEditing=!1;if(!this.formulaMode&&this.settings.unformatOnHover&&"mouseenter"===a.type&&a.altKey)this.constructor._unformatAltHovered(this);else if("focus"===a.type&&(this.isFocused=!0,this.rawValueOnFocus=this.rawValue),"focus"===a.type&&this.settings.unformatOnHover&&this.hoveredWithAlt&&this.constructor._reformatAltHovered(this),
"focus"===a.type||"mouseenter"===a.type&&!this.isFocused){var b=null;this.settings.emptyInputBehavior===d.options.emptyInputBehavior.focus&&0>this.rawValue&&null!==this.settings.negativeBracketsTypeOnBlur&&this.settings.isNegativeSignAllowed&&(b=this.constructor._removeBrackets(c["default"].getElementValue(this.domElement),this.settings));var e=this._getRawValueToFormat(this.rawValue);""!==e&&(b=this.constructor._roundFormattedValueShownOnFocusOrBlur(e,this.settings,this.isFocused),this.settings.showOnlyNumbersOnFocus===
d.options.showOnlyNumbersOnFocus.onlyNumbers?(this.settings.digitGroupSeparator="",this.settings.currencySymbol="",this.settings.suffixText="",b=b.replace(".",this.settings.decimalCharacter)):b=c["default"].isNull(b)?"":this.constructor._addGroupSeparators(b.replace(".",this.settings.decimalCharacter),this.settings,this.isFocused,e));c["default"].isNull(b)?this.valueOnFocus="":this.valueOnFocus=b;this.lastVal=this.valueOnFocus;var h=this.constructor._isElementValueEmptyOrOnlyTheNegativeSign(this.valueOnFocus,
this.settings);e=this.constructor._orderValueCurrencySymbolAndSuffixText(this.valueOnFocus,this.settings,!0);(h=h&&""!==e&&this.settings.emptyInputBehavior===d.options.emptyInputBehavior.focus)&&(b=e);c["default"].isNull(b)||this._setElementValue(b);h&&e===this.settings.currencySymbol&&this.settings.currencySymbolPlacement===d.options.currencySymbolPlacement.suffix&&c["default"].setElementSelection(a.target,0)}}},{key:"_onFocus",value:function(){this.settings.isCancellable&&this._saveCancellableValue()}},
{key:"_onFocusIn",value:function(a){this.settings.selectOnFocus?this.select():c["default"].isNull(this.settings.caretPositionOnFocus)||c["default"].setElementSelection(a.target,this._initialCaretPosition(c["default"].getElementValue(this.domElement)))}},{key:"_enterFormulaMode",value:function(){this.settings.formulaMode&&(this.formulaMode=!0,c["default"].setElementValue(this.domElement,"\x3d"),c["default"].setElementSelection(this.domElement,1))}},{key:"_exitFormulaMode",value:function(){var a=c["default"].getElementValue(this.domElement);
a=a.replace(/^\s*=/,"");try{var b=new f["default"](a,this.settings.decimalCharacter);var e=(new E["default"]).evaluate(b)}catch(h){this._triggerEvent(d.events.invalidFormula,this.domElement,{formula:a,aNElement:this});this.reformat();this.formulaMode=!1;return}this._triggerEvent(d.events.validFormula,this.domElement,{formula:a,result:e,aNElement:this});this.set(e);this.formulaMode=!1}},{key:"_acceptNonPrintableKeysInFormulaMode",value:function(){return this.eventKey===w["default"].keyName.Backspace||
this.eventKey===w["default"].keyName.Delete||this.eventKey===w["default"].keyName.LeftArrow||this.eventKey===w["default"].keyName.RightArrow||this.eventKey===w["default"].keyName.Home||this.eventKey===w["default"].keyName.End}},{key:"_onKeydown",value:function(a){this.formatted=!1;this.isEditing=!0;if(!this.formulaMode&&!this.isFocused&&this.settings.unformatOnHover&&a.altKey&&this.domElement===c["default"].getHoveredElement())this.constructor._unformatAltHovered(this);else{this._updateEventKeyInfo(a);
this.keydownEventCounter+=1;1===this.keydownEventCounter&&(this.initialValueOnFirstKeydown=c["default"].getElementValue(a.target),this.initialRawValueOnFirstKeydown=this.rawValue);if(this.formulaMode){if(this.eventKey===w["default"].keyName.Esc){this.formulaMode=!1;this.reformat();return}if(this.eventKey===w["default"].keyName.Enter){this._exitFormulaMode();return}if(this._acceptNonPrintableKeysInFormulaMode())return}else if(this.eventKey===w["default"].keyName.Equal){this._enterFormulaMode();return}if(this.domElement.readOnly||
this.settings.readOnly||this.domElement.disabled)this.processed=!0;else{this.eventKey===w["default"].keyName.Esc&&(a.preventDefault(),this.settings.isCancellable&&this.rawValue!==this.savedCancellableValue&&(this.set(this.savedCancellableValue),this._triggerEvent(d.events["native"].input,a.target)),this.select());var b=c["default"].getElementValue(a.target);this.eventKey===w["default"].keyName.Enter&&this.rawValue!==this.rawValueOnFocus&&(this._triggerEvent(d.events["native"].change,a.target),this.valueOnFocus=
b,this.rawValueOnFocus=this.rawValue,this.settings.isCancellable&&this._saveCancellableValue());this._updateInternalProperties(a);if(this._processNonPrintableKeysAndShortcuts(a))this.processed=!0;else if(this.eventKey===w["default"].keyName.Backspace||this.eventKey===w["default"].keyName.Delete)b=this._processCharacterDeletion(),this.processed=!0,b?(this._formatValue(a),b=c["default"].getElementValue(a.target),b!==this.lastVal&&this.throwInput&&(this._triggerEvent(d.events["native"].input,a.target),
a.preventDefault()),this.lastVal=b,this.throwInput=!0):a.preventDefault()}}}},{key:"_onKeypress",value:function(a){if(this.formulaMode)this._acceptNonPrintableKeysInFormulaMode()||this.settings.formulaChars.test(this.eventKey)||a.preventDefault();else if(this.eventKey!==w["default"].keyName.Insert){var b=this.processed;this._updateInternalProperties(a);this._processNonPrintableKeysAndShortcuts(a)||(b?a.preventDefault():this._processCharacterInsertion()?(this._formatValue(a),b=c["default"].getElementValue(a.target),
b!==this.lastVal&&this.throwInput?this._triggerEvent(d.events["native"].input,a.target):this.eventKey!==this.settings.decimalCharacter&&this.eventKey!==this.settings.decimalCharacterAlternative||c["default"].getElementSelection(a.target).start!==c["default"].getElementSelection(a.target).end||c["default"].getElementSelection(a.target).start!==b.indexOf(this.settings.decimalCharacter)||(b=c["default"].getElementSelection(a.target).start+1,c["default"].setElementSelection(a.target,b)),a.preventDefault(),
this.lastVal=c["default"].getElementValue(a.target),this.throwInput=!0,this._setValidOrInvalidState(this.rawValue)):a.preventDefault())}}},{key:"_onKeyup",value:function(a){this.isEditing=!1;this.keydownEventCounter=0;if(!this.formulaMode)if(this.settings.isCancellable&&this.eventKey===w["default"].keyName.Esc)a.preventDefault();else{if(this.eventKey===w["default"].keyName.Z||this.eventKey===w["default"].keyName.z){if(a.ctrlKey&&a.shiftKey){a.preventDefault();this._historyTableRedo();this.onGoingRedo=
!0;return}if(a.ctrlKey&&!a.shiftKey)if(this.onGoingRedo)this.onGoingRedo=!1;else{a.preventDefault();this._historyTableUndo();return}}this.onGoingRedo&&(a.ctrlKey||a.shiftKey)&&(this.onGoingRedo=!1);if((a.ctrlKey||a.metaKey)&&this.eventKey===w["default"].keyName.x){var b=c["default"].getElementSelection(this.domElement).start,e=this.constructor._toNumericValue(c["default"].getElementValue(a.target),this.settings);this.set(e);this._setCaretPosition(b)}this.eventKey===w["default"].keyName.Alt&&this.settings.unformatOnHover&&
this.hoveredWithAlt?this.constructor._reformatAltHovered(this):!a.ctrlKey&&!a.metaKey||this.eventKey!==w["default"].keyName.Backspace&&this.eventKey!==w["default"].keyName.Delete?(this._updateInternalProperties(a),b=this._processNonPrintableKeysAndShortcuts(a),delete this.valuePartsBeforePaste,e=c["default"].getElementValue(a.target),b||""===e&&""===this.initialValueOnFirstKeydown||(e===this.settings.currencySymbol?this.settings.currencySymbolPlacement===d.options.currencySymbolPlacement.suffix?c["default"].setElementSelection(a.target,
0):c["default"].setElementSelection(a.target,this.settings.currencySymbol.length):this.eventKey===w["default"].keyName.Tab&&c["default"].setElementSelection(a.target,0,e.length),(e===this.settings.suffixText||""===this.rawValue&&""!==this.settings.currencySymbol&&""!==this.settings.suffixText)&&c["default"].setElementSelection(a.target,0),null!==this.settings.decimalPlacesShownOnFocus&&this._saveValueToPersistentStorage(),this.formatted||this._formatValue(a),this._setValidOrInvalidState(this.rawValue),
this._saveRawValueForAndroid(),e!==this.initialValueOnFirstKeydown&&this._triggerEvent(d.events.formatted,a.target,{oldValue:this.initialValueOnFirstKeydown,newValue:e,oldRawValue:this.initialRawValueOnFirstKeydown,newRawValue:this.rawValue,isPristine:this.isPristine(!1),error:null,aNElement:this}),1<this.historyTable.length&&(a=c["default"].getElementSelection(this.domElement),this.selectionStart=a.start,this.selectionEnd=a.end,this.historyTable[this.historyTableIndex].start=this.selectionStart,
this.historyTable[this.historyTableIndex].end=this.selectionEnd))):(a=c["default"].getElementValue(a.target),this._setRawValue(this._formatOrUnformatOther(!1,a)))}}},{key:"_saveRawValueForAndroid",value:function(){if(this.eventKey===w["default"].keyName.AndroidDefault){var a=this.constructor._stripAllNonNumberCharactersExceptCustomDecimalChar(this.getFormatted(),this.settings,!0,this.isFocused);a=this.constructor._convertToNumericString(a,this.settings);this._setRawValue(a)}}},{key:"_onFocusOutAndMouseLeave",
value:function(a){this.isEditing=!1;if("mouseleave"!==a.type||!this.formulaMode)if(this.settings.unformatOnHover&&"mouseleave"===a.type&&this.hoveredWithAlt)this.constructor._reformatAltHovered(this);else if("mouseleave"===a.type&&!this.isFocused||"blur"===a.type){"blur"===a.type&&this.formulaMode&&this._exitFormulaMode();this._saveValueToPersistentStorage();this.settings.showOnlyNumbersOnFocus===d.options.showOnlyNumbersOnFocus.onlyNumbers&&(this.settings.digitGroupSeparator=this.originalDigitGroupSeparator,
this.settings.currencySymbol=this.originalCurrencySymbol,this.settings.suffixText=this.originalSuffixText);var b=this._getRawValueToFormat(this.rawValue),e=c["default"].isNull(b),h=this.constructor._checkIfInRangeWithOverrideOption(b,this.settings),g=r(h,2);h=g[0];g=g[1];var l=!1;""===b||e||(this._triggerRangeEvents(h,g),this.settings.valuesToStrings&&this._checkValuesToStrings(b)&&(this._setElementValue(this.settings.valuesToStrings[b]),l=!0));if(!l){l=e||""===b?b:String(b);if(""!==b&&!e)h&&g&&!this.constructor._isElementValueEmptyOrOnlyTheNegativeSign(b,
this.settings)?(l=this._modifyNegativeSignAndDecimalCharacterForRawValue(l),this.settings.divisorWhenUnfocused&&!c["default"].isNull(l)&&(l/=this.settings.divisorWhenUnfocused,l=l.toString()),l=this.constructor._roundFormattedValueShownOnBlur(l,this.settings),l=this.constructor._modifyNegativeSignAndDecimalCharacterForFormattedValue(l,this.settings)):this._triggerRangeEvents(h,g);else if(""===b)switch(this.settings.emptyInputBehavior){case d.options.emptyInputBehavior.zero:this._setRawValue("0");
l=this.constructor._roundValue("0",this.settings,0);break;case d.options.emptyInputBehavior.min:this._setRawValue(this.settings.minimumValue);l=this.constructor._roundFormattedValueShownOnFocusOrBlur(this.settings.minimumValue,this.settings,this.isFocused);break;case d.options.emptyInputBehavior.max:this._setRawValue(this.settings.maximumValue);l=this.constructor._roundFormattedValueShownOnFocusOrBlur(this.settings.maximumValue,this.settings,this.isFocused);break;default:c["default"].isNumber(this.settings.emptyInputBehavior)&&
(this._setRawValue(this.settings.emptyInputBehavior),l=this.constructor._roundFormattedValueShownOnFocusOrBlur(this.settings.emptyInputBehavior,this.settings,this.isFocused))}h=this.constructor._orderValueCurrencySymbolAndSuffixText(l,this.settings,!1);this.constructor._isElementValueEmptyOrOnlyTheNegativeSign(l,this.settings)||e&&this.settings.emptyInputBehavior===d.options.emptyInputBehavior["null"]||(h=this.constructor._addGroupSeparators(l,this.settings,!1,b));if(h!==b||""===b||this.settings.allowDecimalPadding===
d.options.allowDecimalPadding.never||this.settings.allowDecimalPadding===d.options.allowDecimalPadding.floats)this.settings.symbolWhenUnfocused&&""!==b&&null!==b&&(h="".concat(h).concat(this.settings.symbolWhenUnfocused)),this._setElementValue(h)}this._setValidOrInvalidState(this.rawValue);"blur"===a.type&&this._onBlur(a)}}},{key:"_onPaste",value:function(a){a.preventDefault();if(!(this.settings.readOnly||this.domElement.readOnly||this.domElement.disabled)){var b;window.clipboardData&&window.clipboardData.getData?
b=window.clipboardData.getData("Text"):a.clipboardData&&a.clipboardData.getData?b=a.clipboardData.getData("text/plain"):c["default"].throwError("Unable to retrieve the pasted value. Please use a modern browser (ie. Firefox or Chromium).");a=a.target.tagName?a.target:a.explicitOriginalTarget;var e=c["default"].getElementValue(a),h=a.selectionStart||0,g=a.selectionEnd||0,l=g-h;if(l===e.length)e=this._preparePastedText(b),e=c["default"].arabicToLatinNumbers(e,!1,!1,!1),"."===e||""===e||"."!==e&&!c["default"].isNumber(e)?
(this.formatted=!0,this.settings.onInvalidPaste===d.options.onInvalidPaste.error&&c["default"].throwError("The pasted value '".concat(b,"' is not a valid paste content."))):(this.set(e),this.formatted=!0,this._triggerEvent(d.events["native"].input,a));else{var p=c["default"].isNegativeStrict(b,this.settings.negativeSignCharacter);p&&(b=b.slice(1,b.length));var q=this._preparePastedText(b);q="."===q?".":c["default"].arabicToLatinNumbers(q,!1,!1,!1);if("."===q||c["default"].isNumber(q)&&""!==q){var t=
c["default"].isNegativeStrict(this.getNumericString(),this.settings.negativeSignCharacter);var B=p&&!t?t=!0:!1;p=e.slice(0,h);var F=e.slice(g,e.length);p=h!==g?this._preparePastedText(p+F):this._preparePastedText(e);t&&(p=c["default"].setRawNegativeSign(p));t=c["default"].convertCharacterCountToIndexPosition(c["default"].countNumberCharactersOnTheCaretLeftSide(e,h,this.settings.decimalCharacter));B&&t++;var I=p.slice(0,t),K=p.slice(t,p.length);F=!1;"."===q&&(c["default"].contains(I,".")&&(F=!0,I=
I.replace(".","")),K=K.replace(".",""));var L=!1;""===I&&"-"===K&&(I="-",K="",L=!0);switch(this.settings.onInvalidPaste){case d.options.onInvalidPaste.truncate:case d.options.onInvalidPaste.replace:l=c["default"].parseStr(this.settings.minimumValue);h=c["default"].parseStr(this.settings.maximumValue);g=p;for(B=0;B<q.length;){I+=q[B];p=I+K;if(!this.constructor._checkIfInRange(p,l,h))break;g=p;B++}t+=B;L&&t++;if(this.settings.onInvalidPaste===d.options.onInvalidPaste.truncate){p=g;F&&t--;break}for(K=
g.length;B<q.length&&t<K;){if("."!==g[t]){p=c["default"].replaceCharAt(g,t,q[B]);if(!this.constructor._checkIfInRange(p,l,h))break;g=p;B++}t++}F&&t--;p=g;break;default:p="".concat(I).concat(q).concat(K),h===g?t=c["default"].convertCharacterCountToIndexPosition(c["default"].countNumberCharactersOnTheCaretLeftSide(e,h,this.settings.decimalCharacter))+q.length:""===K?(t=c["default"].convertCharacterCountToIndexPosition(c["default"].countNumberCharactersOnTheCaretLeftSide(e,h,this.settings.decimalCharacter))+
q.length,L&&t++):(t=c["default"].convertCharacterCountToIndexPosition(c["default"].countNumberCharactersOnTheCaretLeftSide(e,g,this.settings.decimalCharacter)),h=c["default"].getElementValue(a).slice(h,g),t=t-l+c["default"].countCharInText(this.settings.digitGroupSeparator,h)+q.length),B&&t++,F&&t--}if(c["default"].isNumber(p)&&""!==p){F=q=!1;try{this.set(p),q=!0}catch(M){switch(this.settings.onInvalidPaste){case d.options.onInvalidPaste.clamp:b=c["default"].clampToRangeLimits(p,this.settings);try{this.set(b)}catch(G){c["default"].throwError("Fatal error: Unable to set the clamped value '".concat(b,
"'."))}q=F=!0;p=b;break;case d.options.onInvalidPaste.error:case d.options.onInvalidPaste.truncate:case d.options.onInvalidPaste.replace:c["default"].throwError("The pasted value '".concat(b,"' results in a value '").concat(p,"' that is outside of the minimum [").concat(this.settings.minimumValue,"] and maximum [").concat(this.settings.maximumValue,"] value range."));default:return}}b=c["default"].getElementValue(a);if(q)switch(this.settings.onInvalidPaste){case d.options.onInvalidPaste.clamp:if(F){this.settings.currencySymbolPlacement===
d.options.currencySymbolPlacement.suffix?c["default"].setElementSelection(a,b.length-this.settings.currencySymbol.length):c["default"].setElementSelection(a,b.length);break}default:p=c["default"].findCaretPositionInFormattedNumber(p,t,b,this.settings.decimalCharacter),c["default"].setElementSelection(a,p)}q&&e!==b&&this._triggerEvent(d.events["native"].input,a)}else this.settings.onInvalidPaste===d.options.onInvalidPaste.error&&c["default"].throwError("The pasted value '".concat(b,"' would result into an invalid content '").concat(p,
"'."))}else this.formatted=!0,this.settings.onInvalidPaste===d.options.onInvalidPaste.error&&c["default"].throwError("The pasted value '".concat(b,"' is not a valid paste content."))}}}},{key:"_onBlur",value:function(a){this.isEditing=this.isFocused=!1;this.rawValue!==this.rawValueOnFocus&&this._triggerEvent(d.events["native"].change,a.target);this.rawValueOnFocus=void 0}},{key:"_onWheel",value:function(a){this.formulaMode||this.settings.readOnly||this.domElement.readOnly||this.domElement.disabled||
!this.settings.modifyValueOnWheel||(this.settings.wheelOn===d.options.wheelOn.focus?this.isFocused?a.shiftKey||this.wheelAction(a):a.shiftKey&&this.wheelAction(a):this.settings.wheelOn===d.options.wheelOn.hover?a.shiftKey?(a.preventDefault(),window.scrollBy(0,c["default"].isNegativeStrict(String(a.deltaY))?-50:50)):this.wheelAction(a):c["default"].throwError("Unknown `wheelOn` option."))}},{key:"wheelAction",value:function(a){this.isWheelEvent=!0;var b=a.target.selectionStart||0,e=a.target.selectionEnd||
0,h=this.rawValue,g;c["default"].isUndefinedOrNullOrEmpty(h)?0<this.settings.minimumValue||0>this.settings.maximumValue?c["default"].isWheelUpEvent(a)?g=this.settings.minimumValue:c["default"].isWheelDownEvent(a)?g=this.settings.maximumValue:c["default"].throwError("The event is not a 'wheel' event."):g=0:g=h;g=+g;if(c["default"].isNumber(this.settings.wheelStep)){var l=+this.settings.wheelStep;c["default"].isWheelUpEvent(a)?g+=l:c["default"].isWheelDownEvent(a)&&(g-=l)}else c["default"].isWheelUpEvent(a)?
g=c["default"].addAndRoundToNearestAuto(g,this.settings.decimalPlacesRawValue):c["default"].isWheelDownEvent(a)&&(g=c["default"].subtractAndRoundToNearestAuto(g,this.settings.decimalPlacesRawValue));g=c["default"].clampToRangeLimits(g,this.settings);g!==+h&&(this.set(g),this._triggerEvent(d.events["native"].input,a.target));a.preventDefault();this._setSelection(b,e);this.isWheelEvent=!1}},{key:"_onDrop",value:function(a){if(!this.formulaMode){this.isDropEvent=!0;a.preventDefault();var b=c["default"].isIE11()?
"text":"text/plain";a=a.dataTransfer.getData(b);a=this.unformatOther(a);this.set(a);this.isDropEvent=!1}}},{key:"_onFormSubmit",value:function(){var a=this;this._getFormAutoNumericChildren(this.parentForm).map(function(b){return a.constructor.getAutoNumericElement(b)}).forEach(function(b){return b._unformatOnSubmit()});return!0}},{key:"_onFormReset",value:function(){var a=this;this._getFormAutoNumericChildren(this.parentForm).map(function(b){return a.constructor.getAutoNumericElement(b)}).forEach(function(b){var e=
a._getDefaultValue(b.node());setTimeout(function(){return b.set(e)},0)})}},{key:"_unformatOnSubmit",value:function(){this.settings.unformatOnSubmit&&this._setElementValue(this.rawValue)}},{key:"_onKeydownGlobal",value:function(a){c["default"].character(a)===w["default"].keyName.Alt&&(a=c["default"].getHoveredElement(),d.isManagedByAutoNumeric(a)&&(a=d.getAutoNumericElement(a),!a.formulaMode&&a.settings.unformatOnHover&&this.constructor._unformatAltHovered(a)))}},{key:"_onKeyupGlobal",value:function(a){c["default"].character(a)===
w["default"].keyName.Alt&&(a=c["default"].getHoveredElement(),d.isManagedByAutoNumeric(a)&&(a=d.getAutoNumericElement(a),!a.formulaMode&&a.settings.unformatOnHover&&this.constructor._reformatAltHovered(a)))}},{key:"_isElementTagSupported",value:function(){c["default"].isElement(this.domElement)||c["default"].throwError("The DOM element is not valid, ".concat(this.domElement," given."));return c["default"].isInArray(this.domElement.tagName.toLowerCase(),this.allowedTagList)}},{key:"_isInputElement",
value:function(){return"input"===this.domElement.tagName.toLowerCase()}},{key:"_isInputTypeSupported",value:function(){return"text"===this.domElement.type||"hidden"===this.domElement.type||"tel"===this.domElement.type||c["default"].isUndefinedOrNullOrEmpty(this.domElement.type)}},{key:"_checkElement",value:function(){var a=this.domElement.tagName.toLowerCase();this._isElementTagSupported()||c["default"].throwError("The \x3c".concat(a,"\x3e tag is not supported by autoNumeric"));this._isInputElement()?
(this._isInputTypeSupported()||c["default"].throwError('The input type "'.concat(this.domElement.type,'" is not supported by autoNumeric')),this.isInputElement=!0):(this.isInputElement=!1,this.isContentEditable=this.domElement.hasAttribute("contenteditable")&&"true"===this.domElement.getAttribute("contenteditable"))}},{key:"_formatDefaultValueOnPageLoad",value:function(){var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null,b=!0;c["default"].isNull(a)&&(a=c["default"].getElementValue(this.domElement).trim(),
this.domElement.setAttribute("value",a));if(this.isInputElement||this.isContentEditable){var e=this.constructor._toNumericValue(a,this.settings);if(!this.domElement.hasAttribute("value")||""===this.domElement.getAttribute("value"))isNaN(Number(e))||Infinity===e?c["default"].throwError("The value [".concat(a,"] used in the input is not a valid value autoNumeric can work with.")):(this.set(e),b=!1);else if(null!==this.settings.defaultValueOverride&&this.settings.defaultValueOverride.toString()!==a||
null===this.settings.defaultValueOverride&&""!==a&&a!==this.domElement.getAttribute("value")||""!==a&&"hidden"===this.domElement.getAttribute("type")&&!c["default"].isNumber(e))this.settings.saveValueToSessionStorage&&(null!==this.settings.decimalPlacesShownOnFocus||this.settings.divisorWhenUnfocused)&&this._setRawValue(this._getValueFromPersistentStorage()),this.settings.saveValueToSessionStorage||(b=this.constructor._removeBrackets(a,this.settings),(this.settings.negativePositiveSignPlacement===
d.options.negativePositiveSignPlacement.suffix||this.settings.negativePositiveSignPlacement!==d.options.negativePositiveSignPlacement.prefix&&this.settings.currencySymbolPlacement===d.options.currencySymbolPlacement.suffix)&&""!==this.settings.negativeSignCharacter&&c["default"].isNegative(a,this.settings.negativeSignCharacter)?this._setRawValue("-".concat(this.constructor._stripAllNonNumberCharacters(b,this.settings,!0,this.isFocused))):this._setRawValue(this.constructor._stripAllNonNumberCharacters(b,
this.settings,!0,this.isFocused))),b=!1;if(""===a)switch(this.settings.emptyInputBehavior){case d.options.emptyInputBehavior.focus:case d.options.emptyInputBehavior["null"]:case d.options.emptyInputBehavior.press:break;case d.options.emptyInputBehavior.always:this._setElementValue(this.settings.currencySymbol);break;case d.options.emptyInputBehavior.min:this.set(this.settings.minimumValue);break;case d.options.emptyInputBehavior.max:this.set(this.settings.maximumValue);break;case d.options.emptyInputBehavior.zero:this.set("0");
break;default:this.set(this.settings.emptyInputBehavior)}else b&&a===this.domElement.getAttribute("value")&&this.set(a)}else null!==this.settings.defaultValueOverride&&this.settings.defaultValueOverride!==a||this.set(a)}},{key:"_calculateVMinAndVMaxIntegerSizes",value:function(){var a=this.settings.maximumValue.toString().split(".");a=r(a,1)[0];var b=this.settings.minimumValue||0===this.settings.minimumValue?this.settings.minimumValue.toString().split("."):[];b=r(b,1)[0];a=a.replace(this.settings.negativeSignCharacter,
"");b=b.replace(this.settings.negativeSignCharacter,"");this.settings.mIntPos=Math.max(a.length,1);this.settings.mIntNeg=Math.max(b.length,1)}},{key:"_calculateValuesToStringsKeys",value:function(){this.valuesToStringsKeys=this.settings.valuesToStrings?Object.keys(this.settings.valuesToStrings):[]}},{key:"_transformOptionsValuesToDefaultTypes",value:function(){for(var a in this.settings)if(Object.prototype.hasOwnProperty.call(this.settings,a)){var b=this.settings[a];if("true"===b||"false"===b)this.settings[a]=
"true"===b;"number"===typeof b&&(this.settings[a]=b.toString())}}},{key:"_setSettings",value:function(a){var b=1<arguments.length&&void 0!==arguments[1]?arguments[1]:!1;!b&&c["default"].isNull(a)||this.constructor._convertOldOptionsToNewOnes(a);b?("decimalPlacesRawValue"in a&&(this.settings.originalDecimalPlacesRawValue=a.decimalPlacesRawValue),"decimalPlaces"in a&&(this.settings.originalDecimalPlaces=a.decimalPlaces),this.constructor._calculateDecimalPlacesOnUpdate(a,this.settings),this._mergeSettings(a)):
(this.settings={},this._mergeSettings(this.constructor.getDefaultConfig(),this.domElement.dataset,a,{rawValue:this.defaultRawValue}),this.caretFix=!1,this.throwInput=!0,this.allowedTagList=w["default"].allowedTagList,this.hoveredWithAlt=this.runOnce=!1);this._transformOptionsValuesToDefaultTypes();this._runCallbacksFoundInTheSettingsObject();this.constructor._correctNegativePositiveSignPlacementOption(this.settings);this.constructor._correctCaretPositionOnFocusAndSelectOnFocusOptions(this.settings);
this.constructor._setNegativePositiveSignPermissions(this.settings);b||(c["default"].isNull(a)||!a.decimalPlaces?this.settings.originalDecimalPlaces=null:this.settings.originalDecimalPlaces=a.decimalPlaces,this.settings.originalDecimalPlacesRawValue=this.settings.decimalPlacesRawValue,this.constructor._calculateDecimalPlacesOnInit(this.settings));this._calculateVMinAndVMaxIntegerSizes();this._setTrailingNegativeSignInfo();this.regex={};this.constructor._cachesUsualRegularExpressions(this.settings,
this.regex);this.constructor._setBrackets(this.settings);this._calculateValuesToStringsKeys();c["default"].isEmptyObj(this.settings)&&c["default"].throwError("Unable to set the settings, those are invalid ; an empty object was given.");this.constructor.validate(this.settings,!1,a);this._keepAnOriginalSettingsCopy()}},{key:"_preparePastedText",value:function(a){return this.constructor._stripAllNonNumberCharacters(a,this.settings,!0,this.isFocused)}},{key:"_updateInternalProperties",value:function(){this.selection=
c["default"].getElementSelection(this.domElement);this.processed=!1}},{key:"_updateEventKeyInfo",value:function(a){this.eventKey=c["default"].character(a)}},{key:"_saveCancellableValue",value:function(){this.savedCancellableValue=this.rawValue}},{key:"_setSelection",value:function(a,b){a=Math.max(a,0);b=Math.min(b,c["default"].getElementValue(this.domElement).length);this.selection={start:a,end:b,length:b-a};c["default"].setElementSelection(this.domElement,a,b)}},{key:"_setCaretPosition",value:function(a){this._setSelection(a,
a)}},{key:"_getLeftAndRightPartAroundTheSelection",value:function(){var a=c["default"].getElementValue(this.domElement),b=a.substring(0,this.selection.start);a=a.substring(this.selection.end,a.length);return[b,a]}},{key:"_getUnformattedLeftAndRightPartAroundTheSelection",value:function(){var a=this._getLeftAndRightPartAroundTheSelection(),b=r(a,2);a=b[0];b=b[1];if(""===a&&""===b)return["",""];var e=!0;this.eventKey!==w["default"].keyName.Hyphen&&this.eventKey!==w["default"].keyName.Minus||0!==Number(a)||
(e=!1);this.isTrailingNegative&&(c["default"].isNegative(b,this.settings.negativeSignCharacter)&&!c["default"].isNegative(a,this.settings.negativeSignCharacter)||""===b&&c["default"].isNegative(a,this.settings.negativeSignCharacter,!0))&&(a=a.replace(this.settings.negativeSignCharacter,""),b=b.replace(this.settings.negativeSignCharacter,""),a=a.replace("-",""),b=b.replace("-",""),a="-".concat(a));a=d._stripAllNonNumberCharactersExceptCustomDecimalChar(a,this.settings,e,this.isFocused);b=d._stripAllNonNumberCharactersExceptCustomDecimalChar(b,
this.settings,!1,this.isFocused);return[a,b]}},{key:"_normalizeParts",value:function(a,b){var e=!0;this.eventKey!==w["default"].keyName.Hyphen&&this.eventKey!==w["default"].keyName.Minus||0!==Number(a)||(e=!1);this.isTrailingNegative&&c["default"].isNegative(b,this.settings.negativeSignCharacter)&&!c["default"].isNegative(a,this.settings.negativeSignCharacter)&&(a="-".concat(a),b=b.replace(this.settings.negativeSignCharacter,""));a=d._stripAllNonNumberCharactersExceptCustomDecimalChar(a,this.settings,
e,this.isFocused);b=d._stripAllNonNumberCharactersExceptCustomDecimalChar(b,this.settings,!1,this.isFocused);this.settings.leadingZero!==d.options.leadingZero.deny||this.eventKey!==w["default"].keyName.num0&&this.eventKey!==w["default"].keyName.numpad0||0!==Number(a)||c["default"].contains(a,this.settings.decimalCharacter)||""===b||(a=a.substring(0,a.length-1));e=a+b;if(this.settings.decimalCharacter){var h=e.match(new RegExp("^".concat(this.regex.aNegRegAutoStrip,"\\").concat(this.settings.decimalCharacter)));
h&&(a=a.replace(h[1],h[1]+"0"),e=a+b)}return[a,b,e]}},{key:"_setValueParts",value:function(a,b){var e=2<arguments.length&&void 0!==arguments[2]?arguments[2]:!1,h=this._normalizeParts(a,b),g=r(h,3);h=g[0];var l=g[1];g=g[2];var p=d._checkIfInRangeWithOverrideOption(g,this.settings),q=r(p,2);p=q[0];q=q[1];if(p&&q){p=d._truncateDecimalPlaces(g,this.settings,e,this.settings.decimalPlacesRawValue).replace(this.settings.decimalCharacter,".");if(""===p||p===this.settings.negativeSignCharacter){switch(this.settings.emptyInputBehavior){case d.options.emptyInputBehavior.focus:case d.options.emptyInputBehavior.press:case d.options.emptyInputBehavior.always:p=
"";break;case d.options.emptyInputBehavior.min:p=this.settings.minimumValue;break;case d.options.emptyInputBehavior.max:p=this.settings.maximumValue;break;case d.options.emptyInputBehavior.zero:p="0";break;case d.options.emptyInputBehavior["null"]:p=null;break;default:p=this.settings.emptyInputBehavior}this._setRawValue(p)}else this._setRawValue(this._trimLeadingAndTrailingZeros(p));e=d._truncateDecimalPlaces(g,this.settings,e,this.settings.decimalPlacesShownOnFocus);g=h.length;g>e.length&&(g=e.length);
1===g&&"0"===h&&this.settings.leadingZero===d.options.leadingZero.deny&&(g=""===l||"0"===h&&""!==l?1:0);this._setElementValue(e,!1);this._setCaretPosition(g);return!0}this._triggerRangeEvents(p,q);return!1}},{key:"_getSignPosition",value:function(){if(this.settings.currencySymbol){var a=this.settings.currencySymbol.length;var b=c["default"].getElementValue(this.domElement);this.settings.currencySymbolPlacement===d.options.currencySymbolPlacement.prefix?a=this.settings.negativeSignCharacter&&b&&b.charAt(0)===
this.settings.negativeSignCharacter?[1,a+1]:[0,a]:(b=b.length,a=[b-a,b])}else a=[1E3,-1];return a}},{key:"_expandSelectionOnSign",value:function(){var a=this._getSignPosition(),b=r(a,2);a=b[0];b=b[1];var e=this.selection;e.start<b&&e.end>a&&((e.start<a||e.end>b)&&c["default"].getElementValue(this.domElement).substring(Math.max(e.start,a),Math.min(e.end,b)).match(/^\s*$/)?e.start<a?this._setSelection(e.start,a):this._setSelection(b,e.end):this._setSelection(Math.min(e.start,a),Math.max(e.end,b)))}},
{key:"_checkPaste",value:function(){if(!this.formatted&&!c["default"].isUndefined(this.valuePartsBeforePaste)){var a=this.valuePartsBeforePaste,b=this._getLeftAndRightPartAroundTheSelection(),e=r(b,2);b=e[0];e=e[1];delete this.valuePartsBeforePaste;b=b.substr(0,a[0].length)+d._stripAllNonNumberCharactersExceptCustomDecimalChar(b.substr(a[0].length),this.settings,!0,this.isFocused);this._setValueParts(b,e,!0)||(this._setElementValue(a.join(""),!1),this._setCaretPosition(a[0].length))}}},{key:"_processNonPrintableKeysAndShortcuts",
value:function(a){if((a.ctrlKey||a.metaKey)&&"keyup"===a.type&&!c["default"].isUndefined(this.valuePartsBeforePaste)||a.shiftKey&&this.eventKey===w["default"].keyName.Insert)return this._checkPaste(),!1;if(this.constructor._shouldSkipEventKey(this.eventKey))return!0;if((a.ctrlKey||a.metaKey)&&this.eventKey===w["default"].keyName.a)return this.settings.selectNumberOnly&&(a.preventDefault(),this.selectNumber()),!0;if((a.ctrlKey||a.metaKey)&&(this.eventKey===w["default"].keyName.c||this.eventKey===w["default"].keyName.v||
this.eventKey===w["default"].keyName.x)){"keydown"===a.type&&this._expandSelectionOnSign();if(this.eventKey===w["default"].keyName.v||this.eventKey===w["default"].keyName.Insert)"keydown"===a.type||"keypress"===a.type?c["default"].isUndefined(this.valuePartsBeforePaste)&&(this.valuePartsBeforePaste=this._getLeftAndRightPartAroundTheSelection()):this._checkPaste();return"keydown"===a.type||"keypress"===a.type||this.eventKey===w["default"].keyName.c}return a.ctrlKey||a.metaKey?!(this.eventKey===w["default"].keyName.Z||
this.eventKey===w["default"].keyName.z):this.eventKey===w["default"].keyName.LeftArrow||this.eventKey===w["default"].keyName.RightArrow?("keydown"!==a.type||a.shiftKey||(a=c["default"].getElementValue(this.domElement),this.eventKey!==w["default"].keyName.LeftArrow||a.charAt(this.selection.start-2)!==this.settings.digitGroupSeparator&&a.charAt(this.selection.start-2)!==this.settings.decimalCharacter?this.eventKey!==w["default"].keyName.RightArrow||a.charAt(this.selection.start+1)!==this.settings.digitGroupSeparator&&
a.charAt(this.selection.start+1)!==this.settings.decimalCharacter||this._setCaretPosition(this.selection.start+1):this._setCaretPosition(this.selection.start-1)),!0):c["default"].isInArray(this.eventKey,w["default"].keyName._directionKeys)}},{key:"_processCharacterDeletionIfTrailingNegativeSign",value:function(a){var b=r(a,2);a=b[0];b=b[1];var e=c["default"].getElementValue(this.domElement),h=c["default"].isNegative(e,this.settings.negativeSignCharacter);this.settings.currencySymbolPlacement===d.options.currencySymbolPlacement.prefix&&
this.settings.negativePositiveSignPlacement===d.options.negativePositiveSignPlacement.suffix&&(this.eventKey===w["default"].keyName.Backspace?(this.caretFix=this.selection.start>=e.indexOf(this.settings.suffixText)&&""!==this.settings.suffixText,"-"===e.charAt(this.selection.start-1)?a=a.substring(1):this.selection.start<=e.length-this.settings.suffixText.length&&(a=a.substring(0,a.length-1))):(this.caretFix=this.selection.start>=e.indexOf(this.settings.suffixText)&&""!==this.settings.suffixText,
this.selection.start>=e.indexOf(this.settings.currencySymbol)+this.settings.currencySymbol.length&&(b=b.substring(1,b.length)),c["default"].isNegative(a,this.settings.negativeSignCharacter)&&"-"===e.charAt(this.selection.start)&&(a=a.substring(1))));if(this.settings.currencySymbolPlacement===d.options.currencySymbolPlacement.suffix)switch(this.settings.negativePositiveSignPlacement){case d.options.negativePositiveSignPlacement.left:this.caretFix=this.selection.start>=e.indexOf(this.settings.negativeSignCharacter)+
this.settings.negativeSignCharacter.length;this.eventKey===w["default"].keyName.Backspace?this.selection.start===e.indexOf(this.settings.negativeSignCharacter)+this.settings.negativeSignCharacter.length&&h?a=a.substring(1):"-"!==a&&(this.selection.start<=e.indexOf(this.settings.negativeSignCharacter)||!h)&&(a=a.substring(0,a.length-1)):("-"===a[0]&&(b=b.substring(1)),this.selection.start===e.indexOf(this.settings.negativeSignCharacter)&&h&&(a=a.substring(1)));break;case d.options.negativePositiveSignPlacement.right:this.caretFix=
this.selection.start>=e.indexOf(this.settings.negativeSignCharacter)+this.settings.negativeSignCharacter.length,this.eventKey===w["default"].keyName.Backspace?this.selection.start===e.indexOf(this.settings.negativeSignCharacter)+this.settings.negativeSignCharacter.length?a=a.substring(1):"-"!==a&&this.selection.start<=e.indexOf(this.settings.negativeSignCharacter)-this.settings.currencySymbol.length?a=a.substring(0,a.length-1):""===a||h||(a=a.substring(0,a.length-1)):(this.caretFix=this.selection.start>=
e.indexOf(this.settings.currencySymbol)&&""!==this.settings.currencySymbol,this.selection.start===e.indexOf(this.settings.negativeSignCharacter)&&(a=a.substring(1)),b=b.substring(1))}return[a,b]}},{key:"_processCharacterDeletion",value:function(){if(this.selection.length){this._expandSelectionOnSign();var a=this._getUnformattedLeftAndRightPartAroundTheSelection();var b=r(a,2);a=b[0];b=b[1]}else a=this._getUnformattedLeftAndRightPartAroundTheSelection(),b=r(a,2),a=b[0],b=b[1],""===a&&""===b&&(this.throwInput=
!1),this.isTrailingNegative&&c["default"].isNegative(c["default"].getElementValue(this.domElement),this.settings.negativeSignCharacter)?(a=this._processCharacterDeletionIfTrailingNegativeSign([a,b]),b=r(a,2),a=b[0],b=b[1]):this.eventKey===w["default"].keyName.Backspace?a=a.substring(0,a.length-1):b=b.substring(1,b.length);if(!this.constructor._isWithinRangeWithOverrideOption("".concat(a).concat(b),this.settings))return!1;this._setValueParts(a,b);return!0}},{key:"_isDecimalCharacterInsertionAllowed",
value:function(){return String(this.settings.decimalPlacesShownOnFocus)!==String(d.options.decimalPlacesShownOnFocus.none)&&String(this.settings.decimalPlaces)!==String(d.options.decimalPlaces.none)}},{key:"_processCharacterInsertion",value:function(){var a=this._getUnformattedLeftAndRightPartAroundTheSelection(),b=r(a,2);a=b[0];b=b[1];this.eventKey!==w["default"].keyName.AndroidDefault&&(this.throwInput=!0);if(this.eventKey===this.settings.decimalCharacter||this.settings.decimalCharacterAlternative&&
this.eventKey===this.settings.decimalCharacterAlternative){if(!this._isDecimalCharacterInsertionAllowed()||!this.settings.decimalCharacter)return!1;if(this.settings.alwaysAllowDecimalCharacter)a=a.replace(this.settings.decimalCharacter,""),b=b.replace(this.settings.decimalCharacter,"");else{if(c["default"].contains(a,this.settings.decimalCharacter)||0<b.indexOf(this.settings.decimalCharacter))return!0;0===b.indexOf(this.settings.decimalCharacter)&&(b=b.substr(1))}this.settings.negativeSignCharacter&&
c["default"].contains(b,this.settings.negativeSignCharacter)&&(a="".concat(this.settings.negativeSignCharacter).concat(a),b=b.replace(this.settings.negativeSignCharacter,""));this._setValueParts(a+this.settings.decimalCharacter,b);return!0}if(("-"===this.eventKey||"+"===this.eventKey)&&this.settings.isNegativeSignAllowed)return""===a&&c["default"].contains(b,"-")?b=b.replace("-",""):a=c["default"].isNegativeStrict(a,"-")?a.replace("-",""):"".concat(this.settings.negativeSignCharacter).concat(a),this._setValueParts(a,
b),!0;var e=Number(this.eventKey);return 0<=e&&9>=e?(this.settings.isNegativeSignAllowed&&""===a&&c["default"].contains(b,"-")&&(a="-",b=b.substring(1,b.length)),0>=this.settings.maximumValue&&this.settings.minimumValue<this.settings.maximumValue&&!c["default"].contains(c["default"].getElementValue(this.domElement),this.settings.negativeSignCharacter)&&"0"!==this.eventKey&&(a="-".concat(a)),this._setValueParts("".concat(a).concat(this.eventKey),b),!0):this.throwInput=!1}},{key:"_formatValue",value:function(a){var b=
c["default"].getElementValue(this.domElement),e=this._getUnformattedLeftAndRightPartAroundTheSelection(),h=r(e,1)[0];if((""===this.settings.digitGroupSeparator||""!==this.settings.digitGroupSeparator&&!c["default"].contains(b,this.settings.digitGroupSeparator))&&(""===this.settings.currencySymbol||""!==this.settings.currencySymbol&&!c["default"].contains(b,this.settings.currencySymbol))){e=b.split(this.settings.decimalCharacter);e=r(e,1)[0];var g="";c["default"].isNegative(e,this.settings.negativeSignCharacter)&&
(g=this.settings.negativeSignCharacter,e=e.replace(this.settings.negativeSignCharacter,""),h=h.replace("-",""));""===g&&e.length>this.settings.mIntPos&&"0"===h.charAt(0)&&(h=h.slice(1));g===this.settings.negativeSignCharacter&&e.length>this.settings.mIntNeg&&"0"===h.charAt(0)&&(h=h.slice(1));this.isTrailingNegative||(h="".concat(g).concat(h))}e=this.constructor._addGroupSeparators(b,this.settings,this.isFocused,this.rawValue);g=e.length;if(e){h=h.split("");if((this.settings.negativePositiveSignPlacement===
d.options.negativePositiveSignPlacement.suffix||this.settings.negativePositiveSignPlacement!==d.options.negativePositiveSignPlacement.prefix&&this.settings.currencySymbolPlacement===d.options.currencySymbolPlacement.suffix)&&h[0]===this.settings.negativeSignCharacter&&!this.settings.isNegativeSignAllowed&&(h.shift(),(this.eventKey===w["default"].keyName.Backspace||this.eventKey===w["default"].keyName.Delete)&&this.caretFix)){if(this.settings.currencySymbolPlacement===d.options.currencySymbolPlacement.suffix&&
this.settings.negativePositiveSignPlacement===d.options.negativePositiveSignPlacement.left||this.settings.currencySymbolPlacement===d.options.currencySymbolPlacement.prefix&&this.settings.negativePositiveSignPlacement===d.options.negativePositiveSignPlacement.suffix)h.push(this.settings.negativeSignCharacter),this.caretFix="keydown"===a.type;if(this.settings.currencySymbolPlacement===d.options.currencySymbolPlacement.suffix&&this.settings.negativePositiveSignPlacement===d.options.negativePositiveSignPlacement.right){var l=
this.settings.currencySymbol.split(""),p="\\^$.|?*+()[".split(""),q=[];l.forEach(function(t,B){B=l[t];c["default"].isInArray(B,p)?q.push("\\"+B):q.push(B)});this.eventKey===w["default"].keyName.Backspace&&"-"===this.settings.negativeSignCharacter&&q.push("-");h.push(q.join(""));this.caretFix="keydown"===a.type}}for(a=0;a<h.length;a++)h[a].match("\\d")||(h[a]="\\"+h[a]);a=this.settings.currencySymbolPlacement===d.options.currencySymbolPlacement.suffix?new RegExp("^.*?".concat(h.join(".*?"))):new RegExp("^.*?".concat(this.settings.currencySymbol).concat(h.join(".*?")));
(a=e.match(a))?(g=a[0].length,this.settings.showPositiveSign&&(0===g&&a.input.charAt(0)===this.settings.positiveSignCharacter&&(g=1===a.input.indexOf(this.settings.currencySymbol)?this.settings.currencySymbol.length+1:1),0===g&&a.input.charAt(this.settings.currencySymbol.length)===this.settings.positiveSignCharacter&&(g=this.settings.currencySymbol.length+1)),(0===g&&e.charAt(0)!==this.settings.negativeSignCharacter||1===g&&e.charAt(0)===this.settings.negativeSignCharacter)&&this.settings.currencySymbol&&
this.settings.currencySymbolPlacement===d.options.currencySymbolPlacement.prefix&&(g=this.settings.currencySymbol.length+(c["default"].isNegativeStrict(e,this.settings.negativeSignCharacter)?1:0))):(this.settings.currencySymbol&&this.settings.currencySymbolPlacement===d.options.currencySymbolPlacement.suffix&&(g-=this.settings.currencySymbol.length),this.settings.suffixText&&(g-=this.settings.suffixText.length))}e!==b&&(this._setElementValue(e,!1),this._setCaretPosition(g));this.formatted=!0}}],[{key:"version",
value:function(){return"4.6.0"}},{key:"_setArgumentsValues",value:function(a,b,e){c["default"].isNull(a)&&c["default"].throwError("At least one valid parameter is needed in order to initialize an AutoNumeric object");var h=c["default"].isElement(a),g=c["default"].isString(a),l=c["default"].isObject(b),p=Array.isArray(b)&&0<b.length,q=c["default"].isNumberOrArabic(b)||""===b,t=this._isPreDefinedOptionValid(b),B=c["default"].isNull(b),F=c["default"].isEmptyString(b),I=c["default"].isObject(e),K=Array.isArray(e)&&
0<e.length,L=c["default"].isNull(e),M=this._isPreDefinedOptionValid(e),G;if(h&&B&&L){var H=a;var J=G=null}else h&&q&&L?(H=a,G=b,J=null):h&&l&&L?(H=a,G=null,J=b):h&&t&&L?(H=a,G=null,J=this._getOptionObject(b)):h&&p&&L?(H=a,G=null,J=this.mergeOptions(b)):h&&(B||F)&&I?(H=a,G=null,J=e):h&&(B||F)&&K?(H=a,G=null,J=this.mergeOptions(e)):g&&B&&L?(H=document.querySelector(a),J=G=null):g&&l&&L?(H=document.querySelector(a),G=null,J=b):g&&t&&L?(H=document.querySelector(a),G=null,J=this._getOptionObject(b)):g&&
p&&L?(H=document.querySelector(a),G=null,J=this.mergeOptions(b)):g&&(B||F)&&I?(H=document.querySelector(a),G=null,J=e):g&&(B||F)&&K?(H=document.querySelector(a),G=null,J=this.mergeOptions(e)):g&&q&&L?(H=document.querySelector(a),G=b,J=null):g&&q&&I?(H=document.querySelector(a),G=b,J=e):g&&q&&M?(H=document.querySelector(a),G=b,J=this._getOptionObject(e)):g&&q&&K?(H=document.querySelector(a),G=b,J=this.mergeOptions(e)):h&&q&&I?(H=a,G=b,J=e):h&&q&&M?(H=a,G=b,J=this._getOptionObject(e)):h&&q&&K?(H=a,
G=b,J=this.mergeOptions(e)):c["default"].throwError("The parameters given to the AutoNumeric object are not valid, '".concat(a,"', '").concat(b,"' and '").concat(e,"' given."));c["default"].isNull(H)&&c["default"].throwError("The selector '".concat(a,"' did not select any valid DOM element. Please check on which element you called AutoNumeric."));return{domElement:H,initialValue:G,userOptions:J}}},{key:"mergeOptions",value:function(a){var b=this,e={};a.forEach(function(h){z(e,b._getOptionObject(h))});
return e}},{key:"_isPreDefinedOptionValid",value:function(a){return Object.prototype.hasOwnProperty.call(d.predefinedOptions,a)}},{key:"_getOptionObject",value:function(a){if(c["default"].isString(a)){var b=d.getPredefinedOptions()[a];void 0!==b&&null!==b||c["default"].warning("The given pre-defined option [".concat(a,"] is not recognized by autoNumeric. Please check that pre-defined option name."),!0)}else b=a;return b}},{key:"_doesFormHandlerListExists",value:function(){var a=y(window.aNFormHandlerMap);
return"undefined"!==a&&"object"===a}},{key:"_createFormHandlerList",value:function(){window.aNFormHandlerMap=new Map}},{key:"_checkValuesToStringsArray",value:function(a,b){return c["default"].isInArray(String(a),b)}},{key:"_checkValuesToStringsSettings",value:function(a,b){return this._checkValuesToStringsArray(a,Object.keys(b.valuesToStrings))}},{key:"_checkStringsToValuesSettings",value:function(a,b){return this._checkValuesToStringsArray(a,Object.values(b.valuesToStrings))}},{key:"_unformatAltHovered",
value:function(a){a.hoveredWithAlt=!0;a.unformat()}},{key:"_reformatAltHovered",value:function(a){a.hoveredWithAlt=!1;a.reformat()}},{key:"_getChildANInputElement",value:function(a){var b=this;a=a.getElementsByTagName("input");var e=[];Array.prototype.slice.call(a,0).forEach(function(h){b.test(h)&&e.push(h)});return e}},{key:"test",value:function(a){return this._isInGlobalList(c["default"].domElement(a))}},{key:"_createWeakMap",value:function(a){window[a]=new WeakMap}},{key:"_createGlobalList",value:function(){this.autoNumericGlobalListName=
"autoNumericGlobalList";this._createWeakMap(this.autoNumericGlobalListName)}},{key:"_doesGlobalListExists",value:function(){var a=y(window[this.autoNumericGlobalListName]);return"undefined"!==a&&"object"===a}},{key:"_addToGlobalList",value:function(a){this._doesGlobalListExists()||this._createGlobalList();var b=a.node();if(this._isInGlobalList(b)){if(this._getFromGlobalList(b)===this)return;c["default"].warning("A reference to the DOM element you just initialized already exists in the global AutoNumeric element list. Please make sure to not initialize the same DOM element multiple times.",
a.getSettings().showWarnings)}window[this.autoNumericGlobalListName].set(b,a)}},{key:"_removeFromGlobalList",value:function(a){if(this._doesGlobalListExists())window[this.autoNumericGlobalListName]["delete"](a.node())}},{key:"_getFromGlobalList",value:function(a){return this._doesGlobalListExists()?window[this.autoNumericGlobalListName].get(a):null}},{key:"_isInGlobalList",value:function(a){return this._doesGlobalListExists()?window[this.autoNumericGlobalListName].has(a):!1}},{key:"validate",value:function(a){var b=
1<arguments.length&&void 0!==arguments[1]?arguments[1]:!0,e=2<arguments.length&&void 0!==arguments[2]?arguments[2]:null;!c["default"].isUndefinedOrNullOrEmpty(a)&&c["default"].isObject(a)||c["default"].throwError("The userOptions are invalid ; it should be a valid object, [".concat(a,"] given."));var h=c["default"].isObject(e);h||c["default"].isNull(e)||c["default"].throwError("The 'originalOptions' parameter is invalid ; it should either be a valid option object or `null`, [".concat(a,"] given."));
c["default"].isNull(a)||this._convertOldOptionsToNewOnes(a);b=b?z({},this.getDefaultConfig(),a):a;c["default"].isTrueOrFalseString(b.showWarnings)||c["default"].isBoolean(b.showWarnings)||c["default"].throwError("The debug option 'showWarnings' is invalid ; it should be either 'true' or 'false', [".concat(b.showWarnings,"] given."));var g=/^[0-9]+$/,l=/[0-9]+/,p=/^-?[0-9]+(\.?[0-9]+)?$/,q=/^[0-9]+(\.?[0-9]+)?$/;c["default"].isTrueOrFalseString(b.allowDecimalPadding)||c["default"].isBoolean(b.allowDecimalPadding)||
b.allowDecimalPadding===d.options.allowDecimalPadding.floats||c["default"].throwError("The decimal padding option 'allowDecimalPadding' is invalid ; it should either be `false`, `true` or `'floats'`, [".concat(b.allowDecimalPadding,"] given."));b.allowDecimalPadding!==d.options.allowDecimalPadding.never&&"false"!==b.allowDecimalPadding||b.decimalPlaces===d.options.decimalPlaces.none&&b.decimalPlacesShownOnBlur===d.options.decimalPlacesShownOnBlur.none&&b.decimalPlacesShownOnFocus===d.options.decimalPlacesShownOnFocus.none||
c["default"].warning("Setting 'allowDecimalPadding' to [".concat(b.allowDecimalPadding,"] will override the current 'decimalPlaces*' settings [").concat(b.decimalPlaces,", ").concat(b.decimalPlacesShownOnBlur," and ").concat(b.decimalPlacesShownOnFocus,"]."),b.showWarnings);c["default"].isTrueOrFalseString(b.alwaysAllowDecimalCharacter)||c["default"].isBoolean(b.alwaysAllowDecimalCharacter)||c["default"].throwError("The option 'alwaysAllowDecimalCharacter' is invalid ; it should either be `true` or `false`, [".concat(b.alwaysAllowDecimalCharacter,
"] given."));c["default"].isNull(b.caretPositionOnFocus)||c["default"].isInArray(b.caretPositionOnFocus,[d.options.caretPositionOnFocus.start,d.options.caretPositionOnFocus.end,d.options.caretPositionOnFocus.decimalLeft,d.options.caretPositionOnFocus.decimalRight])||c["default"].throwError("The display on empty string option 'caretPositionOnFocus' is invalid ; it should either be `null`, 'focus', 'press', 'always' or 'zero', [".concat(b.caretPositionOnFocus,"] given."));e=h?e:this._correctCaretPositionOnFocusAndSelectOnFocusOptions(a);
c["default"].isNull(e)||e.caretPositionOnFocus===d.options.caretPositionOnFocus.doNoForceCaretPosition||e.selectOnFocus!==d.options.selectOnFocus.select||c["default"].warning("The 'selectOnFocus' option is set to 'select', which is in conflict with the 'caretPositionOnFocus' which is set to '".concat(e.caretPositionOnFocus,"'. As a result, if this has been called when instantiating an AutoNumeric object, the 'selectOnFocus' option is forced to 'doNotSelect'."),b.showWarnings);c["default"].isInArray(b.digitGroupSeparator,
[d.options.digitGroupSeparator.comma,d.options.digitGroupSeparator.dot,d.options.digitGroupSeparator.normalSpace,d.options.digitGroupSeparator.thinSpace,d.options.digitGroupSeparator.narrowNoBreakSpace,d.options.digitGroupSeparator.noBreakSpace,d.options.digitGroupSeparator.noSeparator,d.options.digitGroupSeparator.apostrophe,d.options.digitGroupSeparator.arabicThousandsSeparator,d.options.digitGroupSeparator.dotAbove,d.options.digitGroupSeparator.privateUseTwo])||c["default"].throwError("The thousand separator character option 'digitGroupSeparator' is invalid ; it should be ',', '.', '\u066c', '\u02d9', \"'\", '\u0092', ' ', '\u2009', '\u202f', '\u00a0' or empty (''), [".concat(b.digitGroupSeparator,
"] given."));c["default"].isTrueOrFalseString(b.showOnlyNumbersOnFocus)||c["default"].isBoolean(b.showOnlyNumbersOnFocus)||c["default"].throwError("The 'showOnlyNumbersOnFocus' option is invalid ; it should be either 'true' or 'false', [".concat(b.showOnlyNumbersOnFocus,"] given."));c["default"].isInArray(b.digitalGroupSpacing,[d.options.digitalGroupSpacing.two,d.options.digitalGroupSpacing.twoScaled,d.options.digitalGroupSpacing.three,d.options.digitalGroupSpacing.four])||2<=b.digitalGroupSpacing&&
4>=b.digitalGroupSpacing||c["default"].throwError("The grouping separator option for thousands 'digitalGroupSpacing' is invalid ; it should be '2', '2s', '3', or '4', [".concat(b.digitalGroupSpacing,"] given."));c["default"].isInArray(b.decimalCharacter,[d.options.decimalCharacter.comma,d.options.decimalCharacter.dot,d.options.decimalCharacter.middleDot,d.options.decimalCharacter.arabicDecimalSeparator,d.options.decimalCharacter.decimalSeparatorKeySymbol])||c["default"].throwError("The decimal separator character option 'decimalCharacter' is invalid ; it should be '.', ',', '\u00b7', '\u2396' or '\u066b', [".concat(b.decimalCharacter,
"] given."));b.decimalCharacter===b.digitGroupSeparator&&c["default"].throwError("autoNumeric will not function properly when the decimal character 'decimalCharacter' [".concat(b.decimalCharacter,"] and the thousand separator 'digitGroupSeparator' [").concat(b.digitGroupSeparator,"] are the same character."));c["default"].isNull(b.decimalCharacterAlternative)||c["default"].isString(b.decimalCharacterAlternative)||c["default"].throwError("The alternate decimal separator character option 'decimalCharacterAlternative' is invalid ; it should be a string, [".concat(b.decimalCharacterAlternative,
"] given."));""===b.currencySymbol||c["default"].isString(b.currencySymbol)||c["default"].throwError("The currency symbol option 'currencySymbol' is invalid ; it should be a string, [".concat(b.currencySymbol,"] given."));c["default"].isInArray(b.currencySymbolPlacement,[d.options.currencySymbolPlacement.prefix,d.options.currencySymbolPlacement.suffix])||c["default"].throwError("The placement of the currency sign option 'currencySymbolPlacement' is invalid ; it should either be 'p' (prefix) or 's' (suffix), [".concat(b.currencySymbolPlacement,
"] given."));c["default"].isInArray(b.negativePositiveSignPlacement,[d.options.negativePositiveSignPlacement.prefix,d.options.negativePositiveSignPlacement.suffix,d.options.negativePositiveSignPlacement.left,d.options.negativePositiveSignPlacement.right,d.options.negativePositiveSignPlacement.none])||c["default"].throwError("The placement of the negative sign option 'negativePositiveSignPlacement' is invalid ; it should either be 'p' (prefix), 's' (suffix), 'l' (left), 'r' (right) or 'null', [".concat(b.negativePositiveSignPlacement,
"] given."));c["default"].isTrueOrFalseString(b.showPositiveSign)||c["default"].isBoolean(b.showPositiveSign)||c["default"].throwError("The show positive sign option 'showPositiveSign' is invalid ; it should be either 'true' or 'false', [".concat(b.showPositiveSign,"] given."));(!c["default"].isString(b.suffixText)||""!==b.suffixText&&(c["default"].isNegative(b.suffixText,b.negativeSignCharacter)||l.test(b.suffixText)))&&c["default"].throwError("The additional suffix option 'suffixText' is invalid ; it should not contains the negative sign '".concat(b.negativeSignCharacter,
"' nor any numerical characters, [").concat(b.suffixText,"] given."));(!c["default"].isString(b.negativeSignCharacter)||1!==b.negativeSignCharacter.length||c["default"].isUndefinedOrNullOrEmpty(b.negativeSignCharacter)||l.test(b.negativeSignCharacter))&&c["default"].throwError("The negative sign character option 'negativeSignCharacter' is invalid ; it should be a single character, and cannot be any numerical characters, [".concat(b.negativeSignCharacter,"] given."));(!c["default"].isString(b.positiveSignCharacter)||
1!==b.positiveSignCharacter.length||c["default"].isUndefinedOrNullOrEmpty(b.positiveSignCharacter)||l.test(b.positiveSignCharacter))&&c["default"].throwError("The positive sign character option 'positiveSignCharacter' is invalid ; it should be a single character, and cannot be any numerical characters, [".concat(b.positiveSignCharacter,"] given.\nIf you want to hide the positive sign character, you need to set the `showPositiveSign` option to `true`."));b.negativeSignCharacter===b.positiveSignCharacter&&
c["default"].throwError("The positive 'positiveSignCharacter' and negative 'negativeSignCharacter' sign characters cannot be identical ; [".concat(b.negativeSignCharacter,"] given."));e=c["default"].isNull(b.negativeBracketsTypeOnBlur)?["",""]:b.negativeBracketsTypeOnBlur.split(",");h=r(e,2);e=h[0];h=h[1];(c["default"].contains(b.digitGroupSeparator,b.negativeSignCharacter)||c["default"].contains(b.decimalCharacter,b.negativeSignCharacter)||c["default"].contains(b.decimalCharacterAlternative,b.negativeSignCharacter)||
c["default"].contains(e,b.negativeSignCharacter)||c["default"].contains(h,b.negativeSignCharacter)||c["default"].contains(b.suffixText,b.negativeSignCharacter))&&c["default"].throwError("The negative sign character option 'negativeSignCharacter' is invalid ; it should not be equal or a part of the digit separator, the decimal character, the decimal character alternative, the negative brackets or the suffix text, [".concat(b.negativeSignCharacter,"] given."));(c["default"].contains(b.digitGroupSeparator,
b.positiveSignCharacter)||c["default"].contains(b.decimalCharacter,b.positiveSignCharacter)||c["default"].contains(b.decimalCharacterAlternative,b.positiveSignCharacter)||c["default"].contains(e,b.positiveSignCharacter)||c["default"].contains(h,b.positiveSignCharacter)||c["default"].contains(b.suffixText,b.positiveSignCharacter))&&c["default"].throwError("The positive sign character option 'positiveSignCharacter' is invalid ; it should not be equal or a part of the digit separator, the decimal character, the decimal character alternative, the negative brackets or the suffix text, [".concat(b.positiveSignCharacter,
"] given."));c["default"].isNull(b.overrideMinMaxLimits)||c["default"].isInArray(b.overrideMinMaxLimits,[d.options.overrideMinMaxLimits.ceiling,d.options.overrideMinMaxLimits.floor,d.options.overrideMinMaxLimits.ignore,d.options.overrideMinMaxLimits.invalid])||c["default"].throwError("The override min \x26 max limits option 'overrideMinMaxLimits' is invalid ; it should either be 'ceiling', 'floor', 'ignore' or 'invalid', [".concat(b.overrideMinMaxLimits,"] given."));b.overrideMinMaxLimits!==d.options.overrideMinMaxLimits.invalid&&
b.overrideMinMaxLimits!==d.options.overrideMinMaxLimits.ignore&&(0<b.minimumValue||0>b.maximumValue)&&c["default"].warning("You've set a `minimumValue` or a `maximumValue` excluding the value `0`. AutoNumeric will force the users to always have a valid value in the input, hence preventing them to clear the field. If you want to allow for temporary invalid values (ie. out-of-range), you should use the 'invalid' option for the 'overrideMinMaxLimits' setting.");c["default"].isString(b.maximumValue)&&
p.test(b.maximumValue)||c["default"].throwError("The maximum possible value option 'maximumValue' is invalid ; it should be a string that represents a positive or negative number, [".concat(b.maximumValue,"] given."));c["default"].isString(b.minimumValue)&&p.test(b.minimumValue)||c["default"].throwError("The minimum possible value option 'minimumValue' is invalid ; it should be a string that represents a positive or negative number, [".concat(b.minimumValue,"] given."));parseFloat(b.minimumValue)>
parseFloat(b.maximumValue)&&c["default"].throwError("The minimum possible value option is greater than the maximum possible value option ; 'minimumValue' [".concat(b.minimumValue,"] should be smaller than 'maximumValue' [").concat(b.maximumValue,"]."));c["default"].isInt(b.decimalPlaces)&&0<=b.decimalPlaces||c["default"].isString(b.decimalPlaces)&&g.test(b.decimalPlaces)||c["default"].throwError("The number of decimal places option 'decimalPlaces' is invalid ; it should be a positive integer, [".concat(b.decimalPlaces,
"] given."));c["default"].isNull(b.decimalPlacesRawValue)||c["default"].isInt(b.decimalPlacesRawValue)&&0<=b.decimalPlacesRawValue||c["default"].isString(b.decimalPlacesRawValue)&&g.test(b.decimalPlacesRawValue)||c["default"].throwError("The number of decimal places for the raw value option 'decimalPlacesRawValue' is invalid ; it should be a positive integer or `null`, [".concat(b.decimalPlacesRawValue,"] given."));this._validateDecimalPlacesRawValue(b);c["default"].isNull(b.decimalPlacesShownOnFocus)||
g.test(String(b.decimalPlacesShownOnFocus))||c["default"].throwError("The number of expanded decimal places option 'decimalPlacesShownOnFocus' is invalid ; it should be a positive integer or `null`, [".concat(b.decimalPlacesShownOnFocus,"] given."));!c["default"].isNull(b.decimalPlacesShownOnFocus)&&Number(b.decimalPlaces)>Number(b.decimalPlacesShownOnFocus)&&c["default"].warning("The extended decimal places 'decimalPlacesShownOnFocus' [".concat(b.decimalPlacesShownOnFocus,"] should be greater than the 'decimalPlaces' [").concat(b.decimalPlaces,
"] value. Currently, this will limit the ability of your user to manually change some of the decimal places. Do you really want to do that?"),b.showWarnings);(c["default"].isNull(b.divisorWhenUnfocused)||q.test(b.divisorWhenUnfocused))&&0!==b.divisorWhenUnfocused&&"0"!==b.divisorWhenUnfocused&&1!==b.divisorWhenUnfocused&&"1"!==b.divisorWhenUnfocused||c["default"].throwError("The divisor option 'divisorWhenUnfocused' is invalid ; it should be a positive number higher than one, preferably an integer, [".concat(b.divisorWhenUnfocused,
"] given."));c["default"].isNull(b.decimalPlacesShownOnBlur)||g.test(b.decimalPlacesShownOnBlur)||c["default"].throwError("The number of decimals shown when unfocused option 'decimalPlacesShownOnBlur' is invalid ; it should be a positive integer or `null`, [".concat(b.decimalPlacesShownOnBlur,"] given."));c["default"].isNull(b.symbolWhenUnfocused)||c["default"].isString(b.symbolWhenUnfocused)||c["default"].throwError("The symbol to show when unfocused option 'symbolWhenUnfocused' is invalid ; it should be a string, [".concat(b.symbolWhenUnfocused,
"] given."));c["default"].isTrueOrFalseString(b.saveValueToSessionStorage)||c["default"].isBoolean(b.saveValueToSessionStorage)||c["default"].throwError("The save to session storage option 'saveValueToSessionStorage' is invalid ; it should be either 'true' or 'false', [".concat(b.saveValueToSessionStorage,"] given."));c["default"].isInArray(b.onInvalidPaste,[d.options.onInvalidPaste.error,d.options.onInvalidPaste.ignore,d.options.onInvalidPaste.clamp,d.options.onInvalidPaste.truncate,d.options.onInvalidPaste.replace])||
c["default"].throwError("The paste behavior option 'onInvalidPaste' is invalid ; it should either be 'error', 'ignore', 'clamp', 'truncate' or 'replace' (cf. documentation), [".concat(b.onInvalidPaste,"] given."));c["default"].isInArray(b.roundingMethod,[d.options.roundingMethod.halfUpSymmetric,d.options.roundingMethod.halfUpAsymmetric,d.options.roundingMethod.halfDownSymmetric,d.options.roundingMethod.halfDownAsymmetric,d.options.roundingMethod.halfEvenBankersRounding,d.options.roundingMethod.upRoundAwayFromZero,
d.options.roundingMethod.downRoundTowardZero,d.options.roundingMethod.toCeilingTowardPositiveInfinity,d.options.roundingMethod.toFloorTowardNegativeInfinity,d.options.roundingMethod.toNearest05,d.options.roundingMethod.toNearest05Alt,d.options.roundingMethod.upToNext05,d.options.roundingMethod.downToNext05])||c["default"].throwError("The rounding method option 'roundingMethod' is invalid ; it should either be 'S', 'A', 's', 'a', 'B', 'U', 'D', 'C', 'F', 'N05', 'CHF', 'U05' or 'D05' (cf. documentation), [".concat(b.roundingMethod,
"] given."));c["default"].isNull(b.negativeBracketsTypeOnBlur)||c["default"].isInArray(b.negativeBracketsTypeOnBlur,[d.options.negativeBracketsTypeOnBlur.parentheses,d.options.negativeBracketsTypeOnBlur.brackets,d.options.negativeBracketsTypeOnBlur.chevrons,d.options.negativeBracketsTypeOnBlur.curlyBraces,d.options.negativeBracketsTypeOnBlur.angleBrackets,d.options.negativeBracketsTypeOnBlur.japaneseQuotationMarks,d.options.negativeBracketsTypeOnBlur.halfBrackets,d.options.negativeBracketsTypeOnBlur.whiteSquareBrackets,
d.options.negativeBracketsTypeOnBlur.quotationMarks,d.options.negativeBracketsTypeOnBlur.guillemets])||c["default"].throwError("The brackets for negative values option 'negativeBracketsTypeOnBlur' is invalid ; it should either be '(,)', '[,]', '\x3c,\x3e', '{,}', '\u3008,\u3009', '\uff62,\uff63', '\u2e24,\u2e25', '\u27e6,\u27e7', '\u2039,\u203a' or '\u00ab,\u00bb', [".concat(b.negativeBracketsTypeOnBlur,"] given."));(c["default"].isString(b.emptyInputBehavior)||c["default"].isNumber(b.emptyInputBehavior))&&
(c["default"].isInArray(b.emptyInputBehavior,[d.options.emptyInputBehavior.focus,d.options.emptyInputBehavior.press,d.options.emptyInputBehavior.always,d.options.emptyInputBehavior.min,d.options.emptyInputBehavior.max,d.options.emptyInputBehavior.zero,d.options.emptyInputBehavior["null"]])||p.test(b.emptyInputBehavior))||c["default"].throwError("The display on empty string option 'emptyInputBehavior' is invalid ; it should either be 'focus', 'press', 'always', 'min', 'max', 'zero', 'null', a number, or a string that represents a number, [".concat(b.emptyInputBehavior,
"] given."));b.emptyInputBehavior===d.options.emptyInputBehavior.zero&&(0<b.minimumValue||0>b.maximumValue)&&c["default"].throwError("The 'emptyInputBehavior' option is set to 'zero', but this value is outside of the range defined by 'minimumValue' and 'maximumValue' [".concat(b.minimumValue,", ").concat(b.maximumValue,"]."));p.test(String(b.emptyInputBehavior))&&(this._isWithinRangeWithOverrideOption(b.emptyInputBehavior,b)||c["default"].throwError("The 'emptyInputBehavior' option is set to a number or a string that represents a number, but its value [".concat(b.emptyInputBehavior,
"] is outside of the range defined by the 'minimumValue' and 'maximumValue' options [").concat(b.minimumValue,", ").concat(b.maximumValue,"].")));c["default"].isTrueOrFalseString(b.eventBubbles)||c["default"].isBoolean(b.eventBubbles)||c["default"].throwError("The event bubbles option 'eventBubbles' is invalid ; it should be either 'true' or 'false', [".concat(b.eventBubbles,"] given."));c["default"].isTrueOrFalseString(b.eventIsCancelable)||c["default"].isBoolean(b.eventIsCancelable)||c["default"].throwError("The event is cancelable option 'eventIsCancelable' is invalid ; it should be either 'true' or 'false', [".concat(b.eventIsCancelable,
"] given."));!c["default"].isBoolean(b.invalidClass)&&/^-?[_a-zA-Z]+[_a-zA-Z0-9-]*$/.test(b.invalidClass)||c["default"].throwError("The name of the 'invalidClass' option is not a valid CSS class name ; it should not be empty, and should follow the '^-?[_a-zA-Z]+[_a-zA-Z0-9-]*$' regex, [".concat(b.invalidClass,"] given."));c["default"].isInArray(b.leadingZero,[d.options.leadingZero.allow,d.options.leadingZero.deny,d.options.leadingZero.keep])||c["default"].throwError("The leading zero behavior option 'leadingZero' is invalid ; it should either be 'allow', 'deny' or 'keep', [".concat(b.leadingZero,
"] given."));c["default"].isTrueOrFalseString(b.formatOnPageLoad)||c["default"].isBoolean(b.formatOnPageLoad)||c["default"].throwError("The format on initialization option 'formatOnPageLoad' is invalid ; it should be either 'true' or 'false', [".concat(b.formatOnPageLoad,"] given."));c["default"].isTrueOrFalseString(b.formulaMode)||c["default"].isBoolean(b.formulaMode)||c["default"].throwError("The formula mode option 'formulaMode' is invalid ; it should be either 'true' or 'false', [".concat(b.formulaMode,
"] given."));g.test(b.historySize)&&0!==b.historySize||c["default"].throwError("The history size option 'historySize' is invalid ; it should be a positive integer, [".concat(b.historySize,"] given."));c["default"].isTrueOrFalseString(b.selectNumberOnly)||c["default"].isBoolean(b.selectNumberOnly)||c["default"].throwError("The select number only option 'selectNumberOnly' is invalid ; it should be either 'true' or 'false', [".concat(b.selectNumberOnly,"] given."));c["default"].isTrueOrFalseString(b.selectOnFocus)||
c["default"].isBoolean(b.selectOnFocus)||c["default"].throwError("The select on focus option 'selectOnFocus' is invalid ; it should be either 'true' or 'false', [".concat(b.selectOnFocus,"] given."));c["default"].isNull(b.defaultValueOverride)||""===b.defaultValueOverride||p.test(b.defaultValueOverride)||c["default"].throwError("The unformatted default value option 'defaultValueOverride' is invalid ; it should be a string that represents a positive or negative number, [".concat(b.defaultValueOverride,
"] given."));c["default"].isTrueOrFalseString(b.unformatOnSubmit)||c["default"].isBoolean(b.unformatOnSubmit)||c["default"].throwError("The remove formatting on submit option 'unformatOnSubmit' is invalid ; it should be either 'true' or 'false', [".concat(b.unformatOnSubmit,"] given."));c["default"].isNull(b.valuesToStrings)||c["default"].isObject(b.valuesToStrings)||c["default"].throwError("The option 'valuesToStrings' is invalid ; it should be an object, ideally with 'key -\x3e value' entries, [".concat(b.valuesToStrings,
"] given."));c["default"].isNull(b.outputFormat)||c["default"].isInArray(b.outputFormat,[d.options.outputFormat.string,d.options.outputFormat.number,d.options.outputFormat.dot,d.options.outputFormat.negativeDot,d.options.outputFormat.comma,d.options.outputFormat.negativeComma,d.options.outputFormat.dotNegative,d.options.outputFormat.commaNegative])||c["default"].throwError("The custom locale format option 'outputFormat' is invalid ; it should either be null, 'string', 'number', '.', '-.', ',', '-,', '.-' or ',-', [".concat(b.outputFormat,
"] given."));c["default"].isTrueOrFalseString(b.isCancellable)||c["default"].isBoolean(b.isCancellable)||c["default"].throwError("The cancellable behavior option 'isCancellable' is invalid ; it should be either 'true' or 'false', [".concat(b.isCancellable,"] given."));c["default"].isTrueOrFalseString(b.modifyValueOnWheel)||c["default"].isBoolean(b.modifyValueOnWheel)||c["default"].throwError("The increment/decrement on mouse wheel option 'modifyValueOnWheel' is invalid ; it should be either 'true' or 'false', [".concat(b.modifyValueOnWheel,
"] given."));c["default"].isTrueOrFalseString(b.watchExternalChanges)||c["default"].isBoolean(b.watchExternalChanges)||c["default"].throwError("The option 'watchExternalChanges' is invalid ; it should be either 'true' or 'false', [".concat(b.watchExternalChanges,"] given."));c["default"].isInArray(b.wheelOn,[d.options.wheelOn.focus,d.options.wheelOn.hover])||c["default"].throwError("The wheel behavior option 'wheelOn' is invalid ; it should either be 'focus' or 'hover', [".concat(b.wheelOn,"] given."));
(!c["default"].isString(b.wheelStep)&&!c["default"].isNumber(b.wheelStep)||"progressive"!==b.wheelStep&&!q.test(b.wheelStep)||0===Number(b.wheelStep))&&c["default"].throwError("The wheel step value option 'wheelStep' is invalid ; it should either be the string 'progressive', or a number or a string that represents a positive number (excluding zero), [".concat(b.wheelStep,"] given."));c["default"].isInArray(b.serializeSpaces,[d.options.serializeSpaces.plus,d.options.serializeSpaces.percent])||c["default"].throwError("The space replacement character option 'serializeSpaces' is invalid ; it should either be '+' or '%20', [".concat(b.serializeSpaces,
"] given."));c["default"].isTrueOrFalseString(b.noEventListeners)||c["default"].isBoolean(b.noEventListeners)||c["default"].throwError("The option 'noEventListeners' that prevent the creation of event listeners is invalid ; it should be either 'true' or 'false', [".concat(b.noEventListeners,"] given."));c["default"].isNull(b.styleRules)||c["default"].isObject(b.styleRules)&&(Object.prototype.hasOwnProperty.call(b.styleRules,"positive")||Object.prototype.hasOwnProperty.call(b.styleRules,"negative")||
Object.prototype.hasOwnProperty.call(b.styleRules,"ranges")||Object.prototype.hasOwnProperty.call(b.styleRules,"userDefined"))||c["default"].throwError("The option 'styleRules' is invalid ; it should be a correctly structured object, with one or more 'positive', 'negative', 'ranges' or 'userDefined' attributes, [".concat(b.styleRules,"] given."));c["default"].isNull(b.styleRules)||!Object.prototype.hasOwnProperty.call(b.styleRules,"userDefined")||c["default"].isNull(b.styleRules.userDefined)||b.styleRules.userDefined.forEach(function(t){Object.prototype.hasOwnProperty.call(t,
"callback")&&!c["default"].isFunction(t.callback)&&c["default"].throwError("The callback defined in the `userDefined` attribute is not a function, ".concat(y(t.callback)," given."))});(c["default"].isNull(b.rawValueDivisor)||q.test(b.rawValueDivisor))&&0!==b.rawValueDivisor&&"0"!==b.rawValueDivisor&&1!==b.rawValueDivisor&&"1"!==b.rawValueDivisor||c["default"].throwError("The raw value divisor option 'rawValueDivisor' is invalid ; it should be a positive number higher than one, preferably an integer, [".concat(b.rawValueDivisor,
"] given."));c["default"].isTrueOrFalseString(b.readOnly)||c["default"].isBoolean(b.readOnly)||c["default"].throwError("The option 'readOnly' is invalid ; it should be either 'true' or 'false', [".concat(b.readOnly,"] given."));c["default"].isTrueOrFalseString(b.unformatOnHover)||c["default"].isBoolean(b.unformatOnHover)||c["default"].throwError("The option 'unformatOnHover' is invalid ; it should be either 'true' or 'false', [".concat(b.unformatOnHover,"] given."));c["default"].isTrueOrFalseString(b.failOnUnknownOption)||
c["default"].isBoolean(b.failOnUnknownOption)||c["default"].throwError("The debug option 'failOnUnknownOption' is invalid ; it should be either 'true' or 'false', [".concat(b.failOnUnknownOption,"] given."));c["default"].isTrueOrFalseString(b.createLocalList)||c["default"].isBoolean(b.createLocalList)||c["default"].throwError("The debug option 'createLocalList' is invalid ; it should be either 'true' or 'false', [".concat(b.createLocalList,"] given."))}},{key:"_validateDecimalPlacesRawValue",value:function(a){c["default"].isNull(a.decimalPlacesRawValue)||
(a.decimalPlacesRawValue<a.decimalPlaces&&c["default"].warning("The number of decimal places to store in the raw value [".concat(a.decimalPlacesRawValue,"] is lower than the ones to display [").concat(a.decimalPlaces,"]. This will likely confuse your users.\nTo solve that, you'd need to either set `decimalPlacesRawValue` to `null`, or set a number of decimal places for the raw value equal of bigger than `decimalPlaces`."),a.showWarnings),a.decimalPlacesRawValue<a.decimalPlacesShownOnFocus&&c["default"].warning("The number of decimal places to store in the raw value [".concat(a.decimalPlacesRawValue,
"] is lower than the ones shown on focus [").concat(a.decimalPlacesShownOnFocus,"]. This will likely confuse your users.\nTo solve that, you'd need to either set `decimalPlacesRawValue` to `null`, or set a number of decimal places for the raw value equal of bigger than `decimalPlacesShownOnFocus`."),a.showWarnings),a.decimalPlacesRawValue<a.decimalPlacesShownOnBlur&&c["default"].warning("The number of decimal places to store in the raw value [".concat(a.decimalPlacesRawValue,"] is lower than the ones shown when unfocused [").concat(a.decimalPlacesShownOnBlur,
"]. This will likely confuse your users.\nTo solve that, you'd need to either set `decimalPlacesRawValue` to `null`, or set a number of decimal places for the raw value equal of bigger than `decimalPlacesShownOnBlur`."),a.showWarnings))}},{key:"areSettingsValid",value:function(a){var b=!0;try{this.validate(a,!0)}catch(e){b=!1}return b}},{key:"getDefaultConfig",value:function(){return d.defaultSettings}},{key:"getPredefinedOptions",value:function(){return d.predefinedOptions}},{key:"_generateOptionsObjectFromOptionsArray",
value:function(a){var b=this;if(c["default"].isUndefinedOrNullOrEmpty(a)||0===a.length)var e=null;else e={},1===a.length&&Array.isArray(a[0])?a[0].forEach(function(h){z(e,b._getOptionObject(h))}):1<=a.length&&a.forEach(function(h){z(e,b._getOptionObject(h))});return e}},{key:"format",value:function(a){if(c["default"].isUndefined(a)||null===a)return null;var b=c["default"].isElement(a)?c["default"].getElementValue(a):a;c["default"].isString(b)||c["default"].isNumber(b)||c["default"].throwError('The value "'.concat(b,
'" being "set" is not numeric and therefore cannot be used appropriately.'));for(var e=arguments.length,h=Array(1<e?e-1:0),g=1;g<e;g++)h[g-1]=arguments[g];e=this._generateOptionsObjectFromOptionsArray(h);e=z({},this.getDefaultConfig(),e);e.isNegativeSignAllowed=0>b;e.isPositiveSignAllowed=0<=b;this._setBrackets(e);this._cachesUsualRegularExpressions(e,{});h=this._toNumericValue(b,e);isNaN(Number(h))&&c["default"].throwError("The value [".concat(h,"] that you are trying to format is not a recognized number."));
this._isWithinRangeWithOverrideOption(h,e)||(c["default"].triggerEvent(d.events.formatted,document,{oldValue:null,newValue:null,oldRawValue:null,newRawValue:null,isPristine:null,error:"Range test failed",aNElement:null},!0,!0),c["default"].throwError("The value [".concat(h,"] being set falls outside of the minimumValue [").concat(e.minimumValue,"] and maximumValue [").concat(e.maximumValue,"] range set for this element")));if(e.valuesToStrings&&this._checkValuesToStringsSettings(b,e))return e.valuesToStrings[b];
this._correctNegativePositiveSignPlacementOption(e);this._calculateDecimalPlacesOnInit(e);c["default"].isUndefinedOrNullOrEmpty(e.rawValueDivisor)||0===e.rawValueDivisor||""===h||null===h||(h*=e.rawValueDivisor);h=this._roundFormattedValueShownOnFocus(h,e);h=this._modifyNegativeSignAndDecimalCharacterForFormattedValue(h,e);return h=this._addGroupSeparators(h,e,!1,h)}},{key:"formatAndSet",value:function(a){var b=this.format(a,1<arguments.length&&void 0!==arguments[1]?arguments[1]:null);c["default"].setElementValue(a,
b);return b}},{key:"unformat",value:function(a){if(c["default"].isNumberStrict(a))return a;var b=c["default"].isElement(a)?c["default"].getElementValue(a):a;if(""===b)return"";if(c["default"].isUndefined(b)||null===b)return null;(c["default"].isArray(b)||c["default"].isObject(b))&&c["default"].throwError("A number or a string representing a number is needed to be able to unformat it, [".concat(b,"] given."));for(var e=arguments.length,h=Array(1<e?e-1:0),g=1;g<e;g++)h[g-1]=arguments[g];e=this._generateOptionsObjectFromOptionsArray(h);
e=z({},this.getDefaultConfig(),e);e.isNegativeSignAllowed=!1;e.isPositiveSignAllowed=!0;b=b.toString();if(e.valuesToStrings&&this._checkStringsToValuesSettings(b,e))return c["default"].objectKeyLookup(e.valuesToStrings,b);c["default"].isNegative(b,e.negativeSignCharacter)?(e.isNegativeSignAllowed=!0,e.isPositiveSignAllowed=!1):c["default"].isNull(e.negativeBracketsTypeOnBlur)||(h=e.negativeBracketsTypeOnBlur.split(","),h=r(h,2),e.firstBracket=h[0],e.lastBracket=h[1],b.charAt(0)===e.firstBracket&&
b.charAt(b.length-1)===e.lastBracket&&(e.isNegativeSignAllowed=!0,e.isPositiveSignAllowed=!1,b=this._removeBrackets(b,e,!1)));b=this._convertToNumericString(b,e);if(RegExp("[^+-0123456789.]","gi").test(b))return NaN;this._correctNegativePositiveSignPlacementOption(e);e.originalDecimalPlacesRawValue=e.decimalPlacesRawValue?e.decimalPlacesRawValue:e.decimalPlaces;this._calculateDecimalPlacesOnInit(e);c["default"].isUndefinedOrNullOrEmpty(e.rawValueDivisor)||0===e.rawValueDivisor||""===b||null===b||
(b/=e.rawValueDivisor);b=this._roundRawValue(b,e);b=b.replace(e.decimalCharacter,".");return b=this._toLocale(b,e.outputFormat,e)}},{key:"unformatAndSet",value:function(a){var b=this.unformat(a,1<arguments.length&&void 0!==arguments[1]?arguments[1]:null);c["default"].setElementValue(a,b);return b}},{key:"localize",value:function(a){var b=1<arguments.length&&void 0!==arguments[1]?arguments[1]:null;var e=c["default"].isElement(a)?c["default"].getElementValue(a):a;if(""===e)return"";c["default"].isNull(b)&&
(b=d.defaultSettings);e=this.unformat(e,b);0===Number(e)&&b.leadingZero!==d.options.leadingZero.keep&&(e="0");var h=c["default"].isNull(b)?b.outputFormat:d.defaultSettings.outputFormat;return this._toLocale(e,h,b)}},{key:"localizeAndSet",value:function(a){var b=this.localize(a,1<arguments.length&&void 0!==arguments[1]?arguments[1]:null);c["default"].setElementValue(a,b);return b}},{key:"isManagedByAutoNumeric",value:function(a){return this._isInGlobalList(c["default"].domElement(a))}},{key:"getAutoNumericElement",
value:function(a){a=c["default"].domElement(a);return this.isManagedByAutoNumeric(a)?this._getFromGlobalList(a):null}},{key:"set",value:function(a,b){var e=2<arguments.length&&void 0!==arguments[2]?arguments[2]:null,h=3<arguments.length&&void 0!==arguments[3]?arguments[3]:!0,g=c["default"].domElement(a);return this.isManagedByAutoNumeric(g)?this.getAutoNumericElement(g).set(b,e,h):(e=!c["default"].isNull(e)&&Object.prototype.hasOwnProperty.call(e,"showWarnings")?e.showWarnings:!0,c["default"].warning("Impossible to find an AutoNumeric object for the given DOM element or selector.",
e),null)}},{key:"getNumericString",value:function(a){return this._get(a,"getNumericString",1<arguments.length&&void 0!==arguments[1]?arguments[1]:null)}},{key:"getFormatted",value:function(a){return this._get(a,"getFormatted",1<arguments.length&&void 0!==arguments[1]?arguments[1]:null)}},{key:"getNumber",value:function(a){return this._get(a,"getNumber",1<arguments.length&&void 0!==arguments[1]?arguments[1]:null)}},{key:"_get",value:function(a,b){var e=2<arguments.length&&void 0!==arguments[2]?arguments[2]:
null,h=c["default"].domElement(a);this.isManagedByAutoNumeric(h)||c["default"].throwError("Impossible to find an AutoNumeric object for the given DOM element or selector.");return this.getAutoNumericElement(h)[b](e)}},{key:"getLocalized",value:function(a){var b=1<arguments.length&&void 0!==arguments[1]?arguments[1]:null,e=2<arguments.length&&void 0!==arguments[2]?arguments[2]:null,h=c["default"].domElement(a);this.isManagedByAutoNumeric(h)||c["default"].throwError("Impossible to find an AutoNumeric object for the given DOM element or selector.");
return this.getAutoNumericElement(h).getLocalized(b,e)}},{key:"_stripAllNonNumberCharacters",value:function(a,b,e,h){return this._stripAllNonNumberCharactersExceptCustomDecimalChar(a,b,e,h).replace(b.decimalCharacter,".")}},{key:"_stripAllNonNumberCharactersExceptCustomDecimalChar",value:function(a,b,e,h){a=this._normalizeCurrencySuffixAndNegativeSignCharacters(a,b);a=a.replace(b.allowedAutoStrip,"");var g=a.match(b.numRegAutoStrip);a=g?[g[1],g[2],g[3]].join(""):"";if(b.leadingZero===d.options.leadingZero.allow||
b.leadingZero===d.options.leadingZero.keep){g="";a=a.split(b.decimalCharacter);var l=r(a,2);a=l[1];l=l[0];c["default"].contains(l,b.negativeSignCharacter)&&(g=b.negativeSignCharacter,l=l.replace(b.negativeSignCharacter,""));""===g&&l.length>b.mIntPos&&"0"===l.charAt(0)&&(l=l.slice(1));""!==g&&l.length>b.mIntNeg&&"0"===l.charAt(0)&&(l=l.slice(1));a="".concat(g).concat(l).concat(c["default"].isUndefined(a)?"":b.decimalCharacter+a)}if(e&&b.leadingZero===d.options.leadingZero.deny||!h&&b.leadingZero===
d.options.leadingZero.allow)a=a.replace(b.stripReg,"$1$2");return a}},{key:"_toggleNegativeBracket",value:function(a,b,e){return e?this._removeBrackets(a,b):this._addBrackets(a,b)}},{key:"_addBrackets",value:function(a,b){return c["default"].isNull(b.negativeBracketsTypeOnBlur)?a:"".concat(b.firstBracket).concat(a.replace(b.negativeSignCharacter,"")).concat(b.lastBracket)}},{key:"_removeBrackets",value:function(a,b){var e=2<arguments.length&&void 0!==arguments[2]?arguments[2]:!0;if(c["default"].isNull(b.negativeBracketsTypeOnBlur)||
a.charAt(0)!==b.firstBracket)var h=a;else h=a.replace(b.firstBracket,""),h=h.replace(b.lastBracket,""),e?(h=h.replace(b.currencySymbol,""),h=this._mergeCurrencySignNegativePositiveSignAndValue(h,b,!0,!1)):h="".concat(b.negativeSignCharacter).concat(h);return h}},{key:"_setBrackets",value:function(a){if(c["default"].isNull(a.negativeBracketsTypeOnBlur))a.firstBracket="",a.lastBracket="";else{var b=a.negativeBracketsTypeOnBlur.split(",");b=r(b,2);var e=b[1];a.firstBracket=b[0];a.lastBracket=e}}},{key:"_convertToNumericString",
value:function(a,b){a=this._removeBrackets(a,b,!1);a=this._normalizeCurrencySuffixAndNegativeSignCharacters(a,b);a=a.replace(new RegExp("[".concat(b.digitGroupSeparator,"]"),"g"),"");"."!==b.decimalCharacter&&(a=a.replace(b.decimalCharacter,"."));c["default"].isNegative(a)&&a.lastIndexOf("-")===a.length-1&&(a=a.replace("-",""),a="-".concat(a));b.showPositiveSign&&(a=a.replace(b.positiveSignCharacter,""));b=c["default"].arabicToLatinNumbers(a,b.leadingZero!==d.options.leadingZero.keep,!1,!1);isNaN(b)||
(a=b.toString());return a}},{key:"_normalizeCurrencySuffixAndNegativeSignCharacters",value:function(a,b){a=String(a);b.currencySymbol!==d.options.currencySymbol.none&&(a=a.replace(b.currencySymbol,""));b.suffixText!==d.options.suffixText.none&&(a=a.replace(b.suffixText,""));b.negativeSignCharacter!==d.options.negativeSignCharacter.hyphen&&(a=a.replace(b.negativeSignCharacter,"-"));return a}},{key:"_toLocale",value:function(a,b,e){if(c["default"].isNull(b)||b===d.options.outputFormat.string)return a;
switch(b){case d.options.outputFormat.number:var h=Number(a);break;case d.options.outputFormat.dotNegative:h=c["default"].isNegative(a)?a.replace("-","")+"-":a;break;case d.options.outputFormat.comma:case d.options.outputFormat.negativeComma:h=a.replace(".",",");break;case d.options.outputFormat.commaNegative:h=a.replace(".",",");h=c["default"].isNegative(h)?h.replace("-","")+"-":h;break;case d.options.outputFormat.dot:case d.options.outputFormat.negativeDot:h=a;break;default:c["default"].throwError("The given outputFormat [".concat(b,
"] option is not recognized."))}b!==d.options.outputFormat.number&&"-"!==e.negativeSignCharacter&&(h=h.replace("-",e.negativeSignCharacter));return h}},{key:"_modifyNegativeSignAndDecimalCharacterForFormattedValue",value:function(a,b){"-"!==b.negativeSignCharacter&&(a=a.replace("-",b.negativeSignCharacter));"."!==b.decimalCharacter&&(a=a.replace(".",b.decimalCharacter));return a}},{key:"_isElementValueEmptyOrOnlyTheNegativeSign",value:function(a,b){return""===a||a===b.negativeSignCharacter}},{key:"_orderValueCurrencySymbolAndSuffixText",
value:function(a,b,e){if(b.emptyInputBehavior===d.options.emptyInputBehavior.always||e)switch(b.negativePositiveSignPlacement){case d.options.negativePositiveSignPlacement.left:case d.options.negativePositiveSignPlacement.prefix:case d.options.negativePositiveSignPlacement.none:a=a+b.currencySymbol+b.suffixText;break;default:a=b.currencySymbol+a+b.suffixText}return a}},{key:"_addGroupSeparators",value:function(a,b,e,h){var g=4<arguments.length&&void 0!==arguments[4]?arguments[4]:null;var l=c["default"].isNull(g)?
c["default"].isNegative(a,b.negativeSignCharacter)||c["default"].isNegativeWithBrackets(a,b.firstBracket,b.lastBracket):0>g;a=this._stripAllNonNumberCharactersExceptCustomDecimalChar(a,b,!1,e);if(this._isElementValueEmptyOrOnlyTheNegativeSign(a,b))return this._orderValueCurrencySymbolAndSuffixText(a,b,!0);var p=c["default"].isZeroOrHasNoValue(a);l&&(a=a.replace("-",""));b.digitalGroupSpacing=b.digitalGroupSpacing.toString();switch(b.digitalGroupSpacing){case d.options.digitalGroupSpacing.two:var q=
/(\d)((\d)(\d{2}?)+)$/;break;case d.options.digitalGroupSpacing.twoScaled:q=/(\d)((?:\d{2}){0,2}\d{3}(?:(?:\d{2}){2}\d{3})*?)$/;break;case d.options.digitalGroupSpacing.four:q=/(\d)((\d{4}?)+)$/;break;default:q=/(\d)((\d{3}?)+)$/}var t=a.split(b.decimalCharacter),B=r(t,2);t=B[0];B=B[1];b.decimalCharacterAlternative&&c["default"].isUndefined(B)&&(t=a.split(b.decimalCharacterAlternative),B=r(t,2),t=B[0],B=B[1]);if(""!==b.digitGroupSeparator)for(;q.test(t);)t=t.replace(q,"$1".concat(b.digitGroupSeparator,
"$2"));q=e?b.decimalPlacesShownOnFocus:b.decimalPlacesShownOnBlur;0===q||c["default"].isUndefined(B)?a=t:(B.length>q&&(B=B.substring(0,q)),a="".concat(t).concat(b.decimalCharacter).concat(B));a=d._mergeCurrencySignNegativePositiveSignAndValue(a,b,l,p);c["default"].isNull(g)&&(g=h);null!==b.negativeBracketsTypeOnBlur&&(0>g||c["default"].isNegativeStrict(a,b.negativeSignCharacter))&&(a=this._toggleNegativeBracket(a,b,e));return b.suffixText?"".concat(a).concat(b.suffixText):a}},{key:"_mergeCurrencySignNegativePositiveSignAndValue",
value:function(a,b,e,h){var g="";e?g=b.negativeSignCharacter:b.showPositiveSign&&!h&&(g=b.positiveSignCharacter);if(b.currencySymbolPlacement===d.options.currencySymbolPlacement.prefix)if(b.negativePositiveSignPlacement!==d.options.negativePositiveSignPlacement.none&&(e||!e&&b.showPositiveSign&&!h))switch(b.negativePositiveSignPlacement){case d.options.negativePositiveSignPlacement.prefix:case d.options.negativePositiveSignPlacement.left:var l="".concat(g).concat(b.currencySymbol).concat(a);break;
case d.options.negativePositiveSignPlacement.right:l="".concat(b.currencySymbol).concat(g).concat(a);break;case d.options.negativePositiveSignPlacement.suffix:l="".concat(b.currencySymbol).concat(a).concat(g)}else l=b.currencySymbol+a;else if(b.currencySymbolPlacement===d.options.currencySymbolPlacement.suffix)if(b.negativePositiveSignPlacement!==d.options.negativePositiveSignPlacement.none&&(e||!e&&b.showPositiveSign&&!h))switch(b.negativePositiveSignPlacement){case d.options.negativePositiveSignPlacement.suffix:case d.options.negativePositiveSignPlacement.right:l=
"".concat(a).concat(b.currencySymbol).concat(g);break;case d.options.negativePositiveSignPlacement.left:l="".concat(a).concat(g).concat(b.currencySymbol);break;case d.options.negativePositiveSignPlacement.prefix:l="".concat(g).concat(a).concat(b.currencySymbol)}else l=a+b.currencySymbol;return l}},{key:"_truncateZeros",value:function(a,b){switch(b){case 0:var e=/(\.(?:\d*[1-9])?)0*$/;break;case 1:e=/(\.\d(?:\d*[1-9])?)0*$/;break;default:e=new RegExp("(\\.\\d{".concat(b,"}(?:\\d*[1-9])?)0*"))}a=a.replace(e,
"$1");0===b&&(a=a.replace(/\.$/,""));return a}},{key:"_roundRawValue",value:function(a,b){return this._roundValue(a,b,b.decimalPlacesRawValue)}},{key:"_roundFormattedValueShownOnFocus",value:function(a,b){return this._roundValue(a,b,Number(b.decimalPlacesShownOnFocus))}},{key:"_roundFormattedValueShownOnBlur",value:function(a,b){return this._roundValue(a,b,Number(b.decimalPlacesShownOnBlur))}},{key:"_roundFormattedValueShownOnFocusOrBlur",value:function(a,b,e){return e?this._roundFormattedValueShownOnFocus(a,
b):this._roundFormattedValueShownOnBlur(a,b)}},{key:"_roundValue",value:function(a,b,e){if(c["default"].isNull(a))return a;a=""===a?"0":a.toString();if(b.roundingMethod===d.options.roundingMethod.toNearest05||b.roundingMethod===d.options.roundingMethod.toNearest05Alt||b.roundingMethod===d.options.roundingMethod.upToNext05||b.roundingMethod===d.options.roundingMethod.downToNext05)return this._roundCloseTo05(a,b);var h=d._prepareValueForRounding(a,b),g=r(h,2);h=g[0];a=g[1];var l=a.lastIndexOf("."),
p=-1===l;g=a.split(".");g=r(g,2);var q=g[0];if(!(0<g[1]||b.allowDecimalPadding!==d.options.allowDecimalPadding.never&&b.allowDecimalPadding!==d.options.allowDecimalPadding.floats))return 0===Number(a)?q:"".concat(h).concat(q);g=b.allowDecimalPadding===d.options.allowDecimalPadding.always||b.allowDecimalPadding===d.options.allowDecimalPadding.floats?e:0;q=a.length-1-(p?a.length-1:l);if(q<=e){if(q<g)for(p&&(a="".concat(a).concat(b.decimalCharacter)),b="000000";q<g;)b=b.substring(0,g-q),a+=b,q+=b.length;
else q>g?a=this._truncateZeros(a,g):0===q&&0===g&&(a=a.replace(/\.$/,""));return 0===Number(a)?a:"".concat(h).concat(a)}e=p?e-1:Number(e)+Number(l);l=Number(a.charAt(e+1));p=a.substring(0,e+1).split("");a="."===a.charAt(e)?a.charAt(e-1)%2:a.charAt(e)%2;if(this._shouldRoundUp(l,b,h,a))for(b=p.length-1;0<=b;--b)if("."!==p[b]){p[b]=+p[b]+1;if(10>p[b])break;0<b&&(p[b]="0")}p=p.slice(0,e+1);a=this._truncateZeros(p.join(""),g);return 0===Number(a)?a:"".concat(h).concat(a)}},{key:"_roundCloseTo05",value:function(a,
b){switch(b.roundingMethod){case d.options.roundingMethod.toNearest05:case d.options.roundingMethod.toNearest05Alt:a=(Math.round(20*a)/20).toString();break;case d.options.roundingMethod.upToNext05:a=(Math.ceil(20*a)/20).toString();break;default:a=(Math.floor(20*a)/20).toString()}return c["default"].contains(a,".")?3>a.length-a.indexOf(".")?a+"0":a:a+".00"}},{key:"_prepareValueForRounding",value:function(a,b){var e="";c["default"].isNegativeStrict(a,"-")&&(e="-",a=a.replace("-",""));a.match(/^\d/)||
(a="0".concat(a));0===Number(a)&&(e="");if(0<Number(a)&&b.leadingZero!==d.options.leadingZero.keep||0<a.length&&b.leadingZero===d.options.leadingZero.allow)a=a.replace(/^0*(\d)/,"$1");return[e,a]}},{key:"_shouldRoundUp",value:function(a,b,e,h){return 4<a&&b.roundingMethod===d.options.roundingMethod.halfUpSymmetric||4<a&&b.roundingMethod===d.options.roundingMethod.halfUpAsymmetric&&""===e||5<a&&b.roundingMethod===d.options.roundingMethod.halfUpAsymmetric&&"-"===e||5<a&&b.roundingMethod===d.options.roundingMethod.halfDownSymmetric||
5<a&&b.roundingMethod===d.options.roundingMethod.halfDownAsymmetric&&""===e||4<a&&b.roundingMethod===d.options.roundingMethod.halfDownAsymmetric&&"-"===e||5<a&&b.roundingMethod===d.options.roundingMethod.halfEvenBankersRounding||5===a&&b.roundingMethod===d.options.roundingMethod.halfEvenBankersRounding&&1===h||0<a&&b.roundingMethod===d.options.roundingMethod.toCeilingTowardPositiveInfinity&&""===e||0<a&&b.roundingMethod===d.options.roundingMethod.toFloorTowardNegativeInfinity&&"-"===e||0<a&&b.roundingMethod===
d.options.roundingMethod.upRoundAwayFromZero}},{key:"_truncateDecimalPlaces",value:function(a,b,e,h){e&&(a=this._roundFormattedValueShownOnFocus(a,b));e=a.split(b.decimalCharacter);var g=r(e,2);e=g[0];(g=g[1])&&g.length>h&&(0<h?(a=g.substring(0,h),a="".concat(e).concat(b.decimalCharacter).concat(a)):a=e);return a}},{key:"_checkIfInRangeWithOverrideOption",value:function(a,b){if(c["default"].isNull(a)&&b.emptyInputBehavior===d.options.emptyInputBehavior["null"]||b.overrideMinMaxLimits===d.options.overrideMinMaxLimits.ignore||
b.overrideMinMaxLimits===d.options.overrideMinMaxLimits.invalid)return[!0,!0];a=a.toString();a=a.replace(",",".");var e=c["default"].parseStr(b.minimumValue),h=c["default"].parseStr(b.maximumValue);a=c["default"].parseStr(a);switch(b.overrideMinMaxLimits){case d.options.overrideMinMaxLimits.floor:b=[-1<c["default"].testMinMax(e,a),!0];break;case d.options.overrideMinMaxLimits.ceiling:b=[!0,1>c["default"].testMinMax(h,a)];break;default:b=[-1<c["default"].testMinMax(e,a),1>c["default"].testMinMax(h,
a)]}return b}},{key:"_isWithinRangeWithOverrideOption",value:function(a,b){a=this._checkIfInRangeWithOverrideOption(a,b);a=r(a,2);b=a[1];return a[0]&&b}},{key:"_cleanValueForRangeParse",value:function(a){a=a.toString().replace(",",".");return c["default"].parseStr(a)}},{key:"_isMinimumRangeRespected",value:function(a,b){return-1<c["default"].testMinMax(c["default"].parseStr(b.minimumValue),this._cleanValueForRangeParse(a))}},{key:"_isMaximumRangeRespected",value:function(a,b){return 1>c["default"].testMinMax(c["default"].parseStr(b.maximumValue),
this._cleanValueForRangeParse(a))}},{key:"_readCookie",value:function(a){a+="\x3d";for(var b=document.cookie.split(";"),e,h=0;h<b.length;h+=1){for(e=b[h];" "===e.charAt(0);)e=e.substring(1,e.length);if(0===e.indexOf(a))return e.substring(a.length,e.length)}return null}},{key:"_storageTest",value:function(){try{return sessionStorage.setItem("modernizr","modernizr"),sessionStorage.removeItem("modernizr"),!0}catch(a){return!1}}},{key:"_correctNegativePositiveSignPlacementOption",value:function(a){if(c["default"].isNull(a.negativePositiveSignPlacement))if(c["default"].isUndefined(a)||
!c["default"].isUndefinedOrNullOrEmpty(a.negativePositiveSignPlacement)||c["default"].isUndefinedOrNullOrEmpty(a.currencySymbol))a.negativePositiveSignPlacement=d.options.negativePositiveSignPlacement.left;else switch(a.currencySymbolPlacement){case d.options.currencySymbolPlacement.suffix:a.negativePositiveSignPlacement=d.options.negativePositiveSignPlacement.prefix;break;case d.options.currencySymbolPlacement.prefix:a.negativePositiveSignPlacement=d.options.negativePositiveSignPlacement.left}}},
{key:"_correctCaretPositionOnFocusAndSelectOnFocusOptions",value:function(a){if(c["default"].isNull(a))return null;!c["default"].isUndefinedOrNullOrEmpty(a.caretPositionOnFocus)&&c["default"].isUndefinedOrNullOrEmpty(a.selectOnFocus)&&(a.selectOnFocus=d.options.selectOnFocus.doNotSelect);c["default"].isUndefinedOrNullOrEmpty(a.caretPositionOnFocus)&&!c["default"].isUndefinedOrNullOrEmpty(a.selectOnFocus)&&a.selectOnFocus===d.options.selectOnFocus.select&&(a.caretPositionOnFocus=d.options.caretPositionOnFocus.doNoForceCaretPosition);
return a}},{key:"_calculateDecimalPlacesOnInit",value:function(a){this._validateDecimalPlacesRawValue(a);a.decimalPlacesShownOnFocus===d.options.decimalPlacesShownOnFocus.useDefault&&(a.decimalPlacesShownOnFocus=a.decimalPlaces);a.decimalPlacesShownOnBlur===d.options.decimalPlacesShownOnBlur.useDefault&&(a.decimalPlacesShownOnBlur=a.decimalPlaces);a.decimalPlacesRawValue===d.options.decimalPlacesRawValue.useDefault&&(a.decimalPlacesRawValue=a.decimalPlaces);var b=0;a.rawValueDivisor&&a.rawValueDivisor!==
d.options.rawValueDivisor.none&&(b=String(a.rawValueDivisor).length-1,0>b&&(b=0));a.decimalPlacesRawValue=Math.max(Math.max(a.decimalPlacesShownOnBlur,a.decimalPlacesShownOnFocus)+b,Number(a.originalDecimalPlacesRawValue)+b)}},{key:"_calculateDecimalPlacesOnUpdate",value:function(a){var b=1<arguments.length&&void 0!==arguments[1]?arguments[1]:null;this._validateDecimalPlacesRawValue(a);c["default"].isNull(b)&&c["default"].throwError("When updating the settings, the previous ones should be passed as an argument.");
var e="decimalPlaces"in a;if(e||"decimalPlacesRawValue"in a||"decimalPlacesShownOnFocus"in a||"decimalPlacesShownOnBlur"in a||"rawValueDivisor"in a)e?("decimalPlacesShownOnFocus"in a&&a.decimalPlacesShownOnFocus!==d.options.decimalPlacesShownOnFocus.useDefault||(a.decimalPlacesShownOnFocus=a.decimalPlaces),"decimalPlacesShownOnBlur"in a&&a.decimalPlacesShownOnBlur!==d.options.decimalPlacesShownOnBlur.useDefault||(a.decimalPlacesShownOnBlur=a.decimalPlaces),"decimalPlacesRawValue"in a&&a.decimalPlacesRawValue!==
d.options.decimalPlacesRawValue.useDefault||(a.decimalPlacesRawValue=a.decimalPlaces)):(c["default"].isUndefined(a.decimalPlacesShownOnFocus)&&(a.decimalPlacesShownOnFocus=b.decimalPlacesShownOnFocus),c["default"].isUndefined(a.decimalPlacesShownOnBlur)&&(a.decimalPlacesShownOnBlur=b.decimalPlacesShownOnBlur)),e=0,a.rawValueDivisor&&a.rawValueDivisor!==d.options.rawValueDivisor.none&&(e=String(a.rawValueDivisor).length-1,0>e&&(e=0)),a.decimalPlacesRawValue=a.decimalPlaces||a.decimalPlacesRawValue?
Math.max(Math.max(a.decimalPlacesShownOnBlur,a.decimalPlacesShownOnFocus)+e,Number(a.decimalPlacesRawValue)+e):Math.max(Math.max(a.decimalPlacesShownOnBlur,a.decimalPlacesShownOnFocus)+e,Number(b.originalDecimalPlacesRawValue)+e)}},{key:"_cachesUsualRegularExpressions",value:function(a,b){var e=a.negativeSignCharacter!==d.options.negativeSignCharacter.hyphen?"([-\\".concat(a.negativeSignCharacter,"]?)"):"(-?)";b.aNegRegAutoStrip=e;a.allowedAutoStrip=new RegExp("[^-0123456789\\".concat(a.decimalCharacter,
"]"),"g");a.numRegAutoStrip=new RegExp("".concat(e,"(?:\\").concat(a.decimalCharacter,"?([0-9]+\\").concat(a.decimalCharacter,"[0-9]+)|([0-9]*(?:\\").concat(a.decimalCharacter,"[0-9]*)?))"));a.stripReg=new RegExp("^".concat(b.aNegRegAutoStrip,"0*([0-9])"));a.formulaChars=new RegExp("[0-9".concat(a.decimalCharacter,"+\\-*/() ]"))}},{key:"_convertOldOptionsToNewOnes",value:function(a){var b={aSep:"digitGroupSeparator",nSep:"showOnlyNumbersOnFocus",dGroup:"digitalGroupSpacing",aDec:"decimalCharacter",
altDec:"decimalCharacterAlternative",aSign:"currencySymbol",pSign:"currencySymbolPlacement",pNeg:"negativePositiveSignPlacement",aSuffix:"suffixText",oLimits:"overrideMinMaxLimits",vMax:"maximumValue",vMin:"minimumValue",mDec:"decimalPlacesOverride",eDec:"decimalPlacesShownOnFocus",scaleDecimal:"decimalPlacesShownOnBlur",aStor:"saveValueToSessionStorage",mRound:"roundingMethod",aPad:"allowDecimalPadding",nBracket:"negativeBracketsTypeOnBlur",wEmpty:"emptyInputBehavior",lZero:"leadingZero",aForm:"formatOnPageLoad",
sNumber:"selectNumberOnly",anDefault:"defaultValueOverride",unSetOnSubmit:"unformatOnSubmit",outputType:"outputFormat",debug:"showWarnings",allowDecimalPadding:!0,alwaysAllowDecimalCharacter:!0,caretPositionOnFocus:!0,createLocalList:!0,currencySymbol:!0,currencySymbolPlacement:!0,decimalCharacter:!0,decimalCharacterAlternative:!0,decimalPlaces:!0,decimalPlacesRawValue:!0,decimalPlacesShownOnBlur:!0,decimalPlacesShownOnFocus:!0,defaultValueOverride:!0,digitalGroupSpacing:!0,digitGroupSeparator:!0,
divisorWhenUnfocused:!0,emptyInputBehavior:!0,eventBubbles:!0,eventIsCancelable:!0,failOnUnknownOption:!0,formatOnPageLoad:!0,formulaMode:!0,historySize:!0,isCancellable:!0,leadingZero:!0,maximumValue:!0,minimumValue:!0,modifyValueOnWheel:!0,negativeBracketsTypeOnBlur:!0,negativePositiveSignPlacement:!0,negativeSignCharacter:!0,noEventListeners:!0,onInvalidPaste:!0,outputFormat:!0,overrideMinMaxLimits:!0,positiveSignCharacter:!0,rawValueDivisor:!0,readOnly:!0,roundingMethod:!0,saveValueToSessionStorage:!0,
selectNumberOnly:!0,selectOnFocus:!0,serializeSpaces:!0,showOnlyNumbersOnFocus:!0,showPositiveSign:!0,showWarnings:!0,styleRules:!0,suffixText:!0,symbolWhenUnfocused:!0,unformatOnHover:!0,unformatOnSubmit:!0,valuesToStrings:!0,watchExternalChanges:!0,wheelOn:!0,wheelStep:!0,allowedAutoStrip:!0,formulaChars:!0,isNegativeSignAllowed:!0,isPositiveSignAllowed:!0,mIntNeg:!0,mIntPos:!0,numRegAutoStrip:!0,originalDecimalPlaces:!0,originalDecimalPlacesRawValue:!0,stripReg:!0},e;for(e in a)Object.prototype.hasOwnProperty.call(a,
e)&&!0!==b[e]&&(Object.prototype.hasOwnProperty.call(b,e)?(c["default"].warning("You are using the deprecated option name '".concat(e,"'. Please use '").concat(b[e],"' instead from now on. The old option name will be dropped very soon\u2122."),!0),a[b[e]]=a[e],delete a[e]):a.failOnUnknownOption&&c["default"].throwError("Option name '".concat(e,"' is unknown. Please fix the options passed to autoNumeric")));"mDec"in a&&c["default"].warning("The old `mDec` option has been deprecated in favor of more accurate options ; `decimalPlaces`, `decimalPlacesRawValue`, `decimalPlacesShownOnFocus` and `decimalPlacesShownOnBlur`.",
!0)}},{key:"_setNegativePositiveSignPermissions",value:function(a){a.isNegativeSignAllowed=0>a.minimumValue;a.isPositiveSignAllowed=0<=a.maximumValue}},{key:"_toNumericValue",value:function(a,b){if(c["default"].isNumber(Number(a)))var e=c["default"].scientificToDecimal(a);else e=this._convertToNumericString(a.toString(),b),c["default"].isNumber(Number(e))||(c["default"].warning('The given value "'.concat(a,'" cannot be converted to a numeric one and therefore cannot be used appropriately.'),b.showWarnings),
e=NaN);return e}},{key:"_checkIfInRange",value:function(a,b,e){a=c["default"].parseStr(a);return-1<c["default"].testMinMax(b,a)&&1>c["default"].testMinMax(e,a)}},{key:"_shouldSkipEventKey",value:function(a){var b=c["default"].isInArray(a,w["default"].keyName._allFnKeys),e=a===w["default"].keyName.OSLeft||a===w["default"].keyName.OSRight,h=a===w["default"].keyName.ContextMenu,g=c["default"].isInArray(a,w["default"].keyName._someNonPrintableKeys),l=a===w["default"].keyName.NumLock||a===w["default"].keyName.ScrollLock||
a===w["default"].keyName.Insert||a===w["default"].keyName.Command;a=a===w["default"].keyName.Unidentified;return b||e||h||g||a||l}},{key:"_serialize",value:function(a){var b=this,e=1<arguments.length&&void 0!==arguments[1]?arguments[1]:!1,h=2<arguments.length&&void 0!==arguments[2]?arguments[2]:"unformatted",g=3<arguments.length&&void 0!==arguments[3]?arguments[3]:"+",l=4<arguments.length&&void 0!==arguments[4]?arguments[4]:null,p=[];"object"===y(a)&&"form"===a.nodeName.toLowerCase()&&Array.prototype.slice.call(a.elements).forEach(function(t){if(t.name&&
!t.disabled&&-1===["file","reset","submit","button"].indexOf(t.type))if("select-multiple"===t.type)Array.prototype.slice.call(t.options).forEach(function(I){I.selected&&(e?p.push({name:t.name,value:I.value}):p.push("".concat(encodeURIComponent(t.name),"\x3d").concat(encodeURIComponent(I.value))))});else if(-1===["checkbox","radio"].indexOf(t.type)||t.checked){var B;if(b.isManagedByAutoNumeric(t))switch(h){case "unformatted":var F=b.getAutoNumericElement(t);c["default"].isNull(F)||(B=b.unformat(t,
F.getSettings()));break;case "localized":F=b.getAutoNumericElement(t);c["default"].isNull(F)||(B=c["default"].cloneObject(F.getSettings()),c["default"].isNull(l)||(B.outputFormat=l),B=b.localize(t,B));break;default:B=t.value}else B=t.value;c["default"].isUndefined(B)&&c["default"].throwError("This error should never be hit. If it has, something really wrong happened!");e?p.push({name:t.name,value:B}):p.push("".concat(encodeURIComponent(t.name),"\x3d").concat(encodeURIComponent(B)))}});if(e)var q=
p;else q=p.join("\x26"),"+"===g&&(q=q.replace(/%20/g,"+"));return q}},{key:"_serializeNumericString",value:function(a){return this._serialize(a,!1,"unformatted",1<arguments.length&&void 0!==arguments[1]?arguments[1]:"+")}},{key:"_serializeFormatted",value:function(a){return this._serialize(a,!1,"formatted",1<arguments.length&&void 0!==arguments[1]?arguments[1]:"+")}},{key:"_serializeLocalized",value:function(a){return this._serialize(a,!1,"localized",1<arguments.length&&void 0!==arguments[1]?arguments[1]:
"+",2<arguments.length&&void 0!==arguments[2]?arguments[2]:null)}},{key:"_serializeNumericStringArray",value:function(a){return this._serialize(a,!0,"unformatted",1<arguments.length&&void 0!==arguments[1]?arguments[1]:"+")}},{key:"_serializeFormattedArray",value:function(a){return this._serialize(a,!0,"formatted",1<arguments.length&&void 0!==arguments[1]?arguments[1]:"+")}},{key:"_serializeLocalizedArray",value:function(a){return this._serialize(a,!0,"localized",1<arguments.length&&void 0!==arguments[1]?
arguments[1]:"+",2<arguments.length&&void 0!==arguments[2]?arguments[2]:null)}}]);return d}();k.multiple=function(d){var a=1<arguments.length&&void 0!==arguments[1]?arguments[1]:null,b=2<arguments.length&&void 0!==arguments[2]?arguments[2]:null,e=[];c["default"].isObject(a)&&(b=a,a=null);if(c["default"].isString(d))d=n(document.querySelectorAll(d));else if(c["default"].isObject(d)){Object.prototype.hasOwnProperty.call(d,"rootElement")||c["default"].throwError("The object passed to the 'multiple' function is invalid ; no 'rootElement' attribute found.");
var h=n(d.rootElement.querySelectorAll("input"));Object.prototype.hasOwnProperty.call(d,"exclude")?(Array.isArray(d.exclude)||c["default"].throwError("The 'exclude' array passed to the 'multiple' function is invalid."),d=c["default"].filterOut(h,d.exclude)):d=h}else c["default"].isArray(d)||c["default"].throwError("The given parameters to the 'multiple' function are invalid.");if(0===d.length)return h=!0,!c["default"].isNull(b)&&c["default"].isBoolean(b.showWarnings)&&(h=b.showWarnings),c["default"].warning("No valid DOM elements were given hence no AutoNumeric objects were instantiated.",
h),[];var g=!1;h=!1;if(c["default"].isArray(a)&&1<=a.length){var l=y(Number(a[0]));(g="number"===l&&!isNaN(Number(a[0])))||"string"!==l&&!isNaN(l)&&"object"!==l||(h=!0)}l=!1;if(c["default"].isArray(b)&&1<=b.length){var p=y(b[0]);if("string"===p||"object"===p)l=!0}var q=h?k.mergeOptions(a):l?k.mergeOptions(b):b;var t=c["default"].isNumber(a);if(g)var B=a.length;d.forEach(function(F,I){t?e.push(new k(F,a,q)):g&&I<=B?e.push(new k(F,a[I],q)):e.push(new k(F,null,q))});return e};(function(){function d(a,
b){b=b||{bubbles:!1,cancelable:!1,detail:void 0};var e=document.createEvent("CustomEvent");e.initCustomEvent(a,b.bubbles,b.cancelable,b.detail);return e}Array.from||(Array.from=function(a){return[].slice.call(a)});if("undefined"===typeof window||"function"===typeof window.CustomEvent)return!1;d.prototype=window.Event.prototype;window.CustomEvent=d})()},"./src/AutoNumericDefaultSettings.js":function(m,u,x){x.r(u);m=x("./src/AutoNumeric.js");x("./src/AutoNumericOptions.js");m["default"].defaultSettings=
{allowDecimalPadding:m["default"].options.allowDecimalPadding.always,alwaysAllowDecimalCharacter:m["default"].options.alwaysAllowDecimalCharacter.doNotAllow,caretPositionOnFocus:m["default"].options.caretPositionOnFocus.doNoForceCaretPosition,createLocalList:m["default"].options.createLocalList.createList,currencySymbol:m["default"].options.currencySymbol.none,currencySymbolPlacement:m["default"].options.currencySymbolPlacement.prefix,decimalCharacter:m["default"].options.decimalCharacter.dot,decimalCharacterAlternative:m["default"].options.decimalCharacterAlternative.none,
decimalPlaces:m["default"].options.decimalPlaces.two,decimalPlacesRawValue:m["default"].options.decimalPlacesRawValue.useDefault,decimalPlacesShownOnBlur:m["default"].options.decimalPlacesShownOnBlur.useDefault,decimalPlacesShownOnFocus:m["default"].options.decimalPlacesShownOnFocus.useDefault,defaultValueOverride:m["default"].options.defaultValueOverride.doNotOverride,digitalGroupSpacing:m["default"].options.digitalGroupSpacing.three,digitGroupSeparator:m["default"].options.digitGroupSeparator.comma,
divisorWhenUnfocused:m["default"].options.divisorWhenUnfocused.none,emptyInputBehavior:m["default"].options.emptyInputBehavior.focus,eventBubbles:m["default"].options.eventBubbles.bubbles,eventIsCancelable:m["default"].options.eventIsCancelable.isCancelable,failOnUnknownOption:m["default"].options.failOnUnknownOption.ignore,formatOnPageLoad:m["default"].options.formatOnPageLoad.format,formulaMode:m["default"].options.formulaMode.disabled,historySize:m["default"].options.historySize.medium,invalidClass:m["default"].options.invalidClass,
isCancellable:m["default"].options.isCancellable.cancellable,leadingZero:m["default"].options.leadingZero.deny,maximumValue:m["default"].options.maximumValue.tenTrillions,minimumValue:m["default"].options.minimumValue.tenTrillions,modifyValueOnWheel:m["default"].options.modifyValueOnWheel.modifyValue,negativeBracketsTypeOnBlur:m["default"].options.negativeBracketsTypeOnBlur.none,negativePositiveSignPlacement:m["default"].options.negativePositiveSignPlacement.none,negativeSignCharacter:m["default"].options.negativeSignCharacter.hyphen,
noEventListeners:m["default"].options.noEventListeners.addEvents,onInvalidPaste:m["default"].options.onInvalidPaste.error,outputFormat:m["default"].options.outputFormat.none,overrideMinMaxLimits:m["default"].options.overrideMinMaxLimits.doNotOverride,positiveSignCharacter:m["default"].options.positiveSignCharacter.plus,rawValueDivisor:m["default"].options.rawValueDivisor.none,readOnly:m["default"].options.readOnly.readWrite,roundingMethod:m["default"].options.roundingMethod.halfUpSymmetric,saveValueToSessionStorage:m["default"].options.saveValueToSessionStorage.doNotSave,
selectNumberOnly:m["default"].options.selectNumberOnly.selectNumbersOnly,selectOnFocus:m["default"].options.selectOnFocus.select,serializeSpaces:m["default"].options.serializeSpaces.plus,showOnlyNumbersOnFocus:m["default"].options.showOnlyNumbersOnFocus.showAll,showPositiveSign:m["default"].options.showPositiveSign.hide,showWarnings:m["default"].options.showWarnings.show,styleRules:m["default"].options.styleRules.none,suffixText:m["default"].options.suffixText.none,symbolWhenUnfocused:m["default"].options.symbolWhenUnfocused.none,
unformatOnHover:m["default"].options.unformatOnHover.unformat,unformatOnSubmit:m["default"].options.unformatOnSubmit.keepCurrentValue,valuesToStrings:m["default"].options.valuesToStrings.none,watchExternalChanges:m["default"].options.watchExternalChanges.doNotWatch,wheelOn:m["default"].options.wheelOn.focus,wheelStep:m["default"].options.wheelStep.progressive};Object.freeze(m["default"].defaultSettings);Object.defineProperty(m["default"],"defaultSettings",{configurable:!1,writable:!1})},"./src/AutoNumericEnum.js":function(m,
u,x){x.r(u);m={allowedTagList:"b caption cite code const dd del div dfn dt em h1 h2 h3 h4 h5 h6 input ins kdb label li option output p q s sample span strong td th u".split(" ")};Object.freeze(m.allowedTagList);Object.defineProperty(m,"allowedTagList",{configurable:!1,writable:!1});m.keyCode={Backspace:8,Tab:9,Enter:13,Shift:16,Ctrl:17,Alt:18,Pause:19,CapsLock:20,Esc:27,Space:32,PageUp:33,PageDown:34,End:35,Home:36,LeftArrow:37,UpArrow:38,RightArrow:39,DownArrow:40,Insert:45,Delete:46,num0:48,num1:49,
num2:50,num3:51,num4:52,num5:53,num6:54,num7:55,num8:56,num9:57,a:65,b:66,c:67,d:68,e:69,f:70,g:71,h:72,i:73,j:74,k:75,l:76,m:77,n:78,o:79,p:80,q:81,r:82,s:83,t:84,u:85,v:86,w:87,x:88,y:89,z:90,OSLeft:91,OSRight:92,ContextMenu:93,numpad0:96,numpad1:97,numpad2:98,numpad3:99,numpad4:100,numpad5:101,numpad6:102,numpad7:103,numpad8:104,numpad9:105,MultiplyNumpad:106,PlusNumpad:107,MinusNumpad:109,DotNumpad:110,SlashNumpad:111,F1:112,F2:113,F3:114,F4:115,F5:116,F6:117,F7:118,F8:119,F9:120,F10:121,F11:122,
F12:123,NumLock:144,ScrollLock:145,HyphenFirefox:173,MyComputer:182,MyCalculator:183,Semicolon:186,Equal:187,Comma:188,Hyphen:189,Dot:190,Slash:191,Backquote:192,LeftBracket:219,Backslash:220,RightBracket:221,Quote:222,Command:224,AltGraph:225,AndroidDefault:229};Object.freeze(m.keyCode);Object.defineProperty(m,"keyCode",{configurable:!1,writable:!1});m.fromCharCodeKeyCode={0:"LaunchCalculator",8:"Backspace",9:"Tab",13:"Enter",16:"Shift",17:"Ctrl",18:"Alt",19:"Pause",20:"CapsLock",27:"Escape",32:" ",
33:"PageUp",34:"PageDown",35:"End",36:"Home",37:"ArrowLeft",38:"ArrowUp",39:"ArrowRight",40:"ArrowDown",45:"Insert",46:"Delete",48:"0",49:"1",50:"2",51:"3",52:"4",53:"5",54:"6",55:"7",56:"8",57:"9",91:"OS",92:"OSRight",93:"ContextMenu",96:"0",97:"1",98:"2",99:"3",100:"4",101:"5",102:"6",103:"7",104:"8",105:"9",106:"*",107:"+",109:"-",110:".",111:"/",112:"F1",113:"F2",114:"F3",115:"F4",116:"F5",117:"F6",118:"F7",119:"F8",120:"F9",121:"F10",122:"F11",123:"F12",144:"NumLock",145:"ScrollLock",173:"-",
182:"MyComputer",183:"MyCalculator",186:";",187:"\x3d",188:",",189:"-",190:".",191:"/",192:"`",219:"[",220:"\\",221:"]",222:"'",224:"Meta",225:"AltGraph"};Object.freeze(m.fromCharCodeKeyCode);Object.defineProperty(m,"fromCharCodeKeyCode",{configurable:!1,writable:!1});m.keyName={Unidentified:"Unidentified",AndroidDefault:"AndroidDefault",Alt:"Alt",AltGr:"AltGraph",CapsLock:"CapsLock",Ctrl:"Control",Fn:"Fn",FnLock:"FnLock",Hyper:"Hyper",Meta:"Meta",OSLeft:"OS",OSRight:"OS",Command:"OS",NumLock:"NumLock",
ScrollLock:"ScrollLock",Shift:"Shift",Super:"Super",Symbol:"Symbol",SymbolLock:"SymbolLock",Enter:"Enter",Tab:"Tab",Space:" ",LeftArrow:"ArrowLeft",UpArrow:"ArrowUp",RightArrow:"ArrowRight",DownArrow:"ArrowDown",End:"End",Home:"Home",PageUp:"PageUp",PageDown:"PageDown",Backspace:"Backspace",Clear:"Clear",Copy:"Copy",CrSel:"CrSel",Cut:"Cut",Delete:"Delete",EraseEof:"EraseEof",ExSel:"ExSel",Insert:"Insert",Paste:"Paste",Redo:"Redo",Undo:"Undo",Accept:"Accept",Again:"Again",Attn:"Attn",Cancel:"Cancel",
ContextMenu:"ContextMenu",Esc:"Escape",Execute:"Execute",Find:"Find",Finish:"Finish",Help:"Help",Pause:"Pause",Play:"Play",Props:"Props",Select:"Select",ZoomIn:"ZoomIn",ZoomOut:"ZoomOut",BrightnessDown:"BrightnessDown",BrightnessUp:"BrightnessUp",Eject:"Eject",LogOff:"LogOff",Power:"Power",PowerOff:"PowerOff",PrintScreen:"PrintScreen",Hibernate:"Hibernate",Standby:"Standby",WakeUp:"WakeUp",Compose:"Compose",Dead:"Dead",F1:"F1",F2:"F2",F3:"F3",F4:"F4",F5:"F5",F6:"F6",F7:"F7",F8:"F8",F9:"F9",F10:"F10",
F11:"F11",F12:"F12",Print:"Print",num0:"0",num1:"1",num2:"2",num3:"3",num4:"4",num5:"5",num6:"6",num7:"7",num8:"8",num9:"9",a:"a",b:"b",c:"c",d:"d",e:"e",f:"f",g:"g",h:"h",i:"i",j:"j",k:"k",l:"l",m:"m",n:"n",o:"o",p:"p",q:"q",r:"r",s:"s",t:"t",u:"u",v:"v",w:"w",x:"x",y:"y",z:"z",A:"A",B:"B",C:"C",D:"D",E:"E",F:"F",G:"G",H:"H",I:"I",J:"J",K:"K",L:"L",M:"M",N:"N",O:"O",P:"P",Q:"Q",R:"R",S:"S",T:"T",U:"U",V:"V",W:"W",X:"X",Y:"Y",Z:"Z",Semicolon:";",Equal:"\x3d",Comma:",",Hyphen:"-",Minus:"-",Plus:"+",
Dot:".",Slash:"/",Backquote:"`",LeftParenthesis:"(",RightParenthesis:")",LeftBracket:"[",RightBracket:"]",Backslash:"\\",Quote:"'",numpad0:"0",numpad1:"1",numpad2:"2",numpad3:"3",numpad4:"4",numpad5:"5",numpad6:"6",numpad7:"7",numpad8:"8",numpad9:"9",NumpadDot:".",NumpadDotAlt:",",NumpadMultiply:"*",NumpadPlus:"+",NumpadMinus:"-",NumpadSubtract:"-",NumpadSlash:"/",NumpadDotObsoleteBrowsers:"Decimal",NumpadMultiplyObsoleteBrowsers:"Multiply",NumpadPlusObsoleteBrowsers:"Add",NumpadMinusObsoleteBrowsers:"Subtract",
NumpadSlashObsoleteBrowsers:"Divide",_allFnKeys:"F1 F2 F3 F4 F5 F6 F7 F8 F9 F10 F11 F12".split(" "),_someNonPrintableKeys:"Tab Enter Shift ShiftLeft ShiftRight Control ControlLeft ControlRight Alt AltLeft AltRight Pause CapsLock Escape".split(" "),_directionKeys:"PageUp PageDown End Home ArrowDown ArrowLeft ArrowRight ArrowUp".split(" ")};Object.freeze(m.keyName._allFnKeys);Object.freeze(m.keyName._someNonPrintableKeys);Object.freeze(m.keyName._directionKeys);Object.freeze(m.keyName);Object.defineProperty(m,
"keyName",{configurable:!1,writable:!1});Object.freeze(m);u["default"]=m},"./src/AutoNumericEvents.js":function(m,u,x){x.r(u);m=x("./src/AutoNumeric.js");m["default"].events={correctedValue:"autoNumeric:correctedValue",initialized:"autoNumeric:initialized",invalidFormula:"autoNumeric:invalidFormula",invalidValue:"autoNumeric:invalidValue",formatted:"autoNumeric:formatted",rawValueModified:"autoNumeric:rawValueModified",minRangeExceeded:"autoNumeric:minExceeded",maxRangeExceeded:"autoNumeric:maxExceeded",
"native":{input:"input",change:"change"},validFormula:"autoNumeric:validFormula"};Object.freeze(m["default"].events["native"]);Object.freeze(m["default"].events);Object.defineProperty(m["default"],"events",{configurable:!1,writable:!1})},"./src/AutoNumericHelper.js":function(m,u,x){function n(E){var f=Array.isArray(E)?z(E):void 0;f||(f="undefined"!==typeof Symbol&&Symbol.iterator in Object(E)?Array.from(E):void 0);if(!(E=f||A(E)))throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
return E}function r(){r=Object.assign||function(E){for(var f=1;f<arguments.length;f++){var k=arguments[f],d;for(d in k)Object.prototype.hasOwnProperty.call(k,d)&&(E[d]=k[d])}return E};return r.apply(this,arguments)}function C(E,f){var k=Array.isArray(E)?E:void 0;if(!k)if("undefined"!==typeof Symbol&&Symbol.iterator in Object(E)){k=[];var d=!0,a=!1,b=void 0;try{for(var e=E[Symbol.iterator](),h;!(d=(h=e.next()).done)&&(k.push(h.value),!f||k.length!==f);d=!0);}catch(g){a=!0,b=g}finally{try{if(!d&&null!=
e["return"])e["return"]()}finally{if(a)throw b;}}}else k=void 0;if(!(E=k||A(E,f)))throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");return E}function A(E,f){if(E){if("string"===typeof E)return z(E,f);var k=Object.prototype.toString.call(E).slice(8,-1);"Object"===k&&E.constructor&&(k=E.constructor.name);if("Map"===k||"Set"===k)return Array.from(k);if("Arguments"===k||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(k))return z(E,
f)}}function z(E,f){if(null==f||f>E.length)f=E.length;for(var k=0,d=Array(f);k<f;k++)d[k]=E[k];return d}function y(E){"@babel/helpers - typeof";y="function"===typeof Symbol&&"symbol"===typeof Symbol.iterator?function(f){return typeof f}:function(f){return f&&"function"===typeof Symbol&&f.constructor===Symbol&&f!==Symbol.prototype?"symbol":typeof f};return y(E)}function v(E,f){for(var k=0;k<f.length;k++){var d=f[k];d.enumerable=d.enumerable||!1;d.configurable=!0;"value"in d&&(d.writable=!0);Object.defineProperty(E,
d.key,d)}}function D(E,f,k){f&&v(E.prototype,f);k&&v(E,k);return E}x.r(u);x.d(u,"default",function(){return w});var c=x("./src/AutoNumericEnum.js"),w=function(){function E(){if(!(this instanceof E))throw new TypeError("Cannot call a class as a function");}D(E,null,[{key:"isNull",value:function(f){return null===f}},{key:"isUndefined",value:function(f){return void 0===f}},{key:"isUndefinedOrNullOrEmpty",value:function(f){return null===f||void 0===f||""===f}},{key:"isString",value:function(f){return"string"===
typeof f||f instanceof String}},{key:"isEmptyString",value:function(f){return""===f}},{key:"isBoolean",value:function(f){return"boolean"===typeof f}},{key:"isTrueOrFalseString",value:function(f){f=String(f).toLowerCase();return"true"===f||"false"===f}},{key:"isObject",value:function(f){return"object"===y(f)&&null!==f&&!Array.isArray(f)}},{key:"isEmptyObj",value:function(f){for(var k in f)if(Object.prototype.hasOwnProperty.call(f,k))return!1;return!0}},{key:"isNumberStrict",value:function(f){return"number"===
typeof f}},{key:"isNumber",value:function(f){return!this.isArray(f)&&!isNaN(parseFloat(f))&&isFinite(f)}},{key:"isDigit",value:function(f){return/\d/.test(f)}},{key:"isNumberOrArabic",value:function(f){f=this.arabicToLatinNumbers(f,!1,!0,!0);return this.isNumber(f)}},{key:"isInt",value:function(f){return"number"===typeof f&&parseFloat(f)===parseInt(f,10)&&!isNaN(f)}},{key:"isFunction",value:function(f){return"function"===typeof f}},{key:"isIE11",value:function(){return"undefined"!==typeof window&&
!!window.MSInputMethodContext&&!!document.documentMode}},{key:"contains",value:function(f,k){return this.isString(f)&&this.isString(k)&&""!==f&&""!==k?-1!==f.indexOf(k):!1}},{key:"isInArray",value:function(f,k){return!this.isArray(k)||k===[]||this.isUndefined(f)?!1:-1!==k.indexOf(f)}},{key:"isArray",value:function(f){if("[object Array]"===Object.prototype.toString.call([]))return Array.isArray(f)||"object"===y(f)&&"[object Array]"===Object.prototype.toString.call(f);throw Error("toString message changed for Object Array");
}},{key:"isElement",value:function(f){return"undefined"===typeof Element?!1:f instanceof Element}},{key:"isInputElement",value:function(f){return this.isElement(f)&&"input"===f.tagName.toLowerCase()}},{key:"decimalPlaces",value:function(f){f=f.split(".");f=C(f,2)[1];return this.isUndefined(f)?0:f.length}},{key:"indexFirstNonZeroDecimalPlace",value:function(f){f=String(Math.abs(f)).split(".");f=C(f,2)[1];if(this.isUndefined(f))return 0;f=f.lastIndexOf("0");return-1===f?0:f+2}},{key:"keyCodeNumber",
value:function(f){return"undefined"===typeof f.which?f.keyCode:f.which}},{key:"character",value:function(f){if("Unidentified"===f.key||void 0===f.key||this.isSeleniumBot()){f=this.keyCodeNumber(f);if(f===c["default"].keyCode.AndroidDefault)return c["default"].keyName.AndroidDefault;var k=c["default"].fromCharCodeKeyCode[f];f=E.isUndefinedOrNullOrEmpty(k)?String.fromCharCode(f):k}else switch(f.key){case "Add":f=c["default"].keyName.NumpadPlus;break;case "Apps":f=c["default"].keyName.ContextMenu;break;
case "Crsel":f=c["default"].keyName.CrSel;break;case "Decimal":f=f["char"]?f["char"]:c["default"].keyName.NumpadDot;break;case "Del":f=this.browser();f="firefox"===f.name&&36>=f.version||"ie"===f.name&&9>=f.version?c["default"].keyName.Dot:c["default"].keyName.Delete;break;case "Divide":f=c["default"].keyName.NumpadSlash;break;case "Down":f=c["default"].keyName.DownArrow;break;case "Esc":f=c["default"].keyName.Esc;break;case "Exsel":f=c["default"].keyName.ExSel;break;case "Left":f=c["default"].keyName.LeftArrow;
break;case "Meta":case "Super":f=c["default"].keyName.OSLeft;break;case "Multiply":f=c["default"].keyName.NumpadMultiply;break;case "Right":f=c["default"].keyName.RightArrow;break;case "Spacebar":f=c["default"].keyName.Space;break;case "Subtract":f=c["default"].keyName.NumpadMinus;break;case "Up":f=c["default"].keyName.UpArrow;break;default:f=f.key}return f}},{key:"browser",value:function(){var f=navigator.userAgent,k=f.match(/(opera|chrome|safari|firefox|msie|trident(?=\/))\/?\s*(\d+)/i)||[];if(/trident/i.test(k[1])){var d=
/\brv[ :]+(\d+)/g.exec(f)||[];return{name:"ie",version:d[1]||""}}if("Chrome"===k[1]&&(d=f.match(/\b(OPR|Edge)\/(\d+)/),null!==d))return{name:d[1].replace("OPR","opera"),version:d[2]};k=k[2]?[k[1],k[2]]:[navigator.appName,navigator.appVersion,"-?"];null!==(d=f.match(/version\/(\d+)/i))&&k.splice(1,1,d[1]);return{name:k[0].toLowerCase(),version:k[1]}}},{key:"isSeleniumBot",value:function(){return!0===window.navigator.webdriver}},{key:"isNegative",value:function(f){var k=1<arguments.length&&void 0!==
arguments[1]?arguments[1]:"-",d=2<arguments.length&&void 0!==arguments[2]?arguments[2]:!0;return f===k?!0:""===f?!1:E.isNumber(f)?0>f:d?this.contains(f,k):this.isNegativeStrict(f,k)}},{key:"isNegativeStrict",value:function(f){var k=1<arguments.length&&void 0!==arguments[1]?arguments[1]:"-";return f.charAt(0)===k}},{key:"isNegativeWithBrackets",value:function(f,k,d){return f.charAt(0)===k&&this.contains(f,d)}},{key:"isZeroOrHasNoValue",value:function(f){return!/[1-9]/g.test(f)}},{key:"setRawNegativeSign",
value:function(f){return this.isNegativeStrict(f,"-")?f:"-".concat(f)}},{key:"replaceCharAt",value:function(f,k,d){return"".concat(f.substr(0,k)).concat(d).concat(f.substr(k+d.length))}},{key:"clampToRangeLimits",value:function(f,k){return Math.max(k.minimumValue,Math.min(k.maximumValue,f))}},{key:"countNumberCharactersOnTheCaretLeftSide",value:function(f,k,d){d=new RegExp("[0-9".concat(d,"-]"));for(var a=0,b=0;b<k;b++)d.test(f[b])&&a++;return a}},{key:"findCaretPositionInFormattedNumber",value:function(f,
k,d,a){var b=d.length,e=f.length,h,g=0;for(h=0;h<b&&g<e&&g<k;h++)(f[g]===d[h]||"."===f[g]&&d[h]===a)&&g++;return h}},{key:"countCharInText",value:function(f,k){for(var d=0,a=0;a<k.length;a++)k[a]===f&&d++;return d}},{key:"convertCharacterCountToIndexPosition",value:function(f){return Math.max(f,f-1)}},{key:"getElementSelection",value:function(f){var k={};try{var d=this.isUndefined(f.selectionStart)}catch(b){d=!1}try{if(d){var a=window.getSelection().getRangeAt(0);k.start=a.startOffset;k.end=a.endOffset}else k.start=
f.selectionStart,k.end=f.selectionEnd;k.length=k.end-k.start}catch(b){k.start=0,k.end=0,k.length=0}return k}},{key:"setElementSelection",value:function(f,k){var d=2<arguments.length&&void 0!==arguments[2]?arguments[2]:null;this.isUndefinedOrNullOrEmpty(d)&&(d=k);if(this.isInputElement(f))f.setSelectionRange(k,d);else if(!E.isNull(f.firstChild)){var a=document.createRange();a.setStart(f.firstChild,k);a.setEnd(f.firstChild,d);d=window.getSelection();d.removeAllRanges();d.addRange(a)}}},{key:"throwError",
value:function(f){throw Error(f);}},{key:"warning",value:function(f){(1<arguments.length&&void 0!==arguments[1]?arguments[1]:1)&&console.warn("Warning: ".concat(f))}},{key:"isWheelUpEvent",value:function(f){f.deltaY||this.throwError("The event passed as a parameter is not a valid wheel event, '".concat(f.type,"' given."));return 0>f.deltaY}},{key:"isWheelDownEvent",value:function(f){f.deltaY||this.throwError("The event passed as a parameter is not a valid wheel event, '".concat(f.type,"' given."));
return 0<f.deltaY}},{key:"forceDecimalPlaces",value:function(f,k){var d=String(f).split(".");d=C(d,2);var a=d[1];return a?"".concat(d[0],".").concat(a.substr(0,k)):f}},{key:"roundToNearest",value:function(f){var k=1<arguments.length&&void 0!==arguments[1]?arguments[1]:1E3;if(0===f)return 0;0===k&&this.throwError("The `stepPlace` used to round is equal to `0`. This value must not be equal to zero.");return Math.round(f/k)*k}},{key:"modifyAndRoundToNearestAuto",value:function(f,k,d){f=Number(this.forceDecimalPlaces(f,
d));var a=Math.abs(f);if(0<=a&&1>a){a=Math.pow(10,-d);if(0===f)return k?a:-a;var b=this.indexFirstNonZeroDecimalPlace(f);d=b>=d-1?a:Math.pow(10,-(b+1));return this.roundToNearest(k?f+d:f-d,d)}f=parseInt(f,10);d=Math.abs(f).toString().length;switch(d){case 1:d=0;break;case 2:case 3:d=1;break;case 4:case 5:d=2;break;default:d-=3}d=Math.pow(10,d);f=k?f+d:f-d;return 10>=f&&-10<=f?f:this.roundToNearest(f,d)}},{key:"addAndRoundToNearestAuto",value:function(f,k){return this.modifyAndRoundToNearestAuto(f,
!0,k)}},{key:"subtractAndRoundToNearestAuto",value:function(f,k){return this.modifyAndRoundToNearestAuto(f,!1,k)}},{key:"arabicToLatinNumbers",value:function(f){var k=1<arguments.length&&void 0!==arguments[1]?arguments[1]:!0,d=2<arguments.length&&void 0!==arguments[2]?arguments[2]:!1,a=3<arguments.length&&void 0!==arguments[3]?arguments[3]:!1;if(this.isNull(f))return f;var b=f.toString();if(""===b)return f;if(null===b.match(/[\u0660\u0661\u0662\u0663\u0664\u0665\u0666\u0667\u0668\u0669\u06f4\u06f5\u06f6]/g))return k&&
(b=Number(b)),b;d&&(b=b.replace(/\u066b/,"."));a&&(b=b.replace(/\u066c/g,""));b=b.replace(/[\u0660\u0661\u0662\u0663\u0664\u0665\u0666\u0667\u0668\u0669]/g,function(e){return e.charCodeAt(0)-1632}).replace(/[\u06f0\u06f1\u06f2\u06f3\u06f4\u06f5\u06f6\u06f7\u06f8\u06f9]/g,function(e){return e.charCodeAt(0)-1776});d=Number(b);if(isNaN(d))return d;k&&(b=d);return b}},{key:"triggerEvent",value:function(f){var k=1<arguments.length&&void 0!==arguments[1]?arguments[1]:document,d=2<arguments.length&&void 0!==
arguments[2]?arguments[2]:null,a=3<arguments.length&&void 0!==arguments[3]?arguments[3]:!0,b=4<arguments.length&&void 0!==arguments[4]?arguments[4]:!0;if(window.CustomEvent)var e=new CustomEvent(f,{detail:d,bubbles:a,cancelable:b});else e=document.createEvent("CustomEvent"),e.initCustomEvent(f,a,b,{detail:d});k.dispatchEvent(e)}},{key:"parseStr",value:function(f){var k={},d;0===f&&0>1/f&&(f="-0");f=f.toString();this.isNegativeStrict(f,"-")?(f=f.slice(1),k.s=-1):k.s=1;var a=f.indexOf(".");-1<a&&(f=
f.replace(".",""));0>a&&(a=f.length);var b=-1===f.search(/[1-9]/i)?f.length:f.search(/[1-9]/i);var e=f.length;if(b===e)k.e=0,k.c=[0];else{for(d=e-1;"0"===f.charAt(d);--d)--e;--e;k.e=a-b-1;k.c=[];for(a=0;b<=e;b+=1)k.c[a]=+f.charAt(b),a+=1}return k}},{key:"testMinMax",value:function(f,k){var d=k.c,a=f.c,b=k.s,e=f.s;k=k.e;f=f.e;if(!d[0]||!a[0])return d[0]?b:a[0]?-e:0;if(b!==e)return b;var h=0>b;if(k!==f)return k>f^h?1:-1;k=d.length;f=a.length;e=k<f?k:f;for(b=0;b<e;b+=1)if(d[b]!==a[b])return d[b]>a[b]^
h?1:-1;return k===f?0:k>f^h?1:-1}},{key:"randomString",value:function(){var f=0<arguments.length&&void 0!==arguments[0]?arguments[0]:5;return Math.random().toString(36).substr(2,f)}},{key:"domElement",value:function(f){return E.isString(f)?document.querySelector(f):f}},{key:"getElementValue",value:function(f){return"input"===f.tagName.toLowerCase()?f.value:this.text(f)}},{key:"setElementValue",value:function(f){var k=1<arguments.length&&void 0!==arguments[1]?arguments[1]:null;"input"===f.tagName.toLowerCase()?
f.value=k:f.textContent=k}},{key:"setInvalidState",value:function(f){var k=1<arguments.length&&void 0!==arguments[1]?arguments[1]:"Invalid";(""===k||this.isNull(k))&&this.throwError("Cannot set the invalid state with an empty message.");f.setCustomValidity(k)}},{key:"setValidState",value:function(f){f.setCustomValidity("")}},{key:"cloneObject",value:function(f){return r({},f)}},{key:"camelize",value:function(f){var k=1<arguments.length&&void 0!==arguments[1]?arguments[1]:"-",d=2<arguments.length&&
void 0!==arguments[2]?arguments[2]:!0,a=3<arguments.length&&void 0!==arguments[3]?arguments[3]:!0;if(this.isNull(f))return null;d&&(f=f.replace(/^data-/,""));k=f.split(k).map(function(b){return"".concat(b.charAt(0).toUpperCase()).concat(b.slice(1))});k=k.join("");a&&(k="".concat(k.charAt(0).toLowerCase()).concat(k.slice(1)));return k}},{key:"text",value:function(f){var k=f.nodeType;return k===Node.ELEMENT_NODE||k===Node.DOCUMENT_NODE||k===Node.DOCUMENT_FRAGMENT_NODE?f.textContent:k===Node.TEXT_NODE?
f.nodeValue:""}},{key:"setText",value:function(f,k){var d=f.nodeType;if(d===Node.ELEMENT_NODE||d===Node.DOCUMENT_NODE||d===Node.DOCUMENT_FRAGMENT_NODE)f.textContent=k}},{key:"filterOut",value:function(f,k){var d=this;return f.filter(function(a){return!d.isInArray(a,k)})}},{key:"trimPaddedZerosFromDecimalPlaces",value:function(f){f=String(f);if(""===f)return"";f=f.split(".");var k=C(f,2);f=k[0];k=k[1];if(this.isUndefinedOrNullOrEmpty(k))return f;k=k.replace(/0+$/g,"");return""===k?f:"".concat(f,".").concat(k)}},
{key:"getHoveredElement",value:function(){var f=n(document.querySelectorAll(":hover"));return f[f.length-1]}},{key:"arrayTrim",value:function(f,k){var d=f.length;if(0===d||k>d)return f;if(0>k)return[];f.length=parseInt(k,10);return f}},{key:"arrayUnique",value:function(){var f;return n(new Set((f=[]).concat.apply(f,arguments)))}},{key:"mergeMaps",value:function(){for(var f=arguments.length,k=Array(f),d=0;d<f;d++)k[d]=arguments[d];return new Map(k.reduce(function(a,b){return a.concat(n(b))},[]))}},
{key:"objectKeyLookup",value:function(f,k){f=Object.entries(f).find(function(a){return a[1]===k});var d=null;void 0!==f&&(d=f[0]);return d}},{key:"insertAt",value:function(f,k,d){f=String(f);if(d>f.length)throw Error("The given index is out of the string range.");if(1!==k.length)throw Error("The given string `char` should be only one character long.");return""===f&&0===d?k:"".concat(f.slice(0,d)).concat(k).concat(f.slice(d))}},{key:"scientificToDecimal",value:function(f){if(isNaN(Number(f)))return NaN;
f=String(f);if(!this.contains(f,"e")&&!this.contains(f,"E"))return f;f=f.split(/e/i);var k=C(f,2);f=k[0];var d=k[1];(k=0>f)&&(f=f.replace("-",""));var a=0>+d;a&&(d=d.replace("-",""));var b=f.split(/\./),e=C(b,2);b=e[0];e=e[1];a?(f=b.length>d?this.insertAt(b,".",b.length-d):"0.".concat("0".repeat(d-b.length)).concat(b),f="".concat(f).concat(e?e:"")):e?(f="".concat(b).concat(e),f=d<e.length?this.insertAt(f,".",+d+b.length):"".concat(f).concat("0".repeat(d-e.length))):(f=f.replace(".",""),f="".concat(f).concat("0".repeat(Number(d))));
k&&(f="-".concat(f));return f}}]);return E}()},"./src/AutoNumericOptions.js":function(m,u,x){x.r(u);m=x("./src/AutoNumeric.js");var n=x("./src/AutoNumericHelper.js");m["default"].options={allowDecimalPadding:{always:!0,never:!1,floats:"floats"},alwaysAllowDecimalCharacter:{alwaysAllow:!0,doNotAllow:!1},caretPositionOnFocus:{start:"start",end:"end",decimalLeft:"decimalLeft",decimalRight:"decimalRight",doNoForceCaretPosition:null},createLocalList:{createList:!0,doNotCreateList:!1},currencySymbol:{none:"",
currencySign:"\u00a4",austral:"\u20b3",australCentavo:"\u00a2",baht:"\u0e3f",cedi:"\u20b5",cent:"\u00a2",colon:"\u20a1",cruzeiro:"\u20a2",dollar:"$",dong:"\u20ab",drachma:"\u20af",dram:"\u200b\u058f",european:"\u20a0",euro:"\u20ac",florin:"\u0192",franc:"\u20a3",guarani:"\u20b2",hryvnia:"\u20b4",kip:"\u20ad",att:"\u0ead\u0eb1\u0e94",lepton:"\u039b.",lira:"\u20ba",liraOld:"\u20a4",lari:"\u20be",mark:"\u2133",mill:"\u20a5",naira:"\u20a6",peseta:"\u20a7",peso:"\u20b1",pfennig:"\u20b0",pound:"\u00a3",
real:"R$",riel:"\u17db",ruble:"\u20bd",rupee:"\u20b9",rupeeOld:"\u20a8",shekel:"\u20aa",shekelAlt:"\u05e9\u05f4\u05d7\u200e\u200e",taka:"\u09f3",tenge:"\u20b8",togrog:"\u20ae",won:"\u20a9",yen:"\u00a5"},currencySymbolPlacement:{prefix:"p",suffix:"s"},decimalCharacter:{comma:",",dot:".",middleDot:"\u00b7",arabicDecimalSeparator:"\u066b",decimalSeparatorKeySymbol:"\u2396"},decimalCharacterAlternative:{none:null,comma:",",dot:"."},decimalPlaces:{none:0,one:1,two:2,three:3,four:4,five:5,six:6},decimalPlacesRawValue:{useDefault:null,
none:0,one:1,two:2,three:3,four:4,five:5,six:6},decimalPlacesShownOnBlur:{useDefault:null,none:0,one:1,two:2,three:3,four:4,five:5,six:6},decimalPlacesShownOnFocus:{useDefault:null,none:0,one:1,two:2,three:3,four:4,five:5,six:6},defaultValueOverride:{doNotOverride:null},digitalGroupSpacing:{two:"2",twoScaled:"2s",three:"3",four:"4"},digitGroupSeparator:{comma:",",dot:".",normalSpace:" ",thinSpace:"\u2009",narrowNoBreakSpace:"\u202f",noBreakSpace:"\u00a0",noSeparator:"",apostrophe:"'",arabicThousandsSeparator:"\u066c",
dotAbove:"\u02d9",privateUseTwo:"\u2019"},divisorWhenUnfocused:{none:null,percentage:100,permille:1E3,basisPoint:1E4},emptyInputBehavior:{focus:"focus",press:"press",always:"always",zero:"zero",min:"min",max:"max","null":"null"},eventBubbles:{bubbles:!0,doesNotBubble:!1},eventIsCancelable:{isCancelable:!0,isNotCancelable:!1},failOnUnknownOption:{fail:!0,ignore:!1},formatOnPageLoad:{format:!0,doNotFormat:!1},formulaMode:{enabled:!0,disabled:!1},historySize:{verySmall:5,small:10,medium:20,large:50,
veryLarge:100,insane:Number.MAX_SAFE_INTEGER},invalidClass:"an-invalid",isCancellable:{cancellable:!0,notCancellable:!1},leadingZero:{allow:"allow",deny:"deny",keep:"keep"},maximumValue:{tenTrillions:"10000000000000",oneBillion:"1000000000",zero:"0"},minimumValue:{tenTrillions:"-10000000000000",oneBillion:"-1000000000",zero:"0"},modifyValueOnWheel:{modifyValue:!0,doNothing:!1},negativeBracketsTypeOnBlur:{parentheses:"(,)",brackets:"[,]",chevrons:"\x3c,\x3e",curlyBraces:"{,}",angleBrackets:"\u3008,\u3009",
japaneseQuotationMarks:"\uff62,\uff63",halfBrackets:"\u2e24,\u2e25",whiteSquareBrackets:"\u27e6,\u27e7",quotationMarks:"\u2039,\u203a",guillemets:"\u00ab,\u00bb",none:null},negativePositiveSignPlacement:{prefix:"p",suffix:"s",left:"l",right:"r",none:null},negativeSignCharacter:{hyphen:"-",minus:"\u2212",heavyMinus:"\u2796",fullWidthHyphen:"\uff0d",circledMinus:"\u2296",squaredMinus:"\u229f",triangleMinus:"\u2a3a",plusMinus:"\u00b1",minusPlus:"\u2213",dotMinus:"\u2238",minusTilde:"\u2242",not:"\u00ac"},
noEventListeners:{noEvents:!0,addEvents:!1},onInvalidPaste:{error:"error",ignore:"ignore",clamp:"clamp",truncate:"truncate",replace:"replace"},outputFormat:{string:"string",number:"number",dot:".",negativeDot:"-.",comma:",",negativeComma:"-,",dotNegative:".-",commaNegative:",-",none:null},overrideMinMaxLimits:{ceiling:"ceiling",floor:"floor",ignore:"ignore",invalid:"invalid",doNotOverride:null},positiveSignCharacter:{plus:"+",fullWidthPlus:"\uff0b",heavyPlus:"\u2795",doublePlus:"\u29fa",triplePlus:"\u29fb",
circledPlus:"\u2295",squaredPlus:"\u229e",trianglePlus:"\u2a39",plusMinus:"\u00b1",minusPlus:"\u2213",dotPlus:"\u2214",altHebrewPlus:"\ufb29",normalSpace:" ",thinSpace:"\u2009",narrowNoBreakSpace:"\u202f",noBreakSpace:"\u00a0"},rawValueDivisor:{none:null,percentage:100,permille:1E3,basisPoint:1E4},readOnly:{readOnly:!0,readWrite:!1},roundingMethod:{halfUpSymmetric:"S",halfUpAsymmetric:"A",halfDownSymmetric:"s",halfDownAsymmetric:"a",halfEvenBankersRounding:"B",upRoundAwayFromZero:"U",downRoundTowardZero:"D",
toCeilingTowardPositiveInfinity:"C",toFloorTowardNegativeInfinity:"F",toNearest05:"N05",toNearest05Alt:"CHF",upToNext05:"U05",downToNext05:"D05"},saveValueToSessionStorage:{save:!0,doNotSave:!1},selectNumberOnly:{selectNumbersOnly:!0,selectAll:!1},selectOnFocus:{select:!0,doNotSelect:!1},serializeSpaces:{plus:"+",percent:"%20"},showOnlyNumbersOnFocus:{onlyNumbers:!0,showAll:!1},showPositiveSign:{show:!0,hide:!1},showWarnings:{show:!0,hide:!1},styleRules:{none:null,positiveNegative:{positive:"autoNumeric-positive",
negative:"autoNumeric-negative"},range0To100With4Steps:{ranges:[{min:0,max:25,"class":"autoNumeric-red"},{min:25,max:50,"class":"autoNumeric-orange"},{min:50,max:75,"class":"autoNumeric-yellow"},{min:75,max:100,"class":"autoNumeric-green"}]},evenOdd:{userDefined:[{callback:function(r){return 0===r%2},classes:["autoNumeric-even","autoNumeric-odd"]}]},rangeSmallAndZero:{userDefined:[{callback:function(r){return-1<=r&&0>r?0:0===Number(r)?1:0<r&&1>=r?2:null},classes:["autoNumeric-small-negative","autoNumeric-zero",
"autoNumeric-small-positive"]}]}},suffixText:{none:"",percentage:"%",permille:"\u2030",basisPoint:"\u2031"},symbolWhenUnfocused:{none:null,percentage:"%",permille:"\u2030",basisPoint:"\u2031"},unformatOnHover:{unformat:!0,doNotUnformat:!1},unformatOnSubmit:{unformat:!0,keepCurrentValue:!1},valuesToStrings:{none:null,zeroDash:{0:"-"},oneAroundZero:{"-1":"Min",1:"Max"}},watchExternalChanges:{watch:!0,doNotWatch:!1},wheelOn:{focus:"focus",hover:"hover"},wheelStep:{progressive:"progressive"}};(function(r){Object.getOwnPropertyNames(r).forEach(function(C){"valuesToStrings"===
C?Object.getOwnPropertyNames(r.valuesToStrings).forEach(function(A){n["default"].isIE11()||null===r.valuesToStrings[A]||Object.freeze(r.valuesToStrings[A])}):"styleRules"!==C&&(n["default"].isIE11()||null===r[C]||Object.freeze(r[C]))});return Object.freeze(r)})(m["default"].options);Object.defineProperty(m["default"],"options",{configurable:!1,writable:!1})},"./src/AutoNumericPredefinedOptions.js":function(m,u,x){x.r(u);var n=x("./src/AutoNumeric.js"),r=x("./src/AutoNumericHelper.js");m={digitGroupSeparator:n["default"].options.digitGroupSeparator.dot,
decimalCharacter:n["default"].options.decimalCharacter.comma,decimalCharacterAlternative:n["default"].options.decimalCharacterAlternative.dot,currencySymbol:"\u202f\u20ac",currencySymbolPlacement:n["default"].options.currencySymbolPlacement.suffix,negativePositiveSignPlacement:n["default"].options.negativePositiveSignPlacement.prefix};u={digitGroupSeparator:n["default"].options.digitGroupSeparator.comma,decimalCharacter:n["default"].options.decimalCharacter.dot,currencySymbol:n["default"].options.currencySymbol.dollar,
currencySymbolPlacement:n["default"].options.currencySymbolPlacement.prefix,negativePositiveSignPlacement:n["default"].options.negativePositiveSignPlacement.right};x={digitGroupSeparator:n["default"].options.digitGroupSeparator.comma,decimalCharacter:n["default"].options.decimalCharacter.dot,currencySymbol:n["default"].options.currencySymbol.yen,currencySymbolPlacement:n["default"].options.currencySymbolPlacement.prefix,negativePositiveSignPlacement:n["default"].options.negativePositiveSignPlacement.right};
r["default"].cloneObject(m).formulaMode=n["default"].options.formulaMode.enabled;var C=r["default"].cloneObject(m);C.minimumValue=0;var A=r["default"].cloneObject(m);A.maximumValue=0;A.negativePositiveSignPlacement=n["default"].options.negativePositiveSignPlacement.prefix;var z=r["default"].cloneObject(m);z.digitGroupSeparator=n["default"].options.digitGroupSeparator.normalSpace;var y=r["default"].cloneObject(z);y.minimumValue=0;var v=r["default"].cloneObject(z);v.maximumValue=0;v.negativePositiveSignPlacement=
n["default"].options.negativePositiveSignPlacement.prefix;var D=r["default"].cloneObject(m);D.currencySymbol=n["default"].options.currencySymbol.none;D.suffixText="\u202f".concat(n["default"].options.suffixText.percentage);D.wheelStep=1E-4;D.rawValueDivisor=n["default"].options.rawValueDivisor.percentage;var c=r["default"].cloneObject(D);c.minimumValue=0;var w=r["default"].cloneObject(D);w.maximumValue=0;w.negativePositiveSignPlacement=n["default"].options.negativePositiveSignPlacement.prefix;var E=
r["default"].cloneObject(D);E.decimalPlaces=3;var f=r["default"].cloneObject(c);f.decimalPlaces=3;var k=r["default"].cloneObject(w);k.decimalPlaces=3;r["default"].cloneObject(u).formulaMode=n["default"].options.formulaMode.enabled;var d=r["default"].cloneObject(u);d.minimumValue=0;var a=r["default"].cloneObject(u);a.maximumValue=0;a.negativePositiveSignPlacement=n["default"].options.negativePositiveSignPlacement.prefix;var b=r["default"].cloneObject(a);b.negativeBracketsTypeOnBlur=n["default"].options.negativeBracketsTypeOnBlur.parentheses;
var e=r["default"].cloneObject(u);e.currencySymbol=n["default"].options.currencySymbol.none;e.suffixText=n["default"].options.suffixText.percentage;e.wheelStep=1E-4;e.rawValueDivisor=n["default"].options.rawValueDivisor.percentage;var h=r["default"].cloneObject(e);h.minimumValue=0;var g=r["default"].cloneObject(e);g.maximumValue=0;g.negativePositiveSignPlacement=n["default"].options.negativePositiveSignPlacement.prefix;var l=r["default"].cloneObject(e);l.decimalPlaces=3;var p=r["default"].cloneObject(h);
p.decimalPlaces=3;var q=r["default"].cloneObject(g);q.decimalPlaces=3;r=r["default"].cloneObject(m);r.currencySymbol=n["default"].options.currencySymbol.lira;n["default"].predefinedOptions={euro:m,euroPos:C,euroNeg:A,euroSpace:z,euroSpacePos:y,euroSpaceNeg:v,percentageEU2dec:D,percentageEU2decPos:c,percentageEU2decNeg:w,percentageEU3dec:E,percentageEU3decPos:f,percentageEU3decNeg:k,dollar:u,dollarPos:d,dollarNeg:a,dollarNegBrackets:b,percentageUS2dec:e,percentageUS2decPos:h,percentageUS2decNeg:g,
percentageUS3dec:l,percentageUS3decPos:p,percentageUS3decNeg:q,French:m,Spanish:m,NorthAmerican:u,British:{digitGroupSeparator:n["default"].options.digitGroupSeparator.comma,decimalCharacter:n["default"].options.decimalCharacter.dot,currencySymbol:n["default"].options.currencySymbol.pound,currencySymbolPlacement:n["default"].options.currencySymbolPlacement.prefix,negativePositiveSignPlacement:n["default"].options.negativePositiveSignPlacement.right},Swiss:{digitGroupSeparator:n["default"].options.digitGroupSeparator.apostrophe,
decimalCharacter:n["default"].options.decimalCharacter.dot,currencySymbol:"\u202fCHF",currencySymbolPlacement:n["default"].options.currencySymbolPlacement.suffix,negativePositiveSignPlacement:n["default"].options.negativePositiveSignPlacement.prefix},Japanese:x,Chinese:x,Brazilian:{digitGroupSeparator:n["default"].options.digitGroupSeparator.dot,decimalCharacter:n["default"].options.decimalCharacter.comma,currencySymbol:n["default"].options.currencySymbol.real,currencySymbolPlacement:n["default"].options.currencySymbolPlacement.prefix,
negativePositiveSignPlacement:n["default"].options.negativePositiveSignPlacement.right},Turkish:r,dotDecimalCharCommaSeparator:{digitGroupSeparator:n["default"].options.digitGroupSeparator.comma,decimalCharacter:n["default"].options.decimalCharacter.dot},commaDecimalCharDotSeparator:{digitGroupSeparator:n["default"].options.digitGroupSeparator.dot,decimalCharacter:n["default"].options.decimalCharacter.comma,decimalCharacterAlternative:n["default"].options.decimalCharacterAlternative.dot},integer:{decimalPlaces:0},
integerPos:{minimumValue:n["default"].options.minimumValue.zero,decimalPlaces:0},integerNeg:{maximumValue:n["default"].options.maximumValue.zero,decimalPlaces:0},"float":{allowDecimalPadding:n["default"].options.allowDecimalPadding.never},floatPos:{allowDecimalPadding:n["default"].options.allowDecimalPadding.never,minimumValue:n["default"].options.minimumValue.zero,maximumValue:n["default"].options.maximumValue.tenTrillions},floatNeg:{allowDecimalPadding:n["default"].options.allowDecimalPadding.never,
minimumValue:n["default"].options.minimumValue.tenTrillions,maximumValue:n["default"].options.maximumValue.zero},numeric:{digitGroupSeparator:n["default"].options.digitGroupSeparator.noSeparator,decimalCharacter:n["default"].options.decimalCharacter.dot,currencySymbol:n["default"].options.currencySymbol.none},numericPos:{digitGroupSeparator:n["default"].options.digitGroupSeparator.noSeparator,decimalCharacter:n["default"].options.decimalCharacter.dot,currencySymbol:n["default"].options.currencySymbol.none,
minimumValue:n["default"].options.minimumValue.zero,maximumValue:n["default"].options.maximumValue.tenTrillions},numericNeg:{digitGroupSeparator:n["default"].options.digitGroupSeparator.noSeparator,decimalCharacter:n["default"].options.decimalCharacter.dot,currencySymbol:n["default"].options.currencySymbol.none,minimumValue:n["default"].options.minimumValue.tenTrillions,maximumValue:n["default"].options.maximumValue.zero}};Object.getOwnPropertyNames(n["default"].predefinedOptions).forEach(function(t){Object.freeze(n["default"].predefinedOptions[t])});
Object.freeze(n["default"].predefinedOptions);Object.defineProperty(n["default"],"predefinedOptions",{configurable:!1,writable:!1})},"./src/main.js":function(m,u,x){x.r(u);m=x("./src/AutoNumeric.js");x("./src/AutoNumericEvents.js");x("./src/AutoNumericOptions.js");x("./src/AutoNumericDefaultSettings.js");x("./src/AutoNumericPredefinedOptions.js");u["default"]=m["default"]},"./src/maths/ASTNode.js":function(m,u,x){function n(A,z){for(var y=0;y<z.length;y++){var v=z[y];v.enumerable=v.enumerable||!1;
v.configurable=!0;"value"in v&&(v.writable=!0);Object.defineProperty(A,v.key,v)}}function r(A,z,y){z&&n(A.prototype,z);y&&n(A,y);return A}x.r(u);x.d(u,"default",function(){return C});var C=function(){function A(){if(!(this instanceof A))throw new TypeError("Cannot call a class as a function");}r(A,null,[{key:"createNode",value:function(z,y,v){var D=new A;D.type=z;D.left=y;D.right=v;return D}},{key:"createUnaryNode",value:function(z){var y=new A;y.type="unaryMinus";y.left=z;y.right=null;return y}},
{key:"createLeaf",value:function(z){var y=new A;y.type="number";y.value=z;return y}}]);return A}()},"./src/maths/Evaluator.js":function(m,u,x){function n(A,z){for(var y=0;y<z.length;y++){var v=z[y];v.enumerable=v.enumerable||!1;v.configurable=!0;"value"in v&&(v.writable=!0);Object.defineProperty(A,v.key,v)}}function r(A,z,y){z&&n(A.prototype,z);y&&n(A,y);return A}x.r(u);x.d(u,"default",function(){return C});var C=function(){function A(z){if(!(this instanceof A))throw new TypeError("Cannot call a class as a function");
if(null===z)throw Error("Invalid AST");}r(A,[{key:"evaluate",value:function(z){if(void 0===z||null===z)throw Error("Invalid AST sub-tree");if("number"===z.type)return z.value;if("unaryMinus"===z.type)return-this.evaluate(z.left);var y=this.evaluate(z.left),v=this.evaluate(z.right);switch(z.type){case "op_+":return Number(y)+Number(v);case "op_-":return y-v;case "op_*":return y*v;case "op_/":return y/v;default:throw Error("Invalid operator '".concat(z.type,"'"));}}}]);return A}()},"./src/maths/Lexer.js":function(m,
u,x){function n(y,v){for(var D=0;D<v.length;D++){var c=v[D];c.enumerable=c.enumerable||!1;c.configurable=!0;"value"in c&&(c.writable=!0);Object.defineProperty(y,c.key,c)}}function r(y,v,D){v&&n(y.prototype,v);D&&n(y,D);return y}x.r(u);x.d(u,"default",function(){return z});var C=x("./src/AutoNumericHelper.js"),A=x("./src/maths/Token.js"),z=function(){function y(v){if(!(this instanceof y))throw new TypeError("Cannot call a class as a function");this.text=v;this.textLength=v.length;this.index=0;this.token=
new A["default"]("Error",0,0)}r(y,[{key:"_skipSpaces",value:function(){for(;" "===this.text[this.index]&&this.index<=this.textLength;)this.index++}},{key:"getIndex",value:function(){return this.index}},{key:"getNextToken",value:function(){var v=0<arguments.length&&void 0!==arguments[0]?arguments[0]:".";this._skipSpaces();if(this.textLength===this.index)return this.token.type="EOT",this.token;if(C["default"].isDigit(this.text[this.index]))return this.token.type="num",this.token.value=this._getNumber(v),
this.token;this.token.type="Error";switch(this.text[this.index]){case "+":this.token.type="+";break;case "-":this.token.type="-";break;case "*":this.token.type="*";break;case "/":this.token.type="/";break;case "(":this.token.type="(";break;case ")":this.token.type=")"}if("Error"!==this.token.type)this.token.symbol=this.text[this.index],this.index++;else throw Error("Unexpected token '".concat(this.token.symbol,"' at position '").concat(this.token.index,"' in the token function"));return this.token}},
{key:"_getNumber",value:function(v){this._skipSpaces();for(var D=this.index;this.index<=this.textLength&&C["default"].isDigit(this.text[this.index]);)this.index++;for(this.text[this.index]===v&&this.index++;this.index<=this.textLength&&C["default"].isDigit(this.text[this.index]);)this.index++;if(this.index===D)throw Error("No number has been found while it was expected");return this.text.substring(D,this.index).replace(v,".")}}]);return y}()},"./src/maths/Parser.js":function(m,u,x){function n(y,v){for(var D=
0;D<v.length;D++){var c=v[D];c.enumerable=c.enumerable||!1;c.configurable=!0;"value"in c&&(c.writable=!0);Object.defineProperty(y,c.key,c)}}function r(y,v,D){v&&n(y.prototype,v);D&&n(y,D);return y}x.r(u);x.d(u,"default",function(){return z});var C=x("./src/maths/ASTNode.js"),A=x("./src/maths/Lexer.js"),z=function(){function y(v){var D=1<arguments.length&&void 0!==arguments[1]?arguments[1]:".";if(!(this instanceof y))throw new TypeError("Cannot call a class as a function");this.text=v;this.decimalCharacter=
D;this.lexer=new A["default"](v);this.token=this.lexer.getNextToken(this.decimalCharacter);return this._exp()}r(y,[{key:"_exp",value:function(){var v=this._term(),D=this._moreExp();return C["default"].createNode("op_+",v,D)}},{key:"_moreExp",value:function(){switch(this.token.type){case "+":this.token=this.lexer.getNextToken(this.decimalCharacter);var v=this._term();var D=this._moreExp();return C["default"].createNode("op_+",D,v);case "-":return this.token=this.lexer.getNextToken(this.decimalCharacter),
v=this._term(),D=this._moreExp(),C["default"].createNode("op_-",D,v)}return C["default"].createLeaf(0)}},{key:"_term",value:function(){var v=this._factor(),D=this._moreTerms();return C["default"].createNode("op_*",v,D)}},{key:"_moreTerms",value:function(){switch(this.token.type){case "*":this.token=this.lexer.getNextToken(this.decimalCharacter);var v=this._factor();var D=this._moreTerms();return C["default"].createNode("op_*",D,v);case "/":return this.token=this.lexer.getNextToken(this.decimalCharacter),
v=this._factor(),D=this._moreTerms(),C["default"].createNode("op_/",D,v)}return C["default"].createLeaf(1)}},{key:"_factor",value:function(){switch(this.token.type){case "num":var v=this.token.value;this.token=this.lexer.getNextToken(this.decimalCharacter);return C["default"].createLeaf(v);case "-":return this.token=this.lexer.getNextToken(this.decimalCharacter),v=this._factor(),C["default"].createUnaryNode(v);case "(":return this.token=this.lexer.getNextToken(this.decimalCharacter),v=this._exp(),
this._match(")"),v;default:throw Error("Unexpected token '".concat(this.token.symbol,"' with type '").concat(this.token.type,"' at position '").concat(this.token.index,"' in the factor function"));}}},{key:"_match",value:function(v){var D=this.lexer.getIndex()-1;if(this.text[D]===v)this.token=this.lexer.getNextToken(this.decimalCharacter);else throw Error("Unexpected token '".concat(this.token.symbol,"' at position '").concat(D,"' in the match function"));}}]);return y}()},"./src/maths/Token.js":function(m,
u,x){x.r(u);x.d(u,"default",function(){return n});var n=function y(C,A,z){if(!(this instanceof y))throw new TypeError("Cannot call a class as a function");this.type=C;this.value=A;this.symbol=z}}})["default"]});
PrimeFaces.widget.InputNumber=PrimeFaces.widget.BaseWidget.extend({init:function(m){this._super(m);this.input=$(this.jqId+"_input");this.hiddenInput=$(this.jqId+"_hinput");this.plugOptArray=m.pluginOptions;this.valueToRender=m.valueToRender;this.disabled=m.disabled;if(1<=this.cfg.minimumValue||0>this.cfg.maximumValue)this.cfg.overrideMinMaxLimits="invalid";this.disabled&&(this.input.attr("disabled","disabled"),this.input.addClass("ui-state-disabled"),this.hiddenInput.attr("disabled","disabled"));
PrimeFaces.skinInput(this.input);this.wrapEvents();this.bindInputEvents();this.autonumeric=new AutoNumeric(this.jqId+"_input",this.cfg);""!==this.valueToRender&&(this.autonumeric.set(this.valueToRender),this.autonumeric.rawValueOnFocus=this.valueToRender);this.copyValueToHiddenInput();this.input.data(PrimeFaces.CLIENT_ID_DATA,this.id);this.hiddenInput.data(PrimeFaces.CLIENT_ID_DATA,this.id)},wrapEvents:function(){var m=this,u=this.input[0]?$._data(this.input[0],"events"):null,x=this.input.prop("onkeyup");
!x&&u&&u.keyup&&(x=u.keyup[0].handler);this.input.prop("onkeyup",null).off("keyup").on("keyup.inputnumber",function(C){var A=C.which;if(8===A||13===A||32===A||46<=A&&90>=A||96<=A&&111>=A||186<=A&&222>=A)var z=m.copyValueToHiddenInput();if(x&&!1===x.call(this,C))return z&&m.setValueToHiddenInput(z),!1});var n=this.input.prop("onchange");!n&&u&&u.change&&(n=u.change[0].handler);this.input.prop("onchange",null).off("change").on("change.inputnumber",function(C){var A=m.copyValueToHiddenInput();if(n&&
!1===n.call(this,C))return m.setValueToHiddenInput(A),!1});var r=this.input.prop("onkeydown");!r&&u&&u.keydown&&(r=u.keydown[0].handler);this.input.prop("onkeydown",null).off("keydown").on("keydown.inputnumber",function(C){var A=m.copyValueToHiddenInput();if(r&&!1===r.call(this,C))return m.setValueToHiddenInput(A),!1})},bindInputEvents:function(){var m=this;this.input.off("blur.inputnumber").on("blur.inputnumber",function(u){if((u=AutoNumeric.getAutoNumericElement(this))&&this.value&&0<this.value.length){var x=
this.value.trim();m.cfg.digitGroupSeparator&&(x=x.replaceAll(m.cfg.digitGroupSeparator,""));u.set(x,null,!0);Number(u.rawValue)===Number(u.rawValueOnFocus)&&(u.rawValueOnFocus=u.rawValue)}m.copyValueToHiddenInput()})},copyValueToHiddenInput:function(){var m=this.hiddenInput.val(),u=this.getValue();(""===m^""===u||Number(m)!==Number(u))&&this.setValueToHiddenInput(u);return m},setValueToHiddenInput:function(m){this.hiddenInput.val(m).trigger("input.slider")},enable:function(){PrimeFaces.utils.enableInputWidget(this.input);
PrimeFaces.utils.enableInputWidget(this.hiddenInput);this.disabled=!1},disable:function(){PrimeFaces.utils.disableInputWidget(this.input);PrimeFaces.utils.disableInputWidget(this.hiddenInput);this.disabled=!0},setValue:function(m){this.autonumeric.set(m);m=this.getValue();this.hiddenInput.attr("value",m)},getValue:function(){var m=this.autonumeric.getNumericString();if(this.autonumeric.getSettings().allowDecimalPadding&&m&&0<parseInt(this.cfg.decimalPlaces,10)){if(-1===m.indexOf(".")){var u=this.cfg.decimalPlaces;
m+="."}else u=m.length-m.indexOf(".")-1,u=this.cfg.decimalPlaces-u;for(;0<u--;)m+="0"}m&&m.endsWith(this.cfg.decimalCharacter)&&(m=m.substring(0,m.length-1));return m}});