/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.behavior.ajax;

import jakarta.el.ELContext;
import jakarta.el.MethodExpression;
import jakarta.el.MethodNotFoundException;
import jakarta.el.PropertyNotFoundException;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.AjaxBehaviorEvent;
import jakarta.faces.event.AjaxBehaviorListener;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AjaxBehaviorListenerImpl
implements AjaxBehaviorListener,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(AjaxBehaviorListenerImpl.class.getName());
    private MethodExpression listener;
    private MethodExpression listenerWithArg;
    private MethodExpression listenerWithCustomArg;

    public AjaxBehaviorListenerImpl() {
    }

    public AjaxBehaviorListenerImpl(MethodExpression listener, MethodExpression listenerWithArg) {
        this(listener, listenerWithArg, null);
    }

    public AjaxBehaviorListenerImpl(MethodExpression listener, MethodExpression listenerWithArg, MethodExpression listenerWithCustomArg) {
        this.listener = listener;
        this.listenerWithArg = listenerWithArg;
        this.listenerWithCustomArg = listenerWithCustomArg;
    }

    public void processAjaxBehavior(AjaxBehaviorEvent event) throws AbortProcessingException {
        FacesContext context = FacesContext.getCurrentInstance();
        ELContext elContext = context.getELContext();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Try to invoke listener: " + this.listener.getExpressionString());
        }
        try {
            this.listener.invoke(elContext, new Object[0]);
        }
        catch (MethodNotFoundException | PropertyNotFoundException | ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            this.processArgListener(context, elContext, event);
        }
    }

    private void processArgListener(FacesContext context, ELContext elContext, AjaxBehaviorEvent event) throws AbortProcessingException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Try to invoke listenerWithArg: " + this.listenerWithArg.getExpressionString());
        }
        try {
            this.listenerWithArg.invoke(elContext, new Object[]{event});
        }
        catch (MethodNotFoundException | PropertyNotFoundException | ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            this.processCustomArgListener(context, elContext, event);
        }
    }

    private void processCustomArgListener(FacesContext context, ELContext elContext, AjaxBehaviorEvent event) throws AbortProcessingException {
        if (this.listenerWithCustomArg == null) {
            MethodExpression argListener = context.getApplication().getExpressionFactory().createMethodExpression(elContext, this.listener.getExpressionString(), Void.class, new Class[]{event.getClass()});
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Try to invoke customListener: " + argListener.getExpressionString());
            }
            argListener.invoke(elContext, new Object[]{event});
        } else {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Try to invoke customListener: " + this.listenerWithCustomArg.getExpressionString());
            }
            this.listenerWithCustomArg.invoke(elContext, new Object[]{event});
        }
    }
}

