/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.accordionpanel;

import jakarta.el.ELContext;
import jakarta.el.MethodExpression;
import jakarta.el.ValueExpression;
import jakarta.faces.application.ResourceDependencies;
import jakarta.faces.application.ResourceDependency;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.AjaxBehaviorEvent;
import jakarta.faces.event.BehaviorEvent;
import jakarta.faces.event.FacesEvent;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.primefaces.PrimeFaces;
import org.primefaces.component.accordionpanel.AccordionPanelBase;
import org.primefaces.component.tabview.Tab;
import org.primefaces.el.ValueExpressionAnalyzer;
import org.primefaces.event.TabChangeEvent;
import org.primefaces.event.TabCloseEvent;
import org.primefaces.event.TabEvent;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.MapBuilder;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="components.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="jquery/jquery-plugins.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="components.js")})
public class AccordionPanel
extends AccordionPanelBase {
    public static final String COMPONENT_TYPE = "org.primefaces.component.AccordionPanel";
    public static final String CONTAINER_CLASS = "ui-accordion ui-widget ui-helper-reset ui-hidden-container";
    public static final String ACTIVE_TAB_HEADER_CLASS = "ui-accordion-header ui-helper-reset ui-state-default ui-state-active ui-corner-top";
    public static final String TAB_HEADER_CLASS = "ui-accordion-header ui-helper-reset ui-state-default ui-corner-all";
    public static final String TAB_HEADER_ICON_CLASS = "ui-icon ui-icon-triangle-1-e";
    public static final String TAB_HEADER_ICON_RTL_CLASS = "ui-icon ui-icon-triangle-1-w";
    public static final String ACTIVE_TAB_HEADER_ICON_CLASS = "ui-icon ui-icon-triangle-1-s";
    public static final String ACTIVE_TAB_CONTENT_CLASS = "ui-accordion-content ui-helper-reset ui-widget-content";
    public static final String INACTIVE_TAB_CONTENT_CLASS = "ui-accordion-content ui-helper-reset ui-widget-content ui-helper-hidden";
    private static final String DEFAULT_EVENT = "tabChange";
    private static final Map<String, Class<? extends BehaviorEvent>> BEHAVIOR_EVENT_MAPPING = MapBuilder.builder().put("tabChange", TabChangeEvent.class).put("tabClose", TabCloseEvent.class).build();
    private static final Collection<String> EVENT_NAMES = BEHAVIOR_EVENT_MAPPING.keySet();

    @Override
    public Map<String, Class<? extends BehaviorEvent>> getBehaviorEventMapping() {
        return BEHAVIOR_EVENT_MAPPING;
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public String getDefaultEventName() {
        return DEFAULT_EVENT;
    }

    public boolean isContentLoadRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_contentLoad");
    }

    public Tab findTab(String tabClientId) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            UIComponent child = (UIComponent)this.getChildren().get(i);
            if (!child.getClientId().equals(tabClientId)) continue;
            return (Tab)child;
        }
        return null;
    }

    @Override
    public void queueEvent(FacesEvent event) {
        FacesContext context = this.getFacesContext();
        if (ComponentUtils.isRequestSource((UIComponent)this, context) && event instanceof AjaxBehaviorEvent) {
            Map params = context.getExternalContext().getRequestParameterMap();
            String eventName = (String)params.get("jakarta.faces.behavior.event");
            String clientId = this.getClientId(context);
            boolean repeating = this.isRepeating();
            AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
            if (DEFAULT_EVENT.equals(eventName)) {
                String tabClientId = (String)params.get(clientId + "_newTab");
                TabChangeEvent changeEvent = new TabChangeEvent((UIComponent)this, behaviorEvent.getBehavior(), this.findTab(tabClientId));
                if (repeating) {
                    int index = Integer.parseInt((String)params.get(clientId + "_tabindex"));
                    this.setIndex(index);
                    changeEvent.setData(this.getIndexData());
                    changeEvent.setTab(this.getDynamicTab());
                }
                changeEvent.setPhaseId(behaviorEvent.getPhaseId());
                super.queueEvent((FacesEvent)changeEvent);
                if (repeating) {
                    this.setIndex(-1);
                }
            } else if ("tabClose".equals(eventName)) {
                String tabClientId = (String)params.get(clientId + "_tabId");
                TabCloseEvent closeEvent = new TabCloseEvent((UIComponent)this, behaviorEvent.getBehavior(), this.findTab(tabClientId));
                if (repeating) {
                    int index = Integer.parseInt((String)params.get(clientId + "_tabindex"));
                    this.setIndex(index);
                    closeEvent.setData(this.getIndexData());
                    closeEvent.setTab(this.getDynamicTab());
                }
                closeEvent.setPhaseId(behaviorEvent.getPhaseId());
                super.queueEvent((FacesEvent)closeEvent);
                if (repeating) {
                    this.setIndex(-1);
                }
            }
        } else {
            super.queueEvent(event);
        }
    }

    @Override
    public void processUpdates(FacesContext context) {
        if (!this.isRendered()) {
            return;
        }
        super.processUpdates(context);
        ELContext elContext = this.getFacesContext().getELContext();
        ValueExpression expr = ValueExpressionAnalyzer.getExpression(elContext, this.getValueExpression(AccordionPanelBase.PropertyKeys.activeIndex.toString()), true);
        if (expr != null && !expr.isReadOnly(elContext)) {
            expr.setValue(elContext, (Object)this.getActiveIndex());
            this.resetActiveIndex();
        }
    }

    protected void resetActiveIndex() {
        this.getStateHelper().remove((Serializable)((Object)AccordionPanelBase.PropertyKeys.activeIndex));
    }

    @Override
    public void broadcast(FacesEvent event) throws AbortProcessingException {
        MethodExpression me;
        super.broadcast(event);
        if (event instanceof TabEvent && (me = this.getTabController()) != null) {
            boolean retVal = (Boolean)me.invoke(this.getFacesContext().getELContext(), new Object[]{event});
            PrimeFaces.current().ajax().addCallbackParam("access", retVal);
        }
    }
}

