/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.ajaxstatus;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import org.primefaces.component.ajaxstatus.AjaxStatus;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.WidgetBuilder;

public class AjaxStatusRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        AjaxStatus status = (AjaxStatus)component;
        this.encodeMarkup(context, status);
        this.encodeScript(context, status);
    }

    protected void encodeScript(FacesContext context, AjaxStatus status) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("AjaxStatus", status);
        wb.attr("delay", status.getDelay());
        wb.callback("start", "function()", status.getOnstart()).callback("error", "function()", status.getOnerror()).callback("success", "function()", status.getOnsuccess()).callback("complete", "function()", status.getOncomplete());
        wb.finish();
    }

    protected void encodeMarkup(FacesContext context, AjaxStatus status) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = status.getClientId(context);
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        if (status.getStyle() != null) {
            writer.writeAttribute("style", (Object)status.getStyle(), "style");
        }
        if (status.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)status.getStyleClass(), "styleClass");
        }
        for (int i = 0; i < AjaxStatus.EVENTS.size(); ++i) {
            String event = AjaxStatus.EVENTS.get(i);
            UIComponent facet = status.getFacet(event);
            if (!ComponentUtils.shouldRenderFacet(facet)) continue;
            this.encodeFacet(context, clientId, facet, event, true);
        }
        UIComponent defaultFacet = status.getFacet("default");
        if (ComponentUtils.shouldRenderFacet(defaultFacet)) {
            this.encodeFacet(context, clientId, defaultFacet, "default", false);
        }
        writer.endElement("div");
    }

    protected void encodeFacet(FacesContext context, String clientId, UIComponent facet, String facetName, boolean hidden) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(clientId + "_" + facetName), null);
        if (hidden) {
            writer.writeAttribute("style", (Object)"display:none", null);
        }
        this.renderChild(context, facet);
        writer.endElement("div");
    }
}

