/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.api;

import jakarta.faces.FacesException;
import jakarta.faces.application.Application;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.component.ContextCallback;
import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIComponentBase;
import jakarta.faces.component.UIForm;
import jakarta.faces.component.UINamingContainer;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.component.UniqueIdVendor;
import jakarta.faces.component.visit.VisitCallback;
import jakarta.faces.component.visit.VisitContext;
import jakarta.faces.component.visit.VisitResult;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.PhaseId;
import jakarta.faces.event.PostValidateEvent;
import jakarta.faces.event.PreRenderComponentEvent;
import jakarta.faces.event.PreValidateEvent;
import jakarta.faces.model.ArrayDataModel;
import jakarta.faces.model.DataModel;
import jakarta.faces.model.ListDataModel;
import jakarta.faces.model.ResultSetDataModel;
import jakarta.faces.model.ScalarDataModel;
import jakarta.faces.render.Renderer;
import java.io.IOException;
import java.io.Serializable;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.primefaces.component.api.SavedState;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.column.Column;
import org.primefaces.component.columngroup.ColumnGroup;
import org.primefaces.component.columns.Columns;
import org.primefaces.model.CollectionDataModel;
import org.primefaces.model.IterableDataModel;
import org.primefaces.model.LazyDataModel;
import org.primefaces.util.ComponentTraversalUtils;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.ELUtils;
import org.primefaces.util.SharedStringBuilder;

public class UIData
extends jakarta.faces.component.UIData {
    private static final Logger LOGGER = Logger.getLogger(UIData.class.getName());
    private static final String SB_ID = UIData.class.getName() + "#id";
    private final Map<String, Object> _rowTransientStates = new HashMap<String, Object>();
    private Map<String, Object> _rowDeltaStates = new HashMap<String, Object>();
    private Object _initialDescendantFullComponentState;
    private String clientId;
    private DataModel model;
    private Boolean isNested;
    private Object oldVar;

    public boolean isLazy() {
        return ComponentUtils.eval(this.getStateHelper(), (Serializable)((Object)PropertyKeys.lazy), () -> {
            boolean lazy = false;
            Class<?> type = ELUtils.getType(this.getFacesContext(), this.getValueExpression("value"), () -> this.getValue());
            if (type == null) {
                LOGGER.warning("Unable to automatically determine the `lazy` attribute, fallback to false. Either define the `lazy` attribute on the component or make sure the `value` attribute doesn't resolve to `null`. clientId: " + this.getClientId());
            } else {
                lazy = LazyDataModel.class.isAssignableFrom(type);
            }
            this.setLazy(lazy);
            return lazy;
        });
    }

    public void setLazy(boolean lazy) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.lazy), (Object)lazy);
    }

    public String getRowIndexVar() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.rowIndexVar), null);
    }

    public void setRowIndexVar(String rowIndexVar) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.rowIndexVar), (Object)rowIndexVar);
    }

    public boolean isRowStatePreserved() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.rowStatePreserved), (Object)false);
    }

    public void setRowStatePreserved(boolean rowStatePreserved) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.rowStatePreserved), (Object)rowStatePreserved);
    }

    public void processDecodes(FacesContext context) {
        if (!this.isRendered()) {
            return;
        }
        this.pushComponentToEL(context, (UIComponent)this);
        this.preDecode(context);
        this.processPhase(context, PhaseId.APPLY_REQUEST_VALUES);
        this.decode(context);
        this.popComponentFromEL(context);
    }

    public void processValidators(FacesContext context) {
        if (!this.isRendered()) {
            return;
        }
        this.pushComponentToEL(context, (UIComponent)this);
        Application app = context.getApplication();
        app.publishEvent(context, PreValidateEvent.class, (Object)this);
        this.preValidate(context);
        this.processPhase(context, PhaseId.PROCESS_VALIDATIONS);
        app.publishEvent(context, PostValidateEvent.class, (Object)this);
        this.popComponentFromEL(context);
    }

    public void processUpdates(FacesContext context) {
        if (!this.isRendered()) {
            return;
        }
        this.pushComponentToEL(context, (UIComponent)this);
        this.preUpdate(context);
        this.processPhase(context, PhaseId.UPDATE_MODEL_VALUES);
        this.popComponentFromEL(context);
    }

    protected void processPhase(FacesContext context, PhaseId phaseId) {
        this.processFacets(context, phaseId);
        if (this.requiresColumns()) {
            this.processColumnFacets(context, phaseId);
        }
        if (this.shouldSkipChildren(context)) {
            return;
        }
        this.setRowIndex(-1);
        this.processChildren(context, phaseId);
        this.setRowIndex(-1);
    }

    protected void processFacets(FacesContext context, PhaseId phaseId) {
        if (this.getFacetCount() > 0) {
            for (UIComponent facet : this.getFacets().values()) {
                this.process(context, facet, phaseId);
            }
        }
    }

    protected void processColumnFacets(FacesContext context, PhaseId phaseId) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            UIComponent child = (UIComponent)this.getChildren().get(i);
            if (!child.isRendered() || child.getFacetCount() <= 0) continue;
            for (UIComponent facet : child.getFacets().values()) {
                this.process(context, facet, phaseId);
            }
        }
    }

    protected boolean shouldProcessChild(FacesContext context, int rowIndex, PhaseId phaseId) {
        return true;
    }

    protected void processChildren(FacesContext context, PhaseId phaseId) {
        int first = this.getFirst();
        int rows = this.getRows();
        int last = rows == 0 ? this.getRowCount() : first + rows;
        List<UIComponent> iterableChildren = null;
        for (int rowIndex = first; rowIndex < last; ++rowIndex) {
            this.setRowIndex(rowIndex);
            if (!this.isRowAvailable()) break;
            if (!this.shouldProcessChild(context, rowIndex, phaseId)) continue;
            if (iterableChildren == null) {
                iterableChildren = this.getIterableChildren();
            }
            for (int i = 0; i < iterableChildren.size(); ++i) {
                UIComponent child = iterableChildren.get(i);
                if (!child.isRendered()) continue;
                if (child instanceof Column) {
                    for (UIComponent grandkid : child.getChildren()) {
                        this.process(context, grandkid, phaseId);
                    }
                    continue;
                }
                this.process(context, child, phaseId);
            }
        }
    }

    protected void process(FacesContext context, UIComponent component, PhaseId phaseId) {
        if (phaseId == PhaseId.APPLY_REQUEST_VALUES) {
            component.processDecodes(context);
        } else if (phaseId == PhaseId.PROCESS_VALIDATIONS) {
            component.processValidators(context);
        } else if (phaseId == PhaseId.UPDATE_MODEL_VALUES) {
            component.processUpdates(context);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getClientId(FacesContext context) {
        UIComponent namingContainer;
        if (this.clientId != null) {
            return this.clientId;
        }
        String id = this.getId();
        if (id == null) {
            UniqueIdVendor parentUniqueIdVendor = ComponentTraversalUtils.closestUniqueIdVendor((UIComponent)this);
            if (parentUniqueIdVendor == null) {
                UIViewRoot viewRoot = context.getViewRoot();
                if (viewRoot == null) throw new FacesException("Cannot create clientId for " + ((Object)((Object)this)).getClass().getCanonicalName());
                id = viewRoot.createUniqueId();
            } else {
                id = parentUniqueIdVendor.createUniqueId(context, null);
            }
            this.setId(id);
        }
        if ((namingContainer = ComponentTraversalUtils.closestNamingContainer((UIComponent)this)) != null) {
            String containerClientId = namingContainer.getContainerClientId(context);
            if (containerClientId != null) {
                StringBuilder sb = SharedStringBuilder.get(context, SB_ID, containerClientId.length() + 10);
                this.clientId = sb.append(containerClientId).append(UINamingContainer.getSeparatorChar((FacesContext)context)).append(id).toString();
            } else {
                this.clientId = id;
            }
        } else {
            this.clientId = id;
        }
        Renderer renderer = this.getRenderer(context);
        if (renderer == null) return this.clientId;
        this.clientId = renderer.convertClientId(context, this.clientId);
        return this.clientId;
    }

    public String getContainerClientId(FacesContext context) {
        String componentClientId = this.getClientId(context);
        int rowIndex = this.getRowIndex();
        if (rowIndex == -1) {
            return componentClientId;
        }
        StringBuilder sb = SharedStringBuilder.get(context, SB_ID, componentClientId.length() + 4);
        String containerClientId = sb.append(componentClientId).append(UINamingContainer.getSeparatorChar((FacesContext)context)).append(rowIndex).toString();
        return containerClientId;
    }

    public void setId(String id) {
        super.setId(id);
        this.clientId = null;
    }

    private void setRowIndexRowStatePreserved(int rowIndex) {
        String var;
        if (rowIndex < -1) {
            throw new IllegalArgumentException("rowIndex is less than -1");
        }
        if (this.getRowIndex() == rowIndex) {
            return;
        }
        FacesContext facesContext = this.getFacesContext();
        if (this._initialDescendantFullComponentState != null) {
            Map<String, Object> sm = this.saveFullDescendantComponentStates(facesContext, null, this.getChildren().iterator(), false);
            if (sm != null && !sm.isEmpty()) {
                this._rowDeltaStates.put(this.getContainerClientId(facesContext), sm);
            }
            if (this.getRowIndex() != -1) {
                this._rowTransientStates.put(this.getContainerClientId(facesContext), this.saveTransientDescendantComponentStates(facesContext, null, this.getChildren().iterator(), false));
            }
        }
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.rowIndex), (Object)rowIndex);
        DataModel localModel = this.getDataModel();
        localModel.setRowIndex(rowIndex);
        if (rowIndex == -1) {
            this.setDataModel(null);
        }
        if ((var = this.getVar()) != null) {
            Map requestMap = this.getFacesContext().getExternalContext().getRequestMap();
            if (rowIndex == -1) {
                this.oldVar = requestMap.remove(var);
            } else if (this.isRowAvailable()) {
                requestMap.put(var, this.getRowData());
            } else {
                requestMap.remove(var);
                if (null != this.oldVar) {
                    requestMap.put(var, this.oldVar);
                    this.oldVar = null;
                }
            }
        }
        if (this._initialDescendantFullComponentState != null) {
            Object rowState = this._rowDeltaStates.get(this.getContainerClientId(facesContext));
            if (rowState == null) {
                this.restoreFullDescendantComponentStates(facesContext, this.getChildren().iterator(), this._initialDescendantFullComponentState, false);
            } else {
                this.restoreFullDescendantComponentDeltaStates(facesContext, this.getChildren().iterator(), rowState, this._initialDescendantFullComponentState, false);
            }
            if (this.getRowIndex() == -1) {
                this.restoreTransientDescendantComponentStates(facesContext, this.getChildren().iterator(), null, false);
            } else {
                rowState = this._rowTransientStates.get(this.getContainerClientId(facesContext));
                if (rowState == null) {
                    this.restoreTransientDescendantComponentStates(facesContext, this.getChildren().iterator(), null, false);
                } else {
                    this.restoreTransientDescendantComponentStates(facesContext, this.getChildren().iterator(), (Map)rowState, false);
                }
            }
        }
    }

    private void setRowIndexWithoutRowStatePreserved(int rowIndex) {
        this.saveDescendantState();
        this.setRowModel(rowIndex);
        this.restoreDescendantState();
    }

    public void setRowModel(int rowIndex) {
        String var;
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.rowIndex), (Object)rowIndex);
        this.getDataModel().setRowIndex(rowIndex);
        if (rowIndex == -1) {
            this.setDataModel(null);
        }
        if ((var = this.getVar()) != null) {
            String rowIndexVar = this.getRowIndexVar();
            Map requestMap = this.getFacesContext().getExternalContext().getRequestMap();
            if (rowIndex == -1) {
                this.oldVar = requestMap.remove(var);
                if (rowIndexVar != null) {
                    requestMap.remove(rowIndexVar);
                }
            } else if (this.isRowAvailable()) {
                requestMap.put(var, this.getRowData());
                if (rowIndexVar != null) {
                    requestMap.put(rowIndexVar, rowIndex);
                }
            } else {
                requestMap.remove(var);
                if (rowIndexVar != null) {
                    requestMap.put(rowIndexVar, rowIndex);
                }
                if (this.oldVar != null) {
                    requestMap.put(var, this.oldVar);
                    this.oldVar = null;
                }
            }
        }
    }

    public int getRowIndex() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.rowIndex), (Object)-1);
    }

    public void setRowIndex(int rowIndex) {
        if (this.isRowStatePreserved()) {
            this.setRowIndexRowStatePreserved(rowIndex);
        } else {
            this.setRowIndexWithoutRowStatePreserved(rowIndex);
        }
    }

    protected void saveDescendantState() {
        FacesContext context = this.getFacesContext();
        if (this.getChildCount() > 0) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                UIComponent kid = (UIComponent)this.getChildren().get(i);
                this.saveDescendantState(kid, context);
            }
        }
        if (this.getFacetCount() > 0) {
            for (UIComponent facet : this.getFacets().values()) {
                this.saveDescendantState(facet, context);
            }
        }
    }

    protected void saveDescendantState(UIComponent component, FacesContext context) {
        Map saved = (Map)this.getStateHelper().get((Serializable)((Object)PropertyKeys.saved));
        if (component instanceof EditableValueHolder) {
            EditableValueHolder input = (EditableValueHolder)component;
            SavedState state = null;
            String componentClientId = component.getClientId(context);
            if (saved == null) {
                state = new SavedState();
                this.getStateHelper().put((Serializable)((Object)PropertyKeys.saved), componentClientId, (Object)state);
            }
            if (state == null && (state = (SavedState)saved.get(componentClientId)) == null) {
                state = new SavedState();
                this.getStateHelper().put((Serializable)((Object)PropertyKeys.saved), componentClientId, (Object)state);
            }
            state.setValue(input.getLocalValue());
            state.setValid(input.isValid());
            state.setSubmittedValue(input.getSubmittedValue());
            state.setLocalValueSet(input.isLocalValueSet());
        } else if (component instanceof UIForm) {
            UIForm form = (UIForm)component;
            String componentClientId = component.getClientId(context);
            SavedState state = null;
            if (saved == null) {
                state = new SavedState();
                this.getStateHelper().put((Serializable)((Object)PropertyKeys.saved), componentClientId, (Object)state);
            }
            if (state == null && (state = (SavedState)saved.get(componentClientId)) == null) {
                state = new SavedState();
                this.getStateHelper().put((Serializable)((Object)PropertyKeys.saved), componentClientId, (Object)state);
            }
            state.setSubmitted(form.isSubmitted());
        }
        if (component.getChildCount() > 0) {
            for (int i = 0; i < component.getChildCount(); ++i) {
                UIComponent kid = (UIComponent)component.getChildren().get(i);
                this.saveDescendantState(kid, context);
            }
        }
        if (component.getFacetCount() > 0) {
            for (UIComponent facet : component.getFacets().values()) {
                this.saveDescendantState(facet, context);
            }
        }
    }

    protected void restoreDescendantState() {
        FacesContext context = this.getFacesContext();
        if (this.getChildCount() > 0) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                UIComponent kid = (UIComponent)this.getChildren().get(i);
                this.restoreDescendantState(kid, context);
            }
        }
        if (this.getFacetCount() > 0) {
            for (UIComponent facet : this.getFacets().values()) {
                this.restoreDescendantState(facet, context);
            }
        }
    }

    protected void restoreDescendantState(UIComponent component, FacesContext context) {
        SavedState state;
        String componentClientId;
        String id = component.getId();
        component.setId(id);
        Map saved = (Map)this.getStateHelper().get((Serializable)((Object)PropertyKeys.saved));
        if (component instanceof EditableValueHolder) {
            EditableValueHolder input = (EditableValueHolder)component;
            componentClientId = component.getClientId(context);
            state = (SavedState)saved.get(componentClientId);
            if (state == null) {
                state = new SavedState();
            }
            input.setValue(state.getValue());
            input.setValid(state.isValid());
            input.setSubmittedValue(state.getSubmittedValue());
            input.setLocalValueSet(state.isLocalValueSet());
        } else if (component instanceof UIForm) {
            UIForm form = (UIForm)component;
            componentClientId = component.getClientId(context);
            state = (SavedState)saved.get(componentClientId);
            if (state == null) {
                state = new SavedState();
            }
            form.setSubmitted(state.getSubmitted());
            state.setSubmitted(form.isSubmitted());
        }
        if (component.getChildCount() > 0) {
            for (int i = 0; i < component.getChildCount(); ++i) {
                UIComponent kid = (UIComponent)component.getChildren().get(i);
                this.restoreDescendantState(kid, context);
            }
        }
        if (component.getFacetCount() > 0) {
            for (UIComponent facet : component.getFacets().values()) {
                this.restoreDescendantState(facet, context);
            }
        }
    }

    protected DataModel getDataModel() {
        if (this.model != null) {
            return this.model;
        }
        Object current = this.getValue();
        if (current == null) {
            this.setDataModel((DataModel)new ListDataModel(Collections.emptyList()));
        } else if (current instanceof DataModel) {
            this.setDataModel((DataModel)current);
        } else if (current instanceof List) {
            this.setDataModel((DataModel)new ListDataModel((List)current));
        } else if (Object[].class.isAssignableFrom(current.getClass())) {
            this.setDataModel((DataModel)new ArrayDataModel((Object[])current));
        } else if (current instanceof ResultSet) {
            this.setDataModel((DataModel)new ResultSetDataModel((ResultSet)current));
        } else if (current instanceof Collection) {
            this.setDataModel(new CollectionDataModel((Collection)current));
        } else if (current instanceof Iterable) {
            this.setDataModel(new IterableDataModel((Iterable)current));
        } else if (current instanceof Map) {
            this.setDataModel(new IterableDataModel(((Map)current).entrySet()));
        } else {
            this.setDataModel((DataModel)new ScalarDataModel(current));
        }
        return this.model;
    }

    protected void setDataModel(DataModel dataModel) {
        this.model = dataModel;
    }

    protected boolean shouldSkipChildren(FacesContext context) {
        return false;
    }

    protected boolean shouldVisitChildren(VisitContext context, boolean visitRows) {
        Collection idsToVisit;
        if (visitRows) {
            this.setRowIndex(-1);
        }
        return !(idsToVisit = context.getSubtreeIdsToVisit((UIComponent)this)).isEmpty();
    }

    public boolean invokeOnComponent(FacesContext context, String clientId, ContextCallback callback) throws FacesException {
        if (!clientId.startsWith(this.getClientId(context))) {
            return false;
        }
        return super.invokeOnComponent(context, clientId, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean visitTree(VisitContext context, VisitCallback callback) {
        if (!this.isVisitable(context)) {
            return false;
        }
        FacesContext facesContext = context.getFacesContext();
        boolean visitRows = !ComponentUtils.isSkipIteration(context, facesContext);
        int rowIndex = -1;
        if (visitRows) {
            rowIndex = this.getRowIndex();
            this.setRowIndex(-1);
        }
        this.pushComponentToEL(facesContext, null);
        try {
            VisitResult result = context.invokeVisitCallback((UIComponent)this, callback);
            if (result == VisitResult.COMPLETE) {
                boolean bl = true;
                return bl;
            }
            if (result == VisitResult.ACCEPT && this.shouldVisitChildren(context, visitRows)) {
                if (this.visitFacets(context, callback, visitRows)) {
                    boolean bl = true;
                    return bl;
                }
                if (this.requiresColumns() && this.visitColumnsAndColumnFacets(context, callback, visitRows)) {
                    boolean bl = true;
                    return bl;
                }
                if (this.visitRows(context, callback, visitRows)) {
                    boolean bl = true;
                    return bl;
                }
            }
        }
        finally {
            this.popComponentFromEL(facesContext);
            if (visitRows) {
                this.setRowIndex(rowIndex);
            }
        }
        return false;
    }

    protected boolean visitFacets(VisitContext context, VisitCallback callback, boolean visitRows) {
        if (visitRows) {
            this.setRowIndex(-1);
        }
        if (this.getFacetCount() > 0) {
            for (UIComponent facet : this.getFacets().values()) {
                if (!facet.visitTree(context, callback)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean visitColumnsAndColumnFacets(VisitContext context, VisitCallback callback, boolean visitRows) {
        if (visitRows) {
            this.setRowIndex(-1);
        }
        if (this.getChildCount() > 0) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                UIComponent child = (UIComponent)this.getChildren().get(i);
                VisitResult result = context.invokeVisitCallback(child, callback);
                if (result == VisitResult.COMPLETE) {
                    return true;
                }
                if (child instanceof UIColumn) {
                    if (child.getFacetCount() <= 0) continue;
                    if (child instanceof Columns) {
                        Columns columns = (Columns)child;
                        for (int j = 0; j < columns.getRowCount(); ++j) {
                            columns.setRowIndex(j);
                            boolean value = this.visitColumnFacets(context, callback, child);
                            if (!value) continue;
                            return true;
                        }
                        columns.setRowIndex(-1);
                        continue;
                    }
                    boolean value = this.visitColumnFacets(context, callback, child);
                    if (!value) continue;
                    return true;
                }
                if (!(child instanceof ColumnGroup)) continue;
                this.visitColumnGroup(context, callback, (ColumnGroup)child);
            }
        }
        return false;
    }

    protected boolean visitColumnGroup(VisitContext context, VisitCallback callback, ColumnGroup group) {
        if (group.getChildCount() > 0) {
            for (int i = 0; i < group.getChildCount(); ++i) {
                UIComponent row = (UIComponent)group.getChildren().get(i);
                if (row.getChildCount() <= 0) continue;
                for (int j = 0; j < row.getChildCount(); ++j) {
                    UIComponent col = (UIComponent)row.getChildren().get(j);
                    if (col instanceof Column) {
                        boolean value = this.visitColumnFacets(context, callback, col);
                        if (!value) continue;
                        return true;
                    }
                    if (!(col instanceof Columns) || col.getFacetCount() <= 0) continue;
                    Columns columns = (Columns)col;
                    for (int k = 0; k < columns.getRowCount(); ++k) {
                        columns.setRowIndex(k);
                        boolean value = this.visitColumnFacets(context, callback, (UIComponent)columns);
                        if (!value) continue;
                        columns.setRowIndex(-1);
                        return true;
                    }
                    columns.setRowIndex(-1);
                }
            }
        }
        return false;
    }

    protected boolean visitColumnFacets(VisitContext context, VisitCallback callback, UIComponent component) {
        if (component.getFacetCount() > 0) {
            for (UIComponent columnFacet : component.getFacets().values()) {
                if (!columnFacet.visitTree(context, callback)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean visitRows(VisitContext context, VisitCallback callback, boolean visitRows) {
        boolean requiresColumns = this.requiresColumns();
        int processed = 0;
        int rowIndex = 0;
        int rows = 0;
        if (visitRows) {
            rowIndex = this.getFirst() - 1;
            rows = this.getRows();
        }
        do {
            if (visitRows) {
                if (rows > 0 && ++processed > rows) break;
                this.setRowIndex(++rowIndex);
                if (!this.isRowAvailable()) break;
            }
            if (this.getChildCount() <= 0) continue;
            for (int i = 0; i < this.getChildCount(); ++i) {
                UIComponent kid = (UIComponent)this.getChildren().get(i);
                if (requiresColumns) {
                    if (kid instanceof Columns) {
                        Columns columns = (Columns)kid;
                        for (int j = 0; j < columns.getRowCount(); ++j) {
                            columns.setRowIndex(j);
                            boolean value = this.visitColumnContent(context, callback, (UIComponent)columns);
                            if (!value) continue;
                            columns.setRowIndex(-1);
                            return true;
                        }
                        columns.setRowIndex(-1);
                        continue;
                    }
                    boolean value = this.visitColumnContent(context, callback, kid);
                    if (!value) continue;
                    return true;
                }
                if (!kid.visitTree(context, callback)) continue;
                return true;
            }
        } while (visitRows);
        return false;
    }

    protected boolean visitColumnContent(VisitContext context, VisitCallback callback, UIComponent component) {
        if (component.getChildCount() > 0) {
            for (int i = 0; i < component.getChildCount(); ++i) {
                UIComponent grandkid = (UIComponent)component.getChildren().get(i);
                if (!grandkid.visitTree(context, callback)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean requiresColumns() {
        return false;
    }

    protected List<UIComponent> getIterableChildren() {
        return this.getChildren();
    }

    public void markInitialState() {
        if (this.isRowStatePreserved() && this.getFacesContext().getAttributes().containsKey("jakarta.faces.IS_BUILDING_INITIAL_STATE")) {
            this._initialDescendantFullComponentState = this.saveDescendantInitialComponentStates(this.getFacesContext(), this.getChildren().iterator(), false);
        }
        super.markInitialState();
    }

    private void restoreFullDescendantComponentStates(FacesContext facesContext, Iterator<UIComponent> childIterator, Object state, boolean restoreChildFacets) {
        Iterator descendantStateIterator = null;
        while (childIterator.hasNext()) {
            if (descendantStateIterator == null && state != null) {
                descendantStateIterator = ((Collection)state).iterator();
            }
            UIComponent component = childIterator.next();
            component.setId(component.getId());
            if (component.isTransient()) continue;
            Object childState = null;
            Object descendantState = null;
            if (descendantStateIterator != null && descendantStateIterator.hasNext()) {
                Object[] object = (Object[])descendantStateIterator.next();
                childState = object[0];
                descendantState = object[1];
            }
            component.clearInitialState();
            component.restoreState(facesContext, childState);
            component.markInitialState();
            Iterator<UIComponent> childsIterator = restoreChildFacets ? component.getFacetsAndChildren() : component.getChildren().iterator();
            this.restoreFullDescendantComponentStates(facesContext, childsIterator, descendantState, true);
        }
    }

    private Collection<Object[]> saveDescendantInitialComponentStates(FacesContext facesContext, Iterator<UIComponent> childIterator, boolean saveChildFacets) {
        ArrayList<Object[]> childStates = null;
        while (childIterator.hasNext()) {
            UIComponent child;
            if (childStates == null) {
                childStates = new ArrayList<Object[]>();
            }
            if ((child = childIterator.next()).isTransient()) continue;
            Iterator<UIComponent> childsIterator = saveChildFacets ? child.getFacetsAndChildren() : child.getChildren().iterator();
            Collection<Object[]> descendantState = this.saveDescendantInitialComponentStates(facesContext, childsIterator, true);
            Object state = null;
            if (child.initialStateMarked()) {
                child.clearInitialState();
                state = child.saveState(facesContext);
                child.markInitialState();
            } else {
                state = child.saveState(facesContext);
            }
            childStates.add(new Object[]{state, descendantState});
        }
        return childStates;
    }

    private Map<String, Object> saveFullDescendantComponentStates(FacesContext facesContext, Map<String, Object> stateMap, Iterator<UIComponent> childIterator, boolean saveChildFacets) {
        while (childIterator.hasNext()) {
            UIComponent child = childIterator.next();
            if (child.isTransient()) continue;
            Iterator<UIComponent> childsIterator = saveChildFacets ? child.getFacetsAndChildren() : child.getChildren().iterator();
            stateMap = this.saveFullDescendantComponentStates(facesContext, stateMap, childsIterator, true);
            Object state = child.saveState(facesContext);
            if (state == null) continue;
            if (stateMap == null) {
                stateMap = new HashMap<String, Object>();
            }
            stateMap.put(child.getClientId(facesContext), state);
        }
        return stateMap;
    }

    private void restoreFullDescendantComponentDeltaStates(FacesContext facesContext, Iterator<UIComponent> childIterator, Object state, Object initialState, boolean restoreChildFacets) {
        Map descendantStateIterator = null;
        Iterator descendantFullStateIterator = null;
        while (childIterator.hasNext()) {
            if (descendantStateIterator == null && state != null) {
                descendantStateIterator = (Map)state;
            }
            if (descendantFullStateIterator == null && initialState != null) {
                descendantFullStateIterator = ((Collection)initialState).iterator();
            }
            UIComponent component = childIterator.next();
            component.setId(component.getId());
            if (component.isTransient()) continue;
            Object childInitialState = null;
            Object descendantInitialState = null;
            Object childState = null;
            if (descendantStateIterator != null && descendantStateIterator.containsKey(component.getClientId(facesContext))) {
                childState = descendantStateIterator.get(component.getClientId(facesContext));
            }
            if (descendantFullStateIterator != null && descendantFullStateIterator.hasNext()) {
                Object[] object = (Object[])descendantFullStateIterator.next();
                childInitialState = object[0];
                descendantInitialState = object[1];
            }
            component.clearInitialState();
            if (childInitialState != null) {
                component.restoreState(facesContext, childInitialState);
                component.markInitialState();
                component.restoreState(facesContext, childState);
            } else {
                component.restoreState(facesContext, childState);
                component.markInitialState();
            }
            Iterator<UIComponent> childsIterator = restoreChildFacets ? component.getFacetsAndChildren() : component.getChildren().iterator();
            this.restoreFullDescendantComponentDeltaStates(facesContext, childsIterator, state, descendantInitialState, true);
        }
    }

    private void restoreTransientDescendantComponentStates(FacesContext facesContext, Iterator<UIComponent> childIterator, Map<String, Object> state, boolean restoreChildFacets) {
        while (childIterator.hasNext()) {
            UIComponent component = childIterator.next();
            component.setId(component.getId());
            if (component.isTransient()) continue;
            component.restoreTransientState(facesContext, state == null ? null : state.get(component.getClientId(facesContext)));
            Iterator<UIComponent> childsIterator = restoreChildFacets ? component.getFacetsAndChildren() : component.getChildren().iterator();
            this.restoreTransientDescendantComponentStates(facesContext, childsIterator, state, true);
        }
    }

    private Map<String, Object> saveTransientDescendantComponentStates(FacesContext facesContext, Map<String, Object> childStates, Iterator<UIComponent> childIterator, boolean saveChildFacets) {
        while (childIterator.hasNext()) {
            UIComponent child = childIterator.next();
            if (child.isTransient()) continue;
            Iterator<UIComponent> childsIterator = saveChildFacets ? child.getFacetsAndChildren() : child.getChildren().iterator();
            childStates = this.saveTransientDescendantComponentStates(facesContext, childStates, childsIterator, true);
            Object state = child.saveTransientState(facesContext);
            if (state == null) continue;
            if (childStates == null) {
                childStates = new HashMap<String, Object>();
            }
            childStates.put(child.getClientId(facesContext), state);
        }
        return childStates;
    }

    public void restoreState(FacesContext context, Object state) {
        if (state == null) {
            return;
        }
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        Object restoredRowStates = UIComponentBase.restoreAttachedState((FacesContext)context, (Object)values[1]);
        if (restoredRowStates == null) {
            if (!this._rowDeltaStates.isEmpty()) {
                this._rowDeltaStates.clear();
            }
        } else {
            this._rowDeltaStates = (Map)restoredRowStates;
        }
    }

    public Object saveState(FacesContext context) {
        ComponentUtils.ViewPoolingResetMode viewPoolingResetMode = ComponentUtils.isViewPooling(context);
        if (viewPoolingResetMode == ComponentUtils.ViewPoolingResetMode.SOFT) {
            this._rowTransientStates.clear();
            this._initialDescendantFullComponentState = null;
            this.clientId = null;
            this.model = null;
            this.isNested = null;
            this.oldVar = null;
        } else if (viewPoolingResetMode == ComponentUtils.ViewPoolingResetMode.HARD) {
            this._rowTransientStates.clear();
            this._rowDeltaStates.clear();
            this._initialDescendantFullComponentState = null;
            this.clientId = null;
            this.model = null;
            this.isNested = null;
            this.oldVar = null;
        }
        if (this.initialStateMarked()) {
            Object superState = super.saveState(context);
            if (superState == null && this._rowDeltaStates.isEmpty()) {
                return null;
            }
            Object[] values = null;
            Object attachedState = UIComponentBase.saveAttachedState((FacesContext)context, this._rowDeltaStates);
            if (superState != null || attachedState != null) {
                values = new Object[]{superState, attachedState};
            }
            return values;
        }
        Object[] values = new Object[]{super.saveState(context), UIComponentBase.saveAttachedState((FacesContext)context, this._rowDeltaStates)};
        return values;
    }

    protected boolean isNestedWithinIterator() {
        if (this.isNested == null) {
            this.isNested = ComponentUtils.isNestedWithinIterator((UIComponent)this);
        }
        return this.isNested;
    }

    protected void preDecode(FacesContext context) {
        this.setDataModel(null);
        Map saved = (Map)this.getStateHelper().get((Serializable)((Object)PropertyKeys.saved));
        if (null == saved || !this.keepSaved(context)) {
            this.getStateHelper().remove((Serializable)((Object)PropertyKeys.saved));
        }
    }

    protected void preValidate(FacesContext context) {
        if (this.isNestedWithinIterator()) {
            this.setDataModel(null);
        }
    }

    protected void preUpdate(FacesContext context) {
        if (this.isNestedWithinIterator()) {
            this.setDataModel(null);
        }
    }

    protected void preEncode(FacesContext context) {
        this.setDataModel(null);
        if (!this.keepSaved(context)) {
            this.getStateHelper().remove((Serializable)((Object)PropertyKeys.saved));
        }
    }

    private boolean keepSaved(FacesContext context) {
        return this.contextHasErrorMessages(context) || this.isNestedWithinIterator();
    }

    private boolean contextHasErrorMessages(FacesContext context) {
        FacesMessage.Severity sev = context.getMaximumSeverity();
        return sev != null && FacesMessage.SEVERITY_ERROR.compareTo((Object)sev) >= 0;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        Renderer renderer;
        this.preEncode(context);
        if (context == null) {
            throw new NullPointerException();
        }
        this.pushComponentToEL(context, null);
        if (!this.isRendered()) {
            return;
        }
        context.getApplication().publishEvent(context, PreRenderComponentEvent.class, (Object)this);
        String rendererType = this.getRendererType();
        if (rendererType != null && (renderer = this.getRenderer(context)) != null) {
            renderer.encodeBegin(context, (UIComponent)this);
        }
    }

    public static enum PropertyKeys {
        rowIndex,
        rowIndexVar,
        saved,
        lazy,
        rowStatePreserved;

    }
}

