/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.bubblechart;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import org.primefaces.component.bubblechart.BubbleChart;
import org.primefaces.component.charts.ChartRenderer;
import org.primefaces.model.charts.bubble.BubbleChartOptions;
import org.primefaces.util.WidgetBuilder;

public class BubbleChartRenderer
extends ChartRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        BubbleChart chart = (BubbleChart)component;
        String clientId = chart.getClientId(context);
        String style = chart.getStyle();
        String styleClass = chart.getStyleClass();
        this.encodeMarkup(context, clientId, style, styleClass);
        this.encodeScript(context, chart);
    }

    protected void encodeScript(FacesContext context, BubbleChart chart) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("BubbleChart", chart);
        this.encodeConfig(context, chart.getModel());
        this.encodeClientBehaviors(context, chart);
        wb.finish();
    }

    @Override
    protected void encodeOptions(FacesContext context, String type, Object options) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (options == null) {
            return;
        }
        BubbleChartOptions bubbleOptions = (BubbleChartOptions)options;
        writer.write(",\"options\":{");
        this.encodeScales(context, type, bubbleOptions.getScales(), false);
        this.encodeElements(context, bubbleOptions.getElements(), bubbleOptions.getScales() != null);
        this.encodeAnimation(context, bubbleOptions.getAnimation(), bubbleOptions.getScales() != null || bubbleOptions.getElements() != null);
        this.encodePlugins(context, bubbleOptions, bubbleOptions.getScales() != null || bubbleOptions.getElements() != null || bubbleOptions.getAnimation() != null);
        writer.write("}");
    }
}

