/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.chart.renderer;

import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.primefaces.component.chart.Chart;
import org.primefaces.component.chart.renderer.CartesianPlotRenderer;
import org.primefaces.model.chart.BarChartModel;
import org.primefaces.model.chart.ChartSeries;
import org.primefaces.util.EscapeUtils;

@Deprecated
public class BarRenderer
extends CartesianPlotRenderer {
    @Override
    protected void encodeData(FacesContext context, Chart chart) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        BarChartModel model = (BarChartModel)chart.getModel();
        boolean horizontal = model.getOrientation().equals("horizontal");
        writer.write(",data:[");
        Iterator<ChartSeries> it = model.getSeries().iterator();
        while (it.hasNext()) {
            ChartSeries series = it.next();
            int i = 1;
            writer.write("[");
            Iterator<Map.Entry<Object, Number>> its = series.getData().entrySet().iterator();
            while (its.hasNext()) {
                String valueToRender;
                Map.Entry<Object, Number> entry = its.next();
                Number value = entry.getValue();
                String string = valueToRender = value != null ? value.toString() : "null";
                if (horizontal) {
                    writer.write("[");
                    writer.write(valueToRender + "," + i);
                    writer.write("]");
                    ++i;
                } else if (model.getDataRenderMode().equals("key")) {
                    writer.write("'" + (String)entry.getKey() + "'," + valueToRender);
                } else {
                    writer.write(valueToRender);
                }
                if (!its.hasNext()) continue;
                writer.write(",");
            }
            writer.write("]");
            if (!it.hasNext()) continue;
            writer.write(",");
        }
        writer.write("]");
    }

    @Override
    protected void encodeOptions(FacesContext context, Chart chart) throws IOException {
        super.encodeOptions(context, chart);
        ResponseWriter writer = context.getResponseWriter();
        BarChartModel model = (BarChartModel)chart.getModel();
        String orientation = model.getOrientation();
        int barPadding = model.getBarPadding();
        int barMargin = model.getBarMargin();
        int barWidth = model.getBarWidth();
        List<String> ticks = model.getTicks();
        String legendLabel = model.getLegendLabel();
        writer.write(",series:[");
        if (model.getDataRenderMode().equals("key") && legendLabel != null) {
            writer.write("{");
            writer.write("label:\"" + EscapeUtils.forJavaScript(legendLabel) + "\"");
            writer.write("}");
        } else {
            Iterator<ChartSeries> it = model.getSeries().iterator();
            while (it.hasNext()) {
                ChartSeries series = it.next();
                series.encode((Writer)writer);
                if (!it.hasNext()) continue;
                writer.write(",");
            }
        }
        writer.write("]");
        writer.write(",ticks:[");
        Iterator<String> tickIt = ticks.iterator();
        while (tickIt.hasNext()) {
            writer.write("\"" + EscapeUtils.forJavaScript(tickIt.next()) + "\"");
            if (!tickIt.hasNext()) continue;
            writer.write(",");
        }
        writer.write("]");
        if (orientation != null) {
            writer.write(",orientation:\"" + orientation + "\"");
        }
        if (barPadding != 8) {
            writer.write(",barPadding:" + barPadding);
        }
        if (barMargin != 10) {
            writer.write(",barMargin:" + barMargin);
        }
        if (barWidth != 0) {
            writer.write(",barWidth:" + barWidth);
        }
        if (model.isStacked()) {
            writer.write(",stackSeries:true");
        }
        if (model.isZoom()) {
            writer.write(",zoom:true");
        }
        if (model.isAnimate()) {
            writer.write(",animate:true");
        }
        if (model.isShowPointLabels()) {
            writer.write(",showPointLabels:true");
        }
        if (model.isShowDatatip()) {
            writer.write(",datatip:true");
            if (model.getDatatipFormat() != null) {
                writer.write(",datatipFormat:\"" + model.getDatatipFormat() + "\"");
            }
        }
    }
}

