/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.chronoline;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.primefaces.component.chronoline.Chronoline;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;

public class ChronolineRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Chronoline chronoline = (Chronoline)component;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = chronoline.getClientId();
        String style = chronoline.getStyle();
        String styleClass = this.getStyleClassBuilder(context).add("ui-chronoline ui-widget").add(chronoline.getStyleClass()).add("left".equals(chronoline.getAlign()), "ui-chronoline-left").add("right".equals(chronoline.getAlign()), "ui-chronoline-right").add("top".equals(chronoline.getAlign()), "ui-chronoline-top").add("bottom".equals(chronoline.getAlign()), "ui-chronoline-bottom").add("alternate".equals(chronoline.getAlign()), "ui-chronoline-alternate").add("horizontal".equals(chronoline.getLayout()), "ui-chronoline-horizontal").add("vertical".equals(chronoline.getLayout()), "ui-chronoline-vertical").build();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        this.encodeEvents(context, chronoline);
        writer.endElement("div");
    }

    protected void encodeEvents(FacesContext context, Chronoline chronoline) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Collection value = (Collection)chronoline.getValue();
        if (value != null) {
            Map requestMap = context.getExternalContext().getRequestMap();
            String var = chronoline.getVar();
            Iterator it = value.iterator();
            while (it.hasNext()) {
                requestMap.put(var, it.next());
                writer.startElement("div", null);
                writer.writeAttribute("class", (Object)"ui-chronoline-event", null);
                this.encodeOppositeContent(context, chronoline);
                this.encodeSeparator(context, chronoline, !it.hasNext());
                this.encodeContent(context, chronoline);
                writer.endElement("div");
            }
            requestMap.remove(var);
        }
    }

    protected void encodeOppositeContent(FacesContext context, Chronoline chronoline) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        UIComponent oppositeFacet = chronoline.getFacet("opposite");
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-chronoline-event-opposite", null);
        if (ComponentUtils.shouldRenderFacet(oppositeFacet)) {
            oppositeFacet.encodeAll(context);
        } else {
            writer.write("&nbsp;");
        }
        writer.endElement("div");
    }

    protected void encodeSeparator(FacesContext context, Chronoline chronoline, boolean isLastItem) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        UIComponent markerFacet = chronoline.getFacet("marker");
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-chronoline-event-separator", null);
        if (ComponentUtils.shouldRenderFacet(markerFacet)) {
            markerFacet.encodeAll(context);
        } else {
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)"ui-chronoline-event-marker", null);
            writer.endElement("div");
        }
        if (!isLastItem) {
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)"ui-chronoline-event-connector", null);
            writer.endElement("div");
        }
        writer.endElement("div");
    }

    protected void encodeContent(FacesContext context, Chronoline chronoline) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-chronoline-event-content", null);
        this.renderChildren(context, (UIComponent)chronoline);
        writer.endElement("div");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

