/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.commandbutton;

import jakarta.faces.FacesException;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIForm;
import jakarta.faces.component.behavior.ClientBehaviorHolder;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.event.ActionEvent;
import jakarta.faces.event.FacesEvent;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.primefaces.component.commandbutton.CommandButton;
import org.primefaces.context.PrimeRequestContext;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.CSVBuilder;
import org.primefaces.util.ComponentTraversalUtils;
import org.primefaces.util.HTML;
import org.primefaces.util.WidgetBuilder;

public class CommandButtonRenderer
extends CoreRenderer {
    private static final Logger LOGGER = Logger.getLogger(CommandButtonRenderer.class.getName());

    public void decode(FacesContext context, UIComponent component) {
        CommandButton button = (CommandButton)component;
        if (button.isDisabled()) {
            return;
        }
        String param = component.getClientId(context);
        if (context.getExternalContext().getRequestParameterMap().containsKey(param)) {
            component.queueEvent((FacesEvent)new ActionEvent(component));
        }
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        CommandButton button = (CommandButton)component;
        this.encodeMarkup(context, button);
        this.encodeScript(context, button);
    }

    protected void encodeMarkup(FacesContext context, CommandButton button) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = button.getClientId(context);
        String type = button.getType();
        boolean pushButton = "reset".equals(type) || "button".equals(type);
        Object value = button.getValue();
        String icon = button.getIcon();
        String title = button.getTitle();
        String onclick = null;
        if (!button.isDisabled() || button.isRenderDisabledClick()) {
            String request = pushButton ? null : this.buildRequest(context, button, clientId);
            onclick = this.buildDomEvent(context, (UIComponent)button, "onclick", "click", "action", request);
        }
        writer.startElement("button", (UIComponent)button);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("name", (Object)clientId, "name");
        writer.writeAttribute("class", (Object)button.resolveStyleClass(), "styleClass");
        writer.writeAttribute("aria-label", (Object)button.getAriaLabel(), null);
        if (onclick != null) {
            if (button.requiresConfirmation()) {
                writer.writeAttribute("data-pfconfirmcommand", (Object)onclick, null);
                writer.writeAttribute("onclick", (Object)button.getConfirmationScript(), "onclick");
            } else {
                writer.writeAttribute("onclick", (Object)onclick, "onclick");
            }
            this.renderPassThruAttributes(context, (UIComponent)button, HTML.BUTTON_WITHOUT_CLICK_ATTRS);
        } else {
            this.renderPassThruAttributes(context, (UIComponent)button, HTML.BUTTON_WITH_CLICK_ATTRS);
        }
        if (button.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", "disabled");
        }
        if (!this.isValueBlank(icon)) {
            String defaultIconClass = button.getIconPos().equals("left") ? "ui-button-icon-left ui-icon ui-c" : "ui-button-icon-right ui-icon ui-c";
            String iconClass = defaultIconClass + " " + icon;
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)iconClass, null);
            writer.endElement("span");
        }
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-button-text ui-c", null);
        if (value == null) {
            String text = title != null ? title : "ui-button";
            writer.writeText((Object)text, "title");
        } else if (button.isEscape()) {
            writer.writeText(value, "value");
        } else {
            writer.write(value.toString());
        }
        writer.endElement("span");
        writer.endElement("button");
    }

    protected String buildRequest(FacesContext context, CommandButton button, String clientId) throws FacesException {
        PrimeRequestContext requestContext = PrimeRequestContext.getCurrentInstance(context);
        boolean csvEnabled = requestContext.getApplicationContext().getConfig().isClientSideValidationEnabled() && button.isValidateClient();
        String request = null;
        boolean ajax = button.isAjax();
        if (ajax) {
            request = this.buildAjaxRequest(context, button);
        } else {
            UIForm form = ComponentTraversalUtils.closestForm(context, (UIComponent)button);
            if (form == null) {
                LOGGER.log(Level.FINE, "CommandButton '" + clientId + "' should be inside a form or should reference a form via its form attribute. We will try to find a fallback form on the client side.");
            }
            request = this.buildNonAjaxRequest(context, (UIComponent)button, (UIComponent)form, null, false);
        }
        if (csvEnabled) {
            CSVBuilder csvb = requestContext.getCSVBuilder();
            request = csvb.init().source("this").ajax(ajax).process((UIComponent)button, button.getProcess()).update((UIComponent)button, button.getUpdate()).command(request).build();
        }
        return request;
    }

    protected void encodeScript(FacesContext context, CommandButton button) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("CommandButton", button).attr("disableOnAjax", button.isDisableOnAjax(), true).attr("disabledAttr", button.isDisabled(), false);
        this.encodeClientBehaviors(context, (ClientBehaviorHolder)button);
        wb.finish();
    }
}

