/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.confirmpopup;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import org.primefaces.component.confirmpopup.ConfirmPopup;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.expression.SearchExpressionUtils;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.WidgetBuilder;

public class ConfirmPopupRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ConfirmPopup popup = (ConfirmPopup)component;
        this.encodeMarkup(context, popup);
        this.encodeScript(context, popup);
    }

    protected void encodeMarkup(FacesContext context, ConfirmPopup popup) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = popup.getClientId(context);
        String style = popup.getStyle();
        String styleClass = this.getStyleClassBuilder(context).add("ui-confirm-popup ui-widget ui-corner-all ui-shadow ui-hidden-container").add(popup.getStyleClass()).build();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        this.encodeContent(context, popup);
        this.encodeFooter(context, popup);
        writer.endElement("div");
    }

    protected void encodeContent(FacesContext context, ConfirmPopup popup) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String messageText = popup.getMessage();
        UIComponent messageFacet = popup.getFacet("message");
        String iconStyleClass = this.getStyleClassBuilder(context).add("ui-confirm-popup-icon").add(popup.getIcon()).build();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-confirm-popup-content ui-widget-content", null);
        writer.writeAttribute("id", (Object)(popup.getClientId(context) + "_content"), null);
        writer.startElement("i", null);
        writer.writeAttribute("class", (Object)iconStyleClass, null);
        writer.endElement("i");
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-confirm-popup-message", null);
        if (ComponentUtils.shouldRenderFacet(messageFacet)) {
            messageFacet.encodeAll(context);
        } else if (messageText != null) {
            writer.writeText((Object)messageText, null);
        }
        writer.endElement("span");
        writer.endElement("div");
    }

    protected void encodeFooter(FacesContext context, ConfirmPopup popup) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-confirm-popup-footer ui-widget-content ui-helper-clearfix", null);
        this.renderChildren(context, (UIComponent)popup);
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, ConfirmPopup popup) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("ConfirmPopup", popup).attr("appendTo", SearchExpressionFacade.resolveClientId(context, (UIComponent)popup, popup.getAppendTo(), SearchExpressionUtils.SET_RESOLVE_CLIENT_SIDE), null).attr("global", popup.isGlobal(), false).attr("dismissable", popup.isDismissable(), true);
        wb.finish();
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

