/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datalist;

import jakarta.faces.FacesException;
import jakarta.faces.application.ResourceDependencies;
import jakarta.faces.application.ResourceDependency;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AjaxBehaviorEvent;
import jakarta.faces.event.BehaviorEvent;
import jakarta.faces.event.FacesEvent;
import jakarta.faces.event.PhaseId;
import jakarta.faces.model.DataModel;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.primefaces.PrimeFaces;
import org.primefaces.component.api.IterationStatus;
import org.primefaces.component.datalist.DataListBase;
import org.primefaces.component.datalist.DataListState;
import org.primefaces.event.SelectEvent;
import org.primefaces.event.data.PageEvent;
import org.primefaces.model.LazyDataModel;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.MapBuilder;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="components.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="jquery/jquery-plugins.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="components.js"), @ResourceDependency(library="primefaces", name="touch/touchswipe.js")})
public class DataList
extends DataListBase {
    public static final String COMPONENT_TYPE = "org.primefaces.component.DataList";
    public static final String DATALIST_CLASS = "ui-datalist ui-widget";
    public static final String CONTENT_CLASS = "ui-datalist-content ui-widget-content";
    public static final String LIST_CLASS = "ui-datalist-data";
    public static final String NO_BULLETS_CLASS = "ui-datalist-nobullets";
    public static final String LIST_ITEM_CLASS = "ui-datalist-item";
    public static final String HEADER_CLASS = "ui-datalist-header ui-widget-header ui-corner-top";
    public static final String FOOTER_CLASS = "ui-datalist-footer ui-widget-header ui-corner-bottom";
    public static final String DATALIST_EMPTY_MESSAGE_CLASS = "ui-datalist-empty-message";
    private static final Map<String, Class<? extends BehaviorEvent>> BEHAVIOR_EVENT_MAPPING = MapBuilder.builder().put("page", PageEvent.class).put("tap", SelectEvent.class).put("taphold", SelectEvent.class).build();
    private static final Collection<String> EVENT_NAMES = BEHAVIOR_EVENT_MAPPING.keySet();

    @Override
    public Map<String, Class<? extends BehaviorEvent>> getBehaviorEventMapping() {
        return BEHAVIOR_EVENT_MAPPING;
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public String getListTag() {
        String type = this.getType();
        if ("unordered".equalsIgnoreCase(type)) {
            return "ul";
        }
        if ("ordered".equalsIgnoreCase(type)) {
            return "ol";
        }
        if ("definition".equalsIgnoreCase(type)) {
            return "dl";
        }
        if ("none".equalsIgnoreCase(type)) {
            return null;
        }
        throw new FacesException("DataList '" + this.getClientId() + "' has invalid list type:'" + type + "'");
    }

    public boolean isDefinition() {
        return this.getType().equalsIgnoreCase("definition");
    }

    public void loadLazyData() {
        DataModel model = this.getDataModel();
        if (model instanceof LazyDataModel) {
            LazyDataModel lazyModel = (LazyDataModel)model;
            lazyModel.setRowCount(lazyModel.count(Collections.emptyMap()));
            this.calculateFirst();
            List data = lazyModel.load(this.getFirst(), this.getRows(), Collections.emptyMap(), Collections.emptyMap());
            lazyModel.setPageSize(this.getRows());
            lazyModel.setWrappedData(data);
            if (ComponentUtils.isRequestSource((UIComponent)this, this.getFacesContext()) && this.isPaginator()) {
                PrimeFaces.current().ajax().addCallbackParam("totalRecords", lazyModel.getRowCount());
            }
        }
    }

    public void queueEvent(FacesEvent event) {
        FacesContext context = this.getFacesContext();
        if (ComponentUtils.isRequestSource((UIComponent)this, context) && event instanceof AjaxBehaviorEvent) {
            this.setRowIndex(-1);
            AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
            Map params = context.getExternalContext().getRequestParameterMap();
            String eventName = (String)params.get("jakarta.faces.behavior.event");
            if ("page".equals(eventName)) {
                String clientId = this.getClientId(context);
                int rows = this.getRowsToRender();
                int first = Integer.parseInt((String)params.get(clientId + "_first"));
                int page = rows > 0 ? first / rows : 0;
                PageEvent pageEvent = new PageEvent((UIComponent)this, behaviorEvent.getBehavior(), page);
                pageEvent.setPhaseId(behaviorEvent.getPhaseId());
                super.queueEvent((FacesEvent)pageEvent);
            } else if ("tap".equals(eventName) || "taphold".equals(eventName)) {
                String clientId = this.getClientId(context);
                int index = Integer.parseInt((String)params.get(clientId + "_item"));
                this.setRowIndex(index);
                SelectEvent<Object> selectEvent = new SelectEvent<Object>((UIComponent)this, behaviorEvent.getBehavior(), this.getRowData());
                selectEvent.setPhaseId(behaviorEvent.getPhaseId());
                this.setRowIndex(-1);
                super.queueEvent(selectEvent);
            }
        } else {
            super.queueEvent(event);
        }
    }

    @Override
    protected void processFacets(FacesContext context, PhaseId phaseId) {
        if (this.getFacetCount() > 0) {
            UIComponent descriptionFacet = this.getFacet("description");
            for (UIComponent facet : this.getFacets().values()) {
                if (facet.equals(descriptionFacet)) continue;
                this.process(context, facet, phaseId);
            }
        }
    }

    @Override
    protected void processChildren(FacesContext context, PhaseId phaseId) {
        boolean definition = this.isDefinition();
        UIComponent descriptionFacet = definition ? this.getFacet("description") : null;
        int childCount = this.getChildCount();
        List<UIComponent> children = childCount > 0 ? this.getIterableChildren() : null;
        this.forEachRow(status -> {
            for (int i = 0; i < childCount; ++i) {
                UIComponent child = (UIComponent)children.get(i);
                if (!child.isRendered()) continue;
                this.process(context, child, phaseId);
            }
            if (definition && ComponentUtils.shouldRenderFacet(descriptionFacet)) {
                this.process(context, descriptionFacet, phaseId);
            }
        });
    }

    @Override
    protected boolean shouldSkipChildren(FacesContext context) {
        Map params = context.getExternalContext().getRequestParameterMap();
        String paramValue = (String)params.get("primefaces.skipchildren");
        if (paramValue != null && !Boolean.parseBoolean(paramValue)) {
            return false;
        }
        return params.containsKey(this.getClientId(context) + "_skipChildren");
    }

    public void forEachRow(Consumer<IterationStatus> callback) {
        FacesContext context = this.getFacesContext();
        Map requestMap = context.getExternalContext().getRequestMap();
        String varStatus = this.getVarStatus();
        String rowIndexVar = this.getRowIndexVar();
        Object varStatusBackup = varStatus == null ? null : (Object)requestMap.get(varStatus);
        Object rowIndexVarBackup = rowIndexVar == null ? null : (Object)requestMap.get(rowIndexVar);
        int first = this.getFirst();
        int rows = this.getRows();
        int pageSize = first + rows;
        int rowCount = this.getRowCount();
        int last = rows == 0 ? rowCount : first + rows;
        for (int i = first; i < last; ++i) {
            this.setRowIndex(i);
            if (!this.isRowAvailable()) break;
            IterationStatus status = new IterationStatus(i == 0, i == rowCount - 1, i, i, first, pageSize - 1, 1);
            if (varStatus != null) {
                requestMap.put(varStatus, status);
            }
            if (rowIndexVar != null) {
                requestMap.put(rowIndexVar, i);
            }
            callback.accept(status);
        }
        this.setRowIndex(-1);
        if (varStatus != null) {
            if (varStatusBackup == null) {
                requestMap.remove(varStatus);
            } else {
                requestMap.put(varStatus, varStatusBackup);
            }
        }
        if (rowIndexVar != null) {
            if (rowIndexVarBackup == null) {
                requestMap.remove(rowIndexVar);
            } else {
                requestMap.put(rowIndexVar, rowIndexVarBackup);
            }
        }
    }

    @Override
    public void restoreMultiViewState() {
        DataListState ls = this.getMultiViewState(false);
        if (ls != null && this.isPaginator()) {
            this.setFirst(ls.getFirst());
            int rows = ls.getRows() == 0 ? this.getRows() : ls.getRows();
            this.setRows(rows);
        }
    }

    @Override
    public DataListState getMultiViewState(boolean create) {
        FacesContext fc = this.getFacesContext();
        String viewId = fc.getViewRoot().getViewId();
        return PrimeFaces.current().multiViewState().get(viewId, this.getClientId(fc), create, DataListState::new);
    }

    @Override
    public void resetMultiViewState() {
        this.setFirst(0);
    }
}

