/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datalist;

import jakarta.faces.FacesException;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.primefaces.component.datalist.DataList;
import org.primefaces.component.datalist.DataListState;
import org.primefaces.renderkit.DataRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.WidgetBuilder;

public class DataListRenderer
extends DataRenderer {
    private static final Logger LOGGER = Logger.getLogger(DataListRenderer.class.getName());

    public void decode(FacesContext context, UIComponent component) {
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        DataList list = (DataList)component;
        if (list.isPaginationRequest(context)) {
            list.updatePaginationData(context);
            if (list.isLazy()) {
                list.loadLazyData();
            }
            if (list.getType().equals("none")) {
                this.encodeFreeList(context, list);
            } else {
                this.encodeStrictList(context, list);
            }
            if (list.isMultiViewState()) {
                DataListState ls = list.getMultiViewState(true);
                ls.setFirst(list.getFirst());
                ls.setRows(list.getRows());
            }
        } else {
            if (list.isMultiViewState()) {
                list.restoreMultiViewState();
            }
            this.encodeMarkup(context, list);
            this.encodeScript(context, list);
            if (list.isPaginator() && list.getRows() == 0) {
                LOGGER.log(Level.WARNING, "DataList with paginator=true should also set the rows attribute. ClientId: " + list.getClientId());
            }
        }
    }

    protected void encodeMarkup(FacesContext context, DataList list) throws IOException {
        if (list.isLazy()) {
            list.loadLazyData();
        }
        ResponseWriter writer = context.getResponseWriter();
        String clientId = list.getClientId(context);
        boolean hasPaginator = list.isPaginator();
        boolean empty = list.getRowCount() == 0;
        String paginatorPosition = list.getPaginatorPosition();
        String styleClass = this.getStyleClassBuilder(context).add("ui-datalist ui-widget").add(list.getStyleClass()).build();
        String style = list.getStyle();
        if (hasPaginator) {
            list.calculateFirst();
        }
        writer.startElement("div", (UIComponent)list);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        this.encodeFacet(context, list, "header", "ui-datalist-header ui-widget-header ui-corner-top");
        if (hasPaginator && !"bottom".equalsIgnoreCase(paginatorPosition)) {
            this.encodePaginatorMarkup(context, list, "top");
        }
        writer.startElement("div", (UIComponent)list);
        writer.writeAttribute("id", (Object)(clientId + "_content"), "id");
        writer.writeAttribute("class", (Object)"ui-datalist-content ui-widget-content", "styleClass");
        if (empty) {
            writer.startElement("div", (UIComponent)list);
            writer.writeAttribute("class", (Object)"ui-datalist-empty-message", null);
            writer.writeText((Object)list.getEmptyMessage(), "emptyMessage");
            writer.endElement("div");
        } else if (list.getType().equals("none")) {
            this.encodeFreeList(context, list);
        } else {
            this.encodeStrictList(context, list);
        }
        writer.endElement("div");
        if (hasPaginator && !"top".equalsIgnoreCase(paginatorPosition)) {
            this.encodePaginatorMarkup(context, list, "bottom");
        }
        this.encodeFacet(context, list, "footer", "ui-datalist-footer ui-widget-header ui-corner-bottom");
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, DataList list) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("DataList", list);
        if (list.isPaginator()) {
            this.encodePaginatorConfig(context, list, wb);
        }
        this.encodeClientBehaviors(context, list);
        wb.finish();
    }

    protected void encodeStrictList(FacesContext context, DataList list) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = list.getClientId(context);
        boolean isDefinition = list.isDefinition();
        UIComponent definitionFacet = list.getFacet("description");
        boolean renderDefinition = isDefinition && ComponentUtils.shouldRenderFacet(definitionFacet);
        String itemType = list.getItemType();
        String listClass = "ui-datalist-data";
        if ("none".equals(itemType)) {
            listClass = listClass + " " + "ui-datalist-nobullets";
        }
        String listTag = list.getListTag();
        String listItemTag = isDefinition ? "dt" : "li";
        writer.startElement(listTag, null);
        writer.writeAttribute("id", (Object)(clientId + "_list"), null);
        writer.writeAttribute("class", (Object)listClass, null);
        if (list.getItemType() != null) {
            writer.writeAttribute("type", (Object)list.getItemType(), null);
        }
        list.forEachRow(status -> {
            try {
                String itemStyleClass = this.getStyleClassBuilder(context).add("ui-datalist-item", list.getItemStyleClass()).build();
                writer.startElement(listItemTag, null);
                writer.writeAttribute("class", (Object)itemStyleClass, null);
                this.renderChildren(context, (UIComponent)list);
                writer.endElement(listItemTag);
                if (renderDefinition) {
                    writer.startElement("dd", null);
                    definitionFacet.encodeAll(context);
                    writer.endElement("dd");
                }
            }
            catch (IOException e) {
                throw new FacesException((Throwable)e);
            }
        });
        writer.endElement(listTag);
    }

    protected void encodeFreeList(FacesContext context, DataList list) throws IOException {
        list.forEachRow(status -> {
            try {
                this.renderChildren(context, (UIComponent)list);
            }
            catch (IOException e) {
                throw new FacesException((Throwable)e);
            }
        });
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

