/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datatable.export;

import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIPanel;
import jakarta.faces.context.FacesContext;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.WorkbookUtil;
import org.primefaces.component.api.DynamicColumn;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.columngroup.ColumnGroup;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.datatable.export.DataTableExporter;
import org.primefaces.component.export.ExcelOptions;
import org.primefaces.component.export.ExportConfiguration;
import org.primefaces.component.export.ExporterOptions;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.ExcelStylesManager;
import org.primefaces.util.LocaleUtils;

public class DataTableExcelExporter
extends DataTableExporter {
    protected Workbook wb;
    private ExcelStylesManager stylesManager;

    @Override
    protected void preExport(FacesContext context, ExportConfiguration exportConfiguration) throws IOException {
        this.wb = this.createWorkBook();
        if (exportConfiguration.getPreProcessor() != null) {
            exportConfiguration.getPreProcessor().invoke(context.getELContext(), new Object[]{this.wb});
        }
    }

    @Override
    public void doExport(FacesContext context, DataTable table, ExportConfiguration exportConfiguration, int index) throws IOException {
        String sheetName = this.getSheetName(context, (UIComponent)table);
        if (sheetName == null) {
            sheetName = table.getId() + (index + 1);
        }
        if ("empty".equals(sheetName = WorkbookUtil.createSafeSheetName((String)sheetName)) || "null".equals(sheetName)) {
            sheetName = "Sheet (" + (index + 1) + ")";
        }
        ExcelOptions options = (ExcelOptions)exportConfiguration.getOptions();
        this.stylesManager = new ExcelStylesManager(this.wb, LocaleUtils.getCurrentLocale(context), options);
        Sheet sheet = this.createSheet(this.wb, sheetName, options);
        this.applyOptions(this.wb, table, sheet, options);
        this.exportTable(context, (UIComponent)table, sheet, exportConfiguration);
        if (options == null || options.isAutoSizeColumn()) {
            for (int i = 0; i < this.getExportableColumns(table).size(); ++i) {
                sheet.autoSizeColumn(i);
            }
        }
    }

    @Override
    protected void postExport(FacesContext context, ExportConfiguration exportConfiguration) throws IOException {
        if (exportConfiguration.getPostProcessor() != null) {
            exportConfiguration.getPostProcessor().invoke(context.getELContext(), new Object[]{this.wb});
        }
        this.wb.write(this.getOutputStream());
        this.wb.close();
        this.wb = null;
    }

    @Override
    protected void exportCells(DataTable table, Object document) {
        Sheet sheet = (Sheet)document;
        int sheetRowIndex = sheet.getLastRowNum() + 1;
        Row row = sheet.createRow(sheetRowIndex);
        for (UIColumn col : this.getExportableColumns(table)) {
            if (col instanceof DynamicColumn) {
                ((DynamicColumn)col).applyStatelessModel();
            }
            this.addColumnValue(table, row, col.getChildren(), col);
        }
    }

    protected void addColumnFacets(DataTable table, Sheet sheet, DataTableExporter.ColumnType columnType) {
        int sheetRowIndex = sheet.getLastRowNum() + 1;
        Row rowHeader = sheet.createRow(sheetRowIndex);
        for (UIColumn col : this.getExportableColumns(table)) {
            String textValue;
            if (col instanceof DynamicColumn) {
                ((DynamicColumn)col).applyStatelessModel();
            }
            UIComponent facet = col.getFacet(columnType.facet());
            switch (columnType) {
                case HEADER: {
                    textValue = col.getExportHeaderValue() != null ? col.getExportHeaderValue() : col.getHeaderText();
                    break;
                }
                case FOOTER: {
                    textValue = col.getExportFooterValue() != null ? col.getExportFooterValue() : col.getFooterText();
                    break;
                }
                default: {
                    textValue = null;
                }
            }
            if (textValue != null) {
                this.addColumnValue(rowHeader, textValue);
                continue;
            }
            if (ComponentUtils.shouldRenderFacet(facet)) {
                this.addColumnValue(rowHeader, facet);
                continue;
            }
            this.addColumnValue(rowHeader, "");
        }
    }

    protected void addTableFacets(FacesContext context, DataTable table, Sheet sheet, DataTableExporter.ColumnType columnType) {
        String facetText = null;
        UIComponent facet = table.getFacet(columnType.facet());
        if (ComponentUtils.shouldRenderFacet(facet)) {
            if (facet instanceof UIPanel) {
                for (UIComponent child : facet.getChildren()) {
                    String value;
                    if (!child.isRendered() || (value = ComponentUtils.getValueToRender(context, child)) == null) continue;
                    facetText = value;
                    break;
                }
            } else {
                facetText = ComponentUtils.getValueToRender(context, facet);
            }
        }
        if (facetText != null) {
            int colspan = this.getExportableColumns(table).size();
            int rowIndex = sheet.getLastRowNum() + 1;
            Row rowHeader = sheet.createRow(rowIndex);
            if (colspan > 1) {
                sheet.addMergedRegion(new CellRangeAddress(rowIndex, rowIndex, 0, colspan - 1));
            }
            this.addColumnValue(rowHeader, 0, facetText);
        }
    }

    protected void addColumnValue(Row row, UIComponent component) {
        String value = component == null ? "" : this.exportValue(FacesContext.getCurrentInstance(), component);
        this.addColumnValue(row, value);
    }

    protected void addColumnValue(Row row, String value) {
        short col = row.getLastCellNum() == -1 ? (short)0 : row.getLastCellNum();
        this.addColumnValue(row, col, value);
    }

    protected void addColumnValue(Row row, int col, String text) {
        Cell cell = row.createCell(col);
        cell.setCellValue(this.stylesManager.createRichTextString(text));
        cell.setCellStyle(this.stylesManager.getFacetStyle());
    }

    protected void addColumnValue(DataTable table, Row row, List<UIComponent> components, UIColumn column) {
        short cellIndex = row.getLastCellNum() == -1 ? (short)0 : row.getLastCellNum();
        Cell cell = row.createCell((int)cellIndex);
        FacesContext context = FacesContext.getCurrentInstance();
        this.exportColumn(context, table, column, components, true, value -> this.stylesManager.updateCell(column, cell, Objects.toString(value, "")));
    }

    protected boolean addColumnGroup(DataTable table, Sheet sheet, DataTableExporter.ColumnType columnType) {
        ColumnGroup cg = table.getColumnGroup(columnType.facet());
        FacesContext context = FacesContext.getCurrentInstance();
        table.forEachColumnGroupRow(context, cg, true, row -> {
            AtomicInteger colIndex = new AtomicInteger(0);
            int rowIndex = sheet.getLastRowNum() + 1;
            Row xlRow = sheet.createRow(rowIndex);
            table.forEachColumn(context, (UIComponent)row, true, true, false, column -> {
                String text = null;
                switch (columnType) {
                    case HEADER: {
                        text = column.getExportHeaderValue() != null ? column.getExportHeaderValue() : column.getHeaderText();
                        break;
                    }
                    case FOOTER: {
                        text = column.getExportFooterValue() != null ? column.getExportFooterValue() : column.getFooterText();
                        break;
                    }
                    default: {
                        text = null;
                    }
                }
                int rowSpan = column.getRowspan() - 1;
                int colSpan = column.getColspan() - 1;
                if (rowSpan > 0 && colSpan > 0) {
                    colIndex.set(this.calculateColumnOffset(sheet, rowIndex, colIndex.get()));
                    sheet.addMergedRegion(new CellRangeAddress(rowIndex, rowIndex + rowSpan, colIndex.get(), colIndex.get() + colSpan));
                    this.addColumnValue(xlRow, (short)colIndex.get(), text);
                    colIndex.set(colIndex.get() + colSpan);
                } else if (rowSpan > 0) {
                    sheet.addMergedRegion(new CellRangeAddress(rowIndex, rowIndex + rowSpan, colIndex.get(), colIndex.get()));
                    this.addColumnValue(xlRow, (short)colIndex.get(), text);
                } else if (colSpan > 0) {
                    colIndex.set(this.calculateColumnOffset(sheet, rowIndex, colIndex.get()));
                    sheet.addMergedRegion(new CellRangeAddress(rowIndex, rowIndex, colIndex.get(), colIndex.get() + colSpan));
                    this.addColumnValue(xlRow, (short)colIndex.get(), text);
                    colIndex.set(colIndex.get() + colSpan);
                } else {
                    colIndex.set(this.calculateColumnOffset(sheet, rowIndex, colIndex.get()));
                    this.addColumnValue(xlRow, (short)colIndex.get(), text);
                }
                colIndex.incrementAndGet();
                return true;
            });
            return true;
        });
        return true;
    }

    protected int calculateColumnOffset(Sheet sheet, int row, int col) {
        for (int j = 0; j < sheet.getNumMergedRegions(); ++j) {
            CellRangeAddress merged = sheet.getMergedRegion(j);
            if (!merged.isInRange(row, col)) continue;
            col = merged.getLastColumn() + 1;
        }
        return col;
    }

    protected Workbook createWorkBook() {
        return new HSSFWorkbook();
    }

    protected Workbook getWorkBook() {
        return this.wb;
    }

    protected Sheet createSheet(Workbook wb, String sheetName, ExcelOptions options) {
        return wb.createSheet(sheetName);
    }

    @Override
    public String getContentType() {
        return "application/vnd.ms-excel";
    }

    @Override
    public String getFileExtension() {
        return ".xls";
    }

    public void exportTable(FacesContext context, UIComponent component, Sheet sheet, ExportConfiguration exportConfiguration) {
        DataTable table = (DataTable)component;
        if (exportConfiguration.isExportHeader()) {
            this.addTableFacets(context, table, sheet, DataTableExporter.ColumnType.HEADER);
            boolean headerGroup = this.addColumnGroup(table, sheet, DataTableExporter.ColumnType.HEADER);
            if (!headerGroup) {
                this.addColumnFacets(table, sheet, DataTableExporter.ColumnType.HEADER);
            }
        }
        if (exportConfiguration.isPageOnly()) {
            this.exportPageOnly(context, table, sheet);
        } else if (exportConfiguration.isSelectionOnly()) {
            this.exportSelectionOnly(context, table, sheet);
        } else {
            this.exportAll(context, table, sheet);
        }
        if (exportConfiguration.isExportFooter()) {
            this.addColumnGroup(table, sheet, DataTableExporter.ColumnType.FOOTER);
            if (table.hasFooterColumn()) {
                this.addColumnFacets(table, sheet, DataTableExporter.ColumnType.FOOTER);
            }
            this.addTableFacets(context, table, sheet, DataTableExporter.ColumnType.FOOTER);
        }
        table.setRowIndex(-1);
    }

    protected void applyOptions(Workbook wb, DataTable table, Sheet sheet, ExporterOptions options) {
        PrintSetup printSetup = sheet.getPrintSetup();
        printSetup.setLandscape(true);
        printSetup.setPaperSize((short)9);
        sheet.setPrintGridlines(true);
    }

    public String getSheetName(FacesContext context, UIComponent table) {
        UIComponent header = table.getFacet("header");
        if (header != null) {
            if (header instanceof UIPanel) {
                for (UIComponent child : header.getChildren()) {
                    String value;
                    if (!child.isRendered() || (value = ComponentUtils.getValueToRender(context, child)) == null) continue;
                    return value;
                }
            } else {
                return ComponentUtils.getValueToRender(context, header);
            }
        }
        return null;
    }
}

