/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datatable.export;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIPanel;
import jakarta.faces.context.FacesContext;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.primefaces.component.api.DynamicColumn;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.columngroup.ColumnGroup;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.datatable.export.DataTableExporter;
import org.primefaces.component.export.ExportConfiguration;
import org.primefaces.component.export.ExporterOptions;
import org.primefaces.component.export.PDFOptions;
import org.primefaces.component.export.PDFOrientationType;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.LangUtils;

public class DataTablePDFExporter
extends DataTableExporter {
    private Font cellFont;
    private Font facetFont;
    private Color facetBgColor;
    private Document document;

    protected Document createDocument() {
        return new Document();
    }

    protected Document getDocument() {
        return this.document;
    }

    @Override
    protected void preExport(FacesContext context, ExportConfiguration exportConfiguration) throws IOException {
        this.document = this.createDocument();
        try {
            PDFOptions options = (PDFOptions)exportConfiguration.getOptions();
            if (options != null && PDFOrientationType.LANDSCAPE == options.getOrientation()) {
                this.document.setPageSize(PageSize.A4.rotate());
            }
            PdfWriter.getInstance((Document)this.document, (OutputStream)this.getOutputStream());
        }
        catch (DocumentException e) {
            throw new IOException(e);
        }
        if (exportConfiguration.getPreProcessor() != null) {
            exportConfiguration.getPreProcessor().invoke(context.getELContext(), new Object[]{this.document});
        }
        if (!this.document.isOpen()) {
            this.document.open();
        }
    }

    @Override
    protected void doExport(FacesContext context, DataTable table, ExportConfiguration exportConfiguration, int index) throws IOException {
        try {
            if (index > 0) {
                Paragraph preface = new Paragraph();
                this.addEmptyLine(preface, 3);
                this.getDocument().add((Element)preface);
            }
            this.getDocument().add((Element)this.exportTable(context, table, exportConfiguration));
        }
        catch (DocumentException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    protected void postExport(FacesContext context, ExportConfiguration exportConfiguration) throws IOException {
        if (exportConfiguration.getPostProcessor() != null) {
            exportConfiguration.getPostProcessor().invoke(context.getELContext(), new Object[]{this.document});
        }
        this.getDocument().close();
        this.document = null;
    }

    @Override
    public String getContentType() {
        return "application/pdf";
    }

    @Override
    public String getFileExtension() {
        return ".pdf";
    }

    protected PdfPTable exportTable(FacesContext context, DataTable table, ExportConfiguration config) {
        int columnsCount = this.getColumnsCount(table);
        PdfPTable pdfTable = new PdfPTable(columnsCount);
        ExporterOptions options = config.getOptions();
        if (options != null) {
            this.applyFont(options.getFontName(), config.getEncodingType());
            this.applyFacetOptions(options);
            this.applyCellOptions(options);
        } else {
            this.applyFont("Times", config.getEncodingType());
        }
        if (config.getOnTableRender() != null) {
            config.getOnTableRender().invoke(context.getELContext(), new Object[]{pdfTable, table});
        }
        if (config.isExportHeader()) {
            this.addTableFacets(context, table, pdfTable, DataTableExporter.ColumnType.HEADER);
            boolean headerGroup = this.addColumnGroup(table, pdfTable, DataTableExporter.ColumnType.HEADER);
            if (!headerGroup) {
                this.addColumnFacets(table, pdfTable, DataTableExporter.ColumnType.HEADER);
            }
        }
        if (config.isPageOnly()) {
            this.exportPageOnly(context, table, pdfTable);
        } else if (config.isSelectionOnly()) {
            this.exportSelectionOnly(context, table, pdfTable);
        } else {
            this.exportAll(context, table, pdfTable);
        }
        if (config.isExportFooter()) {
            this.addColumnGroup(table, pdfTable, DataTableExporter.ColumnType.FOOTER);
            if (table.hasFooterColumn()) {
                this.addColumnFacets(table, pdfTable, DataTableExporter.ColumnType.FOOTER);
            }
            this.addTableFacets(context, table, pdfTable, DataTableExporter.ColumnType.FOOTER);
        }
        table.setRowIndex(-1);
        return pdfTable;
    }

    protected void addTableFacets(FacesContext context, DataTable table, PdfPTable pdfTable, DataTableExporter.ColumnType columnType) {
        String facetText = null;
        UIComponent facet = table.getFacet(columnType.facet());
        if (ComponentUtils.shouldRenderFacet(facet)) {
            if (facet instanceof UIPanel) {
                for (UIComponent child : facet.getChildren()) {
                    String value;
                    if (!child.isRendered() || (value = ComponentUtils.getValueToRender(context, child)) == null) continue;
                    facetText = value;
                    break;
                }
            } else {
                facetText = ComponentUtils.getValueToRender(context, facet);
            }
        }
        if (facetText != null) {
            int colspan = this.getExportableColumns(table).size();
            PdfPCell cell = new PdfPCell((Phrase)new Paragraph(facetText, this.facetFont));
            if (this.facetBgColor != null) {
                cell.setBackgroundColor(this.facetBgColor);
            }
            cell.setHorizontalAlignment(1);
            cell.setColspan(colspan);
            pdfTable.addCell(cell);
        }
    }

    @Override
    protected void exportCells(DataTable table, Object document) {
        PdfPTable pdfTable = (PdfPTable)document;
        for (UIColumn col : this.getExportableColumns(table)) {
            if (col instanceof DynamicColumn) {
                ((DynamicColumn)col).applyStatelessModel();
            }
            this.addColumnValue(table, pdfTable, col.getChildren(), this.cellFont, col);
        }
    }

    protected void addColumnFacets(DataTable table, PdfPTable pdfTable, DataTableExporter.ColumnType columnType) {
        for (UIColumn col : this.getExportableColumns(table)) {
            String textValue;
            if (col instanceof DynamicColumn) {
                ((DynamicColumn)col).applyStatelessModel();
            }
            UIComponent facet = col.getFacet(columnType.facet());
            switch (columnType) {
                case HEADER: {
                    textValue = col.getExportHeaderValue() != null ? col.getExportHeaderValue() : col.getHeaderText();
                    break;
                }
                case FOOTER: {
                    textValue = col.getExportFooterValue() != null ? col.getExportFooterValue() : col.getFooterText();
                    break;
                }
                default: {
                    textValue = null;
                }
            }
            if (textValue != null) {
                this.addColumnValue(pdfTable, textValue, 1, 1);
                continue;
            }
            if (ComponentUtils.shouldRenderFacet(facet)) {
                this.addColumnValue(pdfTable, facet);
                continue;
            }
            this.addColumnValue(pdfTable, "", 1, 1);
        }
    }

    protected boolean addColumnGroup(DataTable table, PdfPTable pdfTable, DataTableExporter.ColumnType columnType) {
        ColumnGroup cg = table.getColumnGroup(columnType.facet());
        FacesContext context = FacesContext.getCurrentInstance();
        table.forEachColumnGroupRow(context, cg, true, row -> {
            table.forEachColumn(context, (UIComponent)row, true, true, false, column -> {
                if (column.isRendered() && column.isExportable()) {
                    String textValue;
                    switch (columnType) {
                        case HEADER: {
                            textValue = column.getExportHeaderValue() != null ? column.getExportHeaderValue() : column.getHeaderText();
                            break;
                        }
                        case FOOTER: {
                            textValue = column.getExportFooterValue() != null ? column.getExportFooterValue() : column.getFooterText();
                            break;
                        }
                        default: {
                            textValue = "";
                        }
                    }
                    int rowSpan = column.getRowspan();
                    int colSpan = column.getColspan();
                    this.addColumnValue(pdfTable, textValue, rowSpan, colSpan);
                }
                return true;
            });
            pdfTable.completeRow();
            return true;
        });
        return true;
    }

    protected void addColumnValue(PdfPTable pdfTable, UIComponent component) {
        String value = component == null ? "" : this.exportValue(FacesContext.getCurrentInstance(), component);
        this.addColumnValue(pdfTable, value, 1, 1);
    }

    protected PdfPCell addColumnValue(PdfPTable pdfTable, String value, int rowSpan, int colSpan) {
        PdfPCell cell = new PdfPCell((Phrase)new Paragraph(value, this.facetFont));
        if (this.facetBgColor != null) {
            cell.setBackgroundColor(this.facetBgColor);
        }
        if (rowSpan > 1) {
            cell.setVerticalAlignment(1);
            cell.setRowspan(rowSpan);
        }
        if (colSpan > 1) {
            cell.setHorizontalAlignment(1);
            cell.setColspan(colSpan);
        }
        pdfTable.addCell(cell);
        return cell;
    }

    protected void addColumnValue(DataTable table, PdfPTable pdfTable, List<UIComponent> components, Font font, UIColumn column) {
        FacesContext context = FacesContext.getCurrentInstance();
        this.exportColumn(context, table, column, components, true, s -> {
            PdfPCell cell = this.createCell(column, (Phrase)new Paragraph(s, font));
            pdfTable.addCell(cell);
        });
    }

    protected int getColumnsCount(DataTable table) {
        return this.getExportableColumns(table).size();
    }

    protected void addEmptyLine(Paragraph paragraph, int number) {
        for (int i = 0; i < number; ++i) {
            paragraph.add((Element)new Paragraph(" "));
        }
    }

    protected void applyFacetOptions(ExporterOptions options) {
        String facetFontSize;
        String facetFontColor;
        String facetBackground = options.getFacetBgColor();
        if (facetBackground != null) {
            this.facetBgColor = Color.decode(facetBackground);
        }
        if ((facetFontColor = options.getFacetFontColor()) != null) {
            this.facetFont.setColor(Color.decode(facetFontColor));
        }
        if ((facetFontSize = options.getFacetFontSize()) != null) {
            this.facetFont.setSize((float)Integer.valueOf(facetFontSize).intValue());
        }
        String facetFontStyle = options.getFacetFontStyle();
        this.setFontStyle(this.facetFont, facetFontStyle);
    }

    protected void applyCellOptions(ExporterOptions options) {
        String cellFontSize;
        String cellFontColor = options.getCellFontColor();
        if (cellFontColor != null) {
            this.cellFont.setColor(Color.decode(cellFontColor));
        }
        if ((cellFontSize = options.getCellFontSize()) != null) {
            this.cellFont.setSize((float)Integer.valueOf(cellFontSize).intValue());
        }
        String cellFontStyle = options.getCellFontStyle();
        this.setFontStyle(this.cellFont, cellFontStyle);
    }

    protected void setFontStyle(Font cellFont, String cellFontStyle) {
        if (cellFontStyle != null) {
            if ("NORMAL".equalsIgnoreCase(cellFontStyle)) {
                cellFontStyle = "0";
            }
            if ("BOLD".equalsIgnoreCase(cellFontStyle)) {
                cellFontStyle = "1";
            }
            if ("ITALIC".equalsIgnoreCase(cellFontStyle)) {
                cellFontStyle = "2";
            }
            cellFont.setStyle(cellFontStyle);
        }
    }

    protected void applyFont(String fontName, String encoding) {
        String newFont = fontName;
        if (LangUtils.isBlank(newFont)) {
            newFont = "Times";
        }
        this.cellFont = FontFactory.getFont((String)newFont, (String)encoding);
        this.facetFont = FontFactory.getFont((String)newFont, (String)encoding, (float)12.0f, (int)1);
    }

    protected PdfPCell createCell(UIColumn column, Phrase phrase) {
        PdfPCell cell = new PdfPCell(phrase);
        return this.applyColumnAlignments(column, cell);
    }

    protected PdfPCell applyColumnAlignments(UIColumn column, PdfPCell cell) {
        String[] styles = new String[]{column.getStyle(), column.getStyleClass()};
        if (LangUtils.containsIgnoreCase(styles, "right")) {
            cell.setHorizontalAlignment(2);
        } else if (LangUtils.containsIgnoreCase(styles, "center")) {
            cell.setHorizontalAlignment(1);
        } else {
            cell.setHorizontalAlignment(0);
        }
        return cell;
    }
}

