/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datatable.feature;

import jakarta.faces.FacesException;
import jakarta.faces.context.FacesContext;
import java.io.IOException;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.datatable.DataTableRenderer;
import org.primefaces.component.datatable.feature.DataTableFeature;

public class ResizableColumnsFeature
implements DataTableFeature {
    private static final ResizableColumnsFeature INSTANCE = new ResizableColumnsFeature();

    private ResizableColumnsFeature() {
    }

    public static ResizableColumnsFeature getInstance() {
        return INSTANCE;
    }

    @Override
    public void decode(FacesContext context, DataTable table) {
        table.decodeColumnResizeState(context);
    }

    @Override
    public void encode(FacesContext context, DataTableRenderer renderer, DataTable table) throws IOException {
        throw new FacesException("ResizableColumnsFeature should not encode.");
    }

    @Override
    public boolean shouldDecode(FacesContext context, DataTable table) {
        return context.getExternalContext().getRequestParameterMap().containsKey(table.getClientId(context) + "_resizableColumnState");
    }

    @Override
    public boolean shouldEncode(FacesContext context, DataTable table) {
        return false;
    }
}

