/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datatable.feature;

import jakarta.faces.FacesException;
import jakarta.faces.context.FacesContext;
import java.io.IOException;
import java.util.Map;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.datatable.DataTableRenderer;
import org.primefaces.component.datatable.feature.DataTableFeature;
import org.primefaces.component.datatable.feature.SelectionFeature;

public class ScrollFeature
implements DataTableFeature {
    private static final ScrollFeature INSTANCE = new ScrollFeature();

    private ScrollFeature() {
    }

    public static ScrollFeature getInstance() {
        return INSTANCE;
    }

    @Override
    public void decode(FacesContext context, DataTable table) {
        throw new FacesException("ScrollFeature should not decode.");
    }

    @Override
    public void encode(FacesContext context, DataTableRenderer renderer, DataTable table) throws IOException {
        Map params = context.getExternalContext().getRequestParameterMap();
        int scrollRows = table.getScrollRows();
        String clientId = table.getClientId(context);
        boolean isVirtualScroll = table.isVirtualScroll();
        boolean isLazy = table.isLazy();
        int scrollOffset = 0;
        if (isVirtualScroll) {
            int rowCount;
            int virtualScrollRows;
            scrollOffset = Integer.parseInt((String)params.get(table.getClientId(context) + "_first"));
            scrollRows = scrollOffset + (virtualScrollRows = scrollRows * 2) > (rowCount = table.getRowCount()) ? rowCount - scrollOffset : virtualScrollRows;
        } else {
            scrollOffset = Integer.parseInt((String)params.get(table.getClientId(context) + "_scrollOffset"));
            table.setScrollOffset(scrollOffset);
        }
        if (isLazy) {
            table.loadLazyScrollData(scrollOffset, scrollRows);
        }
        if (table.isSelectionEnabled()) {
            SelectionFeature.getInstance().decodeSelectionRowKeys(context, table);
        }
        int firstIndex = isLazy && isVirtualScroll ? 0 : scrollOffset;
        int lastIndex = firstIndex + scrollRows;
        for (int i = firstIndex; i < lastIndex; ++i) {
            table.setRowIndex(i);
            if (!table.isRowAvailable()) continue;
            int rowIndex = isLazy && isVirtualScroll ? scrollOffset + i : i;
            renderer.encodeRow(context, table, clientId, rowIndex);
        }
    }

    @Override
    public boolean shouldDecode(FacesContext context, DataTable table) {
        return false;
    }

    @Override
    public boolean shouldEncode(FacesContext context, DataTable table) {
        return table.isScrollingRequest(context);
    }
}

