/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.export;

import jakarta.el.ELContext;
import jakarta.el.MethodExpression;
import jakarta.el.ValueExpression;
import jakarta.faces.FacesException;
import jakarta.faces.component.StateHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.ActionEvent;
import jakarta.faces.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Base64;
import java.util.List;
import org.primefaces.PrimeFaces;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.datatable.export.DataTableExporterFactory;
import org.primefaces.component.export.ExportConfiguration;
import org.primefaces.component.export.Exporter;
import org.primefaces.component.export.ExporterOptions;
import org.primefaces.component.treetable.TreeTable;
import org.primefaces.component.treetable.export.TreeTableExporterFactory;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.LangUtils;
import org.primefaces.util.ResourceUtils;

public class DataExporter
implements ActionListener,
StateHolder {
    private ValueExpression target;
    private ValueExpression type;
    private ValueExpression fileName;
    private ValueExpression encoding;
    private ValueExpression pageOnly;
    private ValueExpression selectionOnly;
    private ValueExpression visibleOnly;
    private ValueExpression exportHeader;
    private ValueExpression exportFooter;
    private MethodExpression preProcessor;
    private MethodExpression postProcessor;
    private ValueExpression options;
    private MethodExpression onTableRender;
    private ValueExpression exporter;

    public DataExporter() {
        ResourceUtils.addComponentResource(FacesContext.getCurrentInstance(), "filedownload/filedownload.js");
    }

    public void processAction(ActionEvent event) {
        FacesContext context = FacesContext.getCurrentInstance();
        ELContext elContext = context.getELContext();
        String tables = (String)this.target.getValue(elContext);
        String exportAs = (String)this.type.getValue(elContext);
        String outputFileName = (String)this.fileName.getValue(elContext);
        String encodingType = "UTF-8";
        if (this.encoding != null) {
            encodingType = (String)this.encoding.getValue(elContext);
        }
        boolean isPageOnly = false;
        if (this.pageOnly != null) {
            isPageOnly = this.pageOnly.isLiteralText() ? Boolean.parseBoolean(this.pageOnly.getValue(context.getELContext()).toString()) : (Boolean)this.pageOnly.getValue(context.getELContext());
        }
        boolean isSelectionOnly = false;
        if (this.selectionOnly != null) {
            isSelectionOnly = this.selectionOnly.isLiteralText() ? Boolean.parseBoolean(this.selectionOnly.getValue(context.getELContext()).toString()) : (Boolean)this.selectionOnly.getValue(context.getELContext());
        }
        boolean isVisibleOnly = false;
        if (this.visibleOnly != null) {
            isVisibleOnly = this.visibleOnly.isLiteralText() ? Boolean.parseBoolean(this.visibleOnly.getValue(context.getELContext()).toString()) : (Boolean)this.visibleOnly.getValue(context.getELContext());
        }
        boolean isExportHeader = true;
        if (this.exportHeader != null) {
            isExportHeader = this.exportHeader.isLiteralText() ? Boolean.parseBoolean(this.exportHeader.getValue(context.getELContext()).toString()) : (Boolean)this.exportHeader.getValue(context.getELContext());
        }
        boolean isExportFooter = true;
        if (this.exportFooter != null) {
            isExportFooter = this.exportFooter.isLiteralText() ? Boolean.parseBoolean(this.exportFooter.getValue(context.getELContext()).toString()) : (Boolean)this.exportFooter.getValue(context.getELContext());
        }
        ExporterOptions exporterOptions = null;
        if (this.options != null) {
            exporterOptions = (ExporterOptions)this.options.getValue(elContext);
        }
        Object customExporterInstance = null;
        if (this.exporter != null) {
            customExporterInstance = this.exporter.getValue(elContext);
        }
        try {
            OutputStream outputStream;
            List<UIComponent> components = SearchExpressionFacade.resolveComponents(context, event.getComponent(), tables);
            Class<? extends UIComponent> targetClass = this.guessTargetClass(components);
            Exporter exporterInstance = this.getExporter(exportAs, exporterOptions, customExporterInstance, targetClass);
            ExportConfiguration config = ExportConfiguration.builder().outputFileName(outputFileName).encodingType(encodingType).pageOnly(isPageOnly).selectionOnly(isSelectionOnly).visibleOnly(isVisibleOnly).exportHeader(isExportHeader).exportFooter(isExportFooter).options(exporterOptions).preProcessor(this.preProcessor).postProcessor(this.postProcessor).onTableRender(this.onTableRender).build();
            ExternalContext externalContext = context.getExternalContext();
            String filenameWithExtension = config.getOutputFileName() + exporterInstance.getFileExtension();
            String contentType = exporterInstance.getContentType();
            if (contentType.startsWith("text/") && LangUtils.isNotBlank(config.getEncodingType())) {
                contentType = contentType + "; charset=" + config.getEncodingType();
            }
            if (PrimeFaces.current().isAjaxRequest()) {
                outputStream = new ByteArrayOutputStream();
            } else {
                outputStream = context.getExternalContext().getResponseOutputStream();
                externalContext.setResponseContentType(contentType);
                this.setResponseHeader(externalContext, ComponentUtils.createContentDisposition("attachment", filenameWithExtension));
                this.addResponseCookie(context);
            }
            exporterInstance.setExportConfiguration(config);
            exporterInstance.export(context, components, outputStream, config);
            if (PrimeFaces.current().isAjaxRequest()) {
                this.ajaxDownload(filenameWithExtension, ((ByteArrayOutputStream)outputStream).toByteArray(), contentType, context);
            } else {
                context.responseComplete();
            }
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
    }

    protected Class<? extends UIComponent> guessTargetClass(List<UIComponent> targets) {
        Class targetClass = null;
        if (targets != null) {
            for (UIComponent current : targets) {
                if (current instanceof DataTable) {
                    targetClass = DataTable.class;
                    continue;
                }
                if (!(current instanceof TreeTable)) continue;
                targetClass = TreeTable.class;
            }
        }
        return targetClass;
    }

    protected Exporter getExporter(String exportAs, ExporterOptions exporterOptions, Object customExporterInstance, Class<? extends UIComponent> targetClass) {
        if (customExporterInstance != null) {
            if (customExporterInstance instanceof Exporter) {
                return (Exporter)customExporterInstance;
            }
            throw new FacesException("Component " + this.getClass().getName() + " customExporterInstance=" + customExporterInstance.getClass().getName() + " does not implement Exporter!");
        }
        if (targetClass != null && TreeTable.class.isAssignableFrom(targetClass)) {
            return TreeTableExporterFactory.getExporter(exportAs, exporterOptions);
        }
        return DataTableExporterFactory.getExporter(exportAs, exporterOptions);
    }

    private void ajaxDownload(String filenameWithExtension, byte[] content, String contentType, FacesContext context) {
        String base64 = Base64.getEncoder().withoutPadding().encodeToString(content);
        String data = "data:" + contentType + ";base64," + base64;
        String monitorKeyCookieName = ResourceUtils.getMonitorKeyCookieName(context, null);
        PrimeFaces.current().executeScript(String.format("PrimeFaces.download('%s', '%s', '%s', '%s')", data, contentType, filenameWithExtension, monitorKeyCookieName));
    }

    protected void setResponseHeader(ExternalContext externalContext, String contentDisposition) {
        ResourceUtils.addNoCacheControl(externalContext);
        externalContext.setResponseHeader("Content-disposition", contentDisposition);
    }

    protected void addResponseCookie(FacesContext context) {
        String monitorKeyCookieName = ResourceUtils.getMonitorKeyCookieName(context, null);
        ResourceUtils.addResponseCookie(context, monitorKeyCookieName, "true", null);
    }

    public boolean isTransient() {
        return false;
    }

    public void setTransient(boolean value) {
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.target = (ValueExpression)values[0];
        this.type = (ValueExpression)values[1];
        this.fileName = (ValueExpression)values[2];
        this.pageOnly = (ValueExpression)values[3];
        this.selectionOnly = (ValueExpression)values[4];
        this.visibleOnly = (ValueExpression)values[5];
        this.exportHeader = (ValueExpression)values[6];
        this.exportFooter = (ValueExpression)values[7];
        this.preProcessor = (MethodExpression)values[8];
        this.postProcessor = (MethodExpression)values[9];
        this.encoding = (ValueExpression)values[10];
        this.options = (ValueExpression)values[11];
        this.onTableRender = (MethodExpression)values[12];
        this.exporter = (ValueExpression)values[13];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{this.target, this.type, this.fileName, this.pageOnly, this.selectionOnly, this.visibleOnly, this.exportHeader, this.exportFooter, this.preProcessor, this.postProcessor, this.encoding, this.options, this.onTableRender, this.exporter};
        return values;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ValueExpression target;
        private ValueExpression type;
        private ValueExpression fileName;
        private ValueExpression encoding;
        private ValueExpression pageOnly;
        private ValueExpression selectionOnly;
        private ValueExpression visibleOnly;
        private ValueExpression exportHeader;
        private ValueExpression exportFooter;
        private MethodExpression preProcessor;
        private MethodExpression postProcessor;
        private ValueExpression options;
        private MethodExpression onTableRender;
        private ValueExpression exporter;

        Builder() {
        }

        public Builder target(ValueExpression target) {
            this.target = target;
            return this;
        }

        public Builder type(ValueExpression type) {
            this.type = type;
            return this;
        }

        public Builder fileName(ValueExpression fileName) {
            this.fileName = fileName;
            return this;
        }

        public Builder encoding(ValueExpression encoding) {
            this.encoding = encoding;
            return this;
        }

        public Builder pageOnly(ValueExpression pageOnly) {
            this.pageOnly = pageOnly;
            return this;
        }

        public Builder selectionOnly(ValueExpression selectionOnly) {
            this.selectionOnly = selectionOnly;
            return this;
        }

        public Builder visibleOnly(ValueExpression visibleOnly) {
            this.visibleOnly = visibleOnly;
            return this;
        }

        public Builder exportHeader(ValueExpression exportHeader) {
            this.exportHeader = exportHeader;
            return this;
        }

        public Builder exportFooter(ValueExpression exportFooter) {
            this.exportFooter = exportFooter;
            return this;
        }

        public Builder preProcessor(MethodExpression preProcessor) {
            this.preProcessor = preProcessor;
            return this;
        }

        public Builder postProcessor(MethodExpression postProcessor) {
            this.postProcessor = postProcessor;
            return this;
        }

        public Builder options(ValueExpression options) {
            this.options = options;
            return this;
        }

        public Builder onTableRender(MethodExpression onTableRender) {
            this.onTableRender = onTableRender;
            return this;
        }

        public Builder exporter(ValueExpression exporter) {
            this.exporter = exporter;
            return this;
        }

        public DataExporter build() {
            DataExporter exporter = new DataExporter();
            exporter.target = this.target;
            exporter.type = this.type;
            exporter.fileName = this.fileName;
            exporter.encoding = this.encoding;
            exporter.pageOnly = this.pageOnly;
            exporter.selectionOnly = this.selectionOnly;
            exporter.visibleOnly = this.visibleOnly;
            exporter.exportHeader = this.exportHeader;
            exporter.exportFooter = this.exportFooter;
            exporter.preProcessor = this.preProcessor;
            exporter.postProcessor = this.postProcessor;
            exporter.options = this.options;
            exporter.onTableRender = this.onTableRender;
            exporter.exporter = this.exporter;
            return exporter;
        }

        public String toString() {
            return "DataExporter.DataExporterBuilder(target=" + this.target + ", type=" + this.type + ", fileName=" + this.fileName + ", encoding=" + this.encoding + ", pageOnly=" + this.pageOnly + ", selectionOnly=" + this.selectionOnly + ", visibleOnly=" + this.visibleOnly + ", exportHeader=" + this.exportHeader + ", exportFooter=" + this.exportFooter + ", preProcessor=" + this.preProcessor + ", postProcessor=" + this.postProcessor + ", options=" + this.options + ", onTableRender=" + this.onTableRender + ", exporter=" + this.exporter + ")";
        }
    }
}

