/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.export;

import jakarta.faces.FacesException;
import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UISelectMany;
import jakarta.faces.component.ValueHolder;
import jakarta.faces.component.html.HtmlCommandLink;
import jakarta.faces.component.html.HtmlGraphicImage;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.Converter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.primefaces.component.celleditor.CellEditor;
import org.primefaces.component.export.ExportConfiguration;
import org.primefaces.component.overlaypanel.OverlayPanel;

public abstract class Exporter<T extends UIComponent> {
    private ExportConfiguration exportConfiguration;

    public abstract void export(FacesContext var1, List<T> var2, OutputStream var3, ExportConfiguration var4) throws IOException;

    public abstract String getContentType();

    public abstract String getFileExtension();

    protected String exportValue(FacesContext context, UIComponent component) {
        if (component instanceof HtmlCommandLink) {
            HtmlCommandLink link = (HtmlCommandLink)component;
            Object value = link.getValue();
            if (value != null) {
                return String.valueOf(value);
            }
            for (UIComponent child : link.getChildren()) {
                if (!(child instanceof ValueHolder)) continue;
                return this.exportValue(context, child);
            }
            return "";
        }
        if (component instanceof ValueHolder) {
            Object submittedValue;
            if (component instanceof EditableValueHolder && (submittedValue = ((EditableValueHolder)component).getSubmittedValue()) != null) {
                return submittedValue.toString();
            }
            ValueHolder valueHolder = (ValueHolder)component;
            Object value = valueHolder.getValue();
            if (value == null) {
                return "";
            }
            Converter converter = valueHolder.getConverter();
            if (converter == null) {
                Class<?> valueType = value.getClass();
                converter = context.getApplication().createConverter(valueType);
            }
            if (converter != null) {
                if (component instanceof UISelectMany) {
                    StringBuilder builder = new StringBuilder();
                    List<Object> collection = null;
                    if (value instanceof List) {
                        collection = (List<Object>)value;
                    } else if (value.getClass().isArray()) {
                        collection = Arrays.asList(value);
                    } else {
                        throw new FacesException("Value of " + component.getClientId(context) + " must be a List or an Array.");
                    }
                    int collectionSize = collection.size();
                    for (int i = 0; i < collectionSize; ++i) {
                        Object object = collection.get(i);
                        builder.append(converter.getAsString(context, component, object));
                        if (i >= collectionSize - 1) continue;
                        builder.append(",");
                    }
                    String valuesAsString = builder.toString();
                    builder.setLength(0);
                    return valuesAsString;
                }
                return converter.getAsString(context, component, value);
            }
            return value.toString();
        }
        if (component instanceof CellEditor) {
            return this.exportValue(context, component.getFacet("output"));
        }
        if (component instanceof HtmlGraphicImage) {
            return (String)component.getAttributes().get("alt");
        }
        if (component instanceof OverlayPanel) {
            return "";
        }
        String value = component.toString();
        if (value != null) {
            return value.trim();
        }
        return "";
    }

    public ExportConfiguration getExportConfiguration() {
        return this.exportConfiguration;
    }

    public void setExportConfiguration(ExportConfiguration exportConfiguration) {
        this.exportConfiguration = exportConfiguration;
    }
}

