/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.inplace;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import org.primefaces.component.inplace.Inplace;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.LangUtils;
import org.primefaces.util.WidgetBuilder;

public class InplaceRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Inplace inplace = (Inplace)component;
        this.encodeMarkup(context, inplace);
        this.encodeScript(context, inplace);
    }

    protected void encodeMarkup(FacesContext context, Inplace inplace) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = inplace.getClientId(context);
        String widgetVar = inplace.resolveWidgetVar(context);
        String userStyle = inplace.getStyle();
        String styleClass = this.getStyleClassBuilder(context).add("ui-inplace ui-hidden-container", inplace.getStyleClass()).build();
        boolean disabled = inplace.isDisabled();
        String displayClass = disabled ? "ui-inplace-display-disabled" : "ui-inplace-display";
        boolean validationFailed = context.isValidationFailed() && !inplace.isValid();
        String mode = inplace.getMode();
        writer.startElement("span", (UIComponent)inplace);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "id");
        if (userStyle != null) {
            writer.writeAttribute("style", (Object)userStyle, "id");
        }
        writer.writeAttribute("data-widget", (Object)widgetVar, null);
        String outputStyle = validationFailed ? "none" : ("output".equals(mode) ? "inline" : "none");
        UIComponent outputFacet = inplace.getFacet("output");
        writer.startElement("span", null);
        writer.writeAttribute("id", (Object)(clientId + "_display"), "id");
        writer.writeAttribute("class", (Object)displayClass, null);
        writer.writeAttribute("style", (Object)("display:" + outputStyle), null);
        if (inplace.getTabindex() != null) {
            writer.writeAttribute("tabindex", (Object)inplace.getTabindex(), null);
            writer.writeAttribute("role", (Object)"button", null);
        }
        if (ComponentUtils.shouldRenderFacet(outputFacet)) {
            outputFacet.encodeAll(context);
        } else {
            writer.writeText((Object)this.getLabelToRender(context, inplace), null);
        }
        writer.endElement("span");
        String inputStyle = validationFailed ? "inline" : ("output".equals(mode) ? "none" : "inline");
        UIComponent inputFacet = inplace.getFacet("input");
        if (!inplace.isDisabled()) {
            writer.startElement("span", null);
            writer.writeAttribute("id", (Object)(clientId + "_content"), "id");
            writer.writeAttribute("class", (Object)"ui-inplace-content", null);
            writer.writeAttribute("style", (Object)("display:" + inputStyle), null);
            if (ComponentUtils.shouldRenderFacet(inputFacet)) {
                inputFacet.encodeAll(context);
            } else {
                this.renderChildren(context, (UIComponent)inplace);
            }
            if (inplace.isEditor()) {
                this.encodeEditor(context, inplace);
            }
            writer.endElement("span");
        }
        writer.endElement("span");
    }

    protected String getLabelToRender(FacesContext context, Inplace inplace) {
        String label = inplace.getLabel();
        if (!this.isValueBlank(label)) {
            return label;
        }
        String value = ComponentUtils.getValueToRender(context, (UIComponent)inplace.getChildren().get(0));
        if (LangUtils.isBlank(value)) {
            String emptyLabel = inplace.getEmptyLabel();
            if (emptyLabel != null) {
                return emptyLabel;
            }
            return "";
        }
        return value;
    }

    protected void encodeScript(FacesContext context, Inplace inplace) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("Inplace", inplace).attr("effect", inplace.getEffect()).attr("effectSpeed", inplace.getEffectSpeed()).attr("event", inplace.getEvent()).attr("toggleable", inplace.isToggleable(), false).attr("disabled", inplace.isDisabled(), false).attr("editor", inplace.isEditor(), false);
        this.encodeClientBehaviors(context, inplace);
        wb.finish();
    }

    protected void encodeEditor(FacesContext context, Inplace inplace) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("span", null);
        writer.writeAttribute("id", (Object)(inplace.getClientId(context) + "_editor"), null);
        writer.writeAttribute("class", (Object)"ui-inplace-editor", null);
        this.encodeButton(context, inplace.getSaveLabel(), "ui-inplace-save", "ui-icon-check");
        this.encodeButton(context, inplace.getCancelLabel(), "ui-inplace-cancel", "ui-icon-close");
        writer.endElement("span");
    }

    protected void encodeButton(FacesContext context, String title, String styleClass, String icon) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("button", null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("class", (Object)("ui-button ui-widget ui-state-default ui-corner-all ui-button-icon-only " + styleClass), null);
        writer.writeAttribute("title", (Object)title, null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)("ui-button-icon-left ui-icon ui-c " + icon), null);
        writer.endElement("span");
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-button-text ui-c", null);
        writer.write("ui-button");
        writer.endElement("span");
        writer.endElement("button");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

