/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.menuitem;

import jakarta.el.MethodExpression;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIParameter;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.ActionEvent;
import jakarta.faces.event.BehaviorEvent;
import jakarta.faces.event.FacesEvent;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.primefaces.component.api.DialogReturnAware;
import org.primefaces.component.menuitem.UIMenuItemBase;
import org.primefaces.event.SelectEvent;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.MapBuilder;

public class UIMenuItem
extends UIMenuItemBase
implements DialogReturnAware {
    public static final String COMPONENT_TYPE = "org.primefaces.component.UIMenuItem";
    private static final String DEFAULT_EVENT = "click";
    private static final Map<String, Class<? extends BehaviorEvent>> BEHAVIOR_EVENT_MAPPING = MapBuilder.builder().put("click", null).put("dialogReturn", SelectEvent.class).build();
    private static final Collection<String> EVENT_NAMES = BEHAVIOR_EVENT_MAPPING.keySet();
    private String confirmationScript;

    @Override
    public Map<String, Class<? extends BehaviorEvent>> getBehaviorEventMapping() {
        return BEHAVIOR_EVENT_MAPPING;
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public String getDefaultEventName() {
        return DEFAULT_EVENT;
    }

    public void decode(FacesContext facesContext) {
        String clientId;
        if (this.isDisabled()) {
            return;
        }
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        if (params.containsKey(clientId = this.getClientId(facesContext))) {
            this.queueEvent((FacesEvent)new ActionEvent((UIComponent)this));
        }
        ComponentUtils.decodeBehaviors(facesContext, (UIComponent)this);
    }

    public void queueEvent(FacesEvent e) {
        FacesContext context = this.getFacesContext();
        if (this.isDialogReturnEvent(e, context)) {
            this.queueDialogReturnEvent(e, context, (UIComponent)this, x$0 -> super.queueEvent(x$0));
        } else {
            super.queueEvent(e);
        }
    }

    @Override
    public boolean shouldRenderChildren() {
        int childCount = this.getChildCount();
        if (childCount > 0) {
            for (int i = 0; i < childCount; ++i) {
                UIComponent child = (UIComponent)this.getChildren().get(i);
                if (child instanceof UIParameter) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isPartialSubmitSet() {
        return this.getStateHelper().get((Serializable)((Object)UIMenuItemBase.PropertyKeys.partialSubmit)) != null || this.getValueExpression(UIMenuItemBase.PropertyKeys.partialSubmit.toString()) != null;
    }

    @Override
    public boolean isResetValuesSet() {
        return this.getStateHelper().get((Serializable)((Object)UIMenuItemBase.PropertyKeys.resetValues)) != null || this.getValueExpression(UIMenuItemBase.PropertyKeys.resetValues.toString()) != null;
    }

    @Override
    public String getHref() {
        return this.getUrl();
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public Map<String, List<String>> getParams() {
        return ComponentUtils.getUIParams((UIComponent)this);
    }

    @Override
    public String getCommand() {
        MethodExpression expr = super.getActionExpression();
        return expr != null ? expr.getExpressionString() : null;
    }

    @Override
    public boolean isAjaxified() {
        return this.getUrl() == null && this.getOutcome() == null && this.isAjax();
    }

    @Override
    public void setParam(String key, Object value) {
        throw new UnsupportedOperationException("Use UIParameter component instead to add parameters.");
    }

    @Override
    public String getConfirmationScript() {
        return this.confirmationScript;
    }

    @Override
    public void setConfirmationScript(String confirmationScript) {
        this.confirmationScript = confirmationScript;
    }

    @Override
    public boolean requiresConfirmation() {
        return this.confirmationScript != null;
    }
}

