/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.schedule;

import jakarta.el.ELContext;
import jakarta.el.ValueExpression;
import jakarta.faces.FacesException;
import jakarta.faces.application.ResourceDependencies;
import jakarta.faces.application.ResourceDependency;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AjaxBehaviorEvent;
import jakarta.faces.event.BehaviorEvent;
import jakarta.faces.event.FacesEvent;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import org.primefaces.component.schedule.ScheduleBase;
import org.primefaces.el.ValueExpressionAnalyzer;
import org.primefaces.event.AbstractAjaxBehaviorEvent;
import org.primefaces.event.SelectEvent;
import org.primefaces.event.schedule.ScheduleEntryMoveEvent;
import org.primefaces.event.schedule.ScheduleEntryResizeEvent;
import org.primefaces.event.schedule.ScheduleRangeEvent;
import org.primefaces.model.ScheduleEvent;
import org.primefaces.util.CalendarUtils;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.LocaleUtils;
import org.primefaces.util.MapBuilder;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="schedule/schedule.css"), @ResourceDependency(library="primefaces", name="components.css"), @ResourceDependency(library="primefaces", name="moment/moment.js"), @ResourceDependency(library="primefaces", name="moment/moment-timezone-with-data.js"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="jquery/jquery-plugins.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="components.js"), @ResourceDependency(library="primefaces", name="schedule/schedule.js")})
public class Schedule
extends ScheduleBase {
    public static final String COMPONENT_TYPE = "org.primefaces.component.Schedule";
    private static final Map<String, Class<? extends BehaviorEvent>> BEHAVIOR_EVENT_MAPPING = MapBuilder.builder().put("dateSelect", SelectEvent.class).put("dateDblSelect", SelectEvent.class).put("eventSelect", SelectEvent.class).put("eventMove", ScheduleEntryMoveEvent.class).put("eventResize", ScheduleEntryResizeEvent.class).put("viewChange", SelectEvent.class).put("rangeSelect", ScheduleRangeEvent.class).build();
    private static final Collection<String> EVENT_NAMES = BEHAVIOR_EVENT_MAPPING.keySet();

    @Override
    public Map<String, Class<? extends BehaviorEvent>> getBehaviorEventMapping() {
        return BEHAVIOR_EVENT_MAPPING;
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    Locale calculateLocale(FacesContext facesContext) {
        return LocaleUtils.resolveLocale(facesContext, this.getLocale(), this.getClientId(facesContext));
    }

    public boolean isEventRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_event");
    }

    public void queueEvent(FacesEvent event) {
        FacesContext context = this.getFacesContext();
        Map params = context.getExternalContext().getRequestParameterMap();
        String eventName = (String)params.get("jakarta.faces.behavior.event");
        String clientId = this.getClientId(context);
        if (ComponentUtils.isRequestSource((UIComponent)this, context)) {
            AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
            AbstractAjaxBehaviorEvent wrapperEvent = null;
            if ("dateSelect".equals(eventName) || "dateDblSelect".equals(eventName)) {
                String selectedDateStr = (String)params.get(clientId + "_selectedDate");
                ZoneId zoneId = CalendarUtils.calculateZoneId(this.getTimeZone());
                LocalDateTime selectedDate = CalendarUtils.toLocalDateTime(zoneId, selectedDateStr);
                SelectEvent<LocalDateTime> selectEvent = new SelectEvent<LocalDateTime>((UIComponent)this, behaviorEvent.getBehavior(), selectedDate);
                selectEvent.setPhaseId(behaviorEvent.getPhaseId());
                wrapperEvent = selectEvent;
            }
            if ("rangeSelect".equals(eventName)) {
                String startDateStr = (String)params.get(clientId + "_startDate");
                String endDateStr = (String)params.get(clientId + "_endDate");
                ZoneId zoneId = CalendarUtils.calculateZoneId(this.getTimeZone());
                LocalDateTime startDate = CalendarUtils.toLocalDateTime(zoneId, startDateStr);
                LocalDateTime endDate = CalendarUtils.toLocalDateTime(zoneId, endDateStr);
                ScheduleRangeEvent selectEvent = new ScheduleRangeEvent((UIComponent)this, behaviorEvent.getBehavior(), startDate, endDate);
                selectEvent.setPhaseId(behaviorEvent.getPhaseId());
                wrapperEvent = selectEvent;
            } else if ("eventSelect".equals(eventName)) {
                String selectedEventId = (String)params.get(clientId + "_selectedEventId");
                ScheduleEvent<?> selectedEvent = this.getValue().getEvent(selectedEventId);
                wrapperEvent = new SelectEvent((UIComponent)this, behaviorEvent.getBehavior(), selectedEvent);
            } else if ("eventMove".equals(eventName)) {
                String movedEventId = (String)params.get(clientId + "_movedEventId");
                ScheduleEvent<?> movedEvent = this.getValue().getEvent(movedEventId);
                int yearDelta = Double.valueOf((String)params.get(clientId + "_yearDelta")).intValue();
                int monthDelta = Double.valueOf((String)params.get(clientId + "_monthDelta")).intValue();
                int dayDelta = Double.valueOf((String)params.get(clientId + "_dayDelta")).intValue();
                int minuteDelta = Double.valueOf((String)params.get(clientId + "_minuteDelta")).intValue();
                boolean allDay = Boolean.parseBoolean((String)params.get(clientId + "_allDay"));
                LocalDateTime startDate = movedEvent.getStartDate();
                LocalDateTime endDate = movedEvent.getEndDate();
                startDate = startDate.plusYears(yearDelta).plusMonths(monthDelta).plusDays(dayDelta).plusMinutes(minuteDelta);
                endDate = endDate.plusYears(yearDelta).plusMonths(monthDelta).plusDays(dayDelta).plusMinutes(minuteDelta);
                movedEvent.setAllDay(allDay);
                movedEvent.setStartDate(startDate);
                movedEvent.setEndDate(endDate);
                wrapperEvent = new ScheduleEntryMoveEvent((UIComponent)this, behaviorEvent.getBehavior(), movedEvent, yearDelta, monthDelta, dayDelta, minuteDelta);
            } else if ("eventResize".equals(eventName)) {
                String resizedEventId = (String)params.get(clientId + "_resizedEventId");
                ScheduleEvent<?> resizedEvent = this.getValue().getEvent(resizedEventId);
                int startDeltaYear = Double.valueOf((String)params.get(clientId + "_startDeltaYear")).intValue();
                int startDeltaMonth = Double.valueOf((String)params.get(clientId + "_startDeltaMonth")).intValue();
                int startDeltaDay = Double.valueOf((String)params.get(clientId + "_startDeltaDay")).intValue();
                int startDeltaMinute = Double.valueOf((String)params.get(clientId + "_startDeltaMinute")).intValue();
                LocalDateTime startDate = resizedEvent.getStartDate();
                startDate = startDate.plusYears(startDeltaYear).plusMonths(startDeltaMonth).plusDays(startDeltaDay).plusMinutes(startDeltaMinute);
                resizedEvent.setStartDate(startDate);
                int endDeltaYear = Double.valueOf((String)params.get(clientId + "_endDeltaYear")).intValue();
                int endDeltaMonth = Double.valueOf((String)params.get(clientId + "_endDeltaMonth")).intValue();
                int endDeltaDay = Double.valueOf((String)params.get(clientId + "_endDeltaDay")).intValue();
                int endDeltaMinute = Double.valueOf((String)params.get(clientId + "_endDeltaMinute")).intValue();
                LocalDateTime endDate = resizedEvent.getEndDate();
                endDate = endDate.plusYears(endDeltaYear).plusMonths(endDeltaMonth).plusDays(endDeltaDay).plusMinutes(endDeltaMinute);
                resizedEvent.setEndDate(endDate);
                wrapperEvent = new ScheduleEntryResizeEvent((UIComponent)this, behaviorEvent.getBehavior(), resizedEvent, startDeltaYear, startDeltaMonth, startDeltaDay, startDeltaMinute, endDeltaYear, endDeltaMonth, endDeltaDay, endDeltaMinute);
            } else if ("viewChange".equals(eventName)) {
                wrapperEvent = new SelectEvent<String>((UIComponent)this, behaviorEvent.getBehavior(), this.getView());
            }
            if (wrapperEvent == null) {
                throw new FacesException("Component " + this.getClass().getName() + " does not support event " + eventName + "!");
            }
            wrapperEvent.setPhaseId(behaviorEvent.getPhaseId());
            super.queueEvent(wrapperEvent);
        } else {
            super.queueEvent(event);
        }
    }

    public void processUpdates(FacesContext context) {
        if (!this.isRendered()) {
            return;
        }
        super.processUpdates(context);
        ELContext elContext = this.getFacesContext().getELContext();
        ValueExpression expr = ValueExpressionAnalyzer.getExpression(elContext, this.getValueExpression(ScheduleBase.PropertyKeys.view.toString()), true);
        if (expr != null && !expr.isReadOnly(elContext)) {
            expr.setValue(elContext, (Object)this.getView());
            this.getStateHelper().remove((Serializable)((Object)ScheduleBase.PropertyKeys.view));
        }
    }
}

