/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.signature;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.util.Map;
import org.primefaces.component.signature.Signature;
import org.primefaces.component.signature.SignatureBase;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.WidgetBuilder;

public class SignatureRenderer
extends InputRenderer {
    public void decode(FacesContext context, UIComponent component) {
        Signature signature = (Signature)component;
        if (!this.shouldDecode(signature)) {
            return;
        }
        Map params = context.getExternalContext().getRequestParameterMap();
        String value = (String)params.get(signature.getClientId(context) + "_value");
        String base64Value = (String)params.get(signature.getClientId(context) + "_base64");
        signature.setSubmittedValue(value);
        if (base64Value != null) {
            signature.setBase64Value(base64Value);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        Signature signature = (Signature)component;
        this.encodeMarkup(facesContext, signature);
        this.encodeScript(facesContext, signature);
    }

    protected void encodeMarkup(FacesContext context, Signature signature) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = signature.getClientId(context);
        String style = signature.getStyle();
        String styleClass = signature.getStyleClass();
        String defaultStyle = signature.resolveStyleClass();
        styleClass = styleClass == null ? defaultStyle : defaultStyle + " " + styleClass;
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, null);
        }
        this.encodeInputField(context, signature, clientId + "_value", signature.getValue());
        if (signature.getValueExpression(SignatureBase.PropertyKeys.base64Value.toString()) != null) {
            this.encodeInputField(context, signature, clientId + "_base64", null);
        }
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, Signature signature) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("Signature", signature).attr("background", signature.getBackgroundColor(), null).attr("color", signature.getColor(), null).attr("thickness", signature.getThickness(), 2).attr("readonly", signature.isReadonly(), false).attr("guideline", signature.isGuideline(), false).attr("guidelineColor", signature.getGuidelineColor(), null).attr("guidelineOffset", signature.getGuidelineOffset(), 25).attr("guidelineIndent", signature.getGuidelineIndent(), 10).callback("onchange", "function()", signature.getOnchange());
        if (signature.getValueExpression(SignatureBase.PropertyKeys.base64Value.toString()) != null) {
            wb.attr("base64", true);
        }
        wb.finish();
    }

    protected void encodeInputField(FacesContext context, Signature signature, String name, Object value) throws IOException {
        String valueToRender = null;
        if (value != null) {
            valueToRender = value.toString();
        }
        this.renderHiddenInput(context, name, valueToRender, this.isDisabled(signature));
    }
}

