/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.splitter;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import org.primefaces.component.splitter.Splitter;
import org.primefaces.component.splitter.SplitterPanel;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class SplitterRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Splitter splitter = (Splitter)component;
        this.encodeMarkup(context, splitter);
        this.encodeScript(context, splitter);
    }

    protected void encodeMarkup(FacesContext context, Splitter splitter) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String layout = splitter.getLayout();
        String styleClass = this.getStyleClassBuilder(context).add("ui-splitter ui-widget").add(splitter.getStyleClass()).add("vertical".equals(layout), "ui-splitter-vertical").add("horizontal".equals(layout), "ui-splitter-horizontal").build();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)splitter.getClientId(context), "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (splitter.getStyle() != null) {
            writer.writeAttribute("style", (Object)splitter.getStyle(), "style");
        }
        int childCount = splitter.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            UIComponent component = (UIComponent)splitter.getChildren().get(i);
            if (!(component instanceof SplitterPanel)) continue;
            this.encodePanel(context, (SplitterPanel)component);
            if (i == childCount - 1) continue;
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)"ui-splitter-gutter", null);
            if ("horizontal".equals(layout)) {
                writer.writeAttribute("style", (Object)("width: " + splitter.getGutterSize() + "px"), null);
            } else if ("vertical".equals(layout)) {
                writer.writeAttribute("style", (Object)("height: " + splitter.getGutterSize() + "px"), null);
            }
            writer.startElement("div", (UIComponent)splitter);
            writer.writeAttribute("class", (Object)"ui-splitter-gutter-handle", null);
            writer.endElement("div");
            writer.endElement("div");
        }
        writer.endElement("div");
    }

    protected void encodePanel(FacesContext context, SplitterPanel splitterPanel) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String styleClass = this.getStyleClassBuilder(context).add("ui-splitter-panel").add(splitterPanel.getStyleClass()).add(splitterPanel.isNested(), "ui-splitter-panel-nested").build();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        writer.writeAttribute("data-size", (Object)splitterPanel.getSize(), null);
        writer.writeAttribute("data-minsize", (Object)splitterPanel.getMinSize(), null);
        if (splitterPanel.getStyle() != null) {
            writer.writeAttribute("style", (Object)splitterPanel.getStyle(), "style");
        }
        splitterPanel.encodeAll(context);
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, Splitter splitter) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("Splitter", splitter).attr("layout", splitter.getLayout()).attr("gutterSize", splitter.getGutterSize()).attr("stateKey", splitter.getStateKey()).attr("stateStorage", splitter.getStateStorage());
        wb.callback("onResizeEnd", "function(panelSizes)", splitter.getOnResizeEnd());
        this.encodeClientBehaviors(context, splitter);
        wb.finish();
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext fc, UIComponent component) {
    }
}

