/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.treetable.export;

import jakarta.faces.FacesException;
import org.primefaces.component.export.Exporter;
import org.primefaces.component.export.ExporterOptions;
import org.primefaces.component.export.ExporterType;
import org.primefaces.component.treetable.TreeTable;
import org.primefaces.component.treetable.export.TreeTableCSVExporter;
import org.primefaces.component.treetable.export.TreeTableExcelExporter;
import org.primefaces.component.treetable.export.TreeTableExcelXExporter;
import org.primefaces.component.treetable.export.TreeTableExcelXStreamExporter;
import org.primefaces.component.treetable.export.TreeTableExporter;
import org.primefaces.component.treetable.export.TreeTablePDFExporter;
import org.primefaces.component.treetable.export.TreeTableXMLExporter;

public class TreeTableExporterFactory {
    private TreeTableExporterFactory() {
    }

    public static Exporter<TreeTable> getExporter(String type, ExporterOptions options) {
        TreeTableExporter exporter = null;
        try {
            ExporterType exporterType = ExporterType.valueOf(type.toUpperCase());
            switch (exporterType) {
                case XLS: {
                    exporter = new TreeTableExcelExporter();
                    break;
                }
                case PDF: {
                    exporter = new TreeTablePDFExporter();
                    break;
                }
                case CSV: {
                    exporter = new TreeTableCSVExporter();
                    break;
                }
                case XML: {
                    exporter = new TreeTableXMLExporter();
                    break;
                }
                case XLSX: {
                    exporter = new TreeTableExcelXExporter();
                    break;
                }
                case XLSXSTREAM: {
                    exporter = new TreeTableExcelXStreamExporter();
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw new FacesException((Throwable)e);
        }
        return exporter;
    }
}

